#include <stdio.h>
#include <string.h>
#include <ndfs.h>

void printInfo( char *data )
{
    int i;
    char *p;
    DO_DATA_MOUNTINFO *ptr = (DO_DATA_MOUNTINFO*)data;
    
    printf( "Child Mount Points: returned - %3d, total - %3d\n"
            "Mounted Objects:    returned - %3d, total - %3d\n"            
            "Name(%d bytes): [%s]\n",
             (int)ptr->usMountPointsReturned, 
             (int)ptr->usMountPointsTotal, 
             (int)ptr->usObjectsReturned, 
             (int)ptr->usObjectsTotal, 
             ptr->cbName, 
             ptr->achName);
             
    p = &data[ sizeof(DO_DATA_MOUNTINFO) + ptr->cbName ];
    if ( ptr->usMountPointsReturned > 0 )
    {
        printf("\n");
        printf("Child Mount Points Information:\n");
        for ( i = 1; i <= ptr->usMountPointsReturned; i++ )
        {
            DO_DATA_MOUNTPOINT *mp = (DO_DATA_MOUNTPOINT *)p;
            printf("MP[%2.2d] = [%s]\n", i, mp->achName );
            p += sizeof(DO_DATA_MOUNTPOINT) + mp->cbName;
        }
    }
    if ( ptr->usObjectsReturned > 0 )
    {
        printf("\n");
        printf("Mounted Objects Information:\n");
        for ( i = 1; i <= ptr->usObjectsReturned; i++ )
        {
            DO_DATA_MOUNTOBJECT *mo = (DO_DATA_MOUNTOBJECT *)p;
            printf("MO[%2.2d]: type = [%8s], flags = %4.4X, [%s]\n",
                   i, mo->achType, mo->ulFlags, mo->achData );
            p += sizeof(DO_DATA_MOUNTOBJECT) + mo->cbData;
        }
    }
}

int main( int argc, char *argv[] )
{
    int rc = 0;
    char data[4096];
    ULONG ulDataLen;
    
    printf( "NetDrive Mount Information Utility\n" );
    if ( argc != 2 )
    {
        printf( "ndgetm path\n" );
        printf( "    where path is the mount point to be queried\n" );
        rc = -1;
    }
    else
    {
        char *path = argv[1];
        
        rc = NdIoctl( DO_IOCTL_QUERYMOUNTINFO,
                      path, 
                      data, 
                      sizeof(data),
                      &ulDataLen );
        if (rc != 0)
        {
            printf("Query failed: return code = %ld\n", rc);
        }
        else
        {
            printf("Query successful.\n");
            printf("Information on %s follows:\n", argv[1] );
            printInfo( &data[0] );
        }
    }
    return rc;
}
