#ifndef __NDFS__H
#define __NDFS__H

#define INCL_DOS
#define INCL_DOSERRORS
#include <os2.h>

    #define ND_FSDNAME           "NDFS"

    /* embedded types */
    #define TYPE_MOUNTPOINT      "mountp"
    #define TYPE_LOCAL           "local"
    #define TYPE_FTP             "ftp"
    #define TYPE_SAMBA           "samba"

    /* drive objects common flags */
    #define DO_FLAG_WRITEPROTECT      0x1
    
    /* mount points flags */
    #define MP_FLAG_NORMAL            0x0
    
    /* NdQueryInfo infolevels */
    #define ND_INFO_IFS            0 
    
    #pragma pack(1)
    typedef struct _RIDINFO
    {
        ULONG  ulReqCompleted;
        USHORT usReqMax;
        USHORT usReqInProcess;
        USHORT usReqMaxInProcess;
        USHORT usReqRetCnt;
        USHORT usReqCptCnt;
        ULONG  ulFreeHits;
        ULONG  ulCptHits;
        ULONG  ulFreeFaults;
        ULONG  ulCptFaults;
        ULONG  ulFreeScanned;
        ULONG  ulCptScanned;
    } RIDINFO;
    
    typedef struct _IFSINFO
    {
        CHAR    achName[8];
        USHORT  usVerMajor;
        USHORT  usVerMinor;
        RIDINFO ridInfo;
        USHORT  usCpgmConnected;
        USHORT  usCpgmPID;
    } IFSINFO;
    #pragma pack()


    APIRET APIENTRY  NdQueryInfo(ULONG infolevel,
                                 PVOID pBuf,
                                 PULONG pcbBuf);
                                 
    APIRET APIENTRY  NdAttach( PSZ pszDevice,
                               PSZ pszLabel,
                               ULONG cUnit,
                               ULONG cUnitAvail );

    APIRET APIENTRY  NdDetach( PSZ pszDevice );
    
    APIRET APIENTRY  NdSetDriveInfo( PSZ pszDevice,
                                     ULONG cUnit,
                                     ULONG cUnitAvail );
                                     
    APIRET APIENTRY  NdMount( PSZ pszType,
                              ULONG ulFlags,
                              PSZ pszDest, 
                              PSZ pszSrc);

    APIRET APIENTRY  NdUnmount( PSZ pszDest, ULONG ulIndex );

    APIRET APIENTRY  NdIoctl( ULONG ulFunction,
                              PSZ   pszDest, 
                              PVOID pData, 
                              ULONG ulDataLenIn,
                              PULONG pulDataLenOut );
                              
    APIRET APIENTRY NdCreateMountPoint( PSZ pszPath, ULONG ulFlags );
    
    APIRET APIENTRY NdDeleteMountPoint( PSZ pszPath );
    
    #define ORD_NDQUERYINFO           1
    #define ORD_NDATTACH              2
    #define ORD_NDDETACH              3
    #define ORD_NDSETDRIVEINFO        4
    #define ORD_NDMOUNT               5
    #define ORD_NDUNMOUNT             6
    #define ORD_NDIOCTL               7
    #define ORD_NDCREATEMOUNTPOINT    8
    #define ORD_NDDELETEMOUNTPOINT    9
    
    /* ftp server's types */
        enum { 
            tAutoDetect = 0, 
            tOS2 = 1,
            tNetSuite = 2,
            tUNIX = 3,
            tULTRIX = 4,
            tFreeport = 5,
            tUNIXBanyan = 6,
            tVMS = 7,
            tPCTCP = 8,
            tIBMVM = 9,
            tNetware = 10,
            tHellsoft = 11,
            tNovellLWP = 12,
            tWinNT = 13,
            tMac = 14,
            tMacPeter = 15,
            tNetware41 = 16,
            tChameleonNT = 17,
            tWollogong = 18,
            tVMSMultiNet = 19,
            tWinNTAlpha = 20
        };
        

        /* IOCTL functions */
        #define DO_IOCTL_QUERYMOUNTPOINT    0
        #define DO_IOCTL_QUERYMOUNTINFO     1
        #define DO_IOCTL_REFRESH            2
     
        #pragma pack(1)
        typedef struct _DO_DATA_MOUNTINFO        
        {
            USHORT usMountPointsTotal;
            USHORT usMountPointsReturned;
            USHORT usObjectsTotal;
            USHORT usObjectsReturned;
            ULONG  cbName;
            CHAR   achName[1];
        } DO_DATA_MOUNTINFO;
        typedef DO_DATA_MOUNTINFO *PDO_DATA_MOUNTINFO;
        
        typedef struct _DO_DATA_MOUNTPOINT
        {
            ULONG  cbName;
            CHAR   achName[1];
        } DO_DATA_MOUNTPOINT;
        typedef DO_DATA_MOUNTPOINT *PDO_DATA_MOUNTPOINT;
        
        typedef struct _DO_DATA_MOUNTOBJECT
        {
            CHAR   achType[8];
            ULONG  ulFlags;
            ULONG  cbData;
            CHAR   achData[1];
        } DO_DATA_MOUNTOBJECT;
        typedef DO_DATA_MOUNTOBJECT *PDO_DATA_MOUNTOBJECT;
        #pragma pack()

#endif // __NDFS__H
