#include <stdio.h>
#include <string.h>
#include <ndfs.h>


int main( int argc, char *argv[] )
{
    int rc = 0;
    printf( "NetDrive Detach Drive Letter Utility\n" );
    if ( argc != 2 )
    {
        printf( "nddetach X:\n" );
        printf( "   where X is the drive letter to be deleted\n" );
        rc = -1;
    }
    else
    {
        char *drive = argv[1];
        
        rc = NdDetach( drive );
        
        if ( rc != 0 )
        {
            printf("Detach failed: return code = %ld\n", rc);
        }
        else
        {
            printf("Detach successful. Drive letter deleted.\n");
        }
    }
    
    return rc;
}
