#include <stdio.h>
#include <string.h>
#include <ndfs.h>

int main( int argc, char *argv[] )
{
 
    int rc = 0;
    printf( "NetDrive Delete Mount Point Utility\n" );
    if ( argc != 2 )
    {
        printf( "nddeletemp path\n" );
        printf( "   where path is the mount point to be deleted\n" );
        rc = -1;
    }
    else
    {
        char *mountpoint = argv[1];
        
        rc = NdDeleteMountPoint( mountpoint );
        
        if (rc != 0)
        {
            printf("Delete failed: return code = %ld\n", rc);
        }
        else
        {
            printf("Mount point deleted.\n");
        }
    }
    return rc;
}
