#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ndfs.h>


static int nd_check( ULONG ulPeriod, ULONG ulRetries )
{
    int rc;
    int i;
    int infinity = (ulRetries == 0ul);
    
    for ( i = 0; infinity || i < ulRetries; i++ )
    {
        IFSINFO ifsInfo;
        ULONG ulDataLength = sizeof( IFSINFO );
        rc = NdQueryInfo( ND_INFO_IFS, &ifsInfo, &ulDataLength );
        if ( rc != NO_ERROR || !ifsInfo.usCpgmConnected ) 
        {
            return 1;
        }
        DosSleep( ulPeriod*1000ul );
    }
            
    return 0;
}


int main( int argc, char *argv[] )
{
    int rc = 0;
    ULONG period  = 10; // 10 seconds
    ULONG retries = 0; //  inf
    printf( "NetDrive NDCTL Check Utility\n" );
    
    switch( argc )
    {
        default:
        {
            printf( "ndcheck [period retries]\n" );
            printf( "    default period=10 (in seconds), retries=infinity\n" );
        } break;
        case 3:
        {
             period = atoi( argv[1] );
             if ( period == 0 ) 
             {
                 period = 10;
             }
             retries = atoi( argv[2] );
        }
        case 1:
        {
            rc = nd_check( period, retries );
            if (rc != 0)
            {
                printf("NDCTL is not running.\n");
            }
            else
            {
                printf("NDCTL is running.\n");
            }
        } break;
    }
    return rc;
}
