#include <stdio.h>
#include <string.h>
#include <ndfs.h>


int main( int argc, char *argv[] )
{
    int rc = 0;
    printf( "NetDrive Attach Drive Letter Utility\n" );
    if ( argc != 2 )
    {
        printf( "ndattach X:\n" );
        printf( "   where X is the drive letter to be created\n" );
        rc = -1;
    }
    else
    {
        char *drive = argv[1];
        char *label = "NETDRIVE";
        ULONG  units      = 64ul*1024ul*1024ul/512ul; /* 64 megs */
        ULONG  unitsavail = 64ul*1024ul*1024ul/512ul; /* 64 megs */
        
        rc = NdAttach( drive, label, units, unitsavail );
        
        if ( rc != 0 )
        {
            printf("Attach failed: return code = %ld\n", rc);
        }
        else
        {
            printf("Attach successful. Drive letter created.\n");
        }
    }
    
    return rc;
}
