/*
 * RemoteBoxDialog.java
 */
import java.awt. *;
import java.awt.event.*;
import javax.swing. *;

/** The RemoteBoxDialog-class creates a dialog where you can specify the
 * hostname/ip-address and portnumber of a remote server running lreadjav
 * @author Werner Zimmermann
 */
public class RemoteBoxDialog extends JDialog
{   
    static final int CANCEL = 0;                                // status of the dialog after clicking the cancel-button
    static final int OK = 1;                                    // status of the dialog after clicking the ok-button
    int status = CANCEL;                                        // default-status of the dialog
    
    /** The RemoteBoxDialog()-method creates a new instance of this class showing the
     * given hostname and portnumber in the textfields
     * @param parentFrame the parent frame
     * @param hostName the given hostname of the remoteserver
     * @param portNumber the given portnumber of the remote host
     */
    public RemoteBoxDialog(Frame parentFrame, String hostName, String portNumber)
    {   
        super(parentFrame);
	// This code is automatically generated by Visual Cafe when you add
	// components to the visual environment. It instantiates and initializes
	// the components. To modify the code, only use code syntax that matches
	// what Visual Cafe can generate, or Visual Cafe may be unable to back
	// parse your Java file into its visual environment.
	//{{INIT_CONTROLS
		setModal(true);
		setTitle("LTOOL Connect to remote host");
		getContentPane().setLayout(new GridLayout(3,2,0,0));
		setSize(366,110);
		setVisible(false);
		remoteHostJLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
		remoteHostJLabel.setText("Remote host:");
		getContentPane().add(remoteHostJLabel);
		remoteHostJLabel.setFont(new Font("SansSerif", Font.BOLD, 12));
		remoteHostJLabel.setBounds(0,0,183,36);
		getContentPane().add(hostNameField);
		hostNameField.setFont(new Font("SansSerif", Font.BOLD, 12));
		hostNameField.setBounds(183,0,183,36);
		portNumberJLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
		portNumberJLabel.setText("Port number:");
		getContentPane().add(portNumberJLabel);
		portNumberJLabel.setFont(new Font("SansSerif", Font.BOLD, 12));
		portNumberJLabel.setBounds(0,36,183,36);
		getContentPane().add(portNumberField);
		portNumberField.setFont(new Font("SansSerif", Font.BOLD, 12));
		portNumberField.setBounds(183,36,183,36);
		okButton.setText("OK");
		okButton.setOpaque(false);
		okButton.setActionCommand("OK");
		okButton.setMnemonic((int)'O');
		getContentPane().add(okButton);
		okButton.setFont(new Font("SansSerif", Font.BOLD, 12));
		okButton.setBounds(0,72,183,36);
		cancelButton.setText("Cancel");
		cancelButton.setActionCommand("Cancel");
		getContentPane().add(cancelButton);
		cancelButton.setFont(new Font("SansSerif", Font.BOLD, 12));
		cancelButton.setBounds(183,72,183,36);
		//}}
	hostNameField.setText(hostName);
	portNumberField.setText(portNumber);
	
	//{{REGISTER_LISTENERS
	SymWindow aSymWindow = new SymWindow();
	 this.addWindowListener(aSymWindow);
	SymAction lSymAction = new SymAction();
	 okButton.addActionListener(lSymAction);
	 cancelButton.addActionListener(lSymAction);
	//}}
        
        getRootPane().setDefaultButton(okButton) ;
    }
    /** The getStatus() returns the status of the dialog, if the okbutton was clicked it
     * returns OK, if the cancelbutton was clicked it returns CANCEL
     * @return the status of the dialog
     */
    public int getStatus()
    {   
        return status;
    }
    /** the getHostName()-method returns the hostname in the hostNameField
     * @return the hostname in the hostNameField
     */
    public String getHostName()
    {   
        return hostNameField.getText();
    }
    /** the getPortNumber()-method returns the portnumber in the portNumberField
     * @return the portnumber in the portNumberField
     */
    public int getPortNumber()
    {   
        return ( new Integer(portNumberField.getText())).intValue();
    }
    /** the setVisible()-method sets the dialog visible or invisible
     * @param b true if the dialog should be visible
     */
    public void setVisible(boolean b)
    {   
        if (b)
        {   
            Rectangle bounds = (getParent()).getBounds();
            Dimension size = getSize();
            setLocation(bounds.x + (bounds.width - size.width) / 2,
                        bounds.y + (bounds.height - size.height) / 2);
        }
        super.setVisible(b);
    }
    /** calls the super.addNotify()-method */
    public void addNotify()
    {								// Record the size of the window prior to calling parents addNotify.
        Dimension d = getSize();
        super.addNotify();
        if (fComponentsAdjusted)
            return;
        // Adjust components according to the insets
        Insets insets = getInsets();
        setSize(insets.left + insets.right + d.width, insets.top + insets.bottom + d.height);
        Component components[] = getContentPane().getComponents();
        for (int i = 0; i < components.length; i++)
        {   
            Point p = components[i].getLocation();
            p.translate(insets.left, insets.top);
            components[i].setLocation(p);
        }
        fComponentsAdjusted = true;
    }
    // Used for addNotify check.
    boolean fComponentsAdjusted = false;

    //{{DECLARE_CONTROLS
	javax.swing.JLabel remoteHostJLabel = new javax.swing.JLabel();
	javax.swing.JTextField hostNameField = new javax.swing.JTextField();
	javax.swing.JLabel portNumberJLabel = new javax.swing.JLabel();
	javax.swing.JTextField portNumberField = new javax.swing.JTextField();
	javax.swing.JButton okButton = new javax.swing.JButton();
	javax.swing.JButton cancelButton = new javax.swing.JButton();
	//}}
    /** WindowAdapter-class */
    class SymWindow extends java.awt.event.WindowAdapter
    {
        /** it's called before closing the window
         * @param event the event data
         */
        public void windowClosing(java.awt.event.WindowEvent event)
        {   
            Object object = event.getSource();
            if (object == RemoteBoxDialog.this)
                jAboutDialog_windowClosing(event);
        }
    }
    /** it's called before closing the dialog
     * @param event the event data
     */
    void jAboutDialog_windowClosing(java.awt.event.WindowEvent event)
    {								// to do: code goes here.
        jAboutDialog_windowClosing_Interaction1(event);
    }
    /** it's called before closing the dialog
     * @param event the event data
     */
    void jAboutDialog_windowClosing_Interaction1(java.awt.event.WindowEvent event)
    {   
        try
        {
            this.setVisible(false);                             // JAboutDialog Hide the JAboutDialog
        }
        catch(Exception e)
        {
        }
    }
    /** ActionListener-class */
    class SymAction implements java.awt.event.ActionListener
    {   
        /** it's called after clicking the ok- or cancel-buttons
         * @param event the event data
         */        
        public void actionPerformed(java.awt.event.ActionEvent event)
        {   
            Object object = event.getSource();
            if (object == okButton)
                okButton_actionPerformed(event);
            else if (object == cancelButton)
                cancelButton_actionPerformed(event);
        }
    }
    /** it's called after clicking the ok-button
     * @param event the event data
     */
    void okButton_actionPerformed(java.awt.event.ActionEvent event)
    {   
        status = OK;
        try
        {
            this.setVisible(false);                             // JAboutDialog Hide the JAboutDialog
        }
        catch(Exception e)
        {
        }
    }
    /** it's called after clicking the cancel-button
     * @param event the event data
     */
    void cancelButton_actionPerformed(java.awt.event.ActionEvent event)
    {   
        status = CANCEL;
        try
        {
            this.setVisible(false);                             // JAboutDialog Hide the JAboutDialog
        }
        catch(Exception e)
        {
        }
    }
    /** This is only used for debugging purposes to run as stand alone program
     * @param args the commandline arguments
     */
    static public void main(String args[])
    {	
        JFrame myFrame = new JFrame("RemoteBoxDialog Test");
        myFrame.setSize(600,400);
        myFrame.setVisible(true);
    	RemoteBoxDialog myDialog = new RemoteBoxDialog(myFrame,"localhost","1605");
    	myDialog.setVisible(true);
    	myFrame.addWindowListener(new WindowAdapter()
        {   
            public void windowClosing(WindowEvent e)
            {   
                System.exit(0);
            }
        });
    }
}

