/*
 * LToolGuiTreeIconData.java
 */
import javax.swing.* ;

/** The LToolGuiTreeIconData-class represents a drive or a directory in the JTree of
 * a DirFilePane with an icon and a text.
 * @author Joerg Holzaepfel
 */
class LToolGuiTreeIconData
{
    protected Icon   icon;
    protected Icon   expandedIcon;
    protected Object data;

    /** This LToolGuiTreeIconData()-method creates a new instance of this class with the
     * given attributes (the same icon for the expanded node and the normal node).
     * @param icon the icon for the normal and expanded node
     * @param data the text of the node
     */
    public LToolGuiTreeIconData(Icon icon, Object data)
    {
        this.icon = icon;
        this.expandedIcon = null;
        this.data = data;
    }
    /** The LToolGuiTreeIconData()-method creates a new instance of this class with the
     * given attributes (different icons for the expanded node and the normal node).
     * @param icon the icon for the normal node
     * @param expandedIcon the icon for the expanded node
     * @param data the text of the node
     */
    public LToolGuiTreeIconData(Icon icon, Icon expandedIcon, Object data)
    {
        this.icon = icon;
        this.expandedIcon = expandedIcon;
        this.data = data;
    }
    /** the getIcon()-method returns the icon of the normal node.
     * @return the icon of the node
     */
    public Icon getIcon()
    {
        return this.icon;
    }
    /** the getExpandedIcon()-method returns the icon of the expanded node.
     * @return the icon of the expanded node
     */
    public Icon getExpandedIcon()
    {
        return this.expandedIcon != null ? this.expandedIcon : this.icon;
    }
    /** The getObject()-method returns the text of the node.
     * @return the text of the node
     */
    public Object getObject()
    {
        return this.data;
    }
    /** the toString()-method returns the data-field casted to a string.
     * @return the data-field as String.
     */
    public String toString()
    {
        return this.data.toString();
    }
}
