/*
 * LToolGuiTableMouseListener.java
 */
import java.util.*;
import java.awt.* ;
import java.awt.event.*;
import javax.swing.*;
//import javax.swing.tree.*;

/** The LToolGuiTableMouseListener is processing the MouseEvents of the JTable in a
 * DirFilePane.
 * @author Joerg Holzaepfel
 */
public class LToolGuiTableMouseListener implements MouseListener 
{
    DirFilePane parent ;                                        // The DirFilePane which adds this MouseListener
    JTable jTable ;                                             // The jTable-field of the DirFilePane
    LToolGuiTableModel tableModel ;                             // The tableModel-field of the DirFilePane
    JTree jTree ;                                               // The jTree-field of the DirFilePane
    boolean isLinux ;                                           // The isLinux-field of the DirFilePane
    ContextMenuTable contextMenuTable ;                         // The contextmenu 

    /** Creates a new instance of LToolGuiTableMouseListener
     * @param parent the DirFilePane to process MouseEvents
     */
    public LToolGuiTableMouseListener(DirFilePane parent) 
    {
        this.parent = parent ;
        jTable = parent.getJTable() ;
        tableModel = parent.getTableModel() ;
        jTree = parent.getJTree() ;
        isLinux = parent.isLinux() ;
        contextMenuTable = parent.getContextMenuTable() ;
    }
    /**
     * Invoked when the mouse button has been clicked (pressed
     * and released) on a component.
     * @param e the event data
     */
    public void mouseClicked(MouseEvent e) 
    {
        LTOOLSgui.setActiveDirFilePane((DirFilePane)parent) ;
        // DirFilePane dirFilePane = (DirFilePane)parent ;

        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        if (e.getClickCount() == 1)
        {
            // getButton() and MouseEvent.BUTTON3 since SunJava1.4
            // if (e.getButton() == MouseEvent.BUTTON3)            // right mouse-button
            if (e.getModifiers() == InputEvent.META_MASK)       // right mouse-button
            {
                Point mousePos = e.getPoint() ;
                int row = jTable.rowAtPoint(mousePos) ;

                if (jTable.getSelectedRowCount() == 0 ||
                        !jTable.isRowSelected(row))             // if no row selected
                {
                    jTable.setRowSelectionInterval(row, row) ;  // set this row selected
                }
                Vector items = parent.getSelectedListItemFile() ;
                
                if (items.size() == 1 && !((ListItemFile)items.elementAt(0)).getFileName().equals("..") ||
                    items.size() > 1)
                {
                    // just show the contextmenu if more than one file is selected
                    // or if only one file is selected and it's different from ".."
                    contextMenuTable.enableAllMenuItems() ;
                    contextMenuTable.show(jTable, e.getX(), e.getY()) ;
                }
                else if (items.size() == 1 && ((ListItemFile)items.elementAt(0)).getFileName().equals(".."))
                {
                    contextMenuTable.disableAllMenuItemsExceptNewPaste() ;
                    contextMenuTable.show(jTable, e.getX(), e.getY()) ;                    
                }
            }
        }
        // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        else if (e.getClickCount() >= 2)
        {
            if (isLinux)
            {
                parent.doubleClickLinuxTable() ;
            }
            else
            {
                parent.doubleClickDOSTable() ;
            }
        }
    }
    /** Invoked when the mouse enters a component.
     * @param e the event data
     */
    public void mouseEntered(MouseEvent e) 
    {
        // debugOutput("jTable.mouseEntered()") ;
    }
    /** Invoked when the mouse exits a component.
     * @param e the event data
     */
    public void mouseExited(MouseEvent e) 
    {
        // debugOutput("jTable.mouseExited()") ;
    }
    /** Invoked when a mouse button has been pressed on a component.
     * @param e the event data
     */
    public void mousePressed(MouseEvent e) 
    {
        // debugOutput("jTable.mousePressed()") ;
        LTOOLSgui.setActiveDirFilePane((DirFilePane)parent) ;
    }
    /** Invoked when a mouse button has been released on a component.
     * @param e the event data
     */
    public void mouseReleased(MouseEvent e) 
    {
        // debugOutput("jTable.mouseReleased()") ;
    }
}
