/*
 * FilePatternDialog.java
 */
import java.awt.*;
import javax.swing.*;

/** The FilePatternDialog-class extends the JDialog-class and is dialog where you
 * can specify a pattern for Files to search in the directories.
 * @author Joerg Holzaepfel
 */
public class FilePatternDialog extends javax.swing.JDialog
{
    static final boolean CANCEL = false ;                       // status of the dialog after clicking the cancel-button
    static final boolean OK = true ;                            // status of the dialog after clicking the ok-button
    private boolean status = CANCEL ;                           // the default-status of the dialog

    /** Creates new form FilePatternDialog
     * @param parent the parent-frame
     * @param modal true if the dialog should be modal
     * @param pattern the pattern to show in the dialog
     * @param isLinux true if the pattern should be for linux-filesystem
     */
	public FilePatternDialog(Frame parent, boolean modal, String pattern, boolean isLinux)
	{
		super(parent, modal);
		
		// This code is automatically generated by Visual Cafe when you add
		// components to the visual environment. It instantiates and initializes
		// the components. To modify the code, only use code syntax that matches
		// what Visual Cafe can generate, or Visual Cafe may be unable to back
		// parse your Java file into its visual environment.
		//{{INIT_CONTROLS
		setResizable(false);
		getContentPane().setLayout(new BorderLayout(0,0));
		setSize(300,101);
		setVisible(false);
		northJPanel.setLayout(new BorderLayout(0,0));
		getContentPane().add(BorderLayout.NORTH,northJPanel);
		northJPanel.setBounds(0,0,300,0);
		eastJPanel.setLayout(new FlowLayout(FlowLayout.CENTER,5,5));
		getContentPane().add(BorderLayout.EAST,eastJPanel);
		eastJPanel.setBounds(290,0,10,66);
		southJPanel.setLayout(new FlowLayout(FlowLayout.CENTER,5,5));
		getContentPane().add(BorderLayout.SOUTH,southJPanel);
		southJPanel.setBounds(0,66,300,35);
		okJButton.setSelected(true);
		okJButton.setText("OK");
		okJButton.setActionCommand("OK");
		southJPanel.add(okJButton);
		okJButton.setBounds(85,5,51,25);
		cancelJButton.setText("Cancel");
		cancelJButton.setActionCommand("Cancel");
		southJPanel.add(cancelJButton);
		cancelJButton.setBounds(141,5,73,25);
		westJPanel.setLayout(new FlowLayout(FlowLayout.CENTER,5,5));
		getContentPane().add(BorderLayout.WEST,westJPanel);
		westJPanel.setBounds(0,0,10,66);
		centerJPanel.setLayout(new GridLayout(3,3,0,0));
		getContentPane().add(BorderLayout.CENTER,centerJPanel);
		centerJPanel.setBounds(10,0,280,66);
		topJPanel.setLayout(new FlowLayout(FlowLayout.CENTER,5,5));
		centerJPanel.add(topJPanel);
		topJPanel.setBounds(0,0,280,22);
		inputJPanel.setLayout(new GridLayout(1,3,0,0));
		centerJPanel.add(inputJPanel);
		inputJPanel.setBounds(0,22,280,22);
		patternJLabel.setText("File Pattern:");
		inputJPanel.add(patternJLabel);
		patternJLabel.setBounds(0,0,93,22);
		inputJPanel.add(patternJTextField);
		patternJTextField.setBounds(93,0,93,22);
		resetJButton.setText("Reset");
		resetJButton.setActionCommand("Reset");
		inputJPanel.add(resetJButton);
		resetJButton.setBounds(186,0,93,22);
		bottomJPanel.setLayout(new FlowLayout(FlowLayout.CENTER,5,5));
		centerJPanel.add(bottomJPanel);
		bottomJPanel.setBounds(0,44,280,22);
		//}}

		//{{REGISTER_LISTENERS
		SymAction lSymAction = new SymAction();
		resetJButton.addActionListener(lSymAction);
		okJButton.addActionListener(lSymAction);
		cancelJButton.addActionListener(lSymAction);
		//}}

        this.patternJTextField.setText(pattern) ;
        if (isLinux)
        {
            this.setTitle("LTOOLS - Linux FilePattern") ;
        }
        else
        {
            this.setTitle("LTOOLS - DOS FilePattern") ;
        }
        int x = parent.getLocation().x + (parent.getWidth()/2 - this.getWidth()/2) ;
        int y = parent.getLocation().y + (parent.getHeight()/2 - this.getHeight()/2) ;
        this.setLocation(new Point(x, y)) ;
        //getRootPane().setDefaultButton(jButtonOK) ;
	}

    /** sets the dialog visible or invisible
     * @param b true if the dialog should be shown
     */    
	public void setVisible(boolean b)
	{
		if (b)
			setLocation(50, 50);
		super.setVisible(b);
	}

    /** the main()-method is just for testing
     * @param args the commandline arguments
     */    
	static public void main(String args[])
	{
        JFrame frame = new JFrame() ;
        frame.setSize(300, 200) ;
        frame.setVisible(true) ;
        FilePatternDialog dialog = new FilePatternDialog(frame, true, "*.java", false) ;
        dialog.show() ;
        System.out.println("status of the dialog: " + dialog.getStatus()) ;
        System.out.println("filepattern         : " + dialog.getFilePattern()) ;
        System.exit(0) ;
	}

    /** calls the super.addNodify()-method */    
	public void addNotify()
	{
		// Record the size of the window prior to calling parents addNotify.
		Dimension size = getSize();

		super.addNotify();

		if (frameSizeAdjusted)
			return;
		frameSizeAdjusted = true;

		// Adjust size of frame according to the insets
		Insets insets = getInsets();
		setSize(insets.left + insets.right + size.width, insets.top + insets.bottom + size.height);
	}

	// Used by addNotify
	boolean frameSizeAdjusted = false;

	//{{DECLARE_CONTROLS
	javax.swing.JPanel northJPanel = new javax.swing.JPanel();
	javax.swing.JPanel eastJPanel = new javax.swing.JPanel();
	javax.swing.JPanel southJPanel = new javax.swing.JPanel();
	javax.swing.JButton okJButton = new javax.swing.JButton();
	javax.swing.JButton cancelJButton = new javax.swing.JButton();
	javax.swing.JPanel westJPanel = new javax.swing.JPanel();
	javax.swing.JPanel centerJPanel = new javax.swing.JPanel();
	javax.swing.JPanel topJPanel = new javax.swing.JPanel();
	javax.swing.JPanel inputJPanel = new javax.swing.JPanel();
	javax.swing.JLabel patternJLabel = new javax.swing.JLabel();
	javax.swing.JTextField patternJTextField = new javax.swing.JTextField();
	javax.swing.JButton resetJButton = new javax.swing.JButton();
	javax.swing.JPanel bottomJPanel = new javax.swing.JPanel();
	//}}


    /** ActionListener-class */    
	class SymAction implements java.awt.event.ActionListener
	{
        /** the actionPerformed()-method of the ActionListener
         * @param event the event data
         */        
		public void actionPerformed(java.awt.event.ActionEvent event)
		{
			Object object = event.getSource();
			if (object == resetJButton)
				resetJButton_actionPerformed(event);
			else if (object == okJButton)
				okJButton_actionPerformed(event);
			else if (object == cancelJButton)
				cancelJButton_actionPerformed(event);
		}
	}

    /** invoked when the resetJButton was pressed and sets the text of the
     * patternJTextField to "*" (show all files)
     * @param event the event data
     */    
	void resetJButton_actionPerformed(java.awt.event.ActionEvent event)
	{
        patternJTextField.setText("*") ;
	}

    /** invoked when the OK-buttons was pressed and sets the staus of the dialog to OK
     * @param event the event data
     */    
	void okJButton_actionPerformed(java.awt.event.ActionEvent event)
	{
        this.status = true ;
        setVisible(false);
	}

    /** invoked when the cancel-buttons was pressed and sets the staus of the dialog to
     * CANCEL
     * @param event the event data
     */    
	void cancelJButton_actionPerformed(java.awt.event.ActionEvent event)
	{
        this.status = false ;
        setVisible(false);
	}
    /** the getFilePattern()-method returns the new pattern in the patternJTextField
     * @return the new file-pattern for the filemanager
     */
    public String getFilePattern() 
    {
        return patternJTextField.getText() ;
    }    
    /** the getStatus()-method returns the status of the dialog. It returns true if the
     * ok-button was pressed or false if the cancel-button was pressed.
     * @return the status of the dialog
     */
    public boolean getStatus()
    {
        return status ;
    }
}