using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.IO ;

namespace FHTE.LTOOLS.GUI
{
    /// <summary>
    /// The MyDebug-Class creates a form with a textBox to show debugging-output.
    /// </summary>
    public class MyDebug : System.Windows.Forms.Form
    {
		#region Fields
        // ############################################################################################################
        // FIELDS
        // ############################################################################################################
        private System.Windows.Forms.TextBox debugOutput;
        private System.Windows.Forms.Panel textBoxPanel;
        private System.Windows.Forms.SaveFileDialog saveFileDialog;
		private System.Windows.Forms.Panel panelMain;
		private System.Windows.Forms.MainMenu mainMenu;
		private System.Windows.Forms.MenuItem menuItemFile;
		private System.Windows.Forms.MenuItem menuItemSave;
		private System.Windows.Forms.MenuItem menuItemClear;
		private System.Windows.Forms.MenuItem menuItemClose;
        /// <summary>
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.Container components = null;
		#endregion

		#region Properties
        // ############################################################################################################
        // PROPERTIES
        // ############################################################################################################
        /// <summary>
        /// returns a line as separator in the debug-output
        /// </summary>
        public static string SeparatorLine 
        {
            get { return "\r\n##############################################################\r\n" ; }
        }
		#endregion


		#region Constructors
        // ############################################################################################################
        // CONSTRUCTORS
        // ############################################################################################################
        /// <summary>
        /// The MyDebug()-constructor creates a form with a textbox and the possibility to save the output in file.
        /// </summary>
        public MyDebug()
        {
            //
            // Required for Windows Form Designer support
            //
            InitializeComponent();

            //
            // TODO: Add any constructor code after InitializeComponent call
            //
            this.Show() ;
            this.debugOutput.Text = DateTime.Now.ToString() + SeparatorLine ;
        }
		#endregion


		#region Methods
        // ############################################################################################################
        // METHODS
        // ############################################################################################################
        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose( bool disposing )
        {
            if( disposing )
            {
                if(components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose( disposing );
        }
        
		#region Windows Form Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
        {
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(MyDebug));
			this.debugOutput = new System.Windows.Forms.TextBox();
			this.panelMain = new System.Windows.Forms.Panel();
			this.textBoxPanel = new System.Windows.Forms.Panel();
			this.saveFileDialog = new System.Windows.Forms.SaveFileDialog();
			this.mainMenu = new System.Windows.Forms.MainMenu();
			this.menuItemFile = new System.Windows.Forms.MenuItem();
			this.menuItemSave = new System.Windows.Forms.MenuItem();
			this.menuItemClear = new System.Windows.Forms.MenuItem();
			this.menuItemClose = new System.Windows.Forms.MenuItem();
			this.panelMain.SuspendLayout();
			this.textBoxPanel.SuspendLayout();
			this.SuspendLayout();
			// 
			// debugOutput
			// 
			this.debugOutput.Dock = System.Windows.Forms.DockStyle.Fill;
			this.debugOutput.Multiline = true;
			this.debugOutput.Name = "debugOutput";
			this.debugOutput.ScrollBars = System.Windows.Forms.ScrollBars.Both;
			this.debugOutput.Size = new System.Drawing.Size(742, 374);
			this.debugOutput.TabIndex = 0;
			this.debugOutput.Text = "";
			// 
			// panelMain
			// 
			this.panelMain.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.textBoxPanel});
			this.panelMain.Dock = System.Windows.Forms.DockStyle.Fill;
			this.panelMain.Name = "panelMain";
			this.panelMain.Size = new System.Drawing.Size(742, 374);
			this.panelMain.TabIndex = 1;
			// 
			// textBoxPanel
			// 
			this.textBoxPanel.Controls.AddRange(new System.Windows.Forms.Control[] {
																					   this.debugOutput});
			this.textBoxPanel.Dock = System.Windows.Forms.DockStyle.Fill;
			this.textBoxPanel.Name = "textBoxPanel";
			this.textBoxPanel.Size = new System.Drawing.Size(742, 374);
			this.textBoxPanel.TabIndex = 2;
			// 
			// saveFileDialog
			// 
			this.saveFileDialog.DefaultExt = "txt";
			this.saveFileDialog.FileName = "debugOutput";
			this.saveFileDialog.Filter = "Text files|*.txt|All files|*.*";
			this.saveFileDialog.Title = "Save file to";
			// 
			// mainMenu
			// 
			this.mainMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					 this.menuItemFile});
			// 
			// menuItemFile
			// 
			this.menuItemFile.Index = 0;
			this.menuItemFile.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						 this.menuItemSave,
																						 this.menuItemClear,
																						 this.menuItemClose});
			this.menuItemFile.Text = "File";
			// 
			// menuItemSave
			// 
			this.menuItemSave.Index = 0;
			this.menuItemSave.Text = "Save As ...";
			this.menuItemSave.Click += new System.EventHandler(this.MenuItemSave_Click);
			// 
			// menuItemClear
			// 
			this.menuItemClear.Index = 1;
			this.menuItemClear.Text = "Clear TextBox";
			this.menuItemClear.Click += new System.EventHandler(this.MenuItemClear_Click);
			// 
			// menuItemClose
			// 
			this.menuItemClose.Index = 2;
			this.menuItemClose.Text = "Close Debug Dialog";
			this.menuItemClose.Click += new System.EventHandler(this.MenuItemClose_Click);
			// 
			// MyDebug
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(742, 374);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.panelMain});
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.Location = new System.Drawing.Point(10, 10);
			this.Menu = this.mainMenu;
			this.Name = "MyDebug";
			this.SizeGripStyle = System.Windows.Forms.SizeGripStyle.Show;
			this.StartPosition = System.Windows.Forms.FormStartPosition.Manual;
			this.Text = "LTOOLS debug output";
			this.Closing += new System.ComponentModel.CancelEventHandler(this.MyDebug_Closing);
			this.panelMain.ResumeLayout(false);
			this.textBoxPanel.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

        /// <summary>
        /// just appends a debug-string to the TextBox
        /// </summary>
        /// <param name="str">a debug output</param>
        public void AppendText(string str)
        {
            debugOutput.AppendText(str) ;
        }
        /// <summary>
        /// the MyDebug_Closing() method cancels ths closing event of the Dialog window and
        /// sets Visible to false.
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void MyDebug_Closing(object sender, System.ComponentModel.CancelEventArgs e)
        {
            e.Cancel = true ;
            this.Visible = false ;
        }
		/// <summary>
		/// the MenuItemSave_Click() method opens a SaveFileDialog() to save the text in the textbox in a file.
		/// </summary>
		/// <param name="sender">sender object</param>
		/// <param name="e">event data</param>
		private void MenuItemSave_Click(object sender, System.EventArgs e)
		{
			try
			{
				if (this.saveFileDialog.ShowDialog() == DialogResult.OK)
				{
					Stream myStream ;
					if((myStream = saveFileDialog.OpenFile()) != null)
					{
						// Code to write the stream goes here.
						StreamWriter sw = new StreamWriter(myStream) ;
						sw.Write(debugOutput.Text) ;
						sw.Close() ;
						myStream.Close();
					}
				}
			}
			catch (Exception ex)
			{
				debugOutput.AppendText(ex.Message + SeparatorLine + ex.Source + SeparatorLine + ex.StackTrace) ;
			}
		}
		/// <summary>
        /// the MenuItemClear_Click() method clears the textbox.
		/// </summary>
		/// <param name="sender">sender object</param>
		/// <param name="e">event data</param>
		private void MenuItemClear_Click(object sender, System.EventArgs e)
		{
			debugOutput.Clear() ;
			this.debugOutput.Text = DateTime.Now.ToString() + SeparatorLine ;
		}
		/// <summary>
		/// the MenuItemClose_Click() set the Visible-property to false
		/// </summary>
		/// <param name="sender">sender object</param>
		/// <param name="e">event data</param>
		private void MenuItemClose_Click(object sender, System.EventArgs e)
		{
			this.Visible = false ;
		}
		#endregion
    }
}
