using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace FHTE.LTOOLS.GUI
{
	/// <summary>
	/// It's a Dialog to modify the name and attributes of a (Linux)file.
	/// </summary>
	public class ModifyLinuxDialog : System.Windows.Forms.Form
	{
        // ############################################################################################################
        // FIELDS
        // ############################################################################################################
        private System.Windows.Forms.Label nameLabel;
        private System.Windows.Forms.Label modificationDateLabel;
        private System.Windows.Forms.Label lengthLabel;
        private System.Windows.Forms.Label gidLabel;
        private System.Windows.Forms.TextBox fileNameTextBox;
        private System.Windows.Forms.TextBox fileDateTextBox;
        private System.Windows.Forms.Label fileLengthLabel;
        private System.Windows.Forms.Label uidLabel;
        private System.Windows.Forms.TextBox gidTextBox;
        private System.Windows.Forms.TextBox uidTextBox;
        private System.Windows.Forms.Label typeLabel;
        private System.Windows.Forms.CheckBox dirCheckBox;
        private System.Windows.Forms.CheckBox linkCheckBox;
        private System.Windows.Forms.CheckBox devCheckBox;
        private System.Windows.Forms.Label userAccessLabel;
        private System.Windows.Forms.CheckBox rUserCheckBox;
        private System.Windows.Forms.CheckBox wUserCheckBox;
        private System.Windows.Forms.CheckBox xUserCheckBox;
        private System.Windows.Forms.CheckBox xGroupCheckBox;
        private System.Windows.Forms.CheckBox wGroupCheckBox;
        private System.Windows.Forms.CheckBox rGroupCheckBox;
        private System.Windows.Forms.Label groupAccessLabel;
        private System.Windows.Forms.CheckBox xWorldCheckBox;
        private System.Windows.Forms.CheckBox wWorldCheckBox;
        private System.Windows.Forms.CheckBox rWorldCheckBox;
        private System.Windows.Forms.Label worldAccessLabel;
        private System.Windows.Forms.Button okButton;
        private System.Windows.Forms.Button cancelButton;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
        private static bool isAccessChanged = false ;           // true if the access of a file has changed
        string accessString ;                                   // the access to the file before modification.
        // ############################################################################################################
        // PROPERTIES
        // ############################################################################################################
        /// <summary>
        /// returns the fileName
        /// </summary>
        public string FileName
        {
            get { return fileNameTextBox.Text ; }
        }
        /// <summary>
        /// returns the UID
        /// </summary>
        public string UID
        {
            get { return uidTextBox.Text ; }
        }
        /// <summary>
        /// returns the GID
        /// </summary>
        public string GID
        {
            get { return gidTextBox.Text ; }
        }
        /// <summary>
        /// returns the Access rights of the User, Group and World
        /// </summary>
        public string Access
        {
            get
            {
                int accessUser = 0, accessGroup = 0, accessWorld = 0;
                // User
                if (rUserCheckBox.Checked)
                {
                    accessUser += 4 ;
                }
                if (wUserCheckBox.Checked)
                {
                    accessUser += 2 ;
                }
                if (xUserCheckBox.Checked)
                {
                    accessUser += 1 ;
                }
                // Group
                if (rGroupCheckBox.Checked)
                {
                    accessGroup += 4 ;
                }
                if (wGroupCheckBox.Checked)
                {
                    accessGroup += 2 ;
                }
                if (xGroupCheckBox.Checked)
                {
                    accessGroup += 1 ;
                }
                // World
                if (rWorldCheckBox.Checked)
                {
                    accessWorld += 4 ;
                }
                if (wWorldCheckBox.Checked)
                {
                    accessWorld += 2 ;
                }
                if (xWorldCheckBox.Checked)
                {
                    accessWorld += 1 ;
                }
                return (accessUser.ToString() + accessGroup.ToString() + accessWorld.ToString()) ;
            }
        }
        /// <summary>
        /// returns a bool value if the file is a directory or not
        /// </summary>
        public bool IsDirectory
        {
            get { return dirCheckBox.Checked ; }
        }
        /// <summary>
        /// returns a bool value if the file is a link or not
        /// </summary>
        public bool IsLink
        {
            get { return linkCheckBox.Checked ; }
        }
        /// <summary>
        /// returns the value in the fileDateTextBox (????)
        /// </summary>
        public string TargetName
        {
            get { return fileDateTextBox.Text ; }
        }
        /// <summary>
        /// returns a bool value if the access of the file has changed
        /// </summary>
        public bool IsAccessChanged
        {
            get { return isAccessChanged ;}
        }

        // ############################################################################################################
        // CONSTRUCTORS
        // ############################################################################################################
        /// <summary>
        /// The Constructor sets the values in the ModifyLinuxDialog.
        /// </summary>
        /// <param name="isNew">true if you want to create a new directory or symbolic link</param>
        /// <param name="fileName">the filename of the modify-file</param>
        /// <param name="fileDate">the last modified date of the file</param>
        /// <param name="fileLength">the size of the file</param>
        /// <param name="uid">the UserID of the file</param>
        /// <param name="gid">the GroupID of the file</param>
        /// <param name="access">the access rights of the file in a string like "rwxr-xr--"</param>
        public ModifyLinuxDialog(bool isNew, string fileName, string fileDate,
		   string fileLength, string uid, string gid, string access)
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
			if (isNew)
			{
			    this.Text = "LTOOLS New Linux directory or symlink" ;
			    dirCheckBox.Enabled  = true ;
			    dirCheckBox.Checked  = true ;
			    linkCheckBox.Enabled = true ;
			}
			fileNameTextBox.Text = fileName ;
			fileDateTextBox.Text = fileDate ;
			fileLengthLabel.Text = fileLength ;
			gidTextBox.Text = gid ;
			uidTextBox.Text = uid ;
			
			if (access.StartsWith("d"))
			{
			    dirCheckBox.Checked = true ;
			}
			if (access.StartsWith("l"))
			{
			    linkCheckBox.Checked = true ;
			}
			if (!access.StartsWith("-") && !access.StartsWith("d") && !access.StartsWith("l"))
			{
			    devCheckBox.Checked = true ;
			}
			
			if (access.Length >= 10)
			{   // USER-CheckBox   
			             // startIndex, length
			    if (access.Substring(1, 1).Equals("r"))
			    {
			        rUserCheckBox.Checked = true ;
			    }
                if (access.Substring(2, 1).Equals("w"))
                {
                    wUserCheckBox.Checked = true ;
                }
                if (access.Substring(3, 1).Equals("x"))
                {
                    xUserCheckBox.Checked = true ;
                }
                // Group-CheckBox
                if (access.Substring(4, 1).Equals("r"))
                {
                    rGroupCheckBox.Checked = true ;
                }
                if (access.Substring(5, 1).Equals("w"))
                {
                    wGroupCheckBox.Checked = true ;
                }
                if (access.Substring(6, 1).Equals("x"))
                {
                    xGroupCheckBox.Checked = true ;
                }
                // World-CheckBox
                if (access.Substring(7, 1).Equals("r"))
                {
                    rWorldCheckBox.Checked = true ;
                }
                if (access.Substring(8, 1).Equals("w"))
                {
                    wWorldCheckBox.Checked = true ;
                }
                if (access.Substring(9, 1).Equals("x"))
                {
                    xWorldCheckBox.Checked = true ;
                }
			}
            accessString = Access ;
		}

        // ############################################################################################################
        // METHODS
        // ############################################################################################################
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
		    System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(ModifyLinuxDialog));
		    this.nameLabel = new System.Windows.Forms.Label();
		    this.modificationDateLabel = new System.Windows.Forms.Label();
		    this.lengthLabel = new System.Windows.Forms.Label();
		    this.gidLabel = new System.Windows.Forms.Label();
		    this.fileNameTextBox = new System.Windows.Forms.TextBox();
		    this.fileDateTextBox = new System.Windows.Forms.TextBox();
		    this.fileLengthLabel = new System.Windows.Forms.Label();
		    this.uidLabel = new System.Windows.Forms.Label();
		    this.gidTextBox = new System.Windows.Forms.TextBox();
		    this.uidTextBox = new System.Windows.Forms.TextBox();
		    this.typeLabel = new System.Windows.Forms.Label();
		    this.dirCheckBox = new System.Windows.Forms.CheckBox();
		    this.linkCheckBox = new System.Windows.Forms.CheckBox();
		    this.devCheckBox = new System.Windows.Forms.CheckBox();
		    this.userAccessLabel = new System.Windows.Forms.Label();
		    this.rUserCheckBox = new System.Windows.Forms.CheckBox();
		    this.wUserCheckBox = new System.Windows.Forms.CheckBox();
		    this.xUserCheckBox = new System.Windows.Forms.CheckBox();
		    this.xGroupCheckBox = new System.Windows.Forms.CheckBox();
		    this.wGroupCheckBox = new System.Windows.Forms.CheckBox();
		    this.rGroupCheckBox = new System.Windows.Forms.CheckBox();
		    this.groupAccessLabel = new System.Windows.Forms.Label();
		    this.xWorldCheckBox = new System.Windows.Forms.CheckBox();
		    this.wWorldCheckBox = new System.Windows.Forms.CheckBox();
		    this.rWorldCheckBox = new System.Windows.Forms.CheckBox();
		    this.worldAccessLabel = new System.Windows.Forms.Label();
		    this.okButton = new System.Windows.Forms.Button();
		    this.cancelButton = new System.Windows.Forms.Button();
		    this.SuspendLayout();
		    // 
		    // nameLabel
		    // 
		    this.nameLabel.Location = new System.Drawing.Point(20, 30);
		    this.nameLabel.Name = "nameLabel";
		    this.nameLabel.Size = new System.Drawing.Size(123, 19);
		    this.nameLabel.TabIndex = 0;
		    this.nameLabel.Text = "Name:";
		    // 
		    // modificationDateLabel
		    // 
		    this.modificationDateLabel.Location = new System.Drawing.Point(20, 69);
		    this.modificationDateLabel.Name = "modificationDateLabel";
		    this.modificationDateLabel.Size = new System.Drawing.Size(123, 20);
		    this.modificationDateLabel.TabIndex = 1;
		    this.modificationDateLabel.Text = "Modification date:";
		    // 
		    // lengthLabel
		    // 
		    this.lengthLabel.Location = new System.Drawing.Point(20, 109);
		    this.lengthLabel.Name = "lengthLabel";
		    this.lengthLabel.Size = new System.Drawing.Size(123, 19);
		    this.lengthLabel.TabIndex = 2;
		    this.lengthLabel.Text = "Length:";
		    // 
		    // gidLabel
		    // 
		    this.gidLabel.Location = new System.Drawing.Point(82, 158);
		    this.gidLabel.Name = "gidLabel";
		    this.gidLabel.Size = new System.Drawing.Size(61, 30);
		    this.gidLabel.TabIndex = 3;
		    this.gidLabel.Text = "GID";
		    // 
		    // fileNameTextBox
		    // 
		    this.fileNameTextBox.Location = new System.Drawing.Point(154, 30);
		    this.fileNameTextBox.MaxLength = 255;
		    this.fileNameTextBox.Name = "fileNameTextBox";
		    this.fileNameTextBox.Size = new System.Drawing.Size(235, 22);
		    this.fileNameTextBox.TabIndex = 4;
		    this.fileNameTextBox.Text = "fileName";
		    // 
		    // fileDateTextBox
		    // 
		    this.fileDateTextBox.Enabled = false;
		    this.fileDateTextBox.Location = new System.Drawing.Point(154, 69);
		    this.fileDateTextBox.Name = "fileDateTextBox";
		    this.fileDateTextBox.Size = new System.Drawing.Size(235, 22);
		    this.fileDateTextBox.TabIndex = 5;
		    this.fileDateTextBox.Text = "fileDate";
		    // 
		    // fileLengthLabel
		    // 
		    this.fileLengthLabel.Location = new System.Drawing.Point(154, 109);
		    this.fileLengthLabel.Name = "fileLengthLabel";
		    this.fileLengthLabel.Size = new System.Drawing.Size(235, 19);
		    this.fileLengthLabel.TabIndex = 6;
		    this.fileLengthLabel.Text = "fileLength";
		    // 
		    // uidLabel
		    // 
		    this.uidLabel.Location = new System.Drawing.Point(215, 158);
		    this.uidLabel.Name = "uidLabel";
		    this.uidLabel.Size = new System.Drawing.Size(41, 28);
		    this.uidLabel.TabIndex = 7;
		    this.uidLabel.Text = "UID";
		    // 
		    // gidTextBox
		    // 
		    this.gidTextBox.Location = new System.Drawing.Point(133, 158);
		    this.gidTextBox.MaxLength = 4;
		    this.gidTextBox.Name = "gidTextBox";
		    this.gidTextBox.Size = new System.Drawing.Size(62, 22);
		    this.gidTextBox.TabIndex = 8;
		    this.gidTextBox.Text = "GID";
		    // 
		    // uidTextBox
		    // 
		    this.uidTextBox.Location = new System.Drawing.Point(266, 158);
		    this.uidTextBox.MaxLength = 4;
		    this.uidTextBox.Name = "uidTextBox";
		    this.uidTextBox.Size = new System.Drawing.Size(62, 22);
		    this.uidTextBox.TabIndex = 9;
		    this.uidTextBox.Text = "UID";
		    // 
		    // typeLabel
		    // 
		    this.typeLabel.Location = new System.Drawing.Point(20, 207);
		    this.typeLabel.Name = "typeLabel";
		    this.typeLabel.Size = new System.Drawing.Size(62, 30);
		    this.typeLabel.TabIndex = 10;
		    this.typeLabel.Text = "Type:";
		    // 
		    // dirCheckBox
		    // 
		    this.dirCheckBox.Enabled = false;
		    this.dirCheckBox.Location = new System.Drawing.Point(123, 207);
		    this.dirCheckBox.Name = "dirCheckBox";
		    this.dirCheckBox.Size = new System.Drawing.Size(61, 30);
		    this.dirCheckBox.TabIndex = 11;
		    this.dirCheckBox.Text = "Dir";
		    this.dirCheckBox.Click += new System.EventHandler(this.DirCheckBox_Click);
		    // 
		    // linkCheckBox
		    // 
		    this.linkCheckBox.Enabled = false;
		    this.linkCheckBox.Location = new System.Drawing.Point(205, 207);
		    this.linkCheckBox.Name = "linkCheckBox";
		    this.linkCheckBox.Size = new System.Drawing.Size(82, 30);
		    this.linkCheckBox.TabIndex = 12;
		    this.linkCheckBox.Text = "Link";
		    this.linkCheckBox.Click += new System.EventHandler(this.LinkCheckBox_Click);
		    // 
		    // devCheckBox
		    // 
		    this.devCheckBox.Enabled = false;
		    this.devCheckBox.Location = new System.Drawing.Point(307, 207);
		    this.devCheckBox.Name = "devCheckBox";
		    this.devCheckBox.Size = new System.Drawing.Size(82, 30);
		    this.devCheckBox.TabIndex = 13;
		    this.devCheckBox.Text = "Dev";
		    // 
		    // userAccessLabel
		    // 
		    this.userAccessLabel.Location = new System.Drawing.Point(20, 257);
		    this.userAccessLabel.Name = "userAccessLabel";
		    this.userAccessLabel.Size = new System.Drawing.Size(134, 29);
		    this.userAccessLabel.TabIndex = 14;
		    this.userAccessLabel.Text = "User access rights:";
		    // 
		    // rUserCheckBox
		    // 
		    this.rUserCheckBox.Location = new System.Drawing.Point(205, 257);
		    this.rUserCheckBox.Name = "rUserCheckBox";
		    this.rUserCheckBox.Size = new System.Drawing.Size(41, 29);
		    this.rUserCheckBox.TabIndex = 15;
		    this.rUserCheckBox.Text = "r";
		    // 
		    // wUserCheckBox
		    // 
		    this.wUserCheckBox.Location = new System.Drawing.Point(266, 257);
		    this.wUserCheckBox.Name = "wUserCheckBox";
		    this.wUserCheckBox.Size = new System.Drawing.Size(41, 29);
		    this.wUserCheckBox.TabIndex = 16;
		    this.wUserCheckBox.Text = "w";
		    // 
		    // xUserCheckBox
		    // 
		    this.xUserCheckBox.Location = new System.Drawing.Point(328, 257);
		    this.xUserCheckBox.Name = "xUserCheckBox";
		    this.xUserCheckBox.Size = new System.Drawing.Size(41, 29);
		    this.xUserCheckBox.TabIndex = 17;
		    this.xUserCheckBox.Text = "x";
		    // 
		    // xGroupCheckBox
		    // 
		    this.xGroupCheckBox.Location = new System.Drawing.Point(328, 306);
		    this.xGroupCheckBox.Name = "xGroupCheckBox";
		    this.xGroupCheckBox.Size = new System.Drawing.Size(41, 30);
		    this.xGroupCheckBox.TabIndex = 21;
		    this.xGroupCheckBox.Text = "x";
		    // 
		    // wGroupCheckBox
		    // 
		    this.wGroupCheckBox.Location = new System.Drawing.Point(266, 306);
		    this.wGroupCheckBox.Name = "wGroupCheckBox";
		    this.wGroupCheckBox.Size = new System.Drawing.Size(41, 30);
		    this.wGroupCheckBox.TabIndex = 20;
		    this.wGroupCheckBox.Text = "w";
		    // 
		    // rGroupCheckBox
		    // 
		    this.rGroupCheckBox.Location = new System.Drawing.Point(205, 306);
		    this.rGroupCheckBox.Name = "rGroupCheckBox";
		    this.rGroupCheckBox.Size = new System.Drawing.Size(41, 30);
		    this.rGroupCheckBox.TabIndex = 19;
		    this.rGroupCheckBox.Text = "r";
		    // 
		    // groupAccessLabel
		    // 
		    this.groupAccessLabel.Location = new System.Drawing.Point(20, 306);
		    this.groupAccessLabel.Name = "groupAccessLabel";
		    this.groupAccessLabel.Size = new System.Drawing.Size(144, 30);
		    this.groupAccessLabel.TabIndex = 18;
		    this.groupAccessLabel.Text = "Group access rights:";
		    // 
		    // xWorldCheckBox
		    // 
		    this.xWorldCheckBox.Location = new System.Drawing.Point(328, 355);
		    this.xWorldCheckBox.Name = "xWorldCheckBox";
		    this.xWorldCheckBox.Size = new System.Drawing.Size(41, 30);
		    this.xWorldCheckBox.TabIndex = 25;
		    this.xWorldCheckBox.Text = "x";
		    // 
		    // wWorldCheckBox
		    // 
		    this.wWorldCheckBox.Location = new System.Drawing.Point(266, 355);
		    this.wWorldCheckBox.Name = "wWorldCheckBox";
		    this.wWorldCheckBox.Size = new System.Drawing.Size(41, 30);
		    this.wWorldCheckBox.TabIndex = 24;
		    this.wWorldCheckBox.Text = "w";
		    // 
		    // rWorldCheckBox
		    // 
		    this.rWorldCheckBox.Location = new System.Drawing.Point(205, 355);
		    this.rWorldCheckBox.Name = "rWorldCheckBox";
		    this.rWorldCheckBox.Size = new System.Drawing.Size(41, 30);
		    this.rWorldCheckBox.TabIndex = 23;
		    this.rWorldCheckBox.Text = "r";
		    // 
		    // worldAccessLabel
		    // 
		    this.worldAccessLabel.Location = new System.Drawing.Point(20, 355);
		    this.worldAccessLabel.Name = "worldAccessLabel";
		    this.worldAccessLabel.Size = new System.Drawing.Size(144, 30);
		    this.worldAccessLabel.TabIndex = 22;
		    this.worldAccessLabel.Text = "World access rights:";
		    // 
		    // okButton
		    // 
		    this.okButton.DialogResult = System.Windows.Forms.DialogResult.OK;
		    this.okButton.Location = new System.Drawing.Point(64, 405);
		    this.okButton.Name = "okButton";
		    this.okButton.Size = new System.Drawing.Size(128, 31);
		    this.okButton.TabIndex = 26;
		    this.okButton.Text = "OK";
		    this.okButton.Click += new System.EventHandler(this.OkButton_Click);
		    // 
		    // cancelButton
		    // 
		    this.cancelButton.DialogResult = System.Windows.Forms.DialogResult.Cancel;
		    this.cancelButton.Location = new System.Drawing.Point(218, 405);
		    this.cancelButton.Name = "cancelButton";
		    this.cancelButton.Size = new System.Drawing.Size(128, 31);
		    this.cancelButton.TabIndex = 27;
		    this.cancelButton.Text = "Cancel";
		    // 
		    // ModifyLinuxDialog
		    // 
		    this.AcceptButton = this.okButton;
		    this.AutoScaleBaseSize = new System.Drawing.Size(6, 15);
		    this.CancelButton = this.cancelButton;
		    this.ClientSize = new System.Drawing.Size(408, 456);
		    this.Controls.AddRange(new System.Windows.Forms.Control[] {
										  this.cancelButton,
										  this.okButton,
										  this.xWorldCheckBox,
										  this.wWorldCheckBox,
										  this.rWorldCheckBox,
										  this.worldAccessLabel,
										  this.xGroupCheckBox,
										  this.wGroupCheckBox,
										  this.rGroupCheckBox,
										  this.groupAccessLabel,
										  this.xUserCheckBox,
										  this.wUserCheckBox,
										  this.rUserCheckBox,
										  this.userAccessLabel,
										  this.devCheckBox,
										  this.linkCheckBox,
										  this.dirCheckBox,
										  this.typeLabel,
										  this.uidTextBox,
										  this.gidTextBox,
										  this.uidLabel,
										  this.fileLengthLabel,
										  this.fileDateTextBox,
										  this.fileNameTextBox,
										  this.gidLabel,
										  this.lengthLabel,
										  this.modificationDateLabel,
										  this.nameLabel});
		    this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
		    this.MaximizeBox = false;
		    this.MaximumSize = new System.Drawing.Size(500, 600);
		    this.MinimizeBox = false;
		    this.MinimumSize = new System.Drawing.Size(328, 392);
		    this.Name = "ModifyLinuxDialog";
		    this.ShowInTaskbar = false;
		    this.SizeGripStyle = System.Windows.Forms.SizeGripStyle.Hide;
		    this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
		    this.Text = "LTOOLS Modify Linux file or directory";
		    this.ResumeLayout(false);

		}
		#endregion

        /// <summary>
        /// The main entry point to test the ModifyLinuxDialog.
        /// </summary>
        [STAThread]
        static void Main() 
        {
            Form myForm = new Form () ;
            // Set the caption bar text of the form.   
            myForm.Text = "ModifyLinuxDialog Test";
            myForm.Size = new Size (600, 400) ;
            myForm.Visible = true ;
            // Form parent, bool isNew, string fileName, string fileDate,
		    // string fileLength, string uid, string gid, string access
            ModifyLinuxDialog myDialog = new ModifyLinuxDialog(true, "testFileName",
              "testFileDate", "testFileLength", "uid", "gid", "-r---w---x") ;
            
            myDialog.ShowDialog() ; // Modaler Dialog
            /*
            MessageBox.Show("Accessrights: " + myDialog.Access +
                            "\nFileName: " + myDialog.FileName +
                            "\nGID: " + myDialog.GID + 
                            "\nUID: " + myDialog.UID +
                            "\nTargetName: " + myDialog.TargetName , 
                            "Values in Dialog") ;
            */
        }

        /// <summary>
        /// if the OK-button was clicked, check if the access rights was changed and set the flag.
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void OkButton_Click(object sender, System.EventArgs e)
        {
            if (!accessString.Equals(Access))
            {
                isAccessChanged = true ;
            }
        }

        /// <summary>
        /// sets the text for the modificationDateLabel and enables or disables the fileDataTextBox
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void DirCheckBox_Click(object sender, System.EventArgs e)
        {
            linkCheckBox.Checked = !dirCheckBox.Checked ;
            if (linkCheckBox.Checked)
            {
                modificationDateLabel.Text = "Symlink target:" ;
                fileDateTextBox.Enabled = true ;
                fileDateTextBox.Text = "" ;
                fileDateTextBox.Visible = true ;
                fileDateTextBox.Focus() ;
            }
            else
            {
                modificationDateLabel.Text = "Modification date:" ;
                fileDateTextBox.Enabled = false ;
                fileDateTextBox.Text = "" ;
                fileNameTextBox.Focus() ;
            }
        }

        /// <summary>
        /// sets the text for the modificationDateLabel and enables or disables the fileDataTextBox
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void LinkCheckBox_Click(object sender, System.EventArgs e)
        {
            dirCheckBox.Checked = !linkCheckBox.Checked ;
            if (linkCheckBox.Checked)
            {
                modificationDateLabel.Text = "Symlink target:" ;
                fileDateTextBox.Enabled = true ;
                fileDateTextBox.Text = "" ;
                fileDateTextBox.Focus() ;
            }
            else
            {
                modificationDateLabel.Text = "Modification date:" ;
                fileDateTextBox.Enabled = false ;
                fileDateTextBox.Text = "" ;
                fileDateTextBox.Visible = true ;
                fileNameTextBox.Focus() ;
            }
        }
	}
}
