using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace FHTE.LTOOLS.GUI
{
	/// <summary>
	/// Summary description for FilePatternDialog.
	/// </summary>
	public class FilePatternDialog : System.Windows.Forms.Form
	{
        // ############################################################################################################
        // FIELDS
        // ############################################################################################################
        private System.Windows.Forms.Button buttonOk;
        private System.Windows.Forms.Button buttonCancel;
        private System.Windows.Forms.Label labelFilePattern;
        private System.Windows.Forms.TextBox textBoxFilePattern;
        private System.Windows.Forms.Button buttonReset;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
        // ############################################################################################################
        // PROPERTIES
        // ############################################################################################################
        /// <summary>
        /// returns the new filepatter in the textBox
        /// </summary>
        public string FilePattern
        {
            get { return textBoxFilePattern.Text ; }
        }

        // ############################################################################################################
        // CONSTRUCTORS
        // ############################################################################################################
		/// <summary>
		/// shows the filepattern dialog with the current file pattern.
		/// </summary>
		/// <param name="pattern">the current filepattern to display</param>
		/// <param name="isLinux">flag to set the title of the form</param>
        public FilePatternDialog(string pattern, bool isLinux)
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
            textBoxFilePattern.Text = pattern ;
            if (isLinux)
            {
                this.Text = "LTOOLS - Linux FilePattern" ;
            }
            else
            {
                this.Text = "LTOOLS - DOS FilePattern" ;
            }
		}

        // ############################################################################################################
        // METHODS
        // ############################################################################################################
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
		    System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FilePatternDialog));
		    this.buttonOk = new System.Windows.Forms.Button();
		    this.buttonCancel = new System.Windows.Forms.Button();
		    this.labelFilePattern = new System.Windows.Forms.Label();
		    this.textBoxFilePattern = new System.Windows.Forms.TextBox();
		    this.buttonReset = new System.Windows.Forms.Button();
		    this.SuspendLayout();
		    // 
		    // buttonOk
		    // 
		    this.buttonOk.DialogResult = System.Windows.Forms.DialogResult.OK;
		    this.buttonOk.Location = new System.Drawing.Point(38, 89);
		    this.buttonOk.Name = "buttonOk";
		    this.buttonOk.Size = new System.Drawing.Size(128, 29);
		    this.buttonOk.TabIndex = 0;
		    this.buttonOk.Text = "OK";
		    // 
		    // buttonCancel
		    // 
		    this.buttonCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
		    this.buttonCancel.Location = new System.Drawing.Point(192, 89);
		    this.buttonCancel.Name = "buttonCancel";
		    this.buttonCancel.Size = new System.Drawing.Size(128, 29);
		    this.buttonCancel.TabIndex = 1;
		    this.buttonCancel.Text = "Cancel";
		    // 
		    // labelFilePattern
		    // 
		    this.labelFilePattern.Location = new System.Drawing.Point(23, 30);
		    this.labelFilePattern.Name = "labelFilePattern";
		    this.labelFilePattern.Size = new System.Drawing.Size(82, 24);
		    this.labelFilePattern.TabIndex = 2;
		    this.labelFilePattern.Text = "File pattern:";
		    this.labelFilePattern.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
		    // 
		    // textBoxFilePattern
		    // 
		    this.textBoxFilePattern.Location = new System.Drawing.Point(125, 30);
		    this.textBoxFilePattern.Name = "textBoxFilePattern";
		    this.textBoxFilePattern.Size = new System.Drawing.Size(118, 22);
		    this.textBoxFilePattern.TabIndex = 3;
		    this.textBoxFilePattern.Text = "*";
		    // 
		    // buttonReset
		    // 
		    this.buttonReset.Location = new System.Drawing.Point(264, 30);
		    this.buttonReset.Name = "buttonReset";
		    this.buttonReset.Size = new System.Drawing.Size(71, 24);
		    this.buttonReset.TabIndex = 4;
		    this.buttonReset.Text = "Reset";
		    this.buttonReset.Click += new System.EventHandler(this.ButtonReset_Click);
		    // 
		    // FilePatternDialog
		    // 
		    this.AcceptButton = this.buttonOk;
		    this.AutoScaleBaseSize = new System.Drawing.Size(6, 15);
		    this.CancelButton = this.buttonCancel;
		    this.ClientSize = new System.Drawing.Size(376, 144);
		    this.Controls.AddRange(new System.Windows.Forms.Control[] {
										  this.buttonReset,
										  this.textBoxFilePattern,
										  this.labelFilePattern,
										  this.buttonCancel,
										  this.buttonOk});
		    this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
		    this.MaximizeBox = false;
		    this.MaximumSize = new System.Drawing.Size(500, 300);
		    this.MinimizeBox = false;
		    this.MinimumSize = new System.Drawing.Size(288, 136);
		    this.Name = "FilePatternDialog";
		    this.ShowInTaskbar = false;
		    this.SizeGripStyle = System.Windows.Forms.SizeGripStyle.Hide;
		    this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
		    this.Text = "LTOOLS - File Pattern";
		    this.ResumeLayout(false);

		}
		#endregion

        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        public static void Main(string[] args)
        {
            // Application.Run(new FilePatternDialog(true));
            string pattern = "*.txt" ;
            FilePatternDialog dialog = new FilePatternDialog(pattern, false) ;

            if (dialog.ShowDialog() == DialogResult.OK)
            {
                MessageBox.Show("FilePattern:\n" + dialog.FilePattern + "\nOK clicked") ;
            }
            else
            {
                MessageBox.Show("FilePattern:\n" + pattern + "\nCancel clicked") ;
            }
        }

        /// <summary>
        /// resets the string in the textbox back to "*" for all files
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void ButtonReset_Click(object sender, System.EventArgs e)
        {
            textBoxFilePattern.Text = "*" ;
        }
	}
}
