using System;
using System.Drawing;
using System.Windows.Forms;

namespace FHTE.LTOOLS.GUI
{
    /// <summary>
    /// DirectoryNode is a derived from TreeNode and has some fields, to get or set some flags for a directory-tree
    /// </summary>
    public class DirectoryNode : System.Windows.Forms.TreeNode 
    {
		#region Fields
        // ############################################################################################################
        // FIELDS
        // ############################################################################################################
        private string path ;                                   // path of the TreeNode, e.g. "c:\" or "windows"
        private bool subDirectoriesAdded ;                      // flag if the subDirectories are added
        private bool isRemovableDrive ;                         // flag if the Drive is Removeable
        #endregion

		#region Properties
		// ############################################################################################################
        // PROPERTIES
        // ############################################################################################################
        /// <summary>
        /// returns or sets the flag if the Drive is removable or not
        /// </summary>
        public bool IsRemovableDrive
        {
            get { return isRemovableDrive ; }
            set { isRemovableDrive = value ; }
        }
        /// <summary>
        /// returns or sets the flag if the subdirectories are added
        /// </summary>
        public bool SubDirectoriesAdded
        {
            set { subDirectoriesAdded = value ; }
            get { return subDirectoriesAdded ; }
        }
        /// <summary>
        /// returns or sets the Path of a DirectoryNode
        /// </summary>
        public string Path
        {
            set { path = value ; }
            get { return path ; }
        }
		#endregion

		#region Constructors
		// ############################################################################################################
        // CONSTRUCTORS
        // ############################################################################################################
        /// <summary>
        /// Constructor of a directoryNode
        /// </summary>
        /// <param name="text"></param>
        public DirectoryNode(String text) : base(text) 
        {
            path = text ;
        }
		#endregion

        // ############################################################################################################
        // METHODS
        // ############################################################################################################
    }
}

