using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using System.IO;
using System.Diagnostics ;
using System.Security ;
using System.Text ;
using System.Net.Sockets ;

namespace FHTE.LTOOLS.GUI
{
	/// <summary>
	/// DirFilePanel is a UserControl that contains a Label on the top, which shows the current directory,
	/// a treeView on the left side, which shows a directory-tree with the Linux or Dos-Drives on the machine and
	/// a listView on the right side, which shows the the files/folders in the current directory.
	/// </summary>
	public class DirFilePanel : System.Windows.Forms.UserControl
	{
        #region Fields
		// ############################################################################################################
		// FIELDS
		// ############################################################################################################
		private System.Windows.Forms.ListView listView;
		private System.Windows.Forms.TreeView treeView;
		private System.Windows.Forms.Panel panelDirLabel;
		private System.Windows.Forms.Panel panelComplete;
		private System.Windows.Forms.Panel panelTreeList;
		private System.Windows.Forms.Splitter splitter;
		private System.Windows.Forms.Label labelDirectory;
		private System.Windows.Forms.ContextMenu contextMenuListView;
		private System.Windows.Forms.ContextMenu contextMenuListViewItem;
		private System.Windows.Forms.ContextMenu contextMenuTreeViewNode;
		private System.Windows.Forms.ContextMenu contextMenuTreeView;
		private System.Windows.Forms.MenuItem menuItemSeparator;
		private System.Windows.Forms.MenuItem menuItemSeparator1;
		private System.Windows.Forms.MenuItem menuItemSeparator2;
		private System.Windows.Forms.MenuItem menuItemTreeViewRefresh;
		private System.Windows.Forms.MenuItem menuItemTreeViewCollapseAll;
		private System.Windows.Forms.MenuItem menuItemListViewItemModify;
		private System.Windows.Forms.MenuItem menuItemListViewItemDelete;
		private System.Windows.Forms.MenuItem menuItemListViewItemCopy;
	        private System.Windows.Forms.MenuItem menuItemListViewItemView;
	        private System.Windows.Forms.MenuItem menuItemListViewHeadline;
		private System.Windows.Forms.MenuItem menuItemListViewSmallIcon;
		private System.Windows.Forms.MenuItem menuItemListViewLargeIcon;
		private System.Windows.Forms.MenuItem menuItemListViewList;
		private System.Windows.Forms.MenuItem menuItemListViewDetails;
		private System.Windows.Forms.MenuItem menuItemListViewNew;
		private System.Windows.Forms.MenuItem menuItemListViewPaste;
		private System.Windows.Forms.MenuItem menuItemTreeViewNodeCollapse;
		private System.Windows.Forms.MenuItem menuItemTreeViewNodeExpand;
		private System.Windows.Forms.MenuItem menuItemTreeViewNodeNew;
		private System.Windows.Forms.MenuItem menuItemTreeViewNodeModify;
		private System.Windows.Forms.MenuItem menuItemTreeViewNodePaste;
		private System.Windows.Forms.MenuItem menuItemTreeViewAddDrive;
		private System.Windows.Forms.MenuItem menuItemTreeViewNodeRemove;
		private System.Windows.Forms.ColumnHeader columnHeaderName;        
		private System.Windows.Forms.ColumnHeader columnHeaderSize;
		private System.Windows.Forms.ColumnHeader columnHeaderTyp;
		private System.Windows.Forms.ColumnHeader columnHeaderLastModified;
		private System.Windows.Forms.ColumnHeader columnHeaderInformation;
		private System.Windows.Forms.ColumnHeader columnHeaderUserID;
		private System.Windows.Forms.ColumnHeader columnHeaderGroupID;
		private System.Windows.Forms.ImageList imageListDirectorySymbols;
		private System.Windows.Forms.ImageList imageListSmallListView;
		private System.Windows.Forms.ImageList imageListLargeListView;
		private System.ComponentModel.IContainer components;

		private static readonly char LinuxDirectorySeparatorChar = '/' ;    // directory-separator char for Linux
		public static string tempPathLinuxFiles = 
			LTOOLSnet.GUIDirectory + "temp" ;               // the directory for temporary files when files copied
		// from Linux to DOS
		bool isLinux = false ;                                  // true if the Control shows Linux-files, false if DOS
		public static MyDebug debugDialog ;                     // a ref. to the debugDialog if you are in debug-mode
		View viewListView ;                                     // the view-style for the listView (detail, large...)
		private DirectoryNode lastSelectedNode ;                // is used in Mouse_Up
		private DirectoryNode darkNode = null ;                 // to paint the backgroud of the node in the treeView 
		// white again after DragOver.
		private const int StartColumnLinuxFilename = 56;		// start column of LINUX filename in dirListing's lines
		private int mouseX ;                                    // fields to save the last mouseX-pos by a drag/drop 
		private int mouseY ;                                    // event
		private SortOrder sortOrder = SortOrder.Ascending ;     // the sortOrder of the ListView
		public const int Folder       = 7 ;                     // icons for the filetree (the index is set in the
		public const int FolderOpened = 8 ;                     // imageListDirectorySymbols. 7 for a closed folder and
		// 8 for a opened folder). indices 0 to 6 are different
		// icons for the drives (DriveFixed, ...)
        
		public static readonly int IndexIconFolder     = 0 ;    // the imageLists imageListLargeListView and 
		public static readonly int IndexIconFile       = 1 ;    // imageListSmallListView contains icons for the
		public static readonly int IndexIconBitmap     = 2 ;    // ListView. icons like a folder and a file-icon.
		public static readonly int IndexIconPdf        = 3 ;    //
		public static readonly int IndexIconHtml       = 4 ;    //
		public static readonly int IndexIconAvi        = 5 ;    //
		public static readonly int IndexIconMp3        = 6 ;    //
		public static readonly int IndexIconLink       = 7 ;    //
		public static readonly int IndexIconFolderUp   = 8 ;    //
		public static readonly int IndexIconError      = 9 ;    //
		public static readonly int IndexIconAccess     = 10 ;	//
		public static readonly int IndexIconExcel      = 11 ;	//
		public static readonly int IndexIconWord	   = 12 ;	//
		public static readonly int IndexIconPowerPoint = 13 ;	//
		public static readonly int IndexIconExe		   = 14 ;	//
		public static readonly int IndexIconJava       = 15 ;
		public static readonly int IndexIconZip        = 16 ;	//

        #endregion

        #region Properties
		// ############################################################################################################
		// PROPERTIES
		// ############################################################################################################
		/// <summary>
		/// returns or sets the viewstyle of the listView
		/// </summary>
		public View ViewListView
		{
			set { viewListView = value ; }
			get { return viewListView ; }
		}
		/// <summary>
		/// returns or sets the flag for the control if it shows Linux or DOS-files
		/// </summary>
		public bool IsLinux
		{
			get { return isLinux ; }
			set { isLinux = value ; }
		}
		/// <summary>
		/// returns the Drive of the selected TreeNode in the TreeView e.g. "/dev/hda7"
		/// </summary>
		private string LinuxDrive
		{
			get 
			{
				string drive = "" ;
				TreeNode node = treeView.SelectedNode ;
				if (node != null)
				{
					while (node.Parent != null)
					{
						node = node.Parent ;
					}
					drive = node.Text.Substring(0, node.Text.IndexOf(" ")) ;
				}
				return drive  ;
			}
		}
        #endregion


        #region Constructors
        // ############################################################################################################
        // CONSTRUCTORS
        // ############################################################################################################
        /// <summary>
        /// Constructor for the DirFilePanel-UserControl, which contains a label, a treeView and a listView
        /// to show the contents of the drives on the local machine
        /// </summary>
        public DirFilePanel()
		{
            // public DirFilePanel(bool isLinux, string drive, string directory)
            //
            // This call is required by the Windows.Forms Form Designer.
            //
            InitializeComponent();

            //
			// TODO: Add any initialization after the InitForm call
            //
            ViewListView = View.Details ;
            labelDirectory.Text = "Directory: " ;
            // listView.Sorting = sortOrder ;                   // don't set the Sorting-property because the item are
                                                                // inserted in the right order.
		}
        #endregion


        #region Methods
        // ############################################################################################################
        // METHODS
        // ############################################################################################################
		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
		    this.components = new System.ComponentModel.Container();
		    System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DirFilePanel));
		    this.treeView = new System.Windows.Forms.TreeView();
		    this.imageListDirectorySymbols = new System.Windows.Forms.ImageList(this.components);
		    this.listView = new System.Windows.Forms.ListView();
		    this.columnHeaderName = new System.Windows.Forms.ColumnHeader();
		    this.columnHeaderSize = new System.Windows.Forms.ColumnHeader();
		    this.columnHeaderTyp = new System.Windows.Forms.ColumnHeader();
		    this.columnHeaderLastModified = new System.Windows.Forms.ColumnHeader();
		    this.columnHeaderInformation = new System.Windows.Forms.ColumnHeader();
		    this.columnHeaderUserID = new System.Windows.Forms.ColumnHeader();
		    this.columnHeaderGroupID = new System.Windows.Forms.ColumnHeader();
		    this.imageListLargeListView = new System.Windows.Forms.ImageList(this.components);
		    this.imageListSmallListView = new System.Windows.Forms.ImageList(this.components);
		    this.contextMenuListView = new System.Windows.Forms.ContextMenu();
		    this.menuItemListViewNew = new System.Windows.Forms.MenuItem();
		    this.menuItemListViewPaste = new System.Windows.Forms.MenuItem();
		    this.menuItemSeparator1 = new System.Windows.Forms.MenuItem();
		    this.menuItemListViewHeadline = new System.Windows.Forms.MenuItem();
		    this.menuItemListViewSmallIcon = new System.Windows.Forms.MenuItem();
		    this.menuItemListViewLargeIcon = new System.Windows.Forms.MenuItem();
		    this.menuItemListViewList = new System.Windows.Forms.MenuItem();
		    this.menuItemListViewDetails = new System.Windows.Forms.MenuItem();
		    this.contextMenuListViewItem = new System.Windows.Forms.ContextMenu();
		    this.menuItemListViewItemModify = new System.Windows.Forms.MenuItem();
		    this.menuItemListViewItemDelete = new System.Windows.Forms.MenuItem();
		    this.menuItemListViewItemCopy = new System.Windows.Forms.MenuItem();
		    this.menuItemListViewItemView = new System.Windows.Forms.MenuItem();
		    this.contextMenuTreeViewNode = new System.Windows.Forms.ContextMenu();
		    this.menuItemTreeViewNodeExpand = new System.Windows.Forms.MenuItem();
		    this.menuItemTreeViewNodeCollapse = new System.Windows.Forms.MenuItem();
		    this.menuItemTreeViewNodeRemove = new System.Windows.Forms.MenuItem();
		    this.menuItemSeparator = new System.Windows.Forms.MenuItem();
		    this.menuItemTreeViewNodeNew = new System.Windows.Forms.MenuItem();
		    this.menuItemTreeViewNodeModify = new System.Windows.Forms.MenuItem();
		    this.menuItemTreeViewNodePaste = new System.Windows.Forms.MenuItem();
		    this.panelComplete = new System.Windows.Forms.Panel();
		    this.panelTreeList = new System.Windows.Forms.Panel();
		    this.splitter = new System.Windows.Forms.Splitter();
		    this.panelDirLabel = new System.Windows.Forms.Panel();
		    this.labelDirectory = new System.Windows.Forms.Label();
		    this.contextMenuTreeView = new System.Windows.Forms.ContextMenu();
		    this.menuItemTreeViewCollapseAll = new System.Windows.Forms.MenuItem();
		    this.menuItemTreeViewAddDrive = new System.Windows.Forms.MenuItem();
		    this.menuItemSeparator2 = new System.Windows.Forms.MenuItem();
		    this.menuItemTreeViewRefresh = new System.Windows.Forms.MenuItem();
		    this.panelComplete.SuspendLayout();
		    this.panelTreeList.SuspendLayout();
		    this.panelDirLabel.SuspendLayout();
		    this.SuspendLayout();
		    // 
		    // treeView
		    // 
		    this.treeView.AllowDrop = true;
		    this.treeView.BackColor = System.Drawing.SystemColors.Window;
		    this.treeView.Dock = System.Windows.Forms.DockStyle.Left;
		    this.treeView.HideSelection = false;
		    this.treeView.HotTracking = true;
		    this.treeView.ImageList = this.imageListDirectorySymbols;
		    this.treeView.Name = "treeView";
		    this.treeView.Size = new System.Drawing.Size(192, 175);
		    this.treeView.Sorted = true;
		    this.treeView.TabIndex = 0;
		    this.treeView.MouseDown += new System.Windows.Forms.MouseEventHandler(this.TreeView_MouseDown);
		    this.treeView.AfterCollapse += new System.Windows.Forms.TreeViewEventHandler(this.TreeView_AfterCollapse);
		    this.treeView.MouseUp += new System.Windows.Forms.MouseEventHandler(this.TreeView_MouseUp);
		    this.treeView.DragOver += new System.Windows.Forms.DragEventHandler(this.TreeView_DragOver);
		    this.treeView.MouseHover += new System.EventHandler(this.TreeView_MouseHover);
		    this.treeView.AfterSelect += new System.Windows.Forms.TreeViewEventHandler(this.TreeView_AfterSelect);
		    this.treeView.BeforeExpand += new System.Windows.Forms.TreeViewCancelEventHandler(this.TreeView_BeforeExpand);
		    this.treeView.DragEnter += new System.Windows.Forms.DragEventHandler(this.TreeView_DragEnter);
		    this.treeView.DragDrop += new System.Windows.Forms.DragEventHandler(this.TreeView_DragDrop);
		    this.treeView.GiveFeedback += new System.Windows.Forms.GiveFeedbackEventHandler(this.TreeView_GiveFeedback);
		    // 
		    // imageListDirectorySymbols
		    // 
		    this.imageListDirectorySymbols.ColorDepth = System.Windows.Forms.ColorDepth.Depth32Bit;
		    this.imageListDirectorySymbols.ImageSize = new System.Drawing.Size(16, 16);
		    this.imageListDirectorySymbols.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageListDirectorySymbols.ImageStream")));
		    this.imageListDirectorySymbols.TransparentColor = System.Drawing.Color.Transparent;
		    // 
		    // listView
		    // 
		    this.listView.AllowDrop = true;
		    this.listView.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
											       this.columnHeaderName,
											       this.columnHeaderSize,
											       this.columnHeaderTyp,
											       this.columnHeaderLastModified,
											       this.columnHeaderInformation,
											       this.columnHeaderUserID,
											       this.columnHeaderGroupID});
		    this.listView.Dock = System.Windows.Forms.DockStyle.Fill;
		    this.listView.HideSelection = false;
		    this.listView.LabelEdit = true;
		    this.listView.LargeImageList = this.imageListLargeListView;
		    this.listView.Location = new System.Drawing.Point(192, 0);
		    this.listView.Name = "listView";
		    this.listView.Size = new System.Drawing.Size(558, 175);
		    this.listView.SmallImageList = this.imageListSmallListView;
		    this.listView.TabIndex = 1;
		    this.listView.View = System.Windows.Forms.View.Details;
		    this.listView.MouseDown += new System.Windows.Forms.MouseEventHandler(this.ListView_MouseDown);
		    this.listView.DoubleClick += new System.EventHandler(this.ListView_DoubleClick);
		    this.listView.MouseUp += new System.Windows.Forms.MouseEventHandler(this.ListView_MouseUp);
		    this.listView.KeyUp += new System.Windows.Forms.KeyEventHandler(this.ListView_KeyUp);
		    this.listView.DragDrop += new System.Windows.Forms.DragEventHandler(this.ListView_DragDrop);
		    this.listView.AfterLabelEdit += new System.Windows.Forms.LabelEditEventHandler(this.ListView_AfterLabelEdit);
		    this.listView.DragEnter += new System.Windows.Forms.DragEventHandler(this.ListView_DragEnter);
		    this.listView.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.ListView_ColumnClick);
		    this.listView.MouseMove += new System.Windows.Forms.MouseEventHandler(this.ListView_MouseMove);
		    this.listView.BeforeLabelEdit += new System.Windows.Forms.LabelEditEventHandler(this.ListView_BeforeLabelEdit);
		    // 
		    // columnHeaderName
		    // 
		    this.columnHeaderName.Text = "Name";
		    this.columnHeaderName.Width = 200;
		    // 
		    // columnHeaderSize
		    // 
		    this.columnHeaderSize.Text = "Size [Bytes]";
		    this.columnHeaderSize.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
		    this.columnHeaderSize.Width = 75;
		    // 
		    // columnHeaderTyp
		    // 
		    this.columnHeaderTyp.Text = "Typ";
		    this.columnHeaderTyp.Width = 50;
		    // 
		    // columnHeaderLastModified
		    // 
		    this.columnHeaderLastModified.Text = "Last Modified";
		    this.columnHeaderLastModified.Width = 75;
		    // 
		    // columnHeaderInformation
		    // 
		    this.columnHeaderInformation.Text = "Access";
		    this.columnHeaderInformation.Width = 75;
		    // 
		    // columnHeaderUserID
		    // 
		    this.columnHeaderUserID.Text = "UserID";
		    // 
		    // columnHeaderGroupID
		    // 
		    this.columnHeaderGroupID.Text = "GroupID";
		    // 
		    // imageListLargeListView
		    // 
		    this.imageListLargeListView.ColorDepth = System.Windows.Forms.ColorDepth.Depth32Bit;
		    this.imageListLargeListView.ImageSize = new System.Drawing.Size(48, 48);
		    this.imageListLargeListView.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageListLargeListView.ImageStream")));
		    this.imageListLargeListView.TransparentColor = System.Drawing.Color.Transparent;
		    // 
		    // imageListSmallListView
		    // 
		    this.imageListSmallListView.ColorDepth = System.Windows.Forms.ColorDepth.Depth32Bit;
		    this.imageListSmallListView.ImageSize = new System.Drawing.Size(16, 16);
		    this.imageListSmallListView.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageListSmallListView.ImageStream")));
		    this.imageListSmallListView.TransparentColor = System.Drawing.Color.Transparent;
		    // 
		    // contextMenuListView
		    // 
		    this.contextMenuListView.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
													this.menuItemListViewNew,
													this.menuItemListViewPaste,
													this.menuItemSeparator1,
													this.menuItemListViewHeadline});
		    // 
		    // menuItemListViewNew
		    // 
		    this.menuItemListViewNew.Index = 0;
		    this.menuItemListViewNew.Text = "New";
		    this.menuItemListViewNew.Click += new System.EventHandler(this.MenuItemListViewNew_Click);
		    // 
		    // menuItemListViewPaste
		    // 
		    this.menuItemListViewPaste.Index = 1;
		    this.menuItemListViewPaste.Text = "Paste";
		    this.menuItemListViewPaste.Click += new System.EventHandler(this.MenuItemListViewPaste_Click);
		    // 
		    // menuItemSeparator1
		    // 
		    this.menuItemSeparator1.Index = 2;
		    this.menuItemSeparator1.Text = "-";
		    // 
		    // menuItemListViewHeadline
		    // 
		    this.menuItemListViewHeadline.Index = 3;
		    this.menuItemListViewHeadline.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
													     this.menuItemListViewSmallIcon,
													     this.menuItemListViewLargeIcon,
													     this.menuItemListViewList,
													     this.menuItemListViewDetails});
		    this.menuItemListViewHeadline.Text = "View Style";
		    // 
		    // menuItemListViewSmallIcon
		    // 
		    this.menuItemListViewSmallIcon.Index = 0;
		    this.menuItemListViewSmallIcon.RadioCheck = true;
		    this.menuItemListViewSmallIcon.Text = "Small Icon";
		    this.menuItemListViewSmallIcon.Click += new System.EventHandler(this.MenuItemListViewSmallIcon_Click);
		    // 
		    // menuItemListViewLargeIcon
		    // 
		    this.menuItemListViewLargeIcon.Index = 1;
		    this.menuItemListViewLargeIcon.RadioCheck = true;
		    this.menuItemListViewLargeIcon.Text = "Large Icon";
		    this.menuItemListViewLargeIcon.Click += new System.EventHandler(this.MenuItemListViewLargeIcon_Click);
		    // 
		    // menuItemListViewList
		    // 
		    this.menuItemListViewList.Index = 2;
		    this.menuItemListViewList.RadioCheck = true;
		    this.menuItemListViewList.Text = "List";
		    this.menuItemListViewList.Click += new System.EventHandler(this.MenuItemListViewList_Click);
		    // 
		    // menuItemListViewDetails
		    // 
		    this.menuItemListViewDetails.Index = 3;
		    this.menuItemListViewDetails.RadioCheck = true;
		    this.menuItemListViewDetails.Text = "Details";
		    this.menuItemListViewDetails.Click += new System.EventHandler(this.MenuItemListViewDetails_Click);
		    // 
		    // contextMenuListViewItem
		    // 
		    this.contextMenuListViewItem.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
													    this.menuItemListViewItemModify,
													    this.menuItemListViewItemDelete,
													    this.menuItemListViewItemCopy,
													    this.menuItemListViewItemView});
		    // 
		    // menuItemListViewItemModify
		    // 
		    this.menuItemListViewItemModify.Index = 0;
		    this.menuItemListViewItemModify.Text = "Modify";
		    this.menuItemListViewItemModify.Click += new System.EventHandler(this.MenuItemListViewItemModify_Click);
		    // 
		    // menuItemListViewItemDelete
		    // 
		    this.menuItemListViewItemDelete.Index = 1;
		    this.menuItemListViewItemDelete.Text = "Delete";
		    this.menuItemListViewItemDelete.Click += new System.EventHandler(this.MenuItemListViewItemDelete_Click);
		    // 
		    // menuItemListViewItemCopy
		    // 
		    this.menuItemListViewItemCopy.Index = 2;
		    this.menuItemListViewItemCopy.Text = "Copy";
		    this.menuItemListViewItemCopy.Click += new System.EventHandler(this.MenuItemListViewItemCopy_Click);
		    // 
		    // menuItemListViewItemView
		    // 
		    this.menuItemListViewItemView.Index = 3;
		    this.menuItemListViewItemView.Text = "View";
		    this.menuItemListViewItemView.Click += new System.EventHandler(this.MenuItemListViewItemView_Click);
		    // 
		    // contextMenuTreeViewNode
		    // 
		    this.contextMenuTreeViewNode.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
													    this.menuItemTreeViewNodeExpand,
													    this.menuItemTreeViewNodeCollapse,
													    this.menuItemTreeViewNodeRemove,
													    this.menuItemSeparator,
													    this.menuItemTreeViewNodeNew,
													    this.menuItemTreeViewNodeModify,
													    this.menuItemTreeViewNodePaste});
		    // 
		    // menuItemTreeViewNodeExpand
		    // 
		    this.menuItemTreeViewNodeExpand.Index = 0;
		    this.menuItemTreeViewNodeExpand.Text = "Expand Node";
		    this.menuItemTreeViewNodeExpand.Click += new System.EventHandler(this.MenuItemTreeViewNodeExpand_Click);
		    // 
		    // menuItemTreeViewNodeCollapse
		    // 
		    this.menuItemTreeViewNodeCollapse.Index = 1;
		    this.menuItemTreeViewNodeCollapse.Text = "Collapse Node";
		    this.menuItemTreeViewNodeCollapse.Click += new System.EventHandler(this.MenuItemTreeViewNodeCollapse_Click);
		    // 
		    // menuItemTreeViewNodeRemove
		    // 
		    this.menuItemTreeViewNodeRemove.Index = 2;
		    this.menuItemTreeViewNodeRemove.Text = "Remove Drive";
		    this.menuItemTreeViewNodeRemove.Click += new System.EventHandler(this.MenuItemTreeViewNodeRemove_Click);
		    // 
		    // menuItemSeparator
		    // 
		    this.menuItemSeparator.Index = 3;
		    this.menuItemSeparator.Text = "-";
		    this.menuItemSeparator.Visible = false;
		    // 
		    // menuItemTreeViewNodeNew
		    // 
		    this.menuItemTreeViewNodeNew.Index = 4;
		    this.menuItemTreeViewNodeNew.Text = "New";
		    this.menuItemTreeViewNodeNew.Visible = false;
		    this.menuItemTreeViewNodeNew.Click += new System.EventHandler(this.MenuItemTreeViewNodeNew_Click);
		    // 
		    // menuItemTreeViewNodeModify
		    // 
		    this.menuItemTreeViewNodeModify.Index = 5;
		    this.menuItemTreeViewNodeModify.Text = "Modify";
		    this.menuItemTreeViewNodeModify.Visible = false;
		    this.menuItemTreeViewNodeModify.Click += new System.EventHandler(this.MenuItemTreeViewNodeModify_Click);
		    // 
		    // menuItemTreeViewNodePaste
		    // 
		    this.menuItemTreeViewNodePaste.Index = 6;
		    this.menuItemTreeViewNodePaste.Text = "Paste";
		    this.menuItemTreeViewNodePaste.Visible = false;
		    this.menuItemTreeViewNodePaste.Click += new System.EventHandler(this.MenuItemTreeViewNodePaste_Click);
		    // 
		    // panelComplete
		    // 
		    this.panelComplete.Controls.AddRange(new System.Windows.Forms.Control[] {
												this.panelTreeList,
												this.panelDirLabel});
		    this.panelComplete.Dock = System.Windows.Forms.DockStyle.Fill;
		    this.panelComplete.Name = "panelComplete";
		    this.panelComplete.Size = new System.Drawing.Size(750, 200);
		    this.panelComplete.TabIndex = 3;
		    // 
		    // panelTreeList
		    // 
		    this.panelTreeList.Controls.AddRange(new System.Windows.Forms.Control[] {
												this.splitter,
												this.listView,
												this.treeView});
		    this.panelTreeList.Dock = System.Windows.Forms.DockStyle.Fill;
		    this.panelTreeList.Location = new System.Drawing.Point(0, 25);
		    this.panelTreeList.Name = "panelTreeList";
		    this.panelTreeList.Size = new System.Drawing.Size(750, 175);
		    this.panelTreeList.TabIndex = 5;
		    // 
		    // splitter
		    // 
		    this.splitter.Location = new System.Drawing.Point(192, 0);
		    this.splitter.Name = "splitter";
		    this.splitter.Size = new System.Drawing.Size(3, 175);
		    this.splitter.TabIndex = 2;
		    this.splitter.TabStop = false;
		    // 
		    // panelDirLabel
		    // 
		    this.panelDirLabel.Controls.AddRange(new System.Windows.Forms.Control[] {
												this.labelDirectory});
		    this.panelDirLabel.Dock = System.Windows.Forms.DockStyle.Top;
		    this.panelDirLabel.Name = "panelDirLabel";
		    this.panelDirLabel.Size = new System.Drawing.Size(750, 25);
		    this.panelDirLabel.TabIndex = 4;
		    // 
		    // labelDirectory
		    // 
		    this.labelDirectory.Dock = System.Windows.Forms.DockStyle.Fill;
		    this.labelDirectory.Name = "labelDirectory";
		    this.labelDirectory.Size = new System.Drawing.Size(750, 25);
		    this.labelDirectory.TabIndex = 0;
		    this.labelDirectory.Text = "labelDirectory";
		    this.labelDirectory.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
		    // 
		    // contextMenuTreeView
		    // 
		    this.contextMenuTreeView.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
													this.menuItemTreeViewCollapseAll,
													this.menuItemTreeViewAddDrive,
													this.menuItemSeparator2,
													this.menuItemTreeViewRefresh});
		    // 
		    // menuItemTreeViewCollapseAll
		    // 
		    this.menuItemTreeViewCollapseAll.Index = 0;
		    this.menuItemTreeViewCollapseAll.Text = "Collapse All";
		    this.menuItemTreeViewCollapseAll.Click += new System.EventHandler(this.MenuItemTreeViewCollapseAll_Click);
		    // 
		    // menuItemTreeViewAddDrive
		    // 
		    this.menuItemTreeViewAddDrive.Index = 1;
		    this.menuItemTreeViewAddDrive.Text = "Add Drive ...";
		    this.menuItemTreeViewAddDrive.Click += new System.EventHandler(this.MenuItemTreeViewAddDrive_Click);
		    // 
		    // menuItemSeparator2
		    // 
		    this.menuItemSeparator2.Index = 2;
		    this.menuItemSeparator2.Text = "-";
		    // 
		    // menuItemTreeViewRefresh
		    // 
		    this.menuItemTreeViewRefresh.Index = 3;
		    this.menuItemTreeViewRefresh.Text = "Refresh";
		    this.menuItemTreeViewRefresh.Click += new System.EventHandler(this.MenuItemTreeViewRefresh_Click);
		    // 
		    // menuItemListViewItemView
		    // 
		    this.menuItemListViewItemView.Index = 3;
		    this.menuItemListViewItemView.Text = "View";
		    // 
		    // DirFilePanel
		    // 
		    this.AllowDrop = true;
		    this.Controls.AddRange(new System.Windows.Forms.Control[] {
										  this.panelComplete});
		    this.Name = "DirFilePanel";
		    this.Size = new System.Drawing.Size(750, 200);
		    this.panelComplete.ResumeLayout(false);
		    this.panelTreeList.ResumeLayout(false);
		    this.panelDirLabel.ResumeLayout(false);
		    this.ResumeLayout(false);

		}
		#endregion
		
        #region DOS
        /// <summary>
        /// For initializing the directoryTree upon creation of the TreeViewCtl form.
        /// Fill the treeView with the DOS-drives on the local machine
        /// </summary>
        public void FillDosDirectoryTree() 
        {
            this.IsLinux = false ;
            DebugOutput("FillDosDirectoryTree()") ;
            treeView.Nodes.Clear() ;                            // first clear the treeView
            
            treeView.BeginUpdate();
			string[] drives = Environment.GetLogicalDrives();
			for (int i = 0; i < drives.Length; i++)
			{
				DebugOutput("drives[i]): " + drives[i]) ;
				DirectoryNode cRoot = new DirectoryNode(drives[i]);
				// set the index of the icon
                cRoot.SelectedImageIndex = PlatformInvokeKernel32.GetDriveType(drives[i]) ;
				cRoot.ImageIndex         = PlatformInvokeKernel32.GetDriveType(drives[i]) ;
                if ( (PlatformInvokeKernel32.GetDriveType(drives[i]) == PlatformInvokeKernel32.DriveRemoveable) ||
                     (PlatformInvokeKernel32.GetDriveType(drives[i]) == PlatformInvokeKernel32.DriveCDRom) )
                {
                    cRoot.IsRemovableDrive   = true ;
                }
                else
                {
                    cRoot.IsRemovableDrive   = false ;
                }

				treeView.Nodes.Add(cRoot);
				try
				{
                    if (cRoot.IsRemovableDrive == false )
                    {
                        AddDosDirectories(cRoot);
                    }
				}
				catch (Exception e)
				{
					DebugOutput(e.Message + "\r\n" + e.StackTrace) ;
				}
			}
			TreeViewSelectDOSDrive() ;
            treeView.EndUpdate() ;
		}
        /// <summary>
        /// For a given root directory (or drive), add the directories to the directoryTree.
        /// </summary>
        /// <param name="node">the node to add the Dos-directories</param>
        private void AddDosDirectories(DirectoryNode node) 
        {   DebugOutput("AddDosDirectories()");
            try 
            {
                DirectoryInfo dir = new DirectoryInfo(GetPathFromNode(node));
                DirectoryInfo[] e = dir.GetDirectories();

                for (int i = 0; i < e.Length; i++) 
                {
                    string name = e[i].Name;
                    if (!name.Equals(".") && !name.Equals("..")) 
                    {
                        DirectoryNode dn = new DirectoryNode(name) ;
                        dn.ImageIndex = Folder ;
                        dn.SelectedImageIndex = FolderOpened ;
                        node.Nodes.Add(dn);
                    }
                }
            }
            catch (Exception e) 
            {
                DebugOutput(MyDebug.SeparatorLine + e.Message + "\r\n" + e.StackTrace + MyDebug.SeparatorLine) ;
            }
        }

        /// <summary>
        /// For a given node, add the sub-directories for node's children in the directoryTree.
        /// </summary>
        /// <param name="node">the node to add the Dos-sub-directories</param>
        private void AddDosSubDirectories(DirectoryNode node) 
        {   DebugOutput("AddDosSubDirectories()");
            try
            {
                for (int i = 0; i < node.Nodes.Count; i++) 
                {
                    AddDosDirectories((DirectoryNode)node.Nodes[i]);
                }
                node.SubDirectoriesAdded = true;
            }
            catch (Exception e)
            {
                DebugOutput(MyDebug.SeparatorLine + e.Message + "\r\n" + e.StackTrace + MyDebug.SeparatorLine) ;
            }
        }
		/// <summary>
		/// Selects the "C:\\" - Drive in the treeView.
		/// </summary>
		private void TreeViewSelectDOSDrive()
		{
			for (int i=0; i < treeView.Nodes.Count; i++)
			{
				if (treeView.Nodes[i].Text.ToUpper() == "C:\\")
				{
					treeView.SelectedNode = treeView.Nodes[i] ; // Select the C:\ node in the TreeView
					return ;
				}
			}
			treeView.SelectedNode = treeView.TopNode ;
		}
        /// <summary>
        /// the ModifyDosFile() method shows a dialog in which you can modify a collection of selected files or 
        /// directories in the listView.
        /// </summary>
        /// <param name="items">Collection of the selected files/directories in the listView</param>
        public void ModifyDosFile(ListView.SelectedListViewItemCollection items)
        {
            bool isNew = false ;
            foreach (ListViewItemFile item in items)
            {
				if (item.IsError || item.FileName.Equals("..") )
				{
					continue ;
				}
                // get the infos of the file now not from the ListViewItemFile
                bool readOnly = false ;
                bool hidden = false ;
                bool system = false ;
                FileAttributes fa ;                             // the attributes of the file or directory

                if (item.IsDirectory)
                {
                    DirectoryInfo di = new DirectoryInfo(item.FullFilePath) ;
                    fa = di.Attributes ;
                    if ((fa & FileAttributes.ReadOnly) != 0)
                    {
                        readOnly = true ;
                    }
                    if ((fa & FileAttributes.Hidden) != 0)
                    {
                        hidden = true ;
                    }
                    if ((fa & FileAttributes.System) != 0)
                    {
                        system = true ;
                    }
                }
                else
                {
                    FileInfo fi = new FileInfo(item.FullFilePath) ;
                    fa = fi.Attributes ;
                    if ((fa & FileAttributes.ReadOnly) != 0)
                    {
                        readOnly = true ;
                    }
                    if ((fa & FileAttributes.Hidden) != 0)
                    {
                        hidden = true ;
                    }
                    if ((fa & FileAttributes.System) != 0)
                    {
                        system = true ;
                    }
                }
                ModifyDosDialog modifyDosDialog = 
                    new ModifyDosDialog(isNew, item.FileName,
                    item.FileSize, item.FileLastModified, 
                    item.IsDirectory, readOnly, hidden, system) ;
                DialogResult result = modifyDosDialog.ShowDialog() ;    // Modaler Dialog
                if (result == DialogResult.OK)
                {
                    FileAttributes newFileAttributes = fa ;
                    // check if any Attribute has changed
                    // IsDirectory cannot be changed
                    if (modifyDosDialog.IsReadOnly != readOnly)
                    {
                        item.IsReadOnly = modifyDosDialog.IsReadOnly ;
                        if (modifyDosDialog.IsReadOnly)         // set to readOnly
                        {
                            newFileAttributes = newFileAttributes | FileAttributes.ReadOnly ;
                        }
                        else                                    // remove readOnly attribut
                        {
                            newFileAttributes = newFileAttributes & ~FileAttributes.ReadOnly ;
                        }
                    }
                    if (modifyDosDialog.IsHidden != hidden)
                    {
                        if (modifyDosDialog.IsHidden)           // set to hidden
                        {
                            newFileAttributes = newFileAttributes | FileAttributes.Hidden ;
                        }
                        else                                    // remove hidden attribute
                        {
                            newFileAttributes = newFileAttributes & ~FileAttributes.Hidden ;
                        }
                    }
                    if (modifyDosDialog.IsSystem != system)
                    {
                        if (modifyDosDialog.IsSystem)           // set to system
                        {
                            newFileAttributes = newFileAttributes | FileAttributes.System ;
                        }
                        else                                    // remove system attribute
                        {
                            newFileAttributes = newFileAttributes & ~FileAttributes.System ;
                        }
                    }

                    DebugOutput("FileAttributes: " + newFileAttributes.ToString()) ;

                    string dest ;
                    if ( item.Directory.EndsWith(Path.DirectorySeparatorChar.ToString()) )
                    {
                        dest = item.Directory + modifyDosDialog.FileName ;
                    }
                    else
                    {
                        dest = item.Directory + Path.DirectorySeparatorChar + modifyDosDialog.FileName ;
                    }
            
                    // if the name or the attributes have changed, update the file
                    if (!item.FullFilePath.ToLower().Equals(dest.ToLower()) ||
                        (newFileAttributes != fa))
                    {
                        // the name has changed
                        if (!item.FullFilePath.ToLower().Equals(dest.ToLower()))
                        {
                            if (item.IsDirectory)               // it's a directory
                            {
                                DebugOutput("ModifyDosFile(): modify directory - source: " + item.FullFilePath + " to destination: " + dest) ;
                                Directory.Move(item.FullFilePath, dest) ;
                            }
                            else                                // it's a file
                            {
                                DebugOutput("ModifyDosFile(): modify file - source: " + item.FullFilePath + " to destination: " + dest) ;
                                File.Move(item.FullFilePath, dest) ;
                            }
                        }
                        
                        if (newFileAttributes != fa)            // if the attributes have changed
                        {
                            if (item.IsDirectory)               // it's a directory
                            {
                                DirectoryInfo di = new DirectoryInfo(dest) ;
                                di.Attributes = newFileAttributes ;
                            }
                            else                                // it's a file
                            {
                                FileInfo fi = new FileInfo(dest) ;
                                fi.Attributes = newFileAttributes ;
                            }
                        }
                        this.UpdateNode(this.GetSelectedDirectoryNode()) ;
                    }
                }
            }
        }

        /// <summary>
        /// the NewDosDirectory() method shows a dialog in which you can insert a directory-name and you can set
        /// some attributes of the new directory.
        /// </summary>
        /// <param name="node">the DirectoryNode(Directory in the DOS-filesystem) for the new directory</param>
        public void NewDosDirectory(DirectoryNode node)
        {
            DebugOutput("NewDosDirectory() in Directory: " + node.Path);
			
            // isNew, fileName, fileLength, fileDate, isDirectory, isReadOnly, isHidden, isSystem
            ModifyDosDialog dialog = new ModifyDosDialog(true, "", "", "", true, false, false, false) ;
            if (dialog.ShowDialog() != DialogResult.OK)
            {
                return ;
            }
            if (!dialog.FileName.Equals(""))
            {
                string newDirectory = node.Path + 
                    Path.DirectorySeparatorChar.ToString() + 
                    dialog.FileName ;

                DirectoryInfo dirInfo = Directory.CreateDirectory(newDirectory) ;
                DirectoryInfo di = new DirectoryInfo(newDirectory) ;
                FileAttributes fa = di.Attributes ;
                
                if (dialog.IsHidden)
                {
                    fa = fa | FileAttributes.Hidden ;
                }
                if (dialog.IsSystem)
                {
                    fa = fa | FileAttributes.System ;
                }
                if (dialog.IsReadOnly)
                {
                    fa = fa | FileAttributes.ReadOnly ;
                }
                di.Attributes = fa ;

                if (!dirInfo.Exists)
                {
                    MessageBox.Show("Could not create directory " + newDirectory, "LTOOLS", 
                        MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
                this.UpdateNode(node) ;
            }
        }

        /// <summary>
        /// the DeleteDosFile() method deletes a collection of files or directories in the listView
        /// </summary>
        /// <param name="items">Collection of the selected files/directories in the listView</param>
        /// <param name="confirmDelete">true if you want to show a MessageBox to confirm deleting the file</param>
        public void DeleteDosFile(ListView.SelectedListViewItemCollection items, bool confirmDelete)
        {
            bool updateFlag = false ;
            bool deleteFlag = false ;

            foreach (ListViewItemFile item in items)
            {
				if (item.IsError || item.FileName.Equals(".."))
				{
					continue ;
				}
                string deleteFile = item.FullFilePath ;
                
                deleteFlag = false ;
                if (confirmDelete)
                {
                    DialogResult result = 
                        MessageBox.Show ("Do you really want to delete \"" + deleteFile + "\"",
                        "LTOOLS", 
                        MessageBoxButtons.YesNoCancel,
                        MessageBoxIcon.Question) ;

                    // MessageBox.Show("delete file: " + deleteFile + "\n" + "confirmDelete: " + confirmDelete.ToString()) ;
                    if (result == DialogResult.Yes)
                    {
                        deleteFlag = true ;
                    }
                    else if (result == DialogResult.Cancel)
                    {
                        return ;
                    }
                }
                else
                {
                    deleteFlag = true ;
                }
                DebugOutput("DeleteDosFile(): " + deleteFile + " - " + deleteFlag.ToString()) ;
                
                // just delete the file if you clicked Yes or confirmDelete is not set to true
                if (deleteFlag)
                {
                    updateFlag = true ;
                    // delete the file or directory
                    FileAttributes fa = File.GetAttributes(deleteFile) ;
                    if ((fa & FileAttributes.Directory) != 0)
                    {
                        try
                        {
                            // the Directory has to be empty
                            Directory.Delete(deleteFile) ; // bool recursive
                        }
                        catch (IOException ex)
                        {
                            DebugOutput(ex.Message) ;
                            MessageBox.Show("Could not delete the directory " + deleteFile + " because it is read only or not empty.", "LTOOLS", 
                                MessageBoxButtons.OK, MessageBoxIcon.Error) ;
                        }
                        catch(SecurityException ex)
                        {
                            DebugOutput(ex.Message) ;
                            MessageBox.Show("Could not delete the directory " + deleteFile + " because you don't have the required permissions.", "LTOOLS", 
                                MessageBoxButtons.OK, MessageBoxIcon.Error) ;
                        }
                        catch
                        {
                            MessageBox.Show("Could not delete file or directory " + deleteFile, "LTOOLS", 
                                MessageBoxButtons.OK, MessageBoxIcon.Error) ;
                        }
                    }
                    else
                    {
                        try
                        {
                            File.Delete(deleteFile) ;
                        }
                        catch
                        {
                            MessageBox.Show("Could not delete file " + deleteFile, "LTOOLS", 
                                MessageBoxButtons.OK, MessageBoxIcon.Error) ;
                        }
                    }
                }

            }
            if (updateFlag)
            {
                DirectoryNode node = this.GetSelectedDirectoryNode() ;
                this.UpdateNode(node) ;
            }
        }

        /// <summary>
        /// the StartDosApplication() method starts an application to show/edit the double-clicked ListViewItem
        /// in the listview or executes the double-clicked application.
        /// </summary>
        /// <param name="item">the selected item in the listView to start an application</param>
        public void StartDosApplication(ListViewItemFile item, bool start)
        {
            try
            {
				if (!item.IsError)
				{
				    if (start)
				    {
					    DebugOutput("StartDosApplication() \""+item.FullFilePath + "\"");
					    Process myProcess = Process.Start("\""+item.FullFilePath+"\"") ;
				    }
				    else
				    {   DebugOutput("StartDosApplication() edit.bat "+item.FullFilePath);
					Process myProcess = Process.Start("edit.bat", "\""+item.FullFilePath+"\"");
				    }
				}
            }
            catch (Exception ex)
            {
                DebugOutput(ex.Message) ;
                MessageBox.Show(ex.Message, "LTOOLS", MessageBoxButtons.OK, MessageBoxIcon.Information) ;
            }
        }

        /// <summary>
        /// the PasteToDos() method pastes the files in the CopyFiles-ArrayList of the Class LTOOLSnet
        /// int the targetDirectory
        /// </summary>
        /// <param name="targetDirectory">the directory the files will be copied to.</param>
        /// <param name="issueMessages">true</param>
        public void PasteToDos(string targetDirectory, bool issueMessages)
        {
            // string[] source = (string[])LTOOLSnet.CopyFilePath.ToArray() ;
            if (!targetDirectory.EndsWith(Path.DirectorySeparatorChar.ToString()))
            {
                targetDirectory = targetDirectory + Path.DirectorySeparatorChar.ToString() ;
            }

            for (int j=0; j < LTOOLSnet.CopyFileCount; j++)
            {
                string destination = targetDirectory + LTOOLSnet.CopyFileName[j] ; 
				if (File.Exists(destination))
				{
					DialogResult result = MessageBox.Show("File \"" + LTOOLSnet.CopyFileName[j] + 
						"\" exists in this directory. Overwrite it?", "LTOOLS",
						MessageBoxButtons.YesNoCancel, MessageBoxIcon.Question) ;
					if (result == DialogResult.No)
					{
						continue ;
					}
					else if (result == DialogResult.Cancel)
					{
						return ;
					}
				}
                DebugOutput("PasteToDos(): source: " + LTOOLSnet.CopyFilePath[j] + " - destination: " + destination) ;

                // Linux To Dos Paste
                if (LTOOLSnet.CopyFileIsLinux)
                {
                    string command = "ldirNT" ;
                    string args ;

                    LDir ldir ;

                    if (LTOOLSnet.Connected == false)
                    {
                        args = "-READ -q -s" + 
                            GetLinuxDrive(LTOOLSnet.CopyFilePath[j].ToString()) + 
                            " \"" + GetLinuxFilePath(LTOOLSnet.CopyFilePath[j].ToString()) + "\"" +
                            " \"" + destination+ "\"" ;
                        DebugOutput(command + " " + args) ;
                        ldir = new LDir(command, args) ;
                    }
                    else // connected
                    {
                        args = "-READ -x -s" + 
                            GetLinuxDrive(LTOOLSnet.CopyFilePath[j].ToString()) + 
                            " \"" + GetLinuxFilePath(LTOOLSnet.CopyFilePath[j].ToString()) + "\" " +
                            "zzz.xxx" ;
                        DebugOutput(command + " " + args) ;
                        ldir = new LDir(command, args, LTOOLSnet.NetSocket) ;
                    }
                    if (ldir.Response.Length > 0)
                    {
                        //if LTOOLS's command line tool issues an error message, show first line of response in message box
                        if (issueMessages)
                        {
                            MessageBox.Show(ldir.Response.Trim(), "LTOOLS", MessageBoxButtons.OK, MessageBoxIcon.Error) ;
                        }
                        return ;
                    }

                    if (LTOOLSnet.Connected)
                    {
                        DebugOutput("GetFileFromHost(\"" + destination + "\")") ;
                        // copy the file to the temporary-directory
                        GetFileFromHost((string) LTOOLSnet.CopyFileName[j]);
                        // move the copied file in the selected path !!!
                        // destination is the new name of the file
                        File.Move(tempPathLinuxFiles + 
                            Path.DirectorySeparatorChar.ToString() + 
                            LTOOLSnet.CopyFileName[j],
                            destination) ;
                    }
                }
                else // Dos   To Dos Paste
                {
                    try
                    {
                        // copy source to destination
                        File.Copy(LTOOLSnet.CopyFilePath[j].ToString(), destination) ;
                    }
                    catch (FileNotFoundException e)
                    {
                        DebugOutput(e.Message) ;
                        if (issueMessages)
                        {
                            MessageBox.Show("Sorry, could not open file " + LTOOLSnet.CopyFilePath[j], "LTOOLS", 
                                MessageBoxButtons.OK, MessageBoxIcon.Error) ;
                        }
                        return ;
                    }
                    catch (IOException e)
                    {
                        DebugOutput(e.Message) ;
                        if (issueMessages)
                        {
                            MessageBox.Show("Sorry, could not write to " + destination + ".\n" + e.Message, "LTOOLS", 
                                MessageBoxButtons.OK, MessageBoxIcon.Error) ;
                        }
                        return ;
                    }
                }
            }
            DirectoryNode node = this.GetSelectedDirectoryNode() ;
            this.UpdateNode(node) ;
        }
         
        /// <summary>
        /// the UpdateDosListView() method updates the listView after selecting a node in the treeView
        /// or after deleting/modifying or pasting files in the selected node of the treeView.
        /// </summary>
        /// <param name="dirNode">the DirectoryNode which should be updated</param>
        public void UpdateDosListView(DirectoryNode dirNode)
        {
            // it's a DosFilesystem
            try
            {
                string path             = GetPathFromNode(dirNode) ;
                DirectoryInfo dir       = new DirectoryInfo(path);
                DirectoryInfo[] dirInfo = dir.GetDirectories();
                FileInfo[] fileInfo     = dir.GetFiles(LTOOLSnet.DOSFilePattern) ;

				ArrayList directories = new ArrayList() ;
				ArrayList files = new ArrayList() ;

                listView.Clear() ;                              // first clear the listView
                listView.View = viewListView ;                  // set the View-property
                ListViewAddColumns() ;                          // adds the columns to the listView

				for (int i = 0; i < dirInfo.Length; i++)        // add the directories to the listView
                {
                    string name = dirInfo[i].Name;
					string fullFilePath ;
					if (!path.EndsWith(Path.DirectorySeparatorChar.ToString()) )
					{
						path = path + Path.DirectorySeparatorChar.ToString() ;
					}
					fullFilePath = path + name ;

					ListViewItemFile item = new ListViewItemFile(name, IndexIconFolder, true, 
						path, "0", Directory.GetLastWriteTime(fullFilePath).ToString(), " ");
					
					// DebugOutput("UpdateDosListView: " + fullFilePath) ;					
					// DebugOutput("UpdateDosListView: " + item.ToString()) ;

					if ( (dirInfo[i].Attributes & FileAttributes.ReadOnly) != 0)
					{
						item.IsReadOnly = true ;
					}
					else 
					{
						item.IsReadOnly = false ;
					}
					item.SubItems.Add("") ;
					item.SubItems.Add("") ;
					item.SubItems.Add(item.FileLastModified) ;
					directories.Add(item) ;
                }
                
                for (int i = 0; i < fileInfo.Length; i++)       // add the files to the listView
                {
                    string name = fileInfo[i].Name ;
					string fullFilePath ;
					if ( path.EndsWith(Path.DirectorySeparatorChar.ToString()) )
					{
						fullFilePath = path + name ;
					}
					else
					{
						fullFilePath = path + Path.DirectorySeparatorChar.ToString() + name ;
					}
					FileInfo fi           = new FileInfo(fullFilePath) ;
					FileAttributes fa     = fi.Attributes ;
					ListViewItemFile item = new ListViewItemFile(name, IndexIconFile, false, 
						path, fi.Length.ToString(), fi.LastWriteTime.ToString(), " ");
					item.FullFilePath = fullFilePath ;
                    if ((fa & FileAttributes.ReadOnly) != 0)
                    {
                        item.IsReadOnly = true ;
                    }
                    else
                    {
                        item.IsReadOnly = false ;
                    }
					item.SubItems.Add(item.FileSize) ;
					item.SubItems.Add(Path.GetExtension(item.FullFilePath)) ;
					item.SubItems.Add(item.FileLastModified) ;
					files.Add(item) ;
                }
				InsertListViewItems(path, directories, files) ;
            }
            catch (Exception ex)
            {
                DebugOutput(MyDebug.SeparatorLine + "UpdateDosListView() Exception - isLinux: " + 
					isLinux + "\r\n" + ex.Message + MyDebug.SeparatorLine) ;
                listView.Clear() ;
                listView.View = View.Details ;
				listView.Columns.Add("Error", listView.Size.Width - 50, HorizontalAlignment.Left);
				ListViewItemFile item = new ListViewItemFile(ex.Message.Replace("\r\n", " "), IndexIconError, false) ;
				item.IsError = true ;
                listView.Items.Add(item) ;
            }
        }
        #endregion
       
        #region Linux
        /// <summary>
        /// For initializing the directoryTree upon creation of the TreeViewCtl form.
        /// Fill the treeView with the Linux-drives on the local or remote machine
        /// </summary>
        public void FillLinuxDirectoryTree()
        {
            try
            {
                // first clear the treeView and listView
                treeView.Nodes.Clear() ;
		listView.Items.Clear() ;
		labelDirectory.Text = "Directory:" ;

                this.IsLinux = true ;
                ArrayList drives = GetLinuxDrives() ;
                DebugOutput("FillLinuxDirectoryTree()") ;
                        
                treeView.BeginUpdate();

                for (int i = 0; i < drives.Count; i++)
                {
                    DebugOutput("drive[]" + drives[i].ToString()) ;
                    DirectoryNode cRoot = new DirectoryNode(drives[i].ToString()) ;
                    cRoot.ImageIndex = 0 ;
                    cRoot.SelectedImageIndex = 0 ;
                    treeView.Nodes.Add(cRoot);
                    try
                    {
			if (AddLinuxDirectories(cRoot, false)==false)
			{   DebugOutput("FillLinuxDirectoryTree(): Removed a Linux drive " + cRoot+"\n");
			    treeView.Nodes.Remove(cRoot);
			}
                    }
                    catch (Exception e)
                    {
                        DebugOutput("AddLinuxDirectories-Exception in FillLinuxDirectoryTree: " + 
							e.Message + e.StackTrace) ;
                    }
                }
                treeView.EndUpdate() ;
                // Select the first node in the TreeView
                try
                {
					if (treeView.Nodes.Count > 0)
					{
						treeView.SelectedNode = treeView.Nodes[0] ;
					}
                }
                catch(Exception e)
                {
                    MessageBox.Show(e.Message, "LTOOLS", MessageBoxButtons.OK, MessageBoxIcon.Error) ;
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "LTOOLS", MessageBoxButtons.OK,
                    MessageBoxIcon.Error) ;
                listView.Items.Clear() ;
            }
        }

        /// <summary>
        /// the GetLinuxDrives() gets all ext2/3 (no swap-partitions) partitions on the local or remote machine.
        /// </summary>
        /// <returns>an ArrayList with all available LinuxDrives on the local or remote machine</returns>
        private ArrayList GetLinuxDrives()
        {
            DebugOutput("GetLinuxDrives()") ;
            ArrayList drives = new ArrayList() ;
            try
            {
                LDir ldir ;
                if (LTOOLSnet.Connected)
                {
                    ldir = new LDir("ldirNT", "-x -part", LTOOLSnet.NetSocket) ;
                }
                else
                {
                    ldir = new LDir("ldirNT", "-part") ;
                }
                string partitions = ldir.GetPartitions() ;
                
                StringTokenizer lines = new StringTokenizer(partitions, "\n\r") ;
                // lines looks like:
                // lines[0]: Partition table info:
                // lines[1]: ------------------------------------------------
                // lines[2]: /dev/hda 1 :   NTFS / HPFS   19077M
                // lines[3]: /dev/hda 2 :   Win ExPar     19077M
                // lines[4]: /dev/hda 5 :   Win9x FAT32   18983M
                // lines[5]: /dev/hda 6 :   Linux EXT2      47MB
                // lines[6]: /dev/hda 7 :   Linux EXT2      47MB
                // fieldno.  0        1 2   3     4         5 
                while (lines.HasMoreTokens())
                {
                    string token = lines.NextToken() ;
                    if (GetLdirField(token, 3).ToLower().Equals("linux") &&
                        !GetLdirField(token, 4).ToLower().Equals("swap"))
                    {
                        drives.Add(GetLdirField(token, 0) + GetLdirField(token, 1) + " " + LinuxDirectorySeparatorChar) ;
                    }
                }
            }
            catch(Exception e)
            {
                MessageBox.Show(e.Message, "LTOOLS", MessageBoxButtons.OK, MessageBoxIcon.Error) ;
                drives = null ;
            }

 	    for (int i=0; i < drives.Count; i++)			//Remove duplicate partitions
	    {   string drive1 = (""+drives[i]).Substring(6,5);

		for (int j=i+1; j < drives.Count; j++)
		{   string drive2 = (""+drives[j]).Substring(6,5);
		    if (drive1.Equals(drive2))
		    {   DebugOutput("Duplicate partition removed: i="+i+"---"+drive1+"---   "+"j="+j+"---"+drive2+"---   ");
		    	drives.RemoveAt(i);
		    	break;
		    }
	    	}
	    }
	    return drives ;
        }

        /// <summary>
        /// returns "/dev/hda6" from a string like "/dev/hda6 /home/test/test.txt"
        /// </summary>
        /// <param name="linuxPath">a full linux path like: "/dev/hda6 /home/test/test.txt"</param>
        /// <returns>a linux-partition like "/dev/hda6" from a full linux-path</returns>
        private string GetLinuxDrive(string linuxPath)
        {
            return linuxPath.Substring(0, linuxPath.IndexOf(" ")) ;
        }

        /// <summary>
        /// returns "/home/test/test.txt" from a string like "/dev/hda6 /home/test/test.txt"
        /// </summary>
        /// <param name="linuxPath">a full linux path like: "/dev/hda6 /home/test/test.txt"</param>
        /// <returns>a file path like "/home/test/test.txt" from a full linux-path</returns>
        private string GetLinuxFilePath(string linuxPath)
        {
            return linuxPath.Substring(linuxPath.IndexOf(" ") + 1) ;
        }

        /// <summary>
        /// For a given root directory (or drive), add the directories to the directoryTree.
        /// </summary>
        /// <param name="node">the node to add the Linux-directories</param>
        private bool AddLinuxDirectories(DirectoryNode node, bool showError) 
        {   try 
            {
                // string arguments = "-x -s" + ((DirectoryNode)node).Path ;
                // Aufbau des ldir-Aufrufs !! ldir -s/dev/hda6 /joerg/testverzeichnis/
                // wichtig ist hinten der "/", sonst wird nur Info zum Verzeichnis ausgegeben !!!
                // string arguments = "-x -s" + GetPathFromNode(node) ;
                string arguments = "-s" + GetLinuxDrive(GetPathFromNode(node)) + 
                                    " \"" + GetLinuxFilePath(GetPathFromNode(node)) + "\"" ;
                DebugOutput("AddLinuxDirectories() - Process arguments: \"ldir " + arguments + "\"") ;
                LDir ldir ;
                if (LTOOLSnet.Connected)
                {
                    // connected to a remote server
                    ldir = new LDir("ldirNT", "-x " + arguments, LTOOLSnet.NetSocket) ;
                }
                else
                {
                    ldir = new LDir("ldirNT", arguments) ;
                }
                 DebugOutput("<<<<< AddLinuxDirectories():\n"+ldir.Response+"\n>>>>>>>>>>>>>>>>>>>\n") ;

		if (!(ldir.Response.StartsWith("d") && ldir.Response.Substring(StartColumnLinuxFilename,1).Equals(".")))
		{   if (showError)
			MessageBox.Show(ldir.Response, "LTOOLS", MessageBoxButtons.OK, MessageBoxIcon.Error);
		    return false;
		}

		
                StringTokenizer st = new StringTokenizer(ldir.Response, "\n\r") ;

                while (st.HasMoreTokens()) 
                {
                    string token = st.NextToken() ;
                    /*
                    string ldirfield = GetLdirField(token, 9) ;
                    DebugOutput(i++ + ": " + token + " --- field No.9:\t" + ldirfield) ;
                    */
                    if (token.Length > StartColumnLinuxFilename)
                    {
                        if (GetLdirField(token, 0)[0].ToString().Equals("d") )
                        {
                            string name = GetLdirField(token, 9) ;
                            if (!name.Equals(".") && !name.Equals("..") )
                            {
                                // DebugOutput ("Directory: " + name) ;
                                DirectoryNode dn = new DirectoryNode(name) ;
                                dn.ImageIndex = Folder ;
                                dn.SelectedImageIndex = FolderOpened ;
                                node.Nodes.Add(dn);
                            }
                        }
                    }
                }
            }
            catch (Exception e) 
            {
                DebugOutput(MyDebug.SeparatorLine + e.Message + "\r\n" + e.StackTrace + MyDebug.SeparatorLine) ;
            }
	    return true;
	}

        /// <summary>
        /// For a given node, add the sub-directories for node's children in the directoryTree.
        /// </summary>
        /// <param name="node">the node to add the Linux-sub-directories</param>
        private void AddLinuxSubDirectories(DirectoryNode node) 
        {   DebugOutput("AddLinuxSubDirectories()");
            try
            {
                for (int i = 0; i < node.Nodes.Count; i++) 
                {
                    AddLinuxDirectories((DirectoryNode)node.Nodes[i], true);
                }
                node.SubDirectoriesAdded = true;
            }
            catch
            {
                DebugOutput("AddLinuxSubDirectories-Exception") ;
            }
        }

        /// <summary>
        /// the NewLinuxDirectory() method shows a dialog in which you can insert a directory-name and you can set
        /// some attributes of the new directory or a symbolic link.
        /// </summary>
        /// <param name="node">the DirectoryNode(Directory in the Linux-filesystem) for the new directory</param>
        public void NewLinuxDirectory(DirectoryNode node)
        {
            DebugOutput("NewLinuxDirectory" + node.Path) ;

            if (LTOOLSnet.IsLinuxReadOnly)
            {
                MessageBox.Show("Your Linux filesystem is set to read only - change in menu 'File - Linux read only' first", "LTOOLS", MessageBoxButtons.OK, MessageBoxIcon.Information) ;
                return ;
            }
            // isNew, fileName, fileLength, fileDate, isDirectory, isReadOnly
            ModifyLinuxDialog dialog = new ModifyLinuxDialog(true, 
                "", "", "",
                "          0", "          0", "-rwxr-xr-x");
            DialogResult result = dialog.ShowDialog() ;

            if (result != DialogResult.OK)
            {
                return ;
            }
            if (!dialog.FileName.Equals(""))
            {
                string command = "ldirNT" ;
                string args = "-WRITE " ;
                if (dialog.IsLink)
                    args = args + "-link ";
                else
                    args = args + "-mkdir ";
                
                if (LTOOLSnet.Connected)
                {
                    args = args + "-x " ;
                } else
                {   args = args + "-q " ;
		}
                args = args + "-s" + LinuxDrive + 
                    " -f" + dialog.Access + 
                    " -g" + dialog.GID.Trim() +
                    " -u" + dialog.UID.Trim() + " " ;
                
                if (dialog.IsLink)
                {
                    // args = args + dialog.TargetName + " " ;
                    args = args + "\"" + dialog.TargetName + "\" " ;
                } 
                else
                {
                    args = args + "ldirtmpl " ;
                    /*
                    if (ltoolgui.Connected)
                        command = command + "zzz.xxx  ";
                    else
                        command = command + "ldirtmpl ";
                    */
                }
                // args = args + "\"" + node.Path + // directoryFullPathName + 
                // LinuxDirectorySeparatorChar + 
                //    dialog.FileName + "\"" ;
                string path = GetLinuxFilePath(node.Path) ;
                if (!path.EndsWith(LinuxDirectorySeparatorChar.ToString()))
                {
                    path = path + LinuxDirectorySeparatorChar ;
                }
                args = args + "\"" + path + dialog.FileName + "\"" ;

                DebugOutput("" + command + " " + args) ;
                
                LDir ldir ;
                if (LTOOLSnet.Connected)
                {
                    ldir = new LDir(command, args, LTOOLSnet.NetSocket) ;
                }
                else
                {
                    ldir = new LDir(command, args) ;
                }

                DebugOutput("NewLinuxDirectory:"+ldir.Response+"<<<\n") ;
                if (ldir.Response.Length > 0)
                {
                    //if LTOOLS's command line tool issues an error message, show first line of response in message box
                    MessageBox.Show(ldir.Response.Trim(), "LTOOLS", 
                        MessageBoxButtons.OK, MessageBoxIcon.Error);
                    return;
                }
                this.UpdateNode(node) ;
            }
        }
        
        /// <summary>
        /// the DeleteLinuxFile() method deletes a collection of files or directories in the listView
        /// </summary>
        /// <param name="items">Collection of the selected files/directories in the listView</param>
        /// <param name="confirmDelete">true if you want to show a MessageBox to confirm deleting the file</param>
        public void DeleteLinuxFile(ListView.SelectedListViewItemCollection items, bool confirmDelete)
        {   DebugOutput("DeleteLinuxFile()");
            bool updateFlag = false ;
            bool deleteFlag = false ;

            if (LTOOLSnet.IsLinuxReadOnly == true)
            {
                DebugOutput("LinuxIsReadOnly") ;
                MessageBox.Show("Your Linux filesystem is set to read only - change in menu 'File - Linux read only' first",
                    "LTOOLS", MessageBoxButtons.OK, MessageBoxIcon.Warning) ;
                return ;
            }

            foreach (ListViewItemFile item in items)
            {
                if (item.IsError || item.FileName.Equals(".."))
                {
                    continue ;
                }
                string deleteFile = item.FullFilePath ;

                deleteFlag = false ;                
                if (confirmDelete)
                {
                    DialogResult result =
                        MessageBox.Show ("Do you really want to delete \"" + deleteFile + "\"",
                        "LTOOLS", 
                        MessageBoxButtons.YesNoCancel,
                        MessageBoxIcon.Question) ;
                    if (result == DialogResult.Yes)
                    {
                        deleteFlag = true ;
                    }
                    else if (result == DialogResult.Cancel)
                    {
                        return ;
                    }
                }
                else
                {
                    deleteFlag = true ;
                }
                DebugOutput("DeleteLinuxFile(): " + deleteFile + " - " + deleteFlag.ToString()) ;

                if (deleteFlag)
                {
                    updateFlag = true ;
                    string command = "ldirNT" ;
                    
                    LDir ldir ;
                    
                    string fileToDelete ;
                    if (item.IsLink) // isLink
                    {
                        fileToDelete = GetLinuxFilePath(GetLinkName(deleteFile)) ;
                    }
                    else
                    {
                        fileToDelete = GetLinuxFilePath(deleteFile) ;
                    }

                    if (LTOOLSnet.Connected)
                    {
                        string args = "-WRITE -del -q -s" + GetLinuxDrive(deleteFile) + 
                            " \"" + fileToDelete + "\"" ;
                        DebugOutput(command + " " + args) ;

                        ldir = new LDir(command, args, LTOOLSnet.NetSocket) ;
                    }
                    else
                    {
                        string args = "-WRITE -del -q -s" + GetLinuxDrive(deleteFile) + 
                            " \"" + fileToDelete + "\"" ;
                        DebugOutput(command + " " + args) ;

                        ldir = new LDir(command, args) ;
                    }

                    DebugOutput("DeleteLinuxFile 1>>>"+ldir.Response+"<<<") ;

                    if (ldir.Response.Length > 0)
                    {	
                        //if LTOOLS's command line tool issues an error message, show first line of response in message box
                        MessageBox.Show(ldir.Response.Trim(),"LTOOLS", MessageBoxButtons.OK, MessageBoxIcon.Error) ;
                        return;
                    }
                }
            }
            if (updateFlag)
            {
                DirectoryNode node = this.GetSelectedDirectoryNode() ;
                this.UpdateNode(node) ;
            }
        }

        /// <summary>
        /// the StartLinuxApplication() method first copies the linuxfile to the temporary dos-directory and then
        /// starts an application to show/edit the double-clicked ListViewItem
        /// in the listview or executes the double-clicked application.
        /// </summary>
        /// <param name="item">the selected item in the listView to start an application</param>
        public void StartLinuxApplication(ListViewItemFile item, bool start)
        {
            // create a directory for the files which will be copied
            // from the linux-filesystem.
            if (!Directory.Exists(DirFilePanel.tempPathLinuxFiles))
            {
                DebugOutput("Create Directory " + DirFilePanel.tempPathLinuxFiles) ;
                Directory.CreateDirectory(DirFilePanel.tempPathLinuxFiles) ;
            }
            DebugOutput("StartLinuxApplication- isLinux: " + isLinux + 
                        ". Process.Start(\"" + item.FullFilePath + "\")") ;
            
            string fileName ;
            string tempFileName ;
            string tempFullPath ;

            // check if the selected item is a link
            // "link -> test.txt" or "link -> /home/test/test.txt"
            if (item.LinuxFileInfoString[0].ToString().Equals("l"))
            {
                int index = item.FileName.IndexOf("->", 0) + 3 ;
                fileName = item.FileName.Substring(index) ;
                
                if (fileName.StartsWith(LinuxDirectorySeparatorChar.ToString()))
                {
                    // it's full path to a file, e.g. "link -> /home/test/test.txt"
                    tempFileName = fileName.Substring(fileName.LastIndexOf(LinuxDirectorySeparatorChar.ToString()) + 1) ;
                    tempFullPath = fileName ;
                }
                else
                {
                    // it's a file in the current directory, e.g. "link -> test.txt"
                    tempFileName = fileName ;
                    tempFullPath = GetLinuxFilePath(item.Directory) + fileName ;
                }
            }
            else
            {
                tempFileName = item.FileName ;
                tempFullPath = GetLinuxFilePath(item.FullFilePath) ;
            }

            string command = "ldirNT" ;
            StringBuilder args = new StringBuilder() ;
            
            if (LTOOLSnet.Connected)
            {
                /*
                args = "-READ -x -s" + GetLinuxDrive(item.FullFilePath) + 
                        " \"" + GetLinuxFilePath(item.FullFilePath) + "\" " + "zzz.xxx" ;
                */
                args.Append("-READ -x -s" + GetLinuxDrive(item.FullFilePath) + 
                    " \"" + tempFullPath + "\" " + "zzz.xxx") ;

                LDir ldir = new LDir(command, args.ToString(), LTOOLSnet.NetSocket) ;
                DebugOutput("connected: " + LTOOLSnet.Connected.ToString() + "\n" + ldir.Response) ;

                if (ldir.Response.Length > 0)
                {
                    //if LTOOLS's command line tool issues an error message, show it
                    MessageBox.Show(ldir.Response.Trim(), "LTOOLS",
                        MessageBoxButtons.OK, MessageBoxIcon.Error) ;
                    return;
                }
            }
            else
            {
                /*
                args = "-READ -s" + GetLinuxDrive(item.FullFilePath) + 
                        " \"" + GetLinuxFilePath(item.FullFilePath) + "\" \"" + DirFilePanel.TempPathLinuxFiles + Path.DirectorySeparatorChar.ToString() + fileName + "\"" ;
                */
                args.Append("-READ -q -s" + GetLinuxDrive(item.FullFilePath) + 
                        " \"" + tempFullPath + "\" \"" + 
                        DirFilePanel.tempPathLinuxFiles + 
                        Path.DirectorySeparatorChar.ToString() + 
                        tempFileName + "\"") ;

                LDir ldir = new LDir(command, args.ToString()) ;
                if (ldir.Response.Length > 0)
                {
                    //if LTOOLS's command line tool issues an error message, show it
                    MessageBox.Show(ldir.Response.Trim(), "LTOOLS",
                        MessageBoxButtons.OK, MessageBoxIcon.Error) ;
                    return;
                }
            }

            if (LTOOLSnet.Connected)
            {
                //Remote files must be copied to the local machine, before we can start them
                GetFileFromHost(tempFileName);
                try
                {
                    DebugOutput("StartLinuxApplication() Connected:" + LTOOLSnet.Connected + " - isLinux: " + isLinux + 
                        ". Process.Start(\"" + tempFileName + "\")") ;
                    // Process.Start("runit.bat", "\"" + item.FullFilePath + "\"") ;
		    if (start)
		    {
			Process myProcess = Process.Start("\""+DirFilePanel.tempPathLinuxFiles + Path.DirectorySeparatorChar.ToString() + tempFileName+"\"") ; 
		    } 
		    else
		    {
			Process myProcess = Process.Start("edit.bat", "\""+DirFilePanel.tempPathLinuxFiles + Path.DirectorySeparatorChar.ToString() + tempFileName+"\"") ; 
		    }
                }
                catch (Exception ex)
                {
                    DebugOutput(ex.Message) ;
                    MessageBox.Show(ex.Message, "LTOOLS", MessageBoxButtons.OK, MessageBoxIcon.Information) ;
                }
            }
            else
            {
                try
                {
                    DebugOutput("StartLinuxApplication() Connected:" + LTOOLSnet.Connected + " - isLinux: " + isLinux + 
                        ". Process.Start(\"" + tempFileName + "\")") ;

		    // Process.Start("runit.bat", "\"" + item.FullFilePath + "\"") ;
                    if (start)
		    {
			Process myProcess = Process.Start("\""+DirFilePanel.tempPathLinuxFiles + Path.DirectorySeparatorChar.ToString() + tempFileName+"\"") ; 
		    } else
		    {   Process myProcess = Process.Start("edit.bat", "\""+DirFilePanel.tempPathLinuxFiles + Path.DirectorySeparatorChar.ToString() + tempFileName+"\"") ;
		    }
                }
                catch (Exception ex)
                {
                    DebugOutput(ex.Message) ;
                    MessageBox.Show(ex.Message, "LTOOLS", MessageBoxButtons.OK, MessageBoxIcon.Information) ;
                }
            }
        }

        /// <summary>
        /// the PasteToLinux() method pastes the files in the CopyFiles-ArrayList of the Class LTOOLSnet
        /// int the targetDirectory
        /// </summary>
        /// <param name="targetDirectory">the directory the files will be copied to.</param>
        /// <param name="issueMessages">true</param>
        public void PasteToLinux(string targetDirectory, bool issueMessages)
        {
            DebugOutput("LTOOLSnet.CopyFileCount: " + LTOOLSnet.CopyFileCount) ;
			bool filePasted = false ;

            for (int j=0; j < LTOOLSnet.CopyFileCount ; j++)
            {
                string destination = targetDirectory + LTOOLSnet.CopyFileName[j] ;
                DebugOutput("PasteToLinux(): source: " + LTOOLSnet.CopyFilePath[j] + " - destination: " + destination) ;

                if (LTOOLSnet.IsLinuxReadOnly == true)
                {
                    MessageBox.Show("Your Linux filesystem is set to read only - change in menu 'File - Linux read only' first", 
                        "LTOOLS", MessageBoxButtons.OK, MessageBoxIcon.Information);
                    return ;
                }

				// check if the linux file exists in the current directory
				if (LinuxFileExist((String)LTOOLSnet.CopyFileName[j]))
				{
					String msg = "Linux-file '" + (String)LTOOLSnet.CopyFileName[j] +
									"' exists - can't overwrite - please delete first." ;
					MessageBox.Show(msg, "LTOOLS", MessageBoxButtons.OK, MessageBoxIcon.Warning) ;
					// break ;
				}

                // Linux to Linux copy ----------------
                if (LTOOLSnet.CopyFileIsLinux) 
                {
                    string command = "ldirNT" ;
                    string args ;
                    //Copy the file from Linux to Dos
                    // ldir -READ -x -s/dev/hda /joerg/test/fhte.java zzz.tmp
                    // args = "-READ -x -s" + LTOOLSnet.CopyFilePath[j] + " " + "zzz.tmp";
                    
                    if (LTOOLSnet.Connected)
                    {
                        args = "-READ -x -s" + GetLinuxDrive(LTOOLSnet.CopyFilePath[j].ToString()) + 
                            " \"" + GetLinuxFilePath(LTOOLSnet.CopyFilePath[j].ToString()) + "\" " + "zzz.tmp" ;
                        DebugOutput("PasteToLinux()-READ:" + command + " " + args) ;

                        LDir ldir = new LDir (command, args, LTOOLSnet.NetSocket) ;

                        if (ldir.Response.Length > 0)
                        {	
                            //if LTOOLS's command line tool issues an error message, show first line of response in message box
                            if (issueMessages)
                            {
                                MessageBox.Show(ldir.Response.Trim(), "LTOOLS", MessageBoxButtons.OK, MessageBoxIcon.Error) ;
                            }
                            return ;
                        }
                        // ldir -WRITE -x -s/dev/hda -copy zzz.tmp /joerg/testverzeichnis/fhte.java
                        args = "-WRITE -x -s" + LinuxDrive + " -copy " + "zzz.tmp" + " \"" + GetLinuxFilePath(destination) + "\"" ; // targetPath + "/" + targetFile;
                        DebugOutput("PasteToLinux()-WRITE LinuxToLinux:" + command + " " + args) ;
                        LDir ldirWrite = new LDir(command, args, LTOOLSnet.NetSocket) ;

						if (ldirWrite.Response.Length > 0)
						{	
							//if LTOOLS's command line tool issues an error message, show first line of response in message box
							if (issueMessages)
							{
								MessageBox.Show(ldir.Response.Trim(), "LTOOLS", MessageBoxButtons.OK, MessageBoxIcon.Error) ;
							}
							return ;
						}
						else
						{
							filePasted = true ;
						}
                    }
                    else										// not connected
                    {
                        args = "-READ -q -s" + GetLinuxDrive(LTOOLSnet.CopyFilePath[j].ToString()) + 
                            " \"" + GetLinuxFilePath(LTOOLSnet.CopyFilePath[j].ToString()) + "\" " + "zzz.tmp";
                        DebugOutput("PasteToLinux()-READ:" + command + " " + args) ;

                        LDir ldir = new LDir (command, args) ;

                        if (ldir.Response.Length > 0)
                        {	
                            //if LTOOLS's command line tool issues an error message, show first line of response in message box
                            if (issueMessages)
                            {
                                MessageBox.Show(ldir.Response.Trim(), "LTOOLS", MessageBoxButtons.OK, MessageBoxIcon.Error) ;
                            }
                            return ;
                        }
                        // ldir -WRITE -x -s/dev/hda -copy zzz.tmp /joerg/testverzeichnis/fhte.java
                        args = "-WRITE -q -s" + LinuxDrive + " -copy " + "zzz.tmp" + " \"" + GetLinuxFilePath(destination) + "\"" ; // targetPath + "/" + targetFile;
                        DebugOutput("PasteToLinux()-WRITE LinuxToLinux:" + command + " " + args) ;
                        LDir ldirWrite = new LDir(command,args) ;

                        if (ldirWrite.Response.Length > 0)
                        {	
                            //if LTOOLS's command line tool issues an error message, show first line of response in message box
                            if (issueMessages)
                            {
                                MessageBox.Show(ldir.Response.Trim(), "LTOOLS", MessageBoxButtons.OK, MessageBoxIcon.Error) ;
                            }
                            return ;
                        }
						else
						{
							filePasted = true ;
						}
                    }
                }
                else											// Dos to Linux copy
                {
                    string command = "ldirNT" ;
                    string args ;
                    
                    if (LTOOLSnet.Connected == false)
                    {
                        args = "-WRITE -q -s" + LinuxDrive + " -copy " + 
                                "\"" + LTOOLSnet.CopyFilePath[j] + "\"" + 
                                " \"" + GetLinuxFilePath(destination) + "\"" ;
                    } 
                    else
                    {
                        PutFileToHost((string) LTOOLSnet.CopyFilePath[j]) ;
                        args = "-WRITE -x -s" + LinuxDrive + " -copy " + "zzz.xxx" + " " + " \"" + GetLinuxFilePath(destination) + "\"" ; // + targetPath + "/" + targetFile;
                    }
                    DebugOutput("PasteToLinux()-WRITE DosToLinux:" + command + " " + args + " - connected: " + LTOOLSnet.Connected) ;
                    
                    LDir ldir ; 
                    if (LTOOLSnet.Connected)
                    {
                        ldir = new LDir(command, args, LTOOLSnet.NetSocket) ;
                    }
                    else
                    {
                        ldir = new LDir(command, args) ;
                    }

                    if (ldir.Response.Length > 0)
                    {						//if LTOOLS's command line tool issues an error message, show first line of response in message box
                        if (issueMessages)
                        {
                            MessageBox.Show(ldir.Response.Trim(), "LTOOLS", MessageBoxButtons.OK, MessageBoxIcon.Error) ;
                        }
                        return ;
                    }
					else
					{
						filePasted = true ;
					}
                }
            }
			if (filePasted)
			{
				UpdateNode(GetSelectedDirectoryNode()) ;
			}
            return ;
        }
		/// <summary>
		/// this Method checks if the given file exist in the current selected directory
		/// </summary>
		/// <param name="fileName">the fileName to check</param>
		/// <returns>true if it exists, false if not</returns>
		public bool LinuxFileExist(String fileName)
		{
			ListView.ListViewItemCollection items = listView.Items ;
			foreach (ListViewItemFile item in items)
			{
				if (item.FileName.Equals(fileName))
				{
					return true ;
				}
			}
			return false ;
		}
        /// <summary>
        /// the ModifyLinuxFile() method shows a dialog in which you can modify a collection of selected files or
        /// directories in the listView.
        /// </summary>
        /// <param name="items">Collection of the selected files/directories in the listView</param>
        public void ModifyLinuxFile(ListView.SelectedListViewItemCollection items)
        {   DebugOutput("ModifyLinuxFile()");
            bool updateFlag = false ;
            foreach (ListViewItemFile item in items)
            {
                if (item.IsError || item.FileName.Equals("..") )
                {
                    continue ;
                }
                DebugOutput("ModifyLinuxFile(): fullpath: " + item.FullFilePath + " --- fileName: " + item.FileName) ;
                // string fileFullPathName = item.FullFilePath ;
                // string fileName = item.FileName ;
                string command ;
                string access = "" ;
                string uid    = "      " ;
                string gid    = "      " ;
                string length = "" ;
                string date   = "" ;
                string time   = "" ;

                /* nicht ntig, da die ntige Zeile in item.LinuxFileInfoString steht
                command = "ldirNT -x -s" + item.FullFilePath ; // currentDrive + " " + fileFullPathName ;
                DebugOutput("ModifyLinuxFile():" + command) ;
                */
                StringTokenizer token = new StringTokenizer(item.LinuxFileInfoString, " ") ;
                int i = 0 ;
                while (token.HasMoreTokens())
                {
                    command = token.NextToken();
                    switch (i)
                    {
                        case 0:
                            access = command;
                            break;
                        case 1:
                            uid = uid + command;
                            break;
                        case 2:
                            gid = gid + command;
                            break;
                        case 3:
                            length = command;
                            break;
                        case 5:
                            date = command;
                            break;
                        case 6:date = date + " " + command;
                            break;
                        case 7:
                            time = command;
                            break;
                        case 8:
                            date = date + " " + command;
                            break;
                    }
                    i++;
                }
                string fileName ;
                if (item.IsLink)
                {
                    // if it's a link, just show the filename of the link
                    // without the name of the linked file
                    // e.g. "link -> test.java": link
                    fileName = GetLinkName(item.FileName) ;
                }
                else
                {
                    fileName = item.FileName ;
                }

                ModifyLinuxDialog dialog = new ModifyLinuxDialog(false, 
                    fileName, date + " " + time, length,
                    uid, gid, access);
                if (dialog.ShowDialog() == DialogResult.OK)
                {
                    if (LTOOLSnet.IsLinuxReadOnly)
                    {
                        DebugOutput("LinuxIsReadOnly") ;
						string errormessage = "Your Linux filesystem is set to read only - change in menu 'File" +
												" - Linux read only' first" ;
                        MessageBox.Show(errormessage, "LTOOLS", MessageBoxButtons.OK, MessageBoxIcon.Warning) ;
                    }
                    else
                    {
						// check if the new filename is not "" or the new filename doesn't contain a "/"
						if (dialog.FileName.Equals("") || 
							dialog.FileName.IndexOf(LinuxDirectorySeparatorChar.ToString()) > 0)
						{
							string errorMessage ;
							if (dialog.FileName.Equals(""))
							{
								errorMessage = "The new filename is not allowed. The length of the filename is 0." ;
							}
							else
							{
								errorMessage = "The new filename is not allowed. The filename contains a /." ;
							}
							MessageBox.Show(errorMessage, "LTOOLS",
								MessageBoxButtons.OK, MessageBoxIcon.Error) ;
							continue ;
						}

                        if (fileName.Equals(dialog.FileName) && 
                            dialog.GID.Equals(gid) && 
                            dialog.UID.Equals(uid) && !dialog.IsAccessChanged)
                        {
                            // if nothing was changed in the dialog, leave this method
                            //return ;
                        }
                        else
                        {
                            updateFlag = true ;
                            DebugOutput("LinuxDrive: \"" + item.LinuxDrive + "\"") ;
                            // z.B.: ldir -WRITE -ren -x -s/dev/hda -f777 /joerg/fhte.java fhte1.java
                            // ldir -WRITE -ren -x -s/dev/hda -f777 /dev/hda /joerg/testverzeichnis/manual.html manual.htm
                            command = "ldirNT " ;
                            string args = "-WRITE " ;
                            if (!fileName.Equals(dialog.FileName))
                            {
                                args = args + "-ren " ;
                            }
                           
                            if (LTOOLSnet.Connected)
                            {
                                args = args + "-x " ;
                            } else
                            {	args = args + "-q " ;
                            }
			    args = args + "-s" + item.LinuxDrive + " -f" + dialog.Access + " " ;
                            if (!dialog.GID.Equals(gid))
                                args = args + "-g" + dialog.GID + " " ;
                            if (!dialog.UID.Equals(uid))
                                args = args + "-u" + dialog.UID + " " ;
                            // now the FullFileFath without the device in front of
                            // cut z.B. "/dev/hda7 "
                            // int startIndex = item.FullFilePath.IndexOf(" ") + 1 ;
                            // MessageBox.Show("\"" + item.FullFilePath.Substring(startIndex) + "\"") ;
                            // args = args + item.FullFilePath.Substring(startIndex) ;
                            
                            string oldPath = GetLinuxFilePath(item.FullFilePath) ;
                            if (item.IsLink)
                            {
                                oldPath = oldPath.Substring(0, oldPath.IndexOf("->") - 1) ;
                            }

                            args = args + "\"" + oldPath + "\"" ;

                            if (!fileName.Equals(dialog.FileName))
                            {
                                args = args + " \"" + dialog.FileName + "\"" ;
                            }
            
                            DebugOutput("ModifyLinuxFile(): " + command + args) ;
                            
                            LDir ldir ;
                            if (LTOOLSnet.Connected)
                            {
                                // connected to a remote server
                                ldir = new LDir(command, args, LTOOLSnet.NetSocket) ;
                            }
                            else 
                            {
                                ldir = new LDir(command, args) ;
                            }
			    DebugOutput("ModifyLinuxFile 1:>>>"+ldir.Response+"<<<");
                            if (ldir.Response.Length > 0)
                            {
                                //if LTOOLS's command line tool issues an error message, 
                                // show first line of response in message box
                                MessageBox.Show(ldir.Response, "LTOOLS", MessageBoxButtons.OK, MessageBoxIcon.Error) ;
                                // return ;
                            }
                        }
                    } // end: if (LTOOLSnet.IsLinuxReadOnly == true)
                } // end: if (result == DialogResult.OK)
            }
            if (updateFlag)
            {
                UpdateNode(this.GetSelectedDirectoryNode()) ;
            }
        }

        /// <summary>
        /// the UpdateLinuxListView() method updates the listView after selecting a node in the treeView
        /// or after deleting/modifying or pasting files in the selected node of the treeView.
        /// </summary>
        /// <param name="dirNode">the DirectoryNode which should be updated</param>
        public void UpdateLinuxListView(DirectoryNode dirNode)
        {
            DebugOutput("UpdateListView() - LINUX: " + dirNode.Path) ;
            string ldirPath = GetPathFromNode(dirNode) ;        // the path of the directory in treeView
            ArrayList directories = new ArrayList() ;
            ArrayList files       = new ArrayList() ;

			// string arguments = "-x -s" + ldirPath ;
			string arguments = "-s" + GetLinuxDrive(ldirPath) + 
				" \"" + GetLinuxFilePath(ldirPath) + "\"" ;
			DebugOutput("UpdateListView() - Process arguments: \"ldir " + arguments + "\"") ;
            
			LDir ldir ;
			if (LTOOLSnet.Connected)							// connected to a remote server
			{
				ldir = new LDir("ldirNT", "-x " + arguments, LTOOLSnet.NetSocket) ;
			}
			else
			{
				ldir = new LDir("ldirNT", arguments) ;
			}
			StringTokenizer st    = new StringTokenizer(ldir.Response, "\n\r") ;
			while (st.HasMoreTokens()) 
			{
				string token = st.NextToken() ;
				if (token.Length < StartColumnLinuxFilename)    // something is wrong, it's not a Linux-drive
				{
					StringBuilder strB = new StringBuilder(token) ;
					while(st.HasMoreTokens())                   // show the complete error-message
					{
						strB.Append(st.NextToken()) ;
					}
					DebugOutput("StartColumnLinuxFilename > token.length: " + strB.ToString()) ;
					listView.Clear() ;
					listView.View = viewListView ;
					listView.Columns.Add("Error", listView.Size.Width - 50, HorizontalAlignment.Left);
					ListViewItemFile item = new ListViewItemFile(strB.ToString(), 0, false) ;
					item.IsError = true ;
					listView.Items.Add(item) ;
					return ;
				}
				else
				{
					string name = GetLdirField(token, 9) ;
					if (GetLdirField(token, 0)[0].ToString().Equals("d"))   // it's a directory
					{   
						if (!name.Equals(".") && !name.Equals("..") )
						{
							string size = GetLdirField(token, 3) ;
							string last = GetLdirField(token, 4) + " " + GetLdirField(token, 5) + " " + 
								GetLdirField(token, 6) + " " + GetLdirField(token, 7) + " " +
								GetLdirField(token, 8) ;
							ListViewItemFile dir = new ListViewItemFile(name, IndexIconFolder, true, 
								ldirPath, size, last, token) ;
							dir.SubItems.Add("") ;
							dir.SubItems.Add("") ;
							dir.SubItems.Add(dir.FileLastModified) ;
							dir.SubItems.Add(GetLdirField(dir.LinuxFileInfoString, 0)) ;
							dir.SubItems.Add(GetLdirField(dir.LinuxFileInfoString, 1)) ;
							dir.SubItems.Add(GetLdirField(dir.LinuxFileInfoString, 2)) ;
							directories.Add(dir) ;
						}
					}
					else if (LTOOLSnet.LinuxFilePattern.Equals("*"))
					{   // it's another filetype an the pattern is set to show all
						string size = GetLdirField(token, 3) ;
						string last = GetLdirField(token, 4) + " " + GetLdirField(token, 5) + " " + 
							GetLdirField(token, 6) + " " + GetLdirField(token, 7) + " " +
							GetLdirField(token, 8) ;
						ListViewItemFile file = new ListViewItemFile(name, IndexIconFile, false,
							ldirPath, size, last, token) ;
						file.SubItems.Add(file.FileSize) ;
						file.SubItems.Add(GetLinuxExtension(file.FullFilePath)) ;
						file.SubItems.Add(file.FileLastModified) ;
						file.SubItems.Add(GetLdirField(file.LinuxFileInfoString, 0)) ;
						file.SubItems.Add(GetLdirField(file.LinuxFileInfoString, 1)) ;
						file.SubItems.Add(GetLdirField(file.LinuxFileInfoString, 2)) ;
						files.Add(file) ;
					}
				}
			}

            if (!LTOOLSnet.LinuxFilePattern.Equals("*"))		// get files with pattern #############################
            {
				string args = "-s" + GetLinuxDrive(ldirPath) + 
					" \"" + GetLinuxFilePath(ldirPath) + LTOOLSnet.LinuxFilePattern + "\"" ;
				DebugOutput("UpdateListView() - Process arguments: \"ldir " + args + "\"") ;
            
				LDir ldirFilePattern ;
				if (LTOOLSnet.Connected)						// connected to a remote server
				{
					ldirFilePattern = new LDir("ldirNT", "-x " + args, LTOOLSnet.NetSocket) ;
				}
				else
				{
					ldirFilePattern = new LDir("ldirNT", args) ;
				}
				// DebugOutput(ldirFilePattern.Response) ;
				StringTokenizer stFilePattern = new StringTokenizer(ldirFilePattern.Response, "\n\r") ;
				while (stFilePattern.HasMoreTokens()) 
				{
					string token = stFilePattern.NextToken() ;
					// something is wrong, it's not a Linux-drive
					if (token.Length < StartColumnLinuxFilename)
					{
						StringBuilder strB = new StringBuilder(token) ;
						while(stFilePattern.HasMoreTokens())               // show the complete error-message
						{
							strB.Append(stFilePattern.NextToken()) ;
						}
						DebugOutput("StartColumnLinuxFilename > token.length: " + strB.ToString()) ;
						// e.g.: Can't find '*.java'.Linux Path Invalid
						// this is the response of ldir if there are no files with this pattern in this directory !!!
						if (!strB.ToString().Equals("Can't find '" + LTOOLSnet.LinuxFilePattern + "'.Linux Path Invalid"))
						{
							listView.Clear() ;
							listView.View = viewListView ;
							listView.Columns.Add("Error", listView.Size.Width - 50, HorizontalAlignment.Left);
							ListViewItemFile item = new ListViewItemFile(strB.ToString(), 0, false) ;
							item.IsError = true ;
							listView.Items.Add(item) ;
							return ;
						}
					}
					else
					{
						string name = GetLdirField(token, 9) ;

						if (!GetLdirField(token, 0)[0].ToString().Equals("d"))
						{   // it's another filetype an the pattern is set to show all
							string size = GetLdirField(token, 3) ;
							string last = GetLdirField(token, 4) + " " + GetLdirField(token, 5) + " " + 
								GetLdirField(token, 6) + " " + GetLdirField(token, 7) + " " +
								GetLdirField(token, 8) ;
							ListViewItemFile file = new ListViewItemFile(name, IndexIconFile, false,
								ldirPath, size, last, token) ;
							file.SubItems.Add(file.FileSize) ;
							file.SubItems.Add(GetLinuxExtension(file.FullFilePath)) ;
							file.SubItems.Add(file.FileLastModified) ;
							file.SubItems.Add(GetLdirField(file.LinuxFileInfoString, 0)) ;
							file.SubItems.Add(GetLdirField(file.LinuxFileInfoString, 1)) ;
							file.SubItems.Add(GetLdirField(file.LinuxFileInfoString, 2)) ;
							files.Add(file) ;
						}
					}
				}
            } // END: if (!LTOOLSnet.LinuxFilePattern.Equals("*"))
			InsertListViewItems(ldirPath, directories, files) ;	// insert the directories/files into listView
        }

        /// <summary>
        /// Extract a field from ldir's output
        /// example command:
        /// "drwxr-xr-x    0    0     49152 Wed Mar 12 04:10:49 2003 lost+found"
        /// 0=mode, 1=uid, 2=gid,  3=length, ....  .... .... ....   9=file/directory name
        /// </summary>
        /// <param name="command">the command line to extract a field</param>
        /// <param name="fieldNr">the fieldnumber to extract from command</param>
        /// <returns>the field number "fieldNr" of the command-string</returns>
        private string GetLdirField(string command, int fieldNr)
        {
            StringTokenizer token = new StringTokenizer(command, " ") ;
            string cmd ;

            int i = 0;
            while (token.HasMoreTokens())
            {
                cmd = token.NextToken() ;
                if (i == 9)                                     // Special treatment for (long) filenames
                {
                    cmd = command.Substring(command.IndexOf(cmd));
                }
                if (i == fieldNr)
                {
                    return cmd ;
                }
                i++ ;
            }
            return "" ;
        }
        /// <summary>
        /// returns the full filepath from a link
        /// e.g. "/dev/hda6 /home/test/testlink -> /home/test/test.txt":
        /// returns "/home/test/test.txt" or 
        /// e.g. "/dev/hda6 /home/test/testlink -> test.txt":
        /// returns "/home/test/test.txt"
        /// </summary>
        /// <param name="fullPath">a full linux path with device, path and linkpath</param>
        /// <returns>returns the full filepath of a link</returns>
        public string GetFilePathFromLink(string fullPath)
        {
            // /dev/hda6 /joe/test verzeichnis/joe/testLink -> Test.java ---- testLink -> Test.java
            // /dev/hda6 /joe/test verzeichnis/joe/testlink2 -> /joe/test verzeichnis/fhte.java ---- testlink2 -> /joe/test verzeichnis/fhte.java
            int index = fullPath.IndexOf("->", 0) + 3 ;
            string fileName = fullPath.Substring(index) ;
            string path ;    
            if (fileName.StartsWith(LinuxDirectorySeparatorChar.ToString()))
            {
                // it's full path to a file, e.g. "link -> /home/test/test.txt"
                path = fileName ;
            }
            else
            {
                // it's a file in the current directory, e.g. "link -> test.txt"
                // last index of LinuxDirectorySeparatorChar + fileName
                string linuxPath = GetLinuxFilePath(fullPath) ;
                path = linuxPath.Substring(0, linuxPath.LastIndexOf(LinuxDirectorySeparatorChar.ToString()) + 1) + fileName ;
            }
            return path ;
        }
        /// <summary>
        /// returns the filename of a link
        /// e.g. "/dev/hda6 /home/test/testlink -> /home/test/test.txt":
        /// returns "test.txt"
        /// </summary>
        /// <param name="fullPath">a full linux path with device, path and linkpath</param>
        /// <returns>the filename of a link</returns>
        public string GetFileNameFromLink(string fullPath)
        {
            int index = fullPath.IndexOf("->", 0) + 3 ;
            string fileName = fullPath.Substring(index) ;

            string name ;    
            if (fileName.StartsWith(LinuxDirectorySeparatorChar.ToString()))
            {
                // it's full path to a file, e.g. "link -> /home/test/test.txt"
                name = fileName.Substring(fileName.LastIndexOf(LinuxDirectorySeparatorChar.ToString()) + 1) ;
            }
            else
            {
                // it's a file in the current directory, e.g. "link -> test.txt"
                name = fileName ;
            }
            return name ;
        }

        /// <summary>
        /// returns the filename of the symbolic link without the "-> filepath"
        /// e.g. "/dev/hda6 /home/test/testlink -> /home/test/test.txt":
        /// returns "/dev/hda6 /home/test/testlink"
        /// </summary>
        /// <param name="link">a full linux path with device, path and linkpath</param>
        /// <returns>the filename of the link</returns>
        private string GetLinkName(string link)
        {
            int index = link.IndexOf("->", 0) - 1 ;
            string linkName = link.Substring(0, index) ;
            return linkName ;
        }
        #endregion

        #region TreeView Event-Handler
        /// <summary>
        /// Event handler for the afterSelect event on the directoryTree. Change the
        /// labelDirectory to show the path of the selected directoryNode, add directories to the nodes
        /// and update the listView with the files in the selected DirectoryNode.
        /// </summary>
        /// <param name="source">source object</param>
        /// <param name="e">event data</param>
        private void TreeView_AfterSelect(object source, TreeViewEventArgs e) 
        {
			lastSelectedNode = (DirectoryNode)e.Node ;
            ((DirectoryNode)e.Node).Path = GetPathFromNode(e.Node) ;    // set the Path in the DirectoryNode
            DebugOutput("TreeView_AfterSelect(): IsLinux = " + IsLinux.ToString() + " - DirectoryNode.Path: " + 
                ((DirectoryNode)e.Node).Path) ;
            labelDirectory.Text = "Directory: " + ((DirectoryNode)e.Node).Path ;
            
            //e.Node.Expand() ;                                             // expand the selected node
            
            // if a Dos-Drive was selected and it's a removable device (CDRom too), then add the directories
            if (((DirectoryNode)e.Node).Text.EndsWith(Path.DirectorySeparatorChar.ToString()) && 
                ((DirectoryNode)e.Node).IsRemovableDrive == true)
            {
                ((DirectoryNode)e.Node).Collapse() ;
                ((DirectoryNode)e.Node).Nodes.Clear() ;
                ((DirectoryNode)e.Node).SubDirectoriesAdded = false ;
                AddDosDirectories((DirectoryNode)e.Node) ;
                ((DirectoryNode)e.Node).Expand() ;
                UpdateDosListView((DirectoryNode)e.Node) ;
            }
            else                                                // update the ListView
            {
                if (IsLinux)
                {
                    UpdateLinuxListView((DirectoryNode)e.Node) ;
                }
                else
                {
                    UpdateDosListView((DirectoryNode)e.Node) ;
                }
            }
        }

        /// <summary>
        /// Event handler for the beforeExpand event on the directoryTree.
        /// If the node is not already expanded, expand it. Add the subdirectories to the Node
        /// before expanding if necessary (when the node was collapsed, the subdirectories are still
        /// available).
        /// </summary>
        /// <param name="source">source object</param>
        /// <param name="e">event data</param>
        private void TreeView_BeforeExpand(object source, TreeViewCancelEventArgs e) 
        {
            if (isLinux)
            {
                DirectoryNode nodeExpanding = (DirectoryNode)e.Node;
                if (!nodeExpanding.SubDirectoriesAdded)
                    AddLinuxSubDirectories(nodeExpanding);
            }
            else
            {
                DirectoryNode nodeExpanding = (DirectoryNode)e.Node;
                if (!nodeExpanding.SubDirectoriesAdded)
                    AddDosSubDirectories(nodeExpanding);
            }
        }

        /// <summary>
        /// Occurs when the mouse drags an item into the client area for this control.
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void TreeView_DragEnter(object sender, System.Windows.Forms.DragEventArgs e)
        {
            DebugOutput("TreeView_DragEnter() - IsLinux: " + IsLinux) ;
            // this.ActiveControl = treeView ;

            if (e.Data.GetDataPresent(DataFormats.Text))
            {
                e.Effect = DragDropEffects.Copy ;
                DebugOutput("DataFormats.Text") ;
            }
            else if (e.Data.GetDataPresent(DataFormats.FileDrop))
            {
                e.Effect = DragDropEffects.Copy ;
                DebugOutput("DataFormats.FileDrop") ;
            }
            else
            {
                e.Effect = DragDropEffects.None ;
                DebugOutput("DataFormats ?") ;
            }
        }

        /// <summary>
        /// Occurs when the mouse drags an item and the user releases the mouse indicating that the item should 
        /// be 'dropped' into this Control.
        /// 
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void TreeView_DragDrop(object sender, System.Windows.Forms.DragEventArgs e)
        {
            DebugOutput("TreeView_DragDrop() - IsLinux: " + IsLinux) ;

            // set the backgroundcolor of the node under mouse to white again
            if (darkNode != null)
            {
                darkNode.BackColor = treeView.BackColor ;
            }

            Point p = treeView.PointToClient(new Point(e.X, e.Y)) ;
            DirectoryNode node = (DirectoryNode)treeView.GetNodeAt(p) ;
            if (node == null)
            {
                return ;
            }

            if (e.Data.GetDataPresent(DataFormats.Text))
            {
                if (e.Data.GetData(DataFormats.Text).ToString().Equals("LTOOLScopy"))
                {   // the text is dropped from LTools
                    DebugOutput("source: " + e.Data.GetData(DataFormats.Text).ToString()) ;
                    
                    DebugOutput("destination: " + GetPathFromNode(node)) ;

                    if (IsLinux && (node != null))
                    {
                        DebugOutput("GetPathFromNode(node): " + GetPathFromNode(node)) ;
                        // DebugOutput("node.Path: " + node.Path) ;
                        PasteToLinux(GetPathFromNode(node), true) ;
                    }
                    else if (!IsLinux && (node != null))
                    {
                        DebugOutput("GetPathFromNode(node): " + GetPathFromNode(node)) ;
                        //DebugOutput("node.Path: " + node.Path) ;
                        PasteToDos(GetPathFromNode(node), true) ;
                    }
                }
                else
                {
                    MessageBox.Show("Unknown Data Format", "LTOOLS") ;
                }
            }            
            else if (e.Data.GetDataPresent(DataFormats.FileDrop))
            {
                ArrayList okFilePaths = new ArrayList() ;
                ArrayList okFileNames = new ArrayList() ;
                ArrayList badFilePaths = new ArrayList() ;

                DebugOutput("source: " + e.Data.GetData(DataFormats.FileDrop).ToString()) ;
                string[] strArray = (string[]) e.Data.GetData(DataFormats.FileDrop) ;
                // check if the files exist
                // if it's a directory then ask if the other files will be copied
                string bad = "" ;
                for (int i=0; i < strArray.Length; i++)
                {
                    if (Directory.Exists(strArray[i]))
                    {
                        badFilePaths.Add(strArray[i]) ;
                        bad += strArray[i] + "\n" ;
                    }
                    else if (File.Exists(strArray[i]))
                    {
                        okFilePaths.Add(strArray[i]) ;
                        okFileNames.Add((new FileInfo(strArray[i])).Name) ;
                    }
                    else
                    {
                        badFilePaths.Add(strArray[i]) ;
                        bad += strArray[i] + "\n" ;
                    }
                }
                
                if (badFilePaths.Count > 0)
                {
                    if (okFilePaths.Count > 0)
                    {
                        if (MessageBox.Show("Following Files cannot be copied:\n" + bad +
                            "\nShould I copy the rest of the files?", "LTOOLS",
                            MessageBoxButtons.YesNo, MessageBoxIcon.Warning) 
                            == DialogResult.No)
                        {
                            return ;
                        }
                    }
                    else
                    {
                        MessageBox.Show("All the Files cannot be copied because they don't exist or they are directories:\n" + bad, "LTOOLS") ;
                        return ;
                    }
                }
                LTOOLSnet.SetCopyFilePath(okFilePaths, okFileNames, false) ;
                if (IsLinux)
                {
                    PasteToLinux(GetPathFromNode(node), true) ;
                }
                else
                {
                    PasteToDos(GetPathFromNode(node), true) ;
                }
                DebugOutput("destination: " + GetPathFromNode(node)) ;
            }
        }

        /// <summary>
        /// Occurs when the mouse drags an item and is moving over the client area of this Control.
        /// the TreeView_DragOver() method changes the color of the TreeNode under the mouse to show
        /// which directory is selceted to drop the file(s).
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void TreeView_DragOver(object sender, System.Windows.Forms.DragEventArgs e)
        {
            Point p = treeView.PointToClient(new Point(e.X, e.Y)) ;
            // Point p = new Point(e.X, e.Y) ;
            DirectoryNode node = (DirectoryNode)treeView.GetNodeAt(p) ;

            if (node != darkNode)
            {
                if (darkNode != null)
                {
                    treeView.BeginUpdate() ;
                    darkNode.BackColor = treeView.BackColor ;
                    treeView.EndUpdate() ;
                }
            }
            // DebugOutput("TreeView_DragOver() --- X: " + e.X + " - Y: " + e.Y) ;
            try
            {
                treeView.BeginUpdate() ;
                if (node != null)
                {
                    // DebugOutput("node.ToString(): " + node.ToString()) ;
                    // treeView.BackColor = Color.White ;
                    darkNode = node ;
                    node.BackColor = Color.CornflowerBlue ;
                }
                // node.BackColor = Color.White ;
                treeView.EndUpdate() ;
            }
            catch (Exception ex)
            {
                DebugOutput(ex.Message) ;
            }
        }

        /// <summary>
        /// Occurs when a mouse button is released.
        /// the TreeView_MouseUp() method shows a contextmenu. If the the mouse is released over a TreeNode
        /// another contextmenu is shown than over a free space of the treeView.
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void TreeView_MouseUp(object sender, System.Windows.Forms.MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                // select the node under mouse
                treeView.SelectedNode = treeView.GetNodeAt(e.X, e.Y) ;
                // show contextmenu on the selected node
                if (treeView.GetNodeAt(e.X, e.Y) != null)
                {
                    string fullPath = treeView.SelectedNode.FullPath ;
                    string drive = "" ;
                    if (IsLinux)
                    {
                        drive = GetLinuxDrive(fullPath) ;
                    }
                    else
                    {
                        drive = fullPath.Substring(0, fullPath.IndexOf("\\")) ;						
                    }
                    menuItemTreeViewNodeRemove.Text = "Remove Drive " + drive ;
                    contextMenuTreeViewNode.Show(treeView, new Point(e.X, e.Y)) ;
                }
                else
                {
                    contextMenuTreeView.Show(treeView, new Point(e.X, e.Y)) ;
                }
            }
            treeView.SelectedNode = (TreeNode)lastSelectedNode ;
        }
		/// <summary>
		/// Occurs when a node has been collapsed.
		/// </summary>
		/// <param name="sender">sender object</param>
		/// <param name="e">event data</param>
		private void TreeView_AfterCollapse(object sender, System.Windows.Forms.TreeViewEventArgs e)
		{
			// DebugOutput("TreeView_AfterCollapse()") ;
		}
        /// <summary>
        /// Occurs when the mouse remains stationary inside of the treeView for an amount of time.
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void TreeView_MouseHover(object sender, System.EventArgs e)
        {
            // DebugOutput("TreeView_MouseHover()") ;
        }
        /// <summary>
        /// Occurs when a mouse button is pressed.
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void TreeView_MouseDown(object sender, System.Windows.Forms.MouseEventArgs e)
        {
            // DebugOutput("TreeView_MouseDown()") ;
        }
        
        /// <summary>
        /// Occurs when the mouse drags an item. The system requests that the control provide feedback to that effect.
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void TreeView_GiveFeedback(object sender, System.Windows.Forms.GiveFeedbackEventArgs e)
        {
            // DebugOutput("TreeView_GiveFeedback()") ;
        }
        #endregion

        #region Contextmenu TreeView
        /// <summary>
        /// the MenuItemTreeViewCollapseAll_Click() method selects the topNode of the treeView and collapses
        /// all the TreeNodes.
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void MenuItemTreeViewCollapseAll_Click(object sender, System.EventArgs e)
        {
            treeView.CollapseAll() ;
			if (IsLinux)
			{
				treeView.SelectedNode = treeView.TopNode ;
			}
			else
			{
				TreeViewSelectDOSDrive() ;
			}
        }
        /// <summary>
        /// the MenuItemTreeViewRefresh_Click() method clears the treeView and builds up the treeView again
        /// like on the start of the application. If there are any drives added to the treeView, they will be
        /// lost and have to be added again.
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void MenuItemTreeViewRefresh_Click(object sender, System.EventArgs e)
        {
            if (IsLinux)
            {
                FillLinuxDirectoryTree() ;
            }
            else
            {
                FillDosDirectoryTree() ;
            }
        }
        /// <summary>
        /// the MenuItemTreeViewAddDrive_Click() method shows a dialog to specify a drive and a directory
        /// which will be added to the treeView.
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        public void MenuItemTreeViewAddDrive_Click(object sender, System.EventArgs e)
        {
            DebugOutput("MenuItemTreeViewAddDrive_Click()") ;
            AddDriveDialog dialog = new AddDriveDialog(IsLinux) ; // IsLinux
            DialogResult result = dialog.ShowDialog() ;

            if (result != DialogResult.OK)
            {
                DebugOutput("dialog.result: " + result.ToString()) ;
                return ;
            }
            DebugOutput("Device: " + dialog.Device + " -- Directory: " + dialog.Directory) ;

            if (IsLinux)
            {
                string nodeText = dialog.Device + " " + dialog.Directory ; // "/" ;
                // the node has to end with an "/"
                if(!nodeText.EndsWith(LinuxDirectorySeparatorChar.ToString()))
                {
                    nodeText += LinuxDirectorySeparatorChar.ToString() ;
                }
                DirectoryNode cRoot = new DirectoryNode(nodeText) ;
                treeView.BeginUpdate() ;
		treeView.Nodes.Add(cRoot) ;
		if (AddLinuxDirectories(cRoot, true)==false)
		{   treeView.Nodes.Remove(cRoot);
		} 
		else
		{   treeView.SelectedNode = cRoot ;
		}
		treeView.EndUpdate() ;
            }
            else
            {
                string nodeText = dialog.Device + dialog.Directory ;
                DirectoryNode cRoot = new DirectoryNode(nodeText) ;
                treeView.BeginUpdate() ;
				treeView.Nodes.Add(cRoot) ;
                AddDosDirectories(cRoot) ;
		treeView.SelectedNode = cRoot ;
                treeView.EndUpdate() ;
            }
        }
        #endregion

        #region Contextmenu TreeViewNode
        /// <summary>
        /// the MenuItemTreeViewNodeExpand_Click() method expands the selected node if it's possible.
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void MenuItemTreeViewNodeExpand_Click(object sender, System.EventArgs e)
        {
            if (treeView.SelectedNode != null)
            {
                treeView.SelectedNode.Expand() ;
            }
        }
        /// <summary>
        /// the MenuItemTreeViewNodeCollapse_Click() method collapses the selected node if it's possible.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void MenuItemTreeViewNodeCollapse_Click(object sender, System.EventArgs e)
        {
            if (treeView.SelectedNode != null)
            {
                treeView.SelectedNode.Collapse() ;
            }
        }
        /// <summary>
        /// the MenuItemTreeViewNodeRemove_Click() method removes the drive of the selected DirectoryNode.
        /// If a DirectoryNode like "C:\temp\test\debug" is selected, this method will remove the full path
        /// of the "C:" drive.
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void MenuItemTreeViewNodeRemove_Click(object sender, System.EventArgs e)
        {
            DirectoryNode tempNode = (DirectoryNode)treeView.SelectedNode ;
            while (tempNode.Parent != null)
            {
                tempNode = (DirectoryNode)treeView.SelectedNode.Parent ;
                treeView.SelectedNode = tempNode ;
            }
            DebugOutput("remove Drive: " + tempNode.Text);
			treeView.BeginUpdate() ;
            treeView.SelectedNode.Remove() ;
			treeView.EndUpdate() ;
			listView.BeginUpdate() ;
			listView.Items.Clear() ;
			listView.EndUpdate() ;
			labelDirectory.Text = "Directory: " ;
        }
        /// <summary>
        /// -------------
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void MenuItemTreeViewNodeNew_Click(object sender, System.EventArgs e)
        {
            DebugOutput("MenuItemTreeViewNodeNew_Click") ;        
        }

        /// <summary>
        /// -------------
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void MenuItemTreeViewNodeModify_Click(object sender, System.EventArgs e)
        {
            DebugOutput("MenuItemTreeViewNodeModify_Click") ;
        }

        /// <summary>
        /// -------------
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void MenuItemTreeViewNodePaste_Click(object sender, System.EventArgs e)
        {
            DebugOutput("MenuItemTreeViewNodePaste_Click") ;        
        }
        #endregion

        #region ListView Event-Handler
        /// <summary>
        /// the ListView_DoubleClick() method examines the double-clicked item, if it's an error-message,
        /// the parent directory(".."), a child directory or an ordinary file. If the item is an error, this
        /// method just returns, doing nothing. If the item is a directory this method changes the directory
        /// in the treeView and if it's file it starts an application with the double-clicked item.
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void ListView_DoubleClick(object sender, System.EventArgs e)
        {
            if (isLinux)
            {
                try
                {
                    ListView tempView = sender as ListView ; 
                    ListViewItemFile item = (ListViewItemFile) tempView.SelectedItems[0] ;
                    if (item.IsError)
                    {
                        return ;
                    }
                    if (tempView.SelectedIndices.Count > 0)
                    {
                        if (item.IsDirectory)                   // it's a directory, change selected Node in TreeView
                        {
                            DebugOutput("ListView_DoubleClick() - isLinux: " + isLinux + 
                                ". Change Directory in TreeView to " + item.Text + " - (" + item.FullFilePath + ")") ;
							ChangeDirectoryInTreeView(item.Text) ;
                        }
                        else                                    // start an application with this file
                        {
                            StartLinuxApplication(item, true) ;
                        }
                    }
                }
                catch (Exception ex)
                {
                    DebugOutput(MyDebug.SeparatorLine + "ListView_DoubleClick\r\n" + ex.Message + MyDebug.SeparatorLine) ;
                }
            }
            else                                                // it'a DOS ListView
            {
                try
                {
                    ListView tempView = sender as ListView ;
                    if (tempView.SelectedIndices.Count > 0)
                    {
                        ListViewItemFile item = (ListViewItemFile) tempView.SelectedItems[0] ;
                        
                        if (item.IsDirectory)                   // it's a directory, change selected Node in TreeView
                        {
                            DebugOutput("ListView_DoubleClick() - isLinux: " + isLinux + ". Change Directory in TreeView to " + item.Text) ;
							ChangeDirectoryInTreeView(item.Text) ;
                        }
                        else                                    // it's a file, run program, which linked with filetype
                        {
                            StartDosApplication(item, true) ;
                        }
                    }
                }
                catch (Exception ex)
                {
                    DebugOutput(MyDebug.SeparatorLine + "ListView_DoubleClick\r\n" + ex.Message + MyDebug.SeparatorLine) ;
                }
            }
        }

        /// <summary>
        /// the ListView_MouseUp() method shows a contextmenu. If a ListViewItem is selected a contextmenu is shown
        /// with menuitems to copy/delete/modify this item. If a free space is clicked in the listView a contextmenu
        /// is shown where you can paste files or insert a new directory or you can change the ViewStyle of the 
        /// listView (small/large icons, details or list).
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void ListView_MouseUp(object sender, System.Windows.Forms.MouseEventArgs e)
        {
            try
            {
                if (e.Button == MouseButtons.Right)
                {
                    ListView tempView = sender as ListView ;
                    if (tempView.SelectedItems.Count == 0)
                    {
                        menuItemListViewDetails.Checked   = (listView.View == View.Details)   ? true : false ;
                        menuItemListViewLargeIcon.Checked = (listView.View == View.LargeIcon) ? true : false ;
                        menuItemListViewSmallIcon.Checked = (listView.View == View.SmallIcon) ? true : false ;
                        menuItemListViewList.Checked      = (listView.View == View.List)      ? true : false ;
                        contextMenuListView.Show(listView, new Point(e.X, e.Y)) ;
                    }
                    else
                    {
                        if (isLinux)
                        {
                            ListView.SelectedListViewItemCollection col = GetSelectedListViewItemFile() ;
                            foreach (ListViewItemFile item in col)
                            {
                                if (item.IsError)
                                {
                                    return ;
                                }
                            }
                            contextMenuListViewItem.Show(listView, new Point(e.X, e.Y)) ;
                        }
                        else
                        {
                            contextMenuListViewItem.Show(listView, new Point(e.X, e.Y)) ;
                        }
                    }
                }                                               // end: if (e.Button == MouseButtons.Right)
            }
            catch (Exception ex)
            {
                DebugOutput("listView_MouseUP - catch\r\n" + ex.Message) ;
            }        
        }

        /// <summary>
        /// the ListView_MouseMove() method starts a drag&drop event if the left mousebutton is pressed
        /// and the mouse is moved away from the selected listViewItem(s)
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void ListView_MouseMove(object sender, System.Windows.Forms.MouseEventArgs e)
        {
            if (e.Button != MouseButtons.Left)
            {
                return ;
            }
            int abstand = 1 ;
            if (e.X > mouseX + abstand || e.Y > mouseY + abstand || 
                e.X < mouseX - abstand || e.Y < mouseY -abstand)
            {
                int anzahl = ((ListView)sender).SelectedItems.Count ;
                ArrayList fullPath = new ArrayList() ;
                ArrayList fileName = new ArrayList() ;
                for (int i=0 ; i < anzahl; i++)
                {
                    if (((ListViewItemFile)((ListView)sender).SelectedItems[i]).IsDirectory)
                    {
                        MessageBox.Show("Sorry, cannot drag directories.", "LTOOLS", 
                            MessageBoxButtons.OK, MessageBoxIcon.Error) ;
                        return ;
                    }
                    else if (((ListViewItemFile)((ListView)sender).SelectedItems[i]).IsLink) // it's a link
                    {
                        string itemFullPath = ((ListViewItemFile)((ListView)sender).SelectedItems[i]).FullFilePath ;
                        fullPath.Add(GetLinuxDrive(itemFullPath) + " " + GetFilePathFromLink(itemFullPath)) ;
                        fileName.Add(GetFileNameFromLink(((ListViewItemFile)((ListView)sender).SelectedItems[i]).FileName)) ;
                    }
                    else if (((ListViewItemFile)((ListView)sender).SelectedItems[i]).IsError) // it's an error message
                    {
                        return ;
                    }
                    else
                    {
                        fullPath.Add(((ListViewItemFile)((ListView)sender).SelectedItems[i]).FullFilePath) ;
                        fileName.Add(((ListViewItemFile)((ListView)sender).SelectedItems[i]).FileName) ;
                    }
                }
                // set the copyArrayLists in LTOOLSnet
                // there are only files in this ArrayList directories won't be copied.
                LTOOLSnet.SetCopyFilePath(fullPath, fileName, IsLinux) ;
                listView.DoDragDrop("LTOOLScopy", DragDropEffects.Copy) ;
            }
        }

        /// <summary>
        /// the ListView_MouseDown() method sets the variables mouseX/Y to check if the mouse if moved
        /// away from a selected ListViewItem to start a drag&drop event.
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void ListView_MouseDown(object sender, System.Windows.Forms.MouseEventArgs e)
        {
            mouseX = e.X ;
            mouseY = e.Y ;
        }

        /// <summary>
        /// the ListView_DragDrop() drops selected ListViewItems from the other listView or files from
        /// the WindowsExplorer in the listView under the mouse. If the files are selected and dropped
        /// in the same listView the DragDrop-event ends without doing something.
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void ListView_DragDrop(object sender, System.Windows.Forms.DragEventArgs e)
        {
            DebugOutput("ListView_DragDrop(): ") ;
/*
            if (sender == this.ActiveControl)
            {
                return ;
            }
*/
            if (e.Data.GetDataPresent(DataFormats.Text))
            {
                if (e.Data.GetData(DataFormats.Text).ToString().Equals("LTOOLScopy"))   // text is dropped from LTools
                {
                    DebugOutput("source: " + e.Data.GetData(DataFormats.Text).ToString()) ;
                    DebugOutput("destination: " + GetPathFromNode(GetSelectedDirectoryNode())) ;

                    if (IsLinux && (this.GetSelectedDirectoryNode() != null))
                    {
                        PasteToLinux((this.GetSelectedDirectoryNode()).Path, true) ;
                    }
                    else if (!IsLinux && (this.GetSelectedDirectoryNode() != null))
                    {
                        PasteToDos((this.GetSelectedDirectoryNode()).Path, true) ;
                    }
                }
                else
                {
                    MessageBox.Show("Unknown Data Format", "LTOOLS") ;
                }
            }
            else if (e.Data.GetDataPresent(DataFormats.FileDrop))
            {
                ArrayList okFilePaths = new ArrayList() ;
                ArrayList okFileNames = new ArrayList() ;
                ArrayList badFilePaths = new ArrayList() ;

                DebugOutput("source: " + e.Data.GetData(DataFormats.FileDrop).ToString()) ;
                string[] strArray = (string[]) e.Data.GetData(DataFormats.FileDrop) ;
                // check if the files exist
                // if it's a directory then ask if the other files will be copied
                string bad = "" ;
                for (int i=0; i < strArray.Length; i++)
                {
                    if (Directory.Exists(strArray[i]))
                    {
                        badFilePaths.Add(strArray[i]) ;
                        bad += strArray[i] + "\n" ;
                    }
                    else if (File.Exists(strArray[i]))
                    {
                        okFilePaths.Add(strArray[i]) ;
                        okFileNames.Add((new FileInfo(strArray[i])).Name) ;
                    }
                    else
                    {
                        badFilePaths.Add(strArray[i]) ;
                        bad += strArray[i] + "\n" ;
                    }
                }
                
                if (badFilePaths.Count > 0)
                {
                    if (okFilePaths.Count > 0)
                    {
                        if (MessageBox.Show("Following Files cannot be copied:\n" + bad +
                            "\nShould I copy the rest of the files?", "LTOOLS",
                            MessageBoxButtons.YesNo, MessageBoxIcon.Warning) 
                            == DialogResult.No)
                        {
                            return ;
                        }
                    }
                    else
                    {
                        MessageBox.Show("All the Files cannot be copied because they don't exist or they are directories:\n" + bad, "LTOOLS") ;
                        return ;
                    }
                }
                LTOOLSnet.SetCopyFilePath(okFilePaths, okFileNames, false) ;
                if (IsLinux)
                {
                    PasteToLinux((this.GetSelectedDirectoryNode()).Path, true) ;
                }
                else
                {
                    PasteToDos((this.GetSelectedDirectoryNode()).Path, true) ;
                }
                DebugOutput("destination: " + GetPathFromNode(GetSelectedDirectoryNode())) ;
            }
        }

        /// <summary>
        /// Occurs when the mouse drag an item into the client area for this Control.
        /// the ListView_DragEnter() method sets the DragDropEffects for the Drag&Drop event.
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void ListView_DragEnter(object sender, System.Windows.Forms.DragEventArgs e)
        {
            DebugOutput("ListView_DragEnter() - IsLinux: " + IsLinux) ;
            // this.ActiveControl = listView ;

            if (e.Data.GetDataPresent(DataFormats.Text))
            {
                e.Effect = DragDropEffects.Copy ;
                DebugOutput("DataFormats.Text") ;
            }
            else if (e.Data.GetDataPresent(DataFormats.FileDrop))
            {
                e.Effect = DragDropEffects.Copy ;
                DebugOutput("DataFormats.FileDrop") ;
            }
            else
            {
                e.Effect = DragDropEffects.None ;
                DebugOutput("DataFormats ?") ;
            }            
        }
        /// <summary>
        /// the ListView_KeyUp() method handles the Key-events in the listView. 
        /// * CONTROL+A selects all files in the active listView
        /// * F5 refreshes the listView
        /// * Del-Key deletes the selected ListViewItems in the listView
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        public void ListView_KeyUp(object sender, System.Windows.Forms.KeyEventArgs e)
        {
			DebugOutput("ListView_KeyUp()") ;
            // DebugOutput("Control: " + e.Control.ToString()) ;
            if (e.Control && e.KeyCode == Keys.A)
            {
                // select all items in the listView
                //DebugOutput("Control + A") ;
                ListView.ListViewItemCollection items = listView.Items;
                foreach (ListViewItem item in items)
                {
                    item.Selected = true ;
                }
            }
            else if (e.KeyCode == Keys.Delete)
            {
				LTOOLSnet.MyProg.ListViewItemFilesDelete() ;
            }
            else if (e.KeyCode == Keys.F5)
            {
                DebugOutput("F5 pressed - refresh the ListView, IsLinux: " + IsLinux) ;
                if (IsLinux)
                {
                    UpdateLinuxListView(GetSelectedDirectoryNode()) ;
                }
                else
                {
                    UpdateDosListView(GetSelectedDirectoryNode()) ;
                }
            }
            else if (e.KeyCode == Keys.Return)
            {
                DebugOutput("Return pressed - start an application, IsLinux: " + IsLinux) ;
                try
                {
                    ListView.SelectedListViewItemCollection items = GetSelectedListViewItemFile() ;
                    ListViewItemFile item ;
                    if (items.Count == 1)
                    {
                        item = (ListViewItemFile) items[0] ;
                        if (item.IsDirectory)
                        {
							ChangeDirectoryInTreeView(item.Text) ;
                        }
                        else
                        {
                            if (IsLinux)
                            {
                                StartLinuxApplication(item, true) ;
                            }
                            else
                            {
                                StartDosApplication(item, true) ;
                            }
                        }
                    }
                    else
                    {
                        MessageBox.Show("Select just one file to start an application, please.", "LTOOLS", MessageBoxButtons.OK, MessageBoxIcon.Information) ;
                    }
                }
                catch (Exception ex)
                {
                    DebugOutput("Exception: " + ex.Message) ;
                }
            }
        }

        /// <summary>
        /// the ListView_BeforeLabelEdit() method checks the selected ListViewItem before modifying the textlabel
        /// it it's a parent directory(".."), a symbolic link or an error message. This types of ListViewItems
        /// cannot be renamed in the ListView.
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void ListView_BeforeLabelEdit(object sender, System.Windows.Forms.LabelEditEventArgs e)
        {
			try
			{
				ListViewItemFile item = ((ListViewItemFile)((ListView)sender).SelectedItems[0]) ; 
				// cancel edit, if it's a ParentFolder (".."), a Link or an error message
				if (item.Text.Equals("..") || item.IsLink || item.IsError)
				{
					e.CancelEdit = true ;
				}
			}
			catch (Exception ex)
			{
				DebugOutput(ex.Message) ;
			}
        }

        /// <summary>
        /// the ListView_AfterLabelEdit() method renames the file(ListViewItem) if the label of the ListViewItem
        /// has changed.
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void ListView_AfterLabelEdit(object sender, System.Windows.Forms.LabelEditEventArgs e)
        {
			try
			{
				// after LabelEdit the file has to be renamed
				// first check if the name was changed
				bool updateFlag = false ;
				DebugOutput("ListView_AfterLabelEdit()") ;
				ListViewItemFile item = ((ListViewItemFile)((ListView)sender).SelectedItems[0]) ; 
            
				if (e.Label == null || 
					e.Label.Equals("") || 
					(e.Label.IndexOf(LinuxDirectorySeparatorChar.ToString()) > 0))
				{
					// e.Label is a null-reference, when the input is 
					// canceled with <esc>
					e.CancelEdit = true ;
					item.Text = item.FileName ;
					return ;
				}

				string source = item.FullFilePath ;
				string destination = item.Directory ;
				if (IsLinux)                                    // Linux-listView
				{
					if (LTOOLSnet.IsLinuxReadOnly)
					{
						e.CancelEdit = true ;
						// item.Text = item.FileName ;
						DebugOutput("LinuxIsReadOnly") ;
						MessageBox.Show("Your Linux filesystem is set to read only - change in menu 'File - Linux read only' first",
							"LTOOLS", MessageBoxButtons.OK, MessageBoxIcon.Warning) ;
					}
					else
					{
						if (!item.FileName.Equals(e.Label))
						{
							updateFlag = true ;
							if (!destination.EndsWith(LinuxDirectorySeparatorChar.ToString()))
							{
								destination = destination + LinuxDirectorySeparatorChar.ToString() + e.Label ;
							}
							else
							{
								destination = destination + e.Label ;
							}
							string command = "ldirNT " ;
							string args = "-WRITE " ;
							args = args + "-ren " ;
							
							if (LTOOLSnet.Connected)
							{
							    args = args + "-x " ;
							} else
							{   args = args + "-q " ;
							}
							args = args + "-s" ;
							args = args + item.FullFilePath ;
							args = args + " \"" + e.Label + "\"" ;
                    
							DebugOutput("ListView_AfterLabelEdit(): " + command + args) ;
                    
							LDir ldir = new LDir(command, args) ;
							DebugOutput(ldir.Response) ;

							if (ldir.Response.Length > 0)
							{
								//if LTOOLS's command line tool issues an error message, 
								// show first line of response in message box
								MessageBox.Show(ldir.Response, "LTOOLS", 
									MessageBoxButtons.OK, MessageBoxIcon.Error) ;
								// return ;
							}
						}
					}
				}
				else                                            // DOS-listView
				{
					if (!item.FileName.Equals(e.Label))
					{
						updateFlag = true ;
						if (!destination.EndsWith(Path.DirectorySeparatorChar.ToString()))
						{
							destination = destination + Path.DirectorySeparatorChar.ToString() + e.Label ;
						}
						else
						{
							destination = destination + e.Label ;
						}
						DebugOutput("IsLinux:" + IsLinux + " - source: " + source + " - destination:" + destination) ;
						if (item.IsDirectory)
						{
							Directory.Move(item.FullFilePath, destination) ;
						}
						else
						{
							File.Move(item.FullFilePath, destination) ;
						}
					}
				}
				if (updateFlag)
				{
					this.UpdateNode(this.GetSelectedDirectoryNode()) ;
				}
			}
			catch (Exception ex)
			{
				DebugOutput(ex.Message) ;
			}
        }

        /// <summary>
        /// the ListView_ColumnClick() sorts the files in the ListView in opposite order.
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void ListView_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
        {
            // e.Column.ToString(): returns the index of the Column
            // DebugOutput("ListView_ColumnClick(): " + e.Column.ToString()) ;
			if (e.Column == 0)
			{
				if(sortOrder == SortOrder.Ascending)
				{
					sortOrder = SortOrder.Descending ;
				}
				else
				{
					sortOrder = SortOrder.Ascending ;
				}
				ArrayList items = new ArrayList() ;
				for (int i=0; i < listView.Items.Count; i++)
				{
					items.Add(listView.Items[i]) ;
				}
				// (ListViewItemFile)
				listView.BeginUpdate() ;
				listView.Clear() ;

				ListViewAddColumns() ;                              // adds the columns to the listView

				for (int i=(items.Count-1); i >= 0; i--)
				{
					listView.Items.Add((ListViewItemFile)items[i]) ;
				}
				listView.EndUpdate() ;
			}
        }
        /// <summary>
        /// The full filepath of the file. GetLinuxExtension returns the file extension.
        /// e.g. ".zip" of test.zip
        /// </summary>
        /// <param name="fullpath">full path of a linux-File</param>
        /// <returns>the extension of a file</returns>
        private string GetLinuxExtension(string fullpath)
        {
            // DebugOutput("GetLinuxExtension(): " + fullpath) ;
            int dotIndex = fullpath.LastIndexOf(".") ;
            int linuxPathIndex = fullpath.LastIndexOf(LinuxDirectorySeparatorChar.ToString()) ;
            if (linuxPathIndex > 0 && linuxPathIndex > dotIndex)
            {
                return "" ;
            }
            else 
            {
                return fullpath.Substring(dotIndex) ;
            }
        }
        #endregion

        #region Contextmenu ListView
        /// <summary>
        /// the MenuItemListViewDetails_Click() updates the viewstyle of the listView - Details.
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void MenuItemListViewDetails_Click(object sender, System.EventArgs e)
        {
            UpdateViewStyle(View.Details) ;
        }
        /// <summary>
        /// the MenuItemListViewList_Click() updates the viewstyle of the listView - List.
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void MenuItemListViewList_Click(object sender, System.EventArgs e)
        {
            UpdateViewStyle(View.List) ;
        }
        /// <summary>
        /// the MenuItemListViewLargeIcon_Click() updates the viewstyle of the listView - LargeIcon.
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void MenuItemListViewLargeIcon_Click(object sender, System.EventArgs e)
        {
            UpdateViewStyle(View.LargeIcon) ;
        }
        /// <summary>
        /// the MenuItemListViewSmallIcon_Click() updates the viewstyle of the listView - SmallIcon.
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void MenuItemListViewSmallIcon_Click(object sender, System.EventArgs e)
        {
            UpdateViewStyle(View.SmallIcon) ;
        }
        /// <summary>
        /// the MenuItemListViewNew_Click() method shows a ModifyDosDialog or ModifyLinuxDialog to create
        /// a new directory (or a symbolic Linux link)
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void MenuItemListViewNew_Click(object sender, System.EventArgs e)
        {
            DebugOutput("MenuItemListViewNew_Click") ;
            DirectoryNode tempNode ;
            if ((tempNode = GetSelectedDirectoryNode()) == null)
            {
                MessageBox.Show("Select directory where to add the new directory", "LTOOLS",
                    MessageBoxButtons.OK, MessageBoxIcon.Information) ;
                return ;
            }

            if (IsLinux)
            {
                NewLinuxDirectory(tempNode) ;
            }
            else
            {
                NewDosDirectory(tempNode) ;
            }
        }
        /// <summary>
        /// the MenuItemListViewPaste_Click() method pastes the files in the ArrayLists of the LTOOLSnet-class
        /// in the active listView.
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void MenuItemListViewPaste_Click(object sender, System.EventArgs e)
        {
            DebugOutput("MenuItemListViewPaste_Click()") ;
			LTOOLSnet.MyProg.ListViewItemFilesPaste() ;
        }
        #endregion

        #region Contextmenu ListViewItem
        /// <summary>
        /// the MenuItemListViewItemModify_Click() method shows a ModifyLinuxFile or a ModifyDosFile dialog
        /// to modify the selected file(s).
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void MenuItemListViewItemModify_Click(object sender, System.EventArgs e)
        {
			DebugOutput("MenuItemListViewItemModify_Click()") ;
			LTOOLSnet.MyProg.ListViewItemFilesModify() ;
        }

        /// <summary>
        /// the MenuItemListViewItemDelete_Click() method deletes the selected file(s).
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void MenuItemListViewItemDelete_Click(object sender, System.EventArgs e)
        {
            DebugOutput("MenuItemListViewItemDelete_Click()") ;
			LTOOLSnet.MyProg.ListViewItemFilesDelete() ;
        }

        /// <summary>
        /// the MenuItemListViewItemCopy_Click() saves the selected file(s) in the CopyPase-ArrayLists in the
        /// LTOOLSnet-class to view the files.
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void MenuItemListViewItemCopy_Click(object sender, System.EventArgs e)
        {
            DebugOutput("MenuItemListViewItemCopy_Click()") ;
	    LTOOLSnet.MyProg.ListViewItemFilesCopy() ;
        }
	    
	/// <summary>
	/// the MenuItemListViewItemView_Click() saves the selected file(s) in the CopyPase-ArrayLists in the
	/// LTOOLSnet-class to copy the files.
	/// </summary>
	/// <param name="sender">sender object</param>
	/// <param name="e">event data</param>
	private void MenuItemListViewItemView_Click(object sender, System.EventArgs e)
	{
	    DebugOutput("MenuItemListViewItemView_Click()") ;
	    LTOOLSnet.MyProg.ListViewItemFilesView() ;
	}

	#endregion

        #region TreeView
        /// <summary>
        /// Returns the directory path of the node.
        /// e.g. Linux: /dev/hda6 /temp/test/
        /// or Dos    : C:\temp\test
        /// </summary>
        /// <param name="node">The DirectoryNode to get the path from.</param>
        /// <returns>Directory path of node.</returns>
        private string GetPathFromNode(TreeNode node) 
        {
            if (node.Parent == null) 
            {
                return node.Text;
            }
            string path = Path.Combine(GetPathFromNode(node.Parent), node.Text);
            if (isLinux)
            {
                // replace the DirectorySeparatorChar
                path.Replace(Path.DirectorySeparatorChar, LinuxDirectorySeparatorChar) ;
                path = path + "/" ;
            }
            // DebugOutput("GetPathFromNode() returns: " + path) ;
            return path ;
        }

        /// <summary>
        /// gets the selected TreeNode in the treeView
        /// </summary>
        /// <returns>the current selected DirectoryNode in the treeView</returns>
        public DirectoryNode GetSelectedDirectoryNode()
        {
            return ((DirectoryNode)treeView.SelectedNode) ;
        }
        /// <summary>
        /// when a file or directory was modified/deleted then this method restores the treeView and the listView 
        /// with the new files/directories.
        /// </summary>
        /// <param name="node">the DirectoryNode to updat</param>
        private void UpdateNode(DirectoryNode node)
        {
            // update this Node and show the updatet version in treeView and listView
            node.Collapse() ;
            node.Nodes.Clear() ;
            node.SubDirectoriesAdded = false ;
            if (IsLinux)
            {
                AddLinuxDirectories(node, true) ;
                node.Expand() ;
                UpdateLinuxListView(node) ;
            }
            else
            {
                AddDosDirectories(node) ;
                node.Expand() ;
                UpdateDosListView(node) ;
            }
        }
        /// <summary>
        /// changes after a doubleClick (or an EnterButton - not yet) the Directory in the treeView
        /// </summary>
        /// <param name="directory">the directory to change to.</param>
        private void ChangeDirectoryInTreeView(string directory)
        {
            DebugOutput("ChangeDirectoryInTreeView() to " + directory) ;
            // die Auswahl des Indexes in TreeView ber den selektierten Index in ListView hat
            // bei DRIVE_REMOVABLE nicht funktioniert, da die Verzeichnisse in ListView komischerweise in
            // einer anderen Reihenfolge als in der TreeView angezeigt werden:
            // treeView.SelectedNode = treeView.SelectedNode.Nodes[listView.SelectedIndices[0]] ;
            // deshalb, wird das Verzeichnis in TreeView mit dem ausgewhlten Verzeichnis in ListView
            // verglichen und dann ausgewhlt:
			if (directory.Equals(".."))
			{
				if (treeView.SelectedNode.Parent != null)
				{
					treeView.SelectedNode = treeView.SelectedNode.Parent ;
				}
			}
			else
			{
				int index = 0 ;
				for (int i=0; i < treeView.SelectedNode.Nodes.Count; i++)
				{
					if (treeView.SelectedNode.Nodes[i].Text == directory)
					{
						index = i ;
					}
				}
				treeView.SelectedNode = treeView.SelectedNode.Nodes[index] ;
			}
        }
        /// <summary>
        /// the GetBackColorTreeView() method returns the BackColor-property of the treeView.
        /// (it's used to set the BackColor of the linuxFilePanel if the connection to the 
        /// remote server is lost.)
        /// </summary>
        /// <returns>the BackColor of the treeView</returns>
        public Color GetBackColorTreeView()
        {
            return treeView.BackColor ;
        }
        #endregion

        #region ListView
        /// <summary>
        /// changes the viewStyle of the listView (detail, large icon, ...)
        /// </summary>
        /// <param name="icon">the new style of the listView</param>
        public void UpdateViewStyle(View icon)
        {
            this.ViewListView = icon ;
            listView.View = this.ViewListView ;
        }
        /// <summary>
        /// returns the current selcted ListViewItemFile(s) in the ListView or null
        /// </summary>
        /// <returns>a collection with all selected items in the listView</returns>
        public ListView.SelectedListViewItemCollection GetSelectedListViewItemFile()
        {
            if (listView.SelectedIndices.Count > 0)
            {
                return listView.SelectedItems ;
            }
            return null ;
        }
        /// <summary>
        /// the ListViewAddColumns() method adds the necessary columns in the listView.
        /// </summary>
        private void ListViewAddColumns()
        {
            listView.Columns.Add(columnHeaderName) ;
            listView.Columns.Add(columnHeaderSize) ;
            listView.Columns.Add(columnHeaderTyp) ;
            listView.Columns.Add(columnHeaderLastModified) ;
			if (IsLinux)
			{
				listView.Columns.Add(columnHeaderInformation) ;
				listView.Columns.Add(columnHeaderUserID) ;
				listView.Columns.Add(columnHeaderGroupID) ;
			}
        }
		/// <summary>
		/// the InsertListViewItems() method inserts the directories and files from the UpdateDosListView() and
		/// the UpdateLinuxListView() in the listView.
		/// </summary>
		/// <param name="directories">ArrayList(ListViewItemFile) with all directories in the selected 
		/// Directory in treeView</param>
		/// <param name="files">ArrayList(ListViewItemFile) with all files in the selected Directory 
		/// in treeView</param>
		private void InsertListViewItems(string ldirPath, ArrayList directories, ArrayList files)
		{
			try
			{
				listView.Clear() ;                              // first clear the ListView
				listView.View = viewListView ;                  // set the ViewStyle of the ListView
				ListViewAddColumns() ;                          // adds the columns to the listView
				directories.Sort() ;							// sort the directories alphabetical
				files.Sort() ;									// sort the files alphabetical

				if (sortOrder == SortOrder.Ascending)           // first parent, then directories and then files
				{
					// Add ListViewItems to the ListView
					if (treeView.SelectedNode.Parent != null)
					{
						// add an item with "..", that you can change to the parent-directory
						ListViewItemFile itemParent = new ListViewItemFile("..", IndexIconFolderUp, true);
						itemParent.FileName = ".." ;
						itemParent.Directory = ldirPath ;
						itemParent.FullFilePath = ldirPath ;
						listView.Items.Add(itemParent);
					}
					foreach(ListViewItemFile dir in directories)
					{
						listView.Items.Add(dir);
					}
					foreach(ListViewItemFile file in files)
					{
						listView.Items.Add(file);                    
					}
				}
				else if (sortOrder == SortOrder.Descending)     // first files, then directories and parent
				{	// Add ListViewItems to the ListView
					for (int i = (files.Count-1); i >= 0; i--)
					{
						ListViewItemFile file = (ListViewItemFile)files[i] ;
						listView.Items.Add(file);                    
					}
					for (int i = (directories.Count-1); i >= 0; i--)
					{
						ListViewItemFile dir = (ListViewItemFile)directories[i] ;
						listView.Items.Add(dir);
					}
					if (treeView.SelectedNode.Parent != null)	// add "..", that you can change to parent-directory
					{
						ListViewItemFile itemParent = new ListViewItemFile("..", IndexIconFolderUp, true);
						itemParent.FileName = ".." ;
						itemParent.Directory = ldirPath ;
						itemParent.FullFilePath = ldirPath ;
						listView.Items.Add(itemParent);
					}
				}
			}
			catch (Exception ex)
			{
				DebugOutput(MyDebug.SeparatorLine + "updateListView() Exception - isLinux: " +
					isLinux + "\r\n" + ex.Message + MyDebug.SeparatorLine) ;
				listView.Items.Clear() ;
				listView.View = View.Details ;
				listView.Items.Add(ex.Message.Replace("\r\n", " ")) ;
			}
		}
        #endregion

        #region Remote Connection
        /// <summary>
        /// the GetFileFromHost() method reads a file from the remote server and writes this file
        /// in the "temp"-directory under the directory where the application is installed.
        /// </summary>
        /// <param name="fileName">the file to get from Host</param>
        private void GetFileFromHost(string fileName)
        {
            DebugOutput ("GetFileFromHost: " + fileName) ;

            string temp = "";
            int bytesRead = 0, bytesToRead, i ;
            byte[] buffer = new byte[LTOOLSnet.BUFSIZE];
            
            try
            {
                temp = "SENDFILE" + "\n";
                Encoding ASCII = Encoding.ASCII ;
                Byte[] byteTemp = ASCII.GetBytes(temp);
                LTOOLSnet.NetSocket.Send(byteTemp, byteTemp.Length, SocketFlags.None) ;
                DebugOutput("GetFileFromHost(): send-ok") ;

                i = LTOOLSnet.NetSocket.Receive(buffer, buffer.Length, 0);

                string received = ASCII.GetString(buffer, 0, i);
                bytesToRead = Int32.Parse(received) ;

                // strRetPage = strRetPage + ASCII.GetString(RecvBytes, 0, bytes);
                DebugOutput("Receive1-ok Bytes: " + i.ToString() + " : --" + received + "--") ;
 
                // Datei remote lesen und in buffer speichern
                FileStream fs = new FileStream(DirFilePanel.tempPathLinuxFiles + @"\" + fileName, FileMode.Create, FileAccess.Write) ;
                bytesRead = 0 ;
                while (bytesRead < bytesToRead)
                {
                    i = LTOOLSnet.NetSocket.Receive(buffer, buffer.Length, 0);
                    DebugOutput("bytesRead: " + bytesRead + " bytesToRead" + bytesToRead + " i:" + i) ;
                    bytesRead = bytesRead + i;
                    // nun buffer in Datei schreiben
                    fs.Write(buffer, 0, i) ;
                }                
                fs.Close() ;
            }
            catch(IOException excpt)
            {
                DebugOutput("Failed I/O " + excpt.Message);
                return;
            }
            catch (Exception excpt)
            {
                DebugOutput("" + excpt.Message) ;
            }
        }

        /// <summary>
        /// the PutFileToHost() writes a file to a remote server.
        /// </summary>
        /// <param name="fileName">the file to put to the remote server</param>
        private void PutFileToHost(string fileName)
        {
            DebugOutput("PutFileToHost(" + fileName + ")") ;
            
            string temp = "" ;
            int bytesRead = 0, i ;
            byte[] buffer = new byte[LTOOLSnet.BUFSIZE] ;

            try
            {
                FileInfo fileInfo = new FileInfo(fileName) ;
                string fileLength = fileInfo.Length.ToString() ;
                FileStream fs = new FileStream(fileName, FileMode.Open, FileAccess.Read) ;
                temp = "RECEIVEFILE\n" + fileLength + "\n" ;
                
                Encoding ASCII = Encoding.ASCII ;
                Byte[] byteTemp = ASCII.GetBytes(temp);

                LTOOLSnet.NetSocket.Send(byteTemp, byteTemp.Length, SocketFlags.None) ;

                do
                {
                    i = fs.Read(buffer, 0, LTOOLSnet.BUFSIZE) ;
                    if (i < 0)
                    {
                        break ;
                    }
                    LTOOLSnet.NetSocket.Send(buffer, i, SocketFlags.None) ;
                    bytesRead = bytesRead + i ;
                } while (i>0) ;
                fs.Close() ;
            }
            catch (Exception e)
            {
                DebugOutput("Exception PutFileToHost(): " + e.Message) ;
            }
        }
        /// <summary>
        /// the SetBackground() sets the color of the listView and the treeView.
        /// </summary>
        /// <param name="col">the new color of the treeView and the listView</param>
        public void SetBackground(Color col)
        {
            treeView.BackColor = col ;
            listView.BackColor = col ;
        }
        #endregion
        
        #region MyDebug Dialog
        /// <summary>
        /// the SetDebugDialog() sets the reference to a MyDebug-dialog
        /// </summary>
        /// <param name="dDialog">a MyDebug-dialog</param>
        public void SetDebugDialog(MyDebug dDialog)
        {
            debugDialog = dDialog ;
        }

        /// <summary>
        /// the DebugOutput() method appends a string to the MyDebug-dialog.
        /// </summary>
        /// <param name="str">the string to append in MyDebug-dialog</param>
        void DebugOutput(string str)
        {
            if (debugDialog != null)
            {
                debugDialog.AppendText(str + "\r\n") ;
            }
        }
        #endregion
        
        #endregion
    }
}
