        page    66,80
        TITLE   LLFCLR 1.3 Clear first track prior to Low Level Format
Comment |
        works with MASM 5.0 and Optasm

R E A D  T H E  D O C U M E N T A T I O N ! ! !

I'm not kidding.  You ABSOLUTELY MUST read the documentation or
you will destroy your hard disk.

See LLFCLR.TXT for details on use.

  USAGE:

Examples:
*********

LLFCLR C:

LLFCLR D:

LLFCLR  will clear the first track of your hard disk.  This will
effectively wipe out all your partitions and any configuration
information stored on your hard disk.  This will effectively
destroy the access to your data.  The only reason to do this is
the get a clean slate for a new low level format.


Register Conventions
********************

Subroutines may trash all registers except those explicity
documented as input or output.


Please report bugs and problems to:

Roedy Green
Canadian Mind Products
#208 - 525 Ninth Street
New Westminster BC Canada
V5H 2N6
tel:(604) 777-1804
mailto:roedy@mindprod.com
http://mindprod.com


Version 1.3 1998 November 8
- embed Barker address

Version 1.2 1996 October 25
- embed POB 707 Quathiaski Cove address

Version 1.1
- embeds new address and phone number

| ; end of comment

;==============================================================


stack   segment stack           ; keep MS link happy by providing null stack
stack   ends

CODE    SEGMENT PARA            ; start off in code.

;==============================================================

data    segment byte            ; provide a separate DATA segment
                                ; actually all come after the code
;==============================================================
;  V A R I A B L E S


BannerMsg       label   byte
        DB      ' LLFCLR 1.3 ۲',13d,10d
        DB 13d,10d
        DB 'Clear first track prior to low level format',13,10
        DB 'Copyright (c) 1990-1999 Roedy Green Canadian Mind Products',13,10
        DB      '#208 - 525 Ninth Street, New Westminster, BC Canada V3M 5T9',13,10
        DB      'tel:(604) 777-1804   mailto:roedy@mindprod.com   http://mindprod.com',13,10
        DB 'May be freely distributed and used for any purpose except military.',13,10
        db 13,10
        DB ' This is an EXTREMELY dangerous utility to use. ',13,10
        DB ' After you use it, all data on your drive will be lost. ',13,10
        DB ' It should only be used just prior to a new low level format. ',13,10
        db 13,10
        db '$'

UsageMsg        DB 13,10
                DB ' Error ۲ ',07,07,07,07,07,07,07,07,13,10
                DB 'Do NOT play with this utility!',13,10
                DB 'Read the LLFCLR.TXT to find how to use it properly.',13,10
                db '$'

ConfirmMsg      Label   Byte
        db      13,10
        db      'Ŀ',13,10
        db      ' Are you sure you REALLY want to wipe out your hard disk? ',13,10
        db      '',13,10
        db      13,10
        db      '$'


WorkedMsg       DB 'First track wiped successfully.',13,10
                db '$'

FailedMsg       DB 'Disk did not respond.',13,10
                db '$'

DriveNo         db      0
                ; C:=2 D:=3

Buffer          dw 0    ; dynamic buffer will grow to 17*512
                        ; it hangs out past the end of the program

data            ends

com     group   code,data       ; force data segment to go at the end!

        ASSUME  CS:com,DS:com,ES:com,SS:com
                                ; seg regs cover everything
        ORG     100H            ; in Code segment

;==========================

Start   proc    far

;       M A I N L I N E   R O U T I N E
        lea     dx,BannerMsg    ; display the banner
        Call    Say
        Call    Parse           ; get drive letter from command line
        Call    Analyze         ; analyse the drive letter
        Call    ConfirmIt       ; One last minute warning
        Call    ClearBuf        ; clear the dynamic buffer
        Call    Wipe            ; wipe out the first track
Done:
        mov     ax,4c00h
        int     21h             ;normal termination

;===============================================================

ConfirmIt       Proc    Near
;       Confirm that ok to proceed with update of boot block
;       If, not jump directly to Abort

        Lea     DX,ConfirmMsg
        Call    Say
        mov     AH,07                   ; read one char, no echo
        int     21h
        cmp     AL,'Y'                  ; is it upper case Y?
                                        ; do not allow lower case y
        JE      Confirmed
        JMP     Trouble                 ; No, Bail out
Confirmed:                              ; Yes, carry on
        RET
ConfirmIt       EndP

;========================================
ClearBuf        proc    near
;       Clear the buffer for the first track
        mov     cx,17*(512/2)   ; words to clear
        lea     di,Buffer
        mov     ax,0
        REP STOSW               ; ES:DI points to buffer
        ret
ClearBuf        EndP

;===============================================================

Wipe    proc    near
;       Wipe out the first track
        mov     ah,03           ; function 3 write

        mov     dl,DriveNo      ; C:=2 D:=3
        add     dl,080h-2       ; 2 -> 80h
        mov     dh,0            ; head 0
        mov     ch,0            ; cyl 0
        mov     cl,1            ; start with sector 1
        mov     al,17d          ; write 17 sectors
        lea     bx,Buffer       ; ES:BX is buffer
        int     13h
        jc      Fail            ; tell user if worked ok or not.
        lea     dx,WorkedMsg
        jmp     SayWorkOrFail
Fail:
        lea     dx,FailedMsg
SayWorkOrFail:
        Call    Say
        ret
Wipe    EndP

;===============================================================

Trouble proc    near
;       Syntax error on the command line

        lea     dx,UsageMsg     ; display usage message
        Call    Say
abort:
                                ; error exit
        mov     ax, 4c04h       ; ERRORLEVEL = 4
        int     21h             ; DIE
Trouble endp

;===============================================================

MLeading        PROC    Near
;       Remove leading blanks
;       on entry BX is addr of string, CX its length
;       trims off any leading blanks, leaving result in BX CX
;       length may also be 0 or 1, but not -ve
;       If the entire string is blank the result is the null string
        mov     di,bx
        mov     al,20H          ; AL = blank  -- the search char
        jcxz    mleading2       ; jump if null string
        repe    scasb           ; scan ES:DI forwards till hit non blank
                                ; DI points just after it (wrap ok)
                                ; cx IS ONE TOO SMALL, OR 0 IF NONE FOUND
        je      mleading1       ; jump if entire string was blank
        inc     cx              ; CX is length of remainder of string
mleading1:
        dec     di              ; DI points to non-blank
mleading2:
        mov     bx,di           ; put address back
        ret
MLeading        ENDP

;========================================

MTrailing       PROC    Near
;       Remove trailing blanks.
;       on entry BX is addr of string, CX its length
;       trims off any trailing blanks, leaving result in BX CX
;       length may also be 0 or 1, but not -ve
;       If the entire string is blank the result is the null string
        mov     di,bx
        add     di,cx           ; calc addr last char in string
        dec     di
        mov     al,20H          ; AL = blank  -- the search char
        jcxz    mtrailing1      ; jump if null string
        std
        repe    scasb           ; scan ES:DI backwards till hit non blank
                                ; DI points just ahead of it (wrap ok)
                                ; CX is one too small, or 0 if none found
        cld
        je      mtrailing1      ; jump if whole string was blank
        inc     cx
mtrailing1:
        ret
MTrailing       ENDP

;========================================

Parse           PROC    NEAR
;       Parse the command line to remove lead/trail blanks from
;       the single drive parameter and terminate it by 2 nulls.
;       sample inputs
;       LLFCLR A:
;       LLFCLR  C:
;       LLFCLR
;
;       When Done DS:BX points to start of string.
;       String will be terminated by 2 nulls
;       CX counts bytes in string exclusive of nulls
                                ; counted string at HEX 80 PSP
                                ; contains command line.
                                ; Preceeded by unwanted spaces.
                                ; possibly followed by unwanted spaces.
                                ; currently missing a trailing null.
        xor     ch,ch
        mov     cl,ds:80H
        mov     bx,81H
        call    Mleading        ; get rid of leading blanks
        call    MTrailing       ; get rid of trailing blanks
        mov     di,bx           ; calc addr of byte just past end
        add     di,cx
        mov     word ptr [di],0 ; plop in pair of nulls after string
        ret
Parse           ENDP

;======================================

ToUC            PROC    NEAR
;       converts char in AL to upper case
        cmp     al,'a'
        jb      FineAsIs
        cmp     al,'z'
        ja      FineAsIs
        sub     al,20H          ; convert a to A
FineAsIs:
        ret
ToUc            ENDP

;======================================

Analyze         PROC    NEAR
;       analyses the command line allowing C: or D:, but not null
;       On entry DS:BX points to start of string.
;       String will be terminated by 2 nulls
;       CX counts bytes in string exclusive of nulls
;       lead/trail spaces are gone.
        mov     DriveNo,0
        jcxz    BadCmd          ; was no drive, treat as error
        cmp     cx,2
        jne     BadCmd          ; kick out C   C:/X, want just plain C:
        mov     ax,[bx]         ; get chars AL<-C  AH<-:
        cmp     ah,':'          ; make sure second char is :
        jne     BadCmd
;;      call    ToUc            ; add in if want to allow c: d: C: D:
        sub     al,'A'          ; a->0 b->1 c->2 d->3
        cmp     al,2
        jb      BadCmd          ; disallow A: B:
        cmp     al,3
        ja      BadCmd          ; allow only C: D:
        mov     DriveNo,AL
        RET

BadCmd:
        Jmp     Trouble
Analyze         ENDP

;======================================

Say     Proc
;       on entry DX points to a string to display
        MOV     AH,9
        Int     21h
        ret
Say     EndP

;==============================================================

Start   endp

;==========================
CODE    ends                    ; end of code segment
        end     Start
