const 
{ᨬ쭮 ⢮ ᪥}
	MAXDISK  = 3000;
{ᨬ쭮 ⢮ 䠩}
	MAXFILES = 12000;
type
{ ப ⨯}
	S8  = String[8];
	S11 = String[11];
	S12 = String[12];
	S13 = String[13];
	S30 = String[30];
{ଠ 䠩 .VD}
	data = record	
		name	: S12;
		ID	: S11;
		dir	: S13;
		arcname	: S8;
		attr	: Byte; 
		size,
		datetime: Longint;
		comm	: S30
	end;
{ଠ 䠩 .VS}
	summary = record
		ID	: S11;
		free,
		size,
		dust,
		zan,
		datetime: Longint;
		kol	: Integer;
	end;
{  ᨢ ᪥}
	disk_point = ^disk;
	disk = record
		size,
		free	: Longint;
		ID	: S11;
	end;
{  ᨢ 䠩}
	file_point = ^fil1;
	fil1 = record
		size	: Longint;
		l	: Integer;
		n	: S12
	end;
var
{ ६}
	sumfile		: file of summary;
	datafile	: file of data;
	outfile		: text;
{६  ᨢ ᪥  䠩}
	info		: data;
	diskette	: summary;
	darray		: array [1..MAXDISK] of disk_point;
	farray		: array [1..MAXFILES] of file_point;
{⢮ ᪥}
	koldisk,
{⢮ 䠩}
	kolfile,
{६ ६}
	i,j		: Integer;
	ms		: Longint;

{楤 ஢ ᨢ 䠩 -  "QuickSort" }
procedure SortFiles ( start , finish : Integer);
var
  i, j: integer;
  x, y: file_point;
begin
  i := start;
  j := finish;
  x := farray[(start + finish) div 2];
  repeat
    while farray[i]^.size>x^.size do Inc(i);
    while x^.size>farray[j]^.size do Dec(j);
    if i <= j then
    begin
      y := farray[i];
      farray[i] := farray[j];
      farray[j] := y;
      Inc(i);
      Dec(j);
    end;
  until i > j;
  if start < j then SortFiles(start, j);
  if i < finish then SortFiles(i, finish);
end;

{楤 ஢ ᨢ ᪥ -  }
procedure SortDisks(start,finish:integer);
var
  i, j: integer;
  x, y: disk_point;
begin
  i := start;
  j := finish;
  x := darray[(start + finish) div 2];
  repeat
    while darray[i]^.size>x^.size do Inc(i);
    while x^.size>darray[j]^.size do Dec(j);
    if i <= j then
    begin
      y := darray[i];
      darray[i] := darray[j];
      darray[j] := y;
      Inc(i);
      Dec(j);
    end;
  until i > j;
  if start < j then SortDisks(start, j);
  if i < finish then SortDisks(i, finish);
end;

begin
	Writeln('Optimal fill disks for LGDH v1.00              (c) 1993 by George Lyapko');
	Writeln('Usage: OPTFILL [Catalog]      (Without ext,default- \LG)');
{᫨   ப  㪠  ⠫, ६  㬮砭,}
	if ParamCount=0 then begin
		Assign(sumfile,'\LG.VS'); 
		Assign(datafile,'\LG.VD'); 
	end else begin
{   ப}
		Assign(sumfile,ParamStr(1)+'.VS'); 
		Assign(datafile,ParamStr(1)+'.VD'); 
	end;
	Reset(sumfile);
{$IFNDEF VER70}
	koldisk := 0;
{$ENDIF}
{⠥ 䠩 .VS  塞 ᨢ darray}
	while not eof(sumfile) do begin
		Read(sumfile,diskette);
		Inc(koldisk);
		if MaxAvail<SizeOf(disk) then begin
			Writeln('墠⪠ ');
			Halt(1);
		end;
		GetMem(darray[koldisk],SizeOf(disk));
		darray[koldisk]^.size := diskette.size;
		darray[koldisk]^.ID := diskette.ID;
	end;
	Close(sumfile);
	Reset(datafile);
{$IFNDEF VER70}
	kolfile := 0;
{$ENDIF}
{⠥ 䠩 .VD  塞 ᨢ farray}
	while not eof(datafile) do begin
		Read(datafile,info);
{᫨  䠩 室  娢, ய᪠}
		if info.arcname = '........' then begin
			Inc(kolfile);
			if MaxAvail<SizeOf(fil1) then begin
				Writeln('墠⪠ ');
				Halt(1);
			end;
			GetMem(farray[kolfile],SizeOf(fil1));
			with farray[kolfile]^ do begin
{塞, ᪮쪮 䠩  ⢨⥫쭮   
 ᪥ ( =512 )}
				size := Succ(Pred(info.size) div 512) * 512;
				n := info.name;
				l := 0;
			end;
		end;
	end;
	Close(datafile);
{㥬  ࠧ...}
	SortFiles(1,kolfile);
	SortDisks(1,koldisk);
{⨬쭮(?) 塞 ᪥}
	for i := 1 to koldisk do begin
		ms := darray[i]^.size;
		j := 1;
		while j<=kolfile do begin
			with farray[j]^ do if (l=0) and (size<=ms) then begin
				l := i;
				Dec(ms,size);
			end;
			Inc(j);
		end;
		darray[i]^.free := ms;
	end;
{뢮  outfile}
	Assign(outfile,'optfill.dat');
	Rewrite(outfile);
	for i := 1 to koldisk do begin
		with darray[i]^ do Writeln(outfile,'',i:4,' ⪠ ',ID,
		'  ',size,'  ',free);
		for j := 1 to kolfile do with farray[j]^ do 
		if l = i then Writeln(outfile,' ':10,n:12,' ':4,size);
	end;
	Close(outfile);
end.
		