PAGE    60,132
NAME    LAUNDER
        TITLE   LAUNDER.Exe Version 3.0
        .286            ; sorry no XT

StealInt        equ 50h         ; steal interrupt 50, 51,... for A: B: swapper code.
                                ; in generated boot code.  Not in Launder itself.
BootLoc         equ 7c00h       ; boot loads at 0000:7c00 absolute.
SecBootLoc      equ 800h        ; where we relocate our boot code to

BiggestFAT      equ 11          ; largest possible FAT in sectors
BiggestDir      equ 224         ; largest possible directory in 32-byte entries
BiggestSectsPerTrack equ 22     ; largest possible sectors per track.

;Registered equ 1
;owner      equ " "

COMMENT |

With an AMI BIOS
-  360 KB 1 secs/disk
-  720 KB 6 secs/disk   (slower because presumes 1.44 first)
-  1.2 MB 5 secs/disk   (slower because presumes 360 first)
- 1.44 MB 1 secs/disk

With Phoenix BIOS, about 1 second per disk.

to do:
- add options to display prompt.
- find out why /Keep displayed a few files

LAUNDER.Exe Copyright Roedy Green Canadian Mind Products 1992,1998

May be freely distributed for non-military use only.

LAUNDER "launders" a pile of floppy diskettes to be recycled by
erasing all the files on them, and by giving them fresh boot
tracks and volume serial numbers consistent with DOS 4.01/DOS 6.0
requirements.

LAUNDER removes all directories, files and both volume labels.  It
gets rid of even system, hidden, and read-only files.  Thus
bootable disks will become standard disks.

LAUNDER was based on SCAT.

Please report bugs and problems to:

Roedy Green
Canadian Mind Products
#208 - 525 Ninth Street
New Westminster BC Canada
V5H 2N6
tel:(604) 777-1804
mailto:roedy@mindprod.com
http://mindprod.com


Version 3.0 1998 November 8
- embed Barker address
- NEEDS WIN95/NT hands-free turn off code. TOGO

Version 2.9 1997 July 2
- add support for 2-M 1.76 MB (1.44++)
- add support for 2-M 1.41 MB (1.2++)
- add support for 2-M 984 K  (720++)

Version 2.8 1996 December 9
- add running counts
- prompts that let you know if /govt /secure /keep options in effect
- simplified diskette descriptions,  took out sector counts, used terms
  double and high density.
- /full option

Version 2.7 1996 October 25
- embed POB 707 Quathiaski Cove address

Version 2.6 1994 August 8
- get around problems with failed boot B reboots.
- STI and CLD on reboot.
- give B: boot three bios tries to read before giving up on it.
- swap A: and B: drives after the B: boot has occurred.

Version 2.5 1994 July 9
- add /BOOTB  feature
- another crack at solving bios bug that A: drive appears not to exist
  immediately after reboot.

Version 2.4 1993 Sept 8
- remove NAG
- full features in Shareware version

Version 2.3 1993 June 17
- reset diskette BIOS subsystem before determining if drive present.
  Bug in many BIOSes says no drive present if you have freshly rebooted.
  Fixes problem with Launder exiting immediately on first use after boot.

Version 2.2 1993 June 7
- no longer test carry on int 13 function 15 get drive function since some
  bioses erroneously set carry even when all is ok.
- no longer treat status codes 1 and 2 as if 3=write protect.  Avoid
  false write protect codes.
- support for /Government /Keep /Prompt /Quiet /Secure
- patched up code so MASM will work, jmp SHORT, out of range jmps etc.

Version 2.1 1993 June 2
- change phone numbers and address

Version 2.0 1992 August 29
- released to the world.
- suicides on excess use.

Version 1.9 1992 July 26
- fix screen erase for BIOS's that don't reveal the screen size.

Version 1.8 1992 July 25
- bypass DOS 4.x
- box around the diskette type to focus attention on that.
- now gives diskette status for read/write failure to help in debug.

Version 1.7 1992 July 23
- shorten description of Norton Proprietary to fit on one line.
- fix bug in Alignbuffer, to bypass DMA boundary errors when DOS
  or QEMM does not do it for you.
- error messages show diskette types

Version 1.6 1992 July 14
- fix bug FF7 markers in FAT were treated as free, rather than as bad.
- add debug code to track bad status

Version 1.5 1992 June 22
- support physical drives 3: and 4:
- test for remove diskette too soon separately from write protect.
- test for remove diskette separately instead of damaged fat error.
- general cleanup of messages.
- change references to old proprietary format to Norton Proprietary format.
- now nags you with a random message when you quit
- now displays a registration message when you quit.
- now clear all errors with an int 13 function 00.
- DOS no longer complains about an illegal disk change if you fail to remove
  the diskette when requested.
- now uses BIOS exclusively for keyboard handling.
- now traps Ctrl-Break even before 1B interrupt, so detects faster.
  DOS is out of the picture, and cannot meddle.
- Flushes pending keystrokes to start and prior to nag prompts.
- now allows any keystroke to get you out of the nag messages.
- LAUNDER goes on strike for 30 seconds, randomly if you grossly
  overuse it without registering.
- demo of nag, with limits set at 10 30 and 40 diskettes to kick in
  higher nag levels.  Usually these would be 200, 500 and 700.

Version 1.4 1992 June 17
- bypass bug in Phoenix BIOS, fails to set carry on i/o failure.
- credits to Magazin fuer Computertechnik
- test directly for changeline support, so even 720 and 360 KB drives
  with changeline will work.
- test for the existence of drive A: and B:
- new eh? noise when put in a write protected diskette, so can tell without
  looking from the hopeless cases.  Sounds more like a mosquito than eh?
- fixup code so that MASM can also assemble it.  Get rid of out of range
  jumps, phase errors etc.  Avoid link bugs by explicit ASSUMES and ES:
  overrides for references to the ROMBIOS region.

Version 1.3 1992 June 17
- convert all i/o to pure BIOS, no DOS to avoid ANSI.SYS troubles.
- check for 360 KB or 720 KB floppy drive, and refuse to run.
  We need changeline support.
- rename from LAUND to LAUNDER
- Ctrl-Break and Ctrl-C now terminate launder safely as does ESC
- Hex 1B interrupt now properly restored on exit.

Version 1.2 1992 June 16
- auto reboot to drive C: if accidentally leave a floppy inserted.

Version 1.1 1992 June 15
- restores original screen background and border.
- uses 16 background colours instead of 8 internally.  360KB diskettes now
  show up as true yellow.
- fixed bug.  LAUNDER crashed if first diskette you fed it was virgin or
  unknown.  Now these have their own dummy BPBs, sounds and colours.
- LAUNDER now does DOS reset to on startup and shutdown.
  This should prevent DOS DIR after LAUNDER from getting the old disk contents.
- LAUNDER now ignores keystrokes other than Space and Esc.
- LAUNDER now ignores Ctrl-Break, rather than aborting or treating it as a char.
- test for XT, and apologize for lack of XT support
- separate mono and colourscheme
- assign official colours to virgins, unknowns and Norton proprietary
- some reoganization to hide some details and bring others up to the main
  routine.

Version 1.0 1992 June 7
- initial version released to BIX for Beta test.
- does not work on XT.  Needs multibit shift and int 15 time delay only
  avail on AT.
- special noise for Virgin diskettes.

How it works
************

1.  We read the boot record to determine the media descriptor
    byte.  If it damaged, it is best to reformat the disk, so we
    don't attempt to recover. In cases of ambiguity we have to look
    at drive type or other BPB fields.

2.  Reconstruct the rest of the BPB from the media byte.  Tell the user
    what kind of disk it is.  Warn the user we are repairing minor damage
    if he reconstructed version differs substantially from the original.

3.  Read the entire first copy of the FAT (up to 11 sectors
    long). Convert all IN-use bytes to free.  Warn the user of any
    diskettes with bad clusters.  Make a duplicate.

4.  Create a dummy root directory with all entries cleared in RAM.

5.  Write out a new boot, two copies of the fat, and an empty root directory.

6.  Tell the user it is ok to remove the floppy.

7.  Wait for a DIFFERENT floppy to appear, goto 1

FAT  made of 1.5 byte entries.
root dir made of 32 byte entries.

---

Green Dot 1.4 MB floppy:

  0    1..9    10..18    19..32      33..2879
boot  fat 1  fat 2  root dir   data files 
                     ^              considered cluster 2
Clusters consist of 1 sector.
A track in 18 sectors long, so root dir starts on second track

----

Red Dot 1.2 MB floppy:

  0    1..7    8..14    15..28      29..2399
boot  fat 1  fat 2  root dir   data files 
                     ^              considered cluster 2
Clusters consist of 1 sector.
A track in 15 sectors long, so root dir starts on second track.

---

Blue Dot 720 KB floppy:

  0    1..3    4..6     7..13       14..1439
boot  fat 1  fat 2  root dir   data files 
                          ^         considered cluster 2
Clusters consist of 2 sectors.
A track is 9 sectors long, so root dir spans first/second tracks.

---

Yellow Dot 360 KB floppy:

  0    1..2    3..4     5..11      12 ... 719
boot  fat 1  fat 2  root dir   data files 
                          ^         considered cluster 2
clusters consist of 2 sectors.
since track is 9 sectors long, the root dir spans the first two tracks.

----

|       ; end of comment
;======

ImAt    Macro   char ; displays character to let you know where
                ; you are executing in the program
                ; DEBUGGING TOOL.
        push    ax
        push    bx
        mov     ah,0Eh
        mov     al,"&char"
        mov     bl,07
        int     10h
        pop     bx
        pop     ax
        endM

;======

CR      MACRO string    ; Carriage return line feed, PRIOR to optional string
        DB 0dh,0ah
        ifnb    <string>
        db      string
        endif
        ENDM

;======

EOS     MACRO   ; marks end of display string
        DB 0dh,0ah,0
        ENDM
;======
jcL     MACRO   Where
        local   isok
;; jc when target is out of range.
;; OPTASM does this automatically, but MASM needs help
        jnc     isok
        jmp     &Where          ; might generate SHORT JMP
isok:
        ENDM
;======
jeL     MACRO   Where
        local   isok
;; je when target is out of range.
;; OPTASM does this automatically, but MASM needs help
        jne     isok
        jmp     &Where          ; might generate SHORT JMP
isok:
        ENDM
;======

Corral  MACRO   r1,lb,ub  ; forces a register to lie in a safe range.
        local   bigenough,smallenough
        cmp     &r1,&lb
        jge     bigenough
        mov     &r1,&lb
bigenough:
        cmp     &r1,&ub
        jle     smallenough
        mov     &r1,&ub
smallenough:

        ENDM
;======

COLOURS         MACRO foreground,background,border
;;              Define colour scheme with a triple of colours.
;;              Displayed when this type of disk is detected.
;;              bk  fore     bor : 16 bits, background msb, border lsb
;;              iRGBiRGB____iRGB
        db      border
        db      foreground+(background*16)
        ENDM

;======

GRAYS           MACRO foreground,background,border
;;              Define colour scheme with a triple of colours.
;;              must be chosen from blacks, grays and whites
;;              bk  fore     bor : 16 bits, background msb, border lsb
;;              iRGBiRGB____iRGB
        db      border
        db      foreground+(background*16)
        ENDM

;======

CLEARREGION     MACRO from,to
;;              Define low,high bounds of region to erase with /SECURE
;;              Zero-based sector numbers for the data region of the disk
        dw      from
        dw      to
        ENDM

;======

BPBStruc Struc          ; The BPB is the part of the boot record
                        ; that describes the disk geometry
                        ; 21 bytes long

BP_SectSize             dw 200h ; All IBM compatible floppies have 512-byte sectors
BP_SectsPerClust        db ?    ; Number of sectors per cluster
BP_ResSects             dw 1    ; Number of reserved sectors on the disk
BP_NFats                db 2    ; Number of FATs
BP_RootEntries          dw ?    ; Number of entries in the Root Directory
BP_TotalSects           dw ?    ; Total number of sectors on the disk
BP_MediaByte            db ?    ; Media descriptor byte
BP_SectsPerFAT          dw ?    ; Number of sectors in (one) FAT
BP_SectsPerTrack        dw ?    ; Number of sectors per track
BP_Heads                dw ?    ; Number of heads (== sides)
BP_HiddenSects          dd 0    ; Number of "hidden" sectors

BPBStruc                Ends


ModelStruc Struc        ; model BPB followed by extra info

                db      (size bpbstruc) dup (?)
ClearFrom       dw      ?       ; first data sector to /SECURE clear
ClearTo         dw      ?       ; last data sector to /SECURE clear
ColourForModel  dw      ?       ; screen colourscheme to use
GrayForModel    dw      ?       ; screen grayscale colourscheme
SoundForModel   dw      ?       ; address of a sound routine
                                ; to announce this type of diskette.
CounterForModel dw      ?       ; address of counter for this type.
DescripForModel db      ?       ; ASCIIZ string description of diskette type

ModelStruc                      Ends

;======


BIOSDATA    segment AT 40h      ; dummy segment in low RAM

                org     4Ah
BIOSNumCols     db      ?       ; Cols per screen

                org     40h
BIOSCountDown   db      ?       ; countdown till motor off

                org     71h
BIOSBreak       db      ?       ; bit 7 =1 if Break recently
                                ; pressed

                org     72h
BIOSWarmFlag    dw      ?

                org     84h
BIOSLastRow     db      ?       ; Lines per screen - 1

BIOSDATA        ends

;======

ROMBIOS         segment AT 0f000h       ; dummy segment inside ROM BIOS

                org     0fff0h
BIOSReset       label   far             ; reset code at FFFF:0000
                                        ; better represented as F000:FFF0

                org     0fffEh
BIOSMachineId   db      ?               ; BIOS machine type code
BIOSSubId       db      ?               ; BIOS sub model id code

ROMBIOS         ends

;==============================================================

Stack           SEGMENT para stack

        db      512 dup (?)

Stack           ends

;==============================================================

CODE    SEGMENT PARA            ; start off in code.
Code    Ends
;==============================================================

data    SEGMENT para            ; provide a separate DATA segment
                                ; Even though it appears in the source
                                ; before the code, it the EXE file it
                                ; will appear at the    end.  This is as dodge
                                ; to avoid forward references that confuse
                                ; MASM.


data    endS

;==============================================================

Buffer  SEGMENT para
                                ; It might need to hold 37 sectors
                                ; to do the i/o.
                                ; Put this at the end, because it is just
                                ; empty workspace.
                                ; However if we are unlucky, we might need
                                ; 37*2 sectors to avoid spanning a DMA
                                ; boundary.  So the buffer needs to be 37K
                                ; big enough to handle
                                ; erasing a 2-M 1.44 floppy in a single i/o
;==========================================================
;
; B O O T   S E C T O R
;
; This is where we build the image of the
; boot sector 0 to place on the floppy.
;==========================================================

;       BOOTSECTOR is first sector on diskette.

                EVEN

Boot_Sector     db 512d dup (?) ; Work area to read/build boot sector

                ORG     Boot_Sector
Boot_jump       db 3 dup (?)    ; Jump to bootstrap code
Boot_oem        db 8 dup (?)    ; Name of OEM

                ORG    Boot_Sector + 20H
;; BPB TAIL
GiantSize       dd ?            ; total sectors if volume > 32 MB
PhysDriveNo     db ?            ; which drive we intend to boot from with this disk.
Reserved        db ?

                ORG     Boot_Sector+0Bh
Boot_BPB        BPBStruc <>     ; 21 bytes

                ORG     Boot_Sector+26h
Boot_ESignature db ?            ; 29h to mark extension
Boot_VolID      db 4 dup (?)    ; 8 hex digits e.g. 1D35-1ECB unique
Boot_VolLab     db 11d dup (?)  ; 11 character volume label
Boot_FAT_Type   db 8d dup (?)   ; FAT12___
                                ; OS/2 likes FAT_____

                ORG     Boot_Sector+3eh
Boot_Code       DB ?            ; boot code for accidental boot.
                                ; padded with 0s
                                ; max 448 bytes.


                ORG     Boot_Sector+0A1h
Boot_Norton_Kilroy      DB      22d dup (?)
                                ; where Norton places
                                ; "Norton Backup Diskette"

                ORG     Boot_Sector+510d
Boot_Signature  DW ?            ; 55AA last two bytes


;==========================================================

;       FAT1 comes next
        db      BiggestFAT*512 dup (?)  ; Each fat might be as long as 11 sectors.
                                ; There are two identical fats, each about 4.5K.
                                ; Note that 12 bit entries may SPAN
                                ; adjacent sectors.
                                ; there is a 3-byte reserved area at the
                                ; head of each fat
                                ; will be dynamically positioned.

;==========================================================

;       FAT2 comes next
        db      BiggestFAT*512 dup (?)  ; just a duplicate copy of FAT1
                                ; dynamically positioned

;==========================================================

;       ROOTDIR                 ; buffer at end of program to erase the
        db      BiggestDir*32 dup (?)   ; root directory to all 0.
                                ; up to BiggestDir 32-byte entries
                                ; 14 sectors, = 7K
                                ; will be dynamically positioned.

;       However in worst case we could need a buffer twice as big in
;       order to get the buffer to avoid a 64K boundary.
        db      37*512 dup (?)  ; to give room to realign the buffer
;==========================================================

Buffer          EndS

;=============================================
;
; B O O T   S E C T O R   M O D E L S
;
; Models for the boot sector.  We use these piece to construct the
; new boot record.
;
; See Ray Duncan's Advanced MS DOS page 180 for Boot sector layout.
;
;=============================================

Data            Segment
My_Norton_Kilroy        DB      'Norton Backup Diskette'


My_Jump         label   byte    ; patch for first 3 bytes of BPB
        DB      0EBh,03Ch,090h
                        ; JMP SHORT Boot_Code NOP
                        ; hand assembled jump to My_Boot_Code
                        ; relative jump to 03e
;=============================================

My_OEM_DOS6     label   byte
        DB  'IBM  4.0'  ; name of company who wrote DOS
                        ; os/2 likes IBM 10.2
;            12345678   ; some programs don't like MS or more recent versions.

;========
;   Skeleton BPBs for various types of diskette
;   Use these both to recognize and patch BPBs

; CGA/VGA colour scheme for screen display while erasing each type of diskette
; We have the blink bit turned off so we can use it to get an intensity bit
; in the background colour.
; These colours will work for mono as well since we disable the blink bit.

;                       iRGB
black           equ     0000b
Blue            equ     0001b   ; foreground shows as underline on mono
Green           equ     0010b
Cyan            equ     0011b
Red             equ     0100b
Violet          equ     0101b
Brown           equ     0110b
LtGray          equ     0111b
DkWhite         equ     0111b
DkGray          equ     1000b   ; might show as black on some screens
LtBlue          equ     1001b   ; foreground shows as underline on mono
LtGreen         equ     1010b
LtCyan          equ     1011b
Pink            equ     1100b
LtViolet        equ     1101b
Yellow          equ     1110b
White           equ     1111b
LtWhite         equ     1111b

; For Monochrome screens, must stick to black, LtGray, DkWhite, White
; On herc, there is no border, but there is or B&W monochrome

;=============================================
; B P B   B O O T   M O D E L S
;=============================================

;       <,secs/clust,,,,rootEntries,sectors,media,secs/fat,secs/track,heads,,>
;       Store extra info after a model BPB
;       If you add more types, check CORRALs in SnaffleDiskGeom
;       Sectors as measured by Norton SI.

D144    BPBStruc <,1,,,224,2880,0f0h,9,18,2,>   ; 2847 clusters, 1.44 MB
;       <,secs/clust,,,,rootEntries,sectors,media,secs/fat,secs/track,heads,,>
        CLEARREGION 33,2879
        COLOURS Black,GREEN,green
        GRAYS   dkwhite,BLACK,dkgray
        dw      offset HighTone
        dw      offset CountGreen
        CR      'Ŀ'
        CR      ' AT 3" 1.44 MB High density GREEN-dot. '
        CR      ''
        EOS


D141    BPBStruc <,1,,,224,2952,0f0h,9,18,2,>   ; 2919 clusters, 1.41 MB
;       <,secs/clust,,,,rootEntries,sectors,media,secs/fat,secs/track,heads,,>
        CLEARREGION 33,2951
        COLOURS Black,CYAN,green
        GRAYS   dkwhite,BLACK,dkgray
        dw      offset HighTone
        dw      offset CountCyan
        CR      'Ŀ'
        CR      ' AT 5" 1.41 MB 2-M proprietary CYAN-dot. '
        CR      ''
        EOS


D12     BPBStruc <,1,,,224,2400,0f9h,7,15,2,>   ; 2371 clusters, 1.2 MB
;       <,secs/clust,,,,rootEntries,sectors,media,secs/fat,secs/track,heads,,>
        CLEARREGION 29,2399
        COLOURS white,RED,red
        GRAYS   dkwhite,BLACK,DkGray
        dw      offset HighTone
        dw      offset CountRed
        CR      'Ŀ'
        CR      ' AT 5" 1.2 MB High density RED-dot. '
        CR      ''
        EOS

D720    BPBStruc <,2,,,112,1440,0f9h,3,9,2,>    ; 1426 clusters, 720 KB
;       <,secs/clust,,,,rootEntries,sectors,media,secs/fat,secs/track,heads,,>
        CLEARREGION     14,1439
        COLOURS white,BLUE,blue
        GRAYS   black,DKWHITE,DkGray
        dw      offset LowTone
        dw      offset CountBlue
        CR      'Ŀ'
        CR      ' XT 3" 720 KB Double density BLUE-dot. '
        CR      ''
        EOS

D176    BPBStruc <,1,,,224,3608,0fah,11,22,2,>  ; 3571 clusters, 1.76 MB
;       <,secs/clust,,,,rootEntries,sectors,media,secs/fat,secs/track,heads,,>
        CLEARREGION 37,3607
        COLOURS Black,CYAN,cyan
        GRAYS   dkwhite,BLACK,dkgray
        dw      offset HighTone
        dw      offset CountCyan
        CR      'Ŀ'
        CR      ' AT 3" 1.76 MB 2-M proprietary CYAN-dot. '
        CR      ''
        EOS

D984    BPBStruc <,1,,,192,1968,0fah,6,12,2,>   ; 1943 clusters, 984K
;       <,secs/clust,,,,rootEntries,sectors,media,secs/fat,secs/track,heads,,>
        CLEARREGION 25,1967
        COLOURS Black,CYAN,cyan
        GRAYS   dkwhite,BLACK,dkgray
        dw      offset HighTone
        dw      offset CountCyan
        CR      'Ŀ'
        CR      ' AT 3" 984K 2-M proprietary CYAN-dot. '
        CR      ''
        EOS


D180    BPBStruc <,1,,,64,360,0fch,2,9,1,>      ; 351 clusters, 180 KB
;       <,secs/clust,,,,rootEntries,sectors,media,secs/fat,secs/track,heads,,>
        CLEARREGION 9,359
        COLOURS white,VIOLET,ltviolet
        GRAYS   black,WHITE,DkGray
        dw      offset StrangeTone
        dw      offset CountOther
        CR      'Ŀ'
        CR      ' XT 5" 180 KB ancient Single sided 9-sector. '
        CR      ''
        EOS


D360    BPBStruc <,2,,,112,720,0fdh,2,9,2,>     ; 354 clusters, 360 KB
;       <,secs/clust,,,,rootEntries,sectors,media,secs/fat,secs/track,heads,,>
        CLEARREGION 12,719
        COLOURS black,YELLOW,yellow
        GRAYS   black,DKWHITE,DkGray
        dw      offset LowTone
        dw      offset CountYellow
        CR      'Ŀ'
        CR      ' XT 5" 360 KB Double density YELLOW-dot. '
        CR      ''
        EOS

D160    BPBStruc <,1,,,64,320,0feh,1,8,1,>      ; 313 clusters, 160 KB
;       <,secs/clust,,,,rootEntries,sectors,media,secs/fat,secs/track,heads,,>
        CLEARREGION 7,319
        COLOURS white,VIOLET,ltviolet
        GRAYS   black,WHITE,DkGray
        dw      offset StrangeTone
        dw      offset CountOther
        CR      'Ŀ'
        CR      ' XT 5" 160 KB ancient Single sided 8-sector. '
        CR      ''
        EOS


DNorton BPBStruc <,1,,,64,320,0feh,1,8,1,>      ; Norton dummy
;       <,secs/clust,,,,rootEntries,sectors,media,secs/fat,secs/track,heads,,>
        CLEARREGION 9999,9999
        COLOURS black,PINK,black
        GRAYS   dkwhite,BLACK,DkGray
        dw      offset StrangeTone
        dw      offset CountUnprocessed
        CR      'Ŀ'
        CR      ' Norton Backup Proprietary diskette. '
        CR      ''
        EOS

DVirgin BPBStruc <,1,,,64,320,0feh,1,8,1,>      ; Virgin Dummy
;       <,secs/clust,,,,rootEntries,sectors,media,secs/fat,secs/track,heads,,>
        CLEARREGION 9999,9999
        COLOURS red,LTWHITE,blue
        GRAYS   black,WHITE,DkGray
        dw      offset Prangtone
        dw      offset CountUnprocessed
        CR      'Ŀ'
        CR      ' Virgin unformatted diskette. '
        CR      ''
        EOS

DUnknown BPBStruc <,1,,,64,320,0feh,1,8,1,>     ; Bad media dummy
;       <,secs/clust,,,,rootEntries,sectors,media,secs/fat,secs/track,heads,,>
        CLEARREGION 9999,9999
        COLOURS white,BLACK,red
        GRAYS   black,WHITE,DkGray
        dw      offset StrangeTone
        dw      offset CountUnprocessed
        CR      'Ŀ'
        CR      ' Unknown type of diskette. '
        CR      ''
        EOS

D320    BPBStruc <,2,,,112,640,0ffh,1,8,2,>     ; 315 clusters, 320 KB
;       <,secs/clust,,,,rootEntries,sectors,media,secs/fat,secs/track,heads,,>
        CLEARREGION 10,639
        COLOURS white,VIOLET,violet
        GRAYS   black,WHITE,DkGray
        dw      offset StrangeTone
        dw      offset CountOther
        CR      'Ŀ'
        CR      ' XT 5" 320 KB ancient Double sided 8-sector. '
        CR      ''
        EOS

;=============================================
;       B O O T   M O D E L S   C O N T I N U E D
;=============================================

My_VolID                db      4 dup (0)       ; 4 bytes long
                                                ; construct a hex volid here.

My_Boot_FAT_Type        DB      'FAT12   '
;                                XXXXXXXX

;=============================================
;       A U T O    R E B O O T   C O D E   M O D E L  T E M P L A T E
;=============================================

;   Code that gets executed if attempt to boot from non-boot floppy by mistake
;   We do not execute it now.  We just put in on the floppy boot sector.
;   This code is not executed as part of LAUNDER,
;   it is data we use to patch the boot.
;   WE ARE IN THE DATA SEGMENT!

        ASSUME  CS:Data,DS:Nothing,ES:Nothing,SS:nothing
                ; not really, but keeps MASM happy

;       This code is executed when you accidentally boot from a floppy.
;       It will be loaded at 0:7c00.  Microsoft makes this presumption so
;       I guess it is safe to burn it into the code.
;       CS: DS: and ES: will be 0.
;       SS:SP will be pointing to some stack.
;       We will soon have to copy a new boot sector over top of where
;       we are.  We must move ourselves to 800:0 first.
;
;       This code was inspired by an article in Magazin fuer Computertechnik
;       by Andreas Stiller and Peter Siering in the 1992 April issue.
;       Their code example was in German.
;

C_MY_BOOT_CODE:                 ; this is at 7c3e
        CLI                     ; prevent interrupts while we shuffle.
        CLD
        MOV     AX,CS
        MOV     DS,AX           ; ensure CS: DS: cover PART1
        MOV     BX,SecBootLoc   ; prepare to copy this boot sector to 800:0
        MOV     ES,BX
        MOV     DI,0
        MOV     SI,BootLoc      ; source 0:7c00
        MOV     CX,256          ; move all 512 bytes of us to 800:0
        REP     MOVSW           ; DS:SI --> ES:DI
        MOV     AX,DS
        MOV     ES,AX           ; ES covers old 0:7c00
        MOV     DS,BX           ; DS covers new 800:0
        MOV     AX,C_PART2-(C_MY_BOOT_CODE-3Eh)
                                ; Where we carry on once move is done
                                ; when at PART2, CS: DS: will all
                                ; point to 800:0, but ES: will still point to
                                ; 0:7c00.
        PUSH    DS
        PUSH    AX
        RETF                    ; jump to PART2: ES:AX at 800:5d
                                ; thus freeing up the original
                                ; official DOS boot location.

; = = = = = = = = = = = = = = = = = = = = = =

C_PART2:
                                ; CS: DS: all point to 800:5d
                                ; 2nd part of boot
                                ; at 800:0 is start of copied boot sector.
                                ; ES: still points to old 0:7c00
        STI                     ; Enable interrupts for Beep

        MOV     SI,C_BOOT_ERR_MSG-(C_MY_BOOT_CODE-3eh)
                                ; position-independent way of getting
                                ; address of 800:BOOT_ERR_MSG
                                ; that moved along with the code to
                                ; 800:0

        CALL    C_DISPLAY_BOOT_STRING
                mov     bx,BootLoc      ; ES:BX 0:7c00 points to old buffer

        MOV     DH,00
        MOV     DL,ES:[BootLoc + 24h]   ; physical drive number DL=80=C: 00=A: 01=B:
                                ; we want to REBOOT from. Usually 80 for C: or
                                ; 01 or B:.  Ordinary disks would have this 0
                                ; for A:
        MOV     AH,0
        INT     13H             ; reset disk

        MOV     AH,01           ; get status to clear it.
                                ; DL still set
        INT     13H

        MOV     AX,0201h        ; BIOS read 1 sector

                                ; DH=0 head#  DL=80=C: 00=A: 01=B:
                                ; DX still set
        MOV     CX,1            ; CH=0 track# CL=1=starting sector#
        INT     13H             ; read hard disk boot sector
        TEST    AH,AH           ; error code, 0=ok.
                                ; al=sector count can't be trusted.
                                ; neither can carry flag.  Many bioses have bugs.

        JNZ     C_BOOT_TROUBLE  ; boot from drive C: failed
C_BOOT_SUCCESS:
;       We successfully read a C: boot record.
;       Make all look like a first time try: ES: DS: CS: are 0.

        MOV     AX,ES
        MOV     DS,AX
        PUSH    DS
        PUSH    BX

;       Patch the RAM boot record we just read so that it too will look on
;       the drive we just REBOOTED from.
        MOV     DS:[BootLoc + 24h],dl   ; B: is drive 01, C: is 80, A: is 00

        RETF                    ; far jump to start of boot sector just read.
                                ; at old 0:7c00

; Drive C: failed to respond.
C_BOOT_TROUBLE:
                                ; at this point DS: points to part 2
                                ; but ES: is still pointing to part 1
        MOV     SI,C_BOOT_FAIL_MSG-(C_MY_BOOT_CODE-3eh)
                                ; Reboot did not take, try reboot from floppy.
        CALL    C_DISPLAY_BOOT_STRING

; Wait for user to hit space bar or other key
        XOR     AH,AH
        INT     16h

; now reboot, hopefully to a different floppy.

        int     19h                     ; reboot
                                        ; this does not do a full init
                                        ; but that is ok, it is already done.
;       Will not come back.

; = = = = = = = = = = = = = = = = = = = = = =

C_DISPLAY_BOOT_STRING   PROC    NEAR

;       Display a string on the screen while in midst of boot.
;       No DOS services yet.  Diskette may boot on XT, so can't use AT BIOS.
;       On Entry DS:SI points to null-terminated string
;       trashes AX BX SI

C_NEXTCHAR:
        LODSB                   ; get next char of error message
        TEST    AL,AL
        JZ      C_STRINGDONE    ; done when hit 0 at    end
                                ; of string
        MOV     BX,7            ; white on blue colour, mono safe
        MOV     AH,0Eh          ; display one char
        INT     10h             ; video i/o
                                ; handles 07 beep too
        JMP     C_NEXTCHAR
C_STRINGDONE:
        RET

C_DISPLAY_BOOT_STRING   ENDP

; = = = = = = = = = = = = = = = = = = = = = =


C_BOOT_ERR_MSG:
        CR
        CR      ' WARNING ۲ A: contains a non-system diskette'
        CR
        CR      'Rebooting from C: hard disk...'
        CR
        EOS

C_BOOT_FAIL_MSG:
        DB      07h             ; beep
        CR      ' ERROR ۲ hard disk drive C: boot failed.'
        CR
        CR      'Insert a DOS system diskette, and hit the space bar.'
        CR
        EOS

C_KILROY:
                                        ; can see it only with a hex editor
                                        ; copyright message for our reboot code.
ifdef   Registered
        DB      'LAUNDER 3.0 UNREGISTERED'
else
        DB      'LAUNDER 3.0 REGISTERED'
endif
        CR
        DB      '(c) 1992,1998 Canadian Mind Products'
        CR
        DB      '#208 - 525 Ninth Street, New Westminster, BC Canada V3M 5T9',13,10
        DB      'tel:(604) 777-1804   mailto:roedy@mindprod.com   http://mindprod.com',13,10

                                                ; If you make this section too long,
        CR                                      ; it will simply be chopped to
        DB      0                               ; fit.


C_ENDMY_BOOT:
; ==========================================================

B_MY_BOOT_CODE:                 ; this is at 7c3e
        CLI                     ; prevent interrupts while we shuffle.
        CLD
        MOV     AX,CS
        MOV     DS,AX           ; ensure CS: DS: cover PART1
        MOV     ES,AX
                                ; copy part3 stealing RAM in vector table
        MOV     SI,BootLoc+B_PART3-(B_MY_BOOT_CODE-3eh)
        MOV     DI,StealInt*4
        MOV     CX,(B_END_PART3-B_PART3)/2
        REP MOVSW
                                ; patch the jump in new code to old Int 13
        MOV     SI,13h*4
        MOV     DI,StealInt*4+(B_OLD_INT13-B_PART3)
        MOV     CX,2
        REP MOVSW
                                          ; patch old Int13 to our new handler.
        MOV     WORD PTR DS:[13h*4],StealInt*4 ; offset of int 50 vector
        MOV     WORD PTR DS:[13h*4+2],0        ; segment of int 50 vector

        MOV     BX,SecBootLoc   ; prepare to copy this boot sector to 800:0
        MOV     ES,BX
        MOV     DI,0
        MOV     SI,BootLoc      ; source 0:7c00
        MOV     CX,256          ; move all 512 bytes of us to 800:0
        REP     MOVSW           ; DS:SI --> ES:DI
        MOV     AX,DS
        MOV     ES,AX           ; ES covers old 0:7c00
        MOV     DS,BX           ; DS covers new 800:0
        MOV     AX,B_PART2-(B_MY_BOOT_CODE-3Eh)
                                ; Where we carry on once move is done
                                ; when at PART2, CS: DS: will all
                                ; point to 800:0, but ES: will still point to
                                ; 0:7c00.
        PUSH    DS
        PUSH    AX
        RETF                    ; jump to PART2: ES:AX at 800:5d
                                ; thus freeing up the original
                                ; official DOS boot location.

; = = = = = = = = = = = = = = = = = = = = = =

B_PART2:
                                ; CS: DS: all point to 800:5d
                                ; 2nd part of boot
                                ; at 800:0 is start of copied boot sector.
                                ; ES: still points to old 0:7c00
        STI                     ; Enable interrupts for Beep

        MOV     SI,B_BOOT_ERR_MSG-(B_MY_BOOT_CODE-3eh)
                                ; position-independent way of getting
                                ; address of 800:BOOT_ERR_MSG
                                ; that moved along with the code to
                                ; 800:0

        CALL    B_DISPLAY_BOOT_STRING
                mov     bx,BootLoc      ; ES:BX 0:7c00 points to old buffer
        MOV     SI,3
B_TRY_AGAIN:
        MOV     DH,00
        MOV     DL,ES:[BootLoc + 24h]   ; physical drive number DL=80=C: 00=A: 01=B:
                                ; we want to REBOOT from. Usually 80 for C: or
                                ; 01 or B:.  Ordinary disks would have this 0
                                ; for A:
        MOV     AH,0
        INT     13H             ; reset disk

        MOV     AH,01           ; get status to clear it.
                                ; DL still set
        INT     13H

        MOV     AX,0201h        ; BIOS read 1 sector

                                ; DH=0 head#  DL=80=C: 00=A: 01=B:
                                ; DX still set
        MOV     CX,1            ; CH=0 track# CL=1=starting sector#
        INT     13H             ; read hard disk boot sector
        TEST    AH,AH           ; error code, 0=ok.
                                ; al=sector count can't be trusted.
                                ; neither can carry flag.  Many bioses have bugs.
        JZ      B_BOOT_SUCCESS
        DEC     SI
        JNZ     B_TRY_AGAIN
        JMP     B_BOOT_TROUBLE  ; boot from drive C: failed
B_BOOT_SUCCESS:
;       We successfully read a B: boot record.
;       Make all look like a first time try: ES: DS: CS: are 0.

        MOV     AX,ES
        MOV     DS,AX
        PUSH    DS
        PUSH    BX

;       Patch the RAM boot record we just read so that it too will look on
;       the drive we just REBOOTED from.
        MOV     DS:[BootLoc + 24h],dl   ; B: is drive 01, C: is 80, A: is 00

        RETF                    ; far jump to start of boot sector just read.
                                ; at old 0:7c00

; Drive C: failed to respond.
B_BOOT_TROUBLE:
                                ; at this point DS: points to part 2
                                ; but ES: is still pointing to part 1
        MOV     SI,B_BOOT_FAIL_MSG-(B_MY_BOOT_CODE-3eh)
                                ; Reboot did not take, try reboot from floppy.
        CALL    B_DISPLAY_BOOT_STRING

; Wait for user to reboot
B_WAIT:
        XOR     AH,AH
        INT     16h
        jmp     B_WAIT
; now reboot, hopefully to a different floppy.


B_PART3 LABEL   BYTE
        ; This code will be moved into some free space in the vector table.
        ; at this point have tos = ip, cs, flags
        PUSHF
        mov     cs:[StealInt*4+(B_SaveAH-B_Part3)],AH
        mov     cs:[StealInt*4+(B_SaveDL-B_Part3)],DL
        CMP     DL,01                   ; Int 13 interceptor to swap A: and B:
        JA      B_NOTAORB               ; will be plopped on top of Int vects 50-52
        XOR     DL,01                   ; swap a: and b:
B_NOTAORB:
        ; when get join int 13 will have tos =  hereip, cs, flags, ip, cs, flags
        db      09ah                    ; CALL far 9A jump offset:seg
B_OLD_INT13 LABEL WORD
        dw      0,0                     ; patched with jump to old INT 13
        ; when return have ip, cs, orig flags
        PUSHF
        CMP     BYTE PTR CS:[StealInt*4+(B_SaveAH-B_Part3)],08
        JE      B_DontRestoreDL
        MOV     DL,CS:[StealInt*4+(B_SaveDL-B_Part3)]
B_DontRestoreDL:
        POPF
        RETF    2       ; ignore flags buried in stack
B_SaveAH        db      0
B_SaveDL        db      0
B_END_PART3 LABEL BYTE

; = = = = = = = = = = = = = = = = = = = = = =

B_DISPLAY_BOOT_STRING   PROC    NEAR

;       Display a string on the screen while in midst of boot.
;       No DOS services yet.  Diskette may boot on XT, so can't use AT BIOS.
;       On Entry DS:SI points to null-terminated string
;       trashes AX BX SI

B_NEXTCHAR:
        LODSB                   ; get next char of error message
        TEST    AL,AL
        JZ      B_STRINGDONE    ; done when hit 0 at    end
                                ; of string
        MOV     BX,7            ; white on blue colour, mono safe
        MOV     AH,0Eh          ; display one char
        INT     10h             ; video i/o
                                ; handles 07 beep too
        JMP     B_NEXTCHAR
B_STRINGDONE:
        RET

B_DISPLAY_BOOT_STRING   ENDP

; = = = = = = = = = = = = = = = = = = = = = =


B_BOOT_ERR_MSG:
        CR
        CR      ' rebooting from B: ۲'
        CR
        EOS

B_BOOT_FAIL_MSG:
        DB      07h             ; beep
        CR      ' ERROR ۲ B: boot failed.'
        CR
        CR      'Remove disks and hit the Reset button.'
        CR
        EOS

B_KILROY:
                                        ; can see it only with a hex editor
                                        ; copyright message for our reboot code.
ifdef   Registered
        DB      'LAUNDER 3.0 UNREGISTERED'
else
        DB      'LAUNDER 3.0 REGISTERED'
endif
        CR
        DB      '(c) 1992-1999 Canadian Mind Products'
        CR
        DB      '#208 - 525 Ninth Street, New Westminster, BC Canada V3M 5T9',13,10
        DB      'tel:(604) 777-1804   mailto:roedy@mindprod.com   http://mindprod.com',13,10

                                                ; If you make this section too long,
        CR                                      ; it will simply be chopped to
        DB      0                               ; fit.


B_ENDMY_BOOT:
; ==========================================================

        ASSUME  CS:NOTHING

;=============================================
;       G E N E R A L   M E S S A G E S
;=============================================

;   General Display Strings


copyrightmsg    label   byte

ifdef   Registered
 CR ' LAUNDER 3.0 ۲  REGISTERED to '
 db     Owner
else
 CR ' LAUNDER 3.0 ۲  UNREGISTERED 30-day trial version'
endif
 CR
 CR 'Quickly Launders (erases/reformats) a pile of diskettes to be recycled.'
 CR 'Copyright Roedy Green Canadian Mind Products 1992,1998.'
 CR 'May be freely distributed and used for any purpose except military.'
 CR
 CR 'You may hit the SPACE BAR at any time to redo to current diskette.'
 CR 'You may hit the ESC key at any time to QUIT.'
 eos

ifdef   Registered
ThanksMsg       Label   byte

        CR      'Thanks for registering your copy of LAUNDER.'
        CR      'Only a handful of people are as honest as you.'
        CR
        EOS
else
        ThanksMsg               label   byte
        CR      'Ŀ'
        CR      ' LAUNDER is NOT a free program. '
        CR      ''
        CR
        CR      'Please register LAUNDER by sending a cheque or money order'
        CR      'for $10 in either American or Canadian funds'
        CR
        DB      'TO:'
        CR
        DB      'LAUNDER REGISTRATIONS'
        CR
        DB      'Roedy Green'
        CR
        DB      'Canadian Mind Products'
        CR
        DB      '#208 - 525 Ninth Street, New Westminster, BC Canada V3M 5T9'
        CR
        DB      'tel:(604) 777-1804   mailto:roedy@mindprod.com   http://mindprod.com'
        CR
        CR      'In return we will send you the registered version of LAUNDER'
        CR      'with source code.'
        CR
        CR      'Thanks for trying Launder!'
        CR
        EOS
endif
        CR
        EOS

InsertEraseMsg  Label   Byte
        CR      'Please insert a diskette to be erased in '
DrPatch1        db      'A:'
        EOS

InsertKeepMsg Label Byte
        CR      'Please insert a diskette to be tidied in '
DrPatch2        db      'A:'
        EOS

InsertSecureMsg Label Byte
        CR      'Please insert a diskette to be security wiped in '
DrPatch3        db      'A:'
        EOS

InsertGovtMsg Label Byte
        CR      'Please insert a diskette to be government ultra-security wiped in '
DrPatch4        db      'A:'
        EOS

StallMsg        label   byte
        CR      'If the erase stalls, hit the space bar.'
        EOS

bootBMsg        label byte
        CR      'This disk will reboot from B: when booted in A:'
        EOS

WakeMsg Label   Byte
        CR      'Then HIT THE SPACE BAR.'
        EOS

WipingMsg       Label   Byte
        CR      '/Secure wiping data from the diskette...'
        EOS

Govt1Msg                Label   Byte
        CR      '/Government pass 1 wiping data from the diskette...'
        EOS
Govt2Msg                Label   Byte
        CR      '            pass 2 wiping data from the diskette...'
        EOS

Govt3Msg                Label   Byte
        CR      '            pass 3 wiping data from the diskette...'
        EOS

GovtVerifyMsg           Label   Byte
        CR      '            pass 4 verifying the erasure...'
        EOS

FatBlobMsg      label   Byte
        db      8,'',0  ; backspace over prev thin blob, then chr(219) blob.

ThinBlobMsg     label   Byte
        db      '',0  ; chr(221) blob.

AskKillMsg      label   Byte
        CR      'Do you want to erase this disk? (Y)es or (N)o?'
        EOS

AskScatMsg      label   Byte
        CR      'Do you want to update the boot record on this disk? (Y)es or (N)o?'
        EOS

ErasingMsg      label   byte
        CR      'All directories and files erased.'
        EOS

KeepMsg         label   byte
        CR      '/Keep tidied the boot record but left the files intact.'
        EOS

IntactMsg       label   byte
        CR      'Leaving the diskette intact.'
        EOS

ThermoStage     db      0       ; 0 -- use Thinblob
                                ; 1 -- do nothing
                                ; 2 -- use fatBlob
                                ; 3 -- do nothing
                                ; so we can fit a 300-char thermo on a line
                                ; it grows by 4 increments per column
RemoveMsg       Label   Byte
        CR
        CR      'Please remove the diskette from '
DrPatch5        db      'A:'
        EOS

NcacheMsg       Label   Byte
        CR      'Please be patient.  Waiting for Norton Cache to flush.'
        EOS

DotMsg          label   Byte    ; used in creating filenames
        DB      '.',0

SpacesMsg       label   Byte    ; used in creating filenames
        DB      '               ',0

LSqMsg          label   Byte    ; used in creating dirnames
        DB      '[',0

RSqMsg          label   Byte    ; used in creating dirnames
        DB      ']',0

CRMsg           label   Byte
        EOS

FilesOnLine     db      0       ; used to put 5 files/line

;=============================================
;       E R R O R   M E S S A G E S
;=============================================

UsageMsg                label   byte
        CR      'Error in command line.'
        CR      'Try LAUNDER A: or LAUNDER B: or 3: or 4:'
        CR      'Or LAUNDER A: /Govt /Keep /Prompt /Quiet /Secure /BootB /Full'
        CR      'no other options are implemented yet.'
        EOS


NoXTMSG                 label   byte
        CR      'Sorry, this version of LAUNDER does not work on XT computers.'
        EOS

NoDOS4MSG               label   byte
        CR      'Sorry, LAUNDER runs afoul of bugs in DOS 4.  Try DOS 3.3, 5.0 or 6.0.'
        EOS

MissingChangeLineMsg            label   byte
        CR      'Sorry, LAUNDER does not work on XT-style diskette drives.'
        CR      'It needs changeline support.'
        CR      'Windows-95 bugs may be interfering.  Try DIR on that'
        CR      "floppy to clear Win-95's pea brain and try again."
        CR      "If even that does not work, reboot to DOS mode."
        EOS

MissingDriveMsg                 label   byte
        CR      'Sorry, but there is no '
DrPatch6        db      'A:'
                db      ' floppy drive.'
                EOS

PartlyFormattedMsg      label   byte
        CR      'This diskette is only partly formatted.'
        CR      'Optionally bulk erase, then reformat, then optionally relaunder.'
        EOS

VirginMsg               label   byte
        CR      'Diskette cannot be read.  Possibly it has not yet been formatted.'
        CR      'Optionally bulk erase, then reformat, then optionally relaunder.'
        EOS

BadMediaMsg     label   byte
        CR      'Media type information in the boot sector is damaged.'
        EOS

BadFatMsg       label   Byte
        CR      'Damaged FAT (File Allocation Table) on diskette.'
        EOS

MinorDamageMsg  label   Byte
        CR      'Minor damage to boot track being corrected.'
        EOS

IsNortonMsg     label   Byte
        CR      'This diskette contains an uneraseable proprietary Norton Backup.'
        EOS

BadStatusMsg    label   Byte
        CR      'DEBUG: Diskette BIOS status is '
        db      0

BadWriteMsg     label   Byte
        CR      'Cannot write successfully.'
        CR      'Diskette may be damaged or only partly formatted.'
        EOS

;       for 3.5" write-protected diskettes
AddTabMsg       Label   Byte
        CR      'Write-protected diskette.'
        CR      'You might slide the write-enable tab to cover the hole'
        CR      'in the upper right corner (some might call it the lower left)'
        CR      'and try that diskette again.'
        EOS

;       for 5.25" write-protected diskettes
RemoveTabMsg    Label   Byte
        CR      'Write-protected diskette.'
        CR      'You might remove the write-protect tab from the upper right corner'
        CR      'and try that diskette again.'
        EOS

RemovedTooSoonMsg       Label   Byte
        CR      'Erase failed.  You took the diskette out too soon.'
        CR      'Please reinsert that diskette, or some other.'
        EOS

FlawedMsg       label   Byte
        CR      'Diskette has bad data clusters.  Consider discarding it.'
        EOS

CantWipeMsg     label Byte
        CR      'Unable to erase all the        data on the diskette.'
        CR      'Cut this diskette into tiny pieces.  Do not recycle!'
        EOS

FailedMsg       label   Byte
        CR      'Either discard this diskette,'
        CR      'or try bulk erasing, then reformatting, then relaundering.'
        CR      'If you simply pulled the diskette out too soon, try it again.'
        EOS
;=====================================
;       D I S K E T T E   S T A T U S   E R R O R   M E S S A G E S
;=====================================

TimeOutMsg      label   byte
        CR      'Technically, the drive failed to respond and timed out.'
        EOS

BadSeekMsg              label   byte
        CR      'Technically, a drive seek failed.'
        EOS

BadNecMsg       label   byte
        CR      'The NEC diskette controller failed.'
        EOS

BadCRCMsg       Label   byte
        CR      'Technically, a bad CRC, evidence of a garbled read.'
        EOS

BadDMAMsg       label   byte
        CR      'DMA boundary error.  Please report this problem to the author.'
        EOS

RecNotFoundMsg  label   byte
        CR      'Technically, a sector is missing on the disk.'
        EOS

BadAddrMarkMsg  label   byte
        CR      'Technically, a formatting header mark is missing.'
        EOS

BadCMDMsg       label   byte
        CR      'BIOS rejected a command.  Please report this problem to the author.'
        EOS

UnknownStatusMsg        label   byte
        ;;      xx      ; emitted by SayHexByte
        db      ' Unknown error.  Please report this problem to the author with the error number.'
        EOS

;=====================================
;       T I M E   V A R I A B L E S
;======================================

TimeOut         EQU     364             ; time to keep motors going in
                                        ; ticks, about 20 secs
                                        ; 1 second = 18.2 ticks

LastActivity    DD      0               ; time in ticks since midnight
                                        ; when user list put disk in or out.

TimeNow         DD      0               ; time now in tick since midnight


;======================================
;   K E Y B O A R D   V A R I A B L E S
;======================================

Old1BVect       DD      0               ; old 1B Ctrl-Break vector
                                        ; we temporarily take it over

;======================================
;    S C R E E N   V A R I A B L E S
;======================================

                EVEN
LastRow         db 24   ; last row on screen 0..24

LastCol         db 79   ; last col on screen 0..79

charcount       dw 0    ; used in building strings

MONO            DB 0    ; -1 = if vmode 0,2 or 7 where we use grays
                        ;  0 = use colours

NcachePresent   db 0    ; -1 if Norton Cache detected

ColourScheme    Label   Word
                        ; pair: Border as lsb and Screen as msb
                        ; used for mono too

BorderAttrib    db 07   ; screen border colour
                        ; i rgb

ScreenAttrib    db 07   ; start with safe attribute
                        ; b rgb i rgb
                        ;  back  fore

OrigColourScheme dw 0707
                        ; screen:border pair use had to start
                        ; We need to restore it on exit.
                        ; border is lsb.


;======================================
;    C O M M A N D   L I N E   S W I T C H E S
;======================================

ParmIndex       dw      0

SlashFull       DB      0       ; -1 = /Full switch
                                ; check that disk is fully formatted
                                ; by reading the last track.

SlashBootB      DB      0       ; -1 = /BootB switch
                                ; boot from B: instead of C: when accidentally
                                ; boot a treated floppy.

SlashGovt       DB      0       ; 1 = /Government switch -- cover up all files w
                                ; char(246) chars as well as empty space.
                                ; 0 = just logically erase files.  Don't bother
                                ; to wipe them.  Just erase the directory
                                ; and FAT entries.
                                ; Erases entire surface
                                ; multiple times to make it
                                ; very difficult to recover
                                ; data, even with special spy
                                ; analog equipment.  However,
                                ; even with the /Government
                                ; option the KGB or CIA could
                                ; still probably reconstruct
                                ; your data.  It uses the
                                ; American D.O.D. standard
                                ; 5220.22M.  It overwrites the
                                ; data first with 0s then with
                                ; 1s, three times.  Then it
                                ; overwrites the area with a
                                ; random value and verifies the
                                ; last write.  This is for
                                ; confidential, not secret
                                ; data.  Finally the contents are
                                ; erased to chr(246).

SlashKeep       DB      0       ; -1 = /Keep switch  -- do not erase files,
                                ;      just build a clean boot block.
                                ;  0 = erase all files.

SlashPrompt     DB      0       ; -1 = /Prompt switch --  display files
                                ;      before erasing.
                                ;  0 = erase without confirmation

SlashQuiet      DB      0       ; -1 = /Quiet switch  -- no sound
                                ;  0 = make usual strange sounds to let
                                ;      user work without watching the screen.

SlashSecure     DB      0       ; -1 = /Secure switch -- cover up all files with
                                ;      char(246) chars as well as empty space.
                                ;  0 = just logically erase files.  Don't bother
                                ;      to wipe them.  Just erase the directory
                                ;      and FAT entries.


;======================================
;    D M A   B U F F E R   V A R I A B L E S
;======================================

;  Pointers to interesting places in the DMA buffer -- first two tracks

BuffSeg         dw      seg Buffer
                                ; where buffer itself is
                                ; ES points to buffer usually.

BootOff         dw      0       ; offset of boot in buffer in bytes
BootStart       dw      0       ; offset of boot on disk in sectors
BootLen         dw      1       ; length of boot in sectors
BootSize        dw      512     ; length of boot in bytes

Fat1Off         dw      0       ; offset of FAT1 in buffer in bytes
Fat1Start       dw      1       ; offset of FAT1 on disk in sectors
Fat1Len         dw      ?       ; length of FAT1 in sectors
Fat1Size        dw      ?       ; length of FAT1 in bytes

Fat2Off         dw      0       ; offset of FAT2 in buffer in bytes
Fat2Start       dw      1       ; offset of FAT2 on disk in sectors
Fat2Len         dw      ?       ; length of FAT2 in sectors
Fat2Size        dw      ?       ; length of FAT2 in bytes

RootOff         dw      ?       ; offset of root dir in buffer in bytes
RootStart       dw      ?       ; offset of root dir on disk in sectors
RootLen         dw      ?       ; length of root dir in sectors
RootSize        dw      ?       ; length of root dir in bytes

OverheadLen     dw      ?       ; sum total of boot+fat1+Fat2+root

;======================================
;    B I O S   I / O   V A R I A B L E S
;======================================
DTA             dd      0       ; offset of i/o buffer for a given i/o
                                ; segment of i/o buffer

DriveNo         DB      0       ; A:=0 B:=1 floppy drive
                                ; 3:=2 4:=3
                                ; which floppy we are working on.

LogSector       dw      0       ; 0..nnn where to start writing
LogCount        dw      0       ; 0..nnn count of logical sectors to write
PhysTrack       db      0       ; 0..79  track to start i/o
PhysHead        db      0       ; 0..1   head to start i/o
PhysSector      db      0       ; 0..14  sector to start i/o, 0-based!
PhysCount       db      0       ; 0..15  count of sectors to i/o
IOcode          db      02      ; 2=read 3=write 4=verify
WholeBuffer     dw      -1      ; -1 = normal, use the whole buffer
                                ;  0 = do i/o only recycling the first track
                                ;      of the buffer for multi-track i/o --
                                ;      e.g. for clearing or verifying.
NECStatus       db      7 dup (0)       ; 7 bytes sensed status from
                                        ; physical floppy drive

BIOSStatus      db      0       ; diskette status according to BIOS
                                ; hex
                                ; 00 = ok
                                ; 01 = bad cmd
                                ; 02 = bad addr mark
                                ; 03 = write protect
                                ; 04 = record not found
                                ; 05 = ?
                                ; 06 = media change
                                ; 07 = ?
                                ; 08 = DMA overrun
                                ; 09 = DMA boundary
                                ; 10 = bad CRC
                                ; 20 = NEC controller failure
                                ; 40 = bad seek
                                ; 80 = timeout


;======================================
;    D I S K   G E O M E T R Y   V A R I A B L E S
;======================================

BestBPB         DW      0       ; pointer to best model BPB
BestDesc        DW      0       ; pointer to best model description string
BestSound       DW      0       ; pointer to sound routine
BestCounter     DW      0       ; pointer to counter for that type
SectsPerTrack   dw      18      ; 8..18  sectors per track
Heads           dw      2       ; 1..2   number of sides
Cyls            dw      80      ; 40..80 number of cyls per disk
RootEntries     dw      224     ; 64.. 224 number of directory entries in root
SectsPerFat     dw      9       ; 1..9 sectors per FAT
SectsPerClust   dw      2       ; 1..2 sectors per cluster
MaxClust        dw      0       ; last cluster number.
                                ; i.e. # of clusters usable by files
                                ; plus 1 since we start numbering
                                ; with cluster 2.
                                ; there are always an integral number
                                ; of clusters on the disk, though not
                                ; necessarily an EVEN number.
Imperfect       DW      0       ; count of flaws (bad clusters)
                                ; 0 = disk is perfect

;======================================
;       U S A G E   M O N I T O R I N G   V A R I A B L E S
;======================================

CountYellow     DW      0       ; count 360 KB diskettes successfully processed
CountRed        DW      0       ; count 1.2 MB diskettes successfully processed
CountBlue       DW      0       ; count 720 KB diskettes successfully processed
CountGreen      DW      0       ; count 1.44 MB diskettes successfully processed
CountCyan       DW      0       ; count 1.76 MB Diskettes successfully processed
CountOther      DW      0       ; count other diskettes successfully processed
CountUnprocessed DW     0       ; count of diskettes not touched.
CountTotal      dw      0       ; how many disks processed in total.

CountTypes      DW      0       ; how many distinct types represented

CountMsg        db 0dh,0ah,'Disks processed: ',0
CountYellowMsg  db ' x 360KB   ',0
CountRedMsg     db ' x 1.2MB   ',0
CountBlueMsg    db ' x 720KB   ',0
CountGreenMsg   db ' x 1.44MB  ',0
CountCyanMsg    db ' x cyan    ',0
CountOtherMsg   db ' x other   ',0
CountTotalMsg   db ' in total  ',0
data    EndS

Code    Segment

;======================================
;   M A I N L I N E   R O U T I N E
;======================================

        ASSUME  CS:Code,DS:Nothing,ES:nothing,SS:Stack

MAIN    Proc    Near
Beginning:
                                ; This is an EXE file, and this is the
                                ; first instruction of program executed.
                                ; CS:IP points to Beginning
                                ; SS:SP points to stack
                                ; DS: ES: point to PSP

        mov     ax,SEG Data
        mov     DS,ax

        ASSUME  CS:Code,DS:Data,ES:nothing,SS:nothing
                                        ; ES:points to PSP
        Call    InitTheWorks            ; parse command line
                                        ; initialize everything

        ASSUME  ES:Buffer               ; for all our i/o.
        call    PleaseInsert            ; ask for first diskettee
        JMP     InsertTimeout           ; get started by treating as though
                                        ; had timed out, and need space to start.

;       M A I N   L O O P

INSERTANOTHERDISK:

        Call    PleaseInsert            ; prompt user to insert a disk

WAITFORINSERT:
        Call    InsertDisk              ; wait for a disk to be inserted.
                                        ; Might not be readable though.

        Call    TestDisk                ; Some disk has just been inserted.
                                        ; read the first sector
GOTDISK:
        Call    ProcessDisk             ; classify disk, and put new
                                        ; boot track on, erase files etc.
        Call    ShowCounts

REMOVE:

        Call    PleaseRemove            ; ask the user to remove the disk
        call    DoneTone                ; make gentle noise to attract attn
        Call    RemoveDisk              ; wait till user removes diskette.

        jmp     INSERTANOTHERDISK       ; Start with Probes, not a Prod.
                                        ; We don't want BIOS to lose track
                                        ; of kind of disk last read.
;       E N D    M A I N   L O O P

;=============================================
;       S P E C I A L   E X E C E P T I O N S
;=============================================

;       Jump to them, not called.

PROD:

;       user just prodded us by hitting the space bar.
;       That means try reading the disk again.

        Call    PleaseInsert            ; ask user to insert a disk,
                                        ; then hit Space to start

        Call    TickleTimer             ; user prodded us, presumably because
                                        ; a disk is ready and we did not
                                        ; notice.  So we use BIOS to read.
        Call    ReadBootViaBIOS         ; make BIOS try various data rates
                                        ; to read the boot record.
        jnc     GOTDISK
        jmp     WAITFORINSERT

;=============================================

INSERTTIMEOUT:
REMOVETIMEOUT:

        ; user went to sleep at the switch

        call    SleepTillProd           ; wait till user hits SPACE to continue
                                        ; prompt user telling him how to wake up.
        JMP     Prod

;=============================================

FAILED:
;       We were unable to categorize or process this disk.

        Call    MakeExcuse              ; dx points to English text of
                                        ; an excuse.
                                        ; DON'T call ClearError. That would
                                        ; stop the motors and make it
                                        ; impossible to tell when disk
                                        ; removed.
        jmp     REMOVE

;=============================================
DESTROYIT:
;       We need to destroy this disk since we could not do a
;       /SECURE or /GOVERNMENT data wipe.

        lea     dx,CantWipeMsg
        call    Say                     ; Cut it into pieces
        Call    PrangTone
        jmp     REMOVE

;=============================================
PARTIALFORMAT:
;       Diskette is only partly formatted
;       failed a /FULL type check

        lea     dx,PartlyFormattedMsg
        call    Say
        call    PrangTone
        jmp     REMOVE

;=============================================

WRITETROUBLE:

;       We had some trouble with a write,  analyse it

        cmp     BIOSStatus,3h           ; code 3 = write protected
        je      IsWriteProtected        ; write protect tab is on for 5.25, off
                                        ; for 3.5"
        cmp     BIOSStatus,6h           ; code 6 = media removed
        je      RemovedTooSoon

        cmp     BIOSstatus,80h          ; code 80 = disk timed out -- probably
        je      RemovedTooSoon          ; disk removed.

BadWrite:
        public  BadWrite                ; so can breakpoint in debugging

        Call    SayStatus               ; display what went wrong

        lea     dx,BadWriteMsg          ; else, report
        JMP     FAILED

;===================

IsWriteProtected:

;       Could not write on disk, was protected.

        call    GetDriveType
        ; BL = drive type 01=360 02=1.2 03=720 04=1.44 05=2.88
        cmp     bl,02
        jle     RemoveTab
        lea     dx,AddTabMsg            ; 3.5" disk, need tab
        jmp     SayTab
RemoveTab:
        lea     dx,RemoveTabMsg         ; 5.25" disk, must remove tab.
SayTab:
        call    say                     ; ask to remove tab and try again
        Call    EhTone                  ; noise to warn did not erase
        jmp     REMOVE

;=============================================

RemovedTooSoon:

;       Took disk out too soon.

        lea     dx,RemovedTooSoonMsg
        call    say                     ; ask to try again
        Call    EhTone                  ; noise to warn did not erase
        jmp     WAITFORINSERT

;=============================================

IsVirgin:

;       we just found a Virgin disk

        lea     si,DVirgin
        call    DiskIs
                                        ; to set up appropriate noise to
                                        ; celebrate the discovery of a
                                        ; virgin.
        Call    DisplayFloppyType
        lea     dx,VirginMsg
        Call    say
        jmp     REMOVE                  ; We don't jump to FAILED because
                                        ; the general message is too harsh
                                        ; for describing virgins.

;=============================================

IsUnknown:

;       We just found an Unknown disk with strange media byte

        lea     si,DUnknown
        call    DiskIs
                                        ; to set up appropriate noise to
                                        ; celebrate the discovery of the
                                        ; Norton proprietary diskette
        Call    DisplayFloppyType
        lea     dx,BadMediaMsg          ; media type byte damaged

        jmp     FAILED

;=============================================

IsNorton:

;       We just found a Proprietary Norton disk


        lea     si,DNorton
        call    DiskIs
                                        ; to set up appropriate noise to
                                        ; celebrate the discovery of the
                                        ; Norton proprietary diskette
        Call    DisplayFloppyType

        lea     dx,IsNortonMsg          ; it is a Norton PROPRIETARY Backup disk

        jmp     FAILED


;=============================================



Quit:
;       Stop LAUNDER
        Call    ShutDownDisk            ; close up shop
        Call    EnableNcache

        Call    ShutDownVideo           ; Put video back the way it was
        Call    ShutDownKeyboard        ; restore int 1Bh vector
        lea     dx,ThanksMsg            ; Thank user for trying launder
        call    say
        mov     ax,4c00h                ; exit back to DOS
        int     21h

MAIN    EndP

;=============================================

InitTheWorks    Proc    near

;       initialize LAUNDER, parse command line

        Call    TrapBreak               ; Trap Ctrl-Break
        Call    FlushKeystrokes         ; get rid of any pre-typed keystrokes
                                        ; especially Ctrl-Break
        Call    InitVideo               ; prepare video screen for use
        Call    InitDisk                ; prepare diskette for manual control
        Call    Banner                  ; Announce ourselves
        Call    Parse                   ; parse the command line to get all parms
        Call    PatchDrive              ; patch drive letter into prompts

        Call    Conflicts               ; resolve /Secure /Government conflict
        Call    NoXT                    ; No XTs please
        Call    NoDOS4                  ; No DOS 4.x please
        Call    MustSupportChangeline   ; No old XT-style drives

        Call    Alignbuffer             ; Align buffer so does not cross
                                        ; a DMA boundary
                                        ; from now on ES: covers DMA buffer
        Call    DisableNcache
        ret

InitTheWorks    EndP

;=============================================

InsertDisk      Proc    Near

;       Get a disk inserted, might not be readable though

TryAProbe:
        Call    CheckTimer
        jcL     INSERTTIMEOUT           ; timer expired waiting for insert

        Call    KeepMotorOnViaCheat     ; Make sure motor stays on
        Call    CheckForProd            ; allow user to prod us or
                                        ; stop the whole show
        jcL     PROD                    ; allow user to stop the show
                                        ; or prod it back to life
                                        ; if it stalls.
        Call    ProbeViaPorts           ; make sure can read at least
                                        ; something on the disk.
                                        ; no noisy recalibrate
                                        ; can read either data rate.

        jc      TryAProbe               ; if fail, keep trying till some
                                        ; disk inserted.
                                        ; Will pass as ok, even if bad
                                        ; read.
                                        ; allow to process same disk
        ret                             ; We have some sort of disk,
                                        ; possibly unreadable.
        InsertDisk      EndP

;=============================================

Testdisk        Proc    Near

;       Try reading sector 1 to test the disk

                                        ; We know some disk is present.
        Call    PleaseWait              ; invite user to hit Space bar
                                        ; to prod the erasure.
                                        ; However, it should take off by
                                        ; all by itself without any prod.
        Call    ReadBootViaBIOS         ; ensure have good read of boot
        jcL     IsVirgin
        ret                             ; we read the disk ok
                                        ; if did not get a good read in
                                        ; three tries, something is very
                                        ; wrong.  Probably disk is unformatted.
TestDisk        EndP

;=============================================

ProcessDisk     Proc    Near

;       we have just managed to read the first sector of a new disk.
;       Completely process it, but don't ask the user to remove it.

        Call    TickleTimer
        Call    SnaffleDiskGeom         ; save best guess at disk geometry so far
        Call    Handle_Norton           ; Check for Norton Proprietary
        mov     al,Boot_BPB.BP_MediaByte
        call    Guess                   ; What kind of diskette is it?
                                        ; DX points to string of English
                                        ; describing the floppy type
        Call    DisplayFloppyType       ; tell user kind of floppy we discovered.

        Call    DetectDamage            ; warn user of damage we
                                        ; are about to fix.

        Call    Build_DOS6_Boot         ; Build new DOS6.0 boot block in RAM
                                        ; from scratch.

        Call    SnaffleDiskGeom         ; save improved guess at geometry

        Call    ReadOneFATViaBIOS       ; read one copy of FAT
        Call    EraseFAT1               ; erase all FAT1 entries except bad clusters
                                        ; in RAM copy
        Call    DupFat                  ; make a duplicate copy of FAT1 in FAT2

        Call    ReadRootDir             ; read list list of files if required

        test    SlashPrompt,-1
        jz      AvoidPrompting
        Call    PromptToKill            ; display list of files
                                        ; ask user if ok to erase
                                        ; carry = yes
        jc      AvoidPrompting          ; YES, jump
        lea     dx,IntactMsg            ; NO
        Call    Say
        jmp     BypassProcessing        ; Ask user for ok to erase
AvoidPrompting:                         ; Yes: erase  No: leave alone
                                        ; Not even boot is changed -- might
                                        ; have a special boot track.

        test    SlashBootB,-1
        jz      NotBootB
        lea     dx,BootBMsg
        call    Say
NotBootB:

        test    SlashKeep,-1
        jz      NotKeep
        lea     dx,KeepMsg
        call    Say
        call    KeepVolLab              ; resync boot VolLab from one in
                                        ; directory.  Could not do it
                                        ; earlier because DIR not yet read.
        Call    WriteBootViaBios        ; just change boot rec
        jmp     short ProcessDiskDone
NotKeep:

        lea     dx,ErasingMsg
        call    Say
        Call    EraseRootDir            ; build a long string of 0s for rootdir
                                        ; in RAM
        Call    WriteTheWorksViaBios    ; write boot, 2 fats and dir

        test    SlashSecure,-1
        jz      NotSecure
        Call    SecureWipe              ; for /SECURE erase entire disk
NotSecure:

        test    SlashGovt,-1
        jz      NotGovt
        Call    GovtWipe                ; for /Govt erase entire disk
NotGovt:

ProcessDiskDone:

        test    SlashFull,-1
        jz      NoSlashFull
        call    FullCheck
NoSlashFull:

        mov     bx,BestCounter          ; count diskettes processed.
        inc     word ptr [bx]           ; address of counter
                                        ; for that disk type
BypassProcessing:
        ret

ProcessDisk     EndP

;=============================================

RemoveDisk      Proc    Near

;       get the diskette removed

FLUSHPRODS:                             ; flush out any prodding keystrokes.
        Call    CheckForProd            ; ignore any except ESC
        jc      FLUSHPRODS

WAITTILLREMOVE:
        Call    CheckTimer
        jcL     REMOVETIMEOUT           ; timer expired waiting for remove
        Call    KeepMotorOnViaCheat     ; Make sure motor stays on
        Call    CheckForProd            ; allow user to prod us or
                                        ; abort the whole show
        jcL     PROD                    ; changeline screwed up somehow,
                                        ; let user prod us to read new disk
        Call    ChangeLineViaPorts      ; see if disk removed yet
        jnc     WAITTILLREMOVE
        Call    ProbeViaPorts           ; see if new disk
        jnc     WAITTILLREMOVE          ; if did not fail, disk is still
                                        ; inserted.  He has not removed it yet

; HURRAY! probe failed.  This means the disk has finally been removed.
        Call    TickleTimer

        ret                             ; on return will carry on at
                                        ; WaitforInsert

RemoveDisk      EndP

;=============================================

ShowCounts      Proc

        lea     dx,CountMsg
        call    Say

        mov     CountTypes,0

        mov     ax,CountYellow          ; calc UseCount
        add     ax,CountRed
        add     ax,CountBlue
        add     ax,CountGreen
        add     ax,CountCyan
        add     ax,countOther
        mov     CountTotal,ax

        mov     ax,CountYellow
        test    ax,ax
        jz      NoYellows
        inc     CountTypes
        call    SayDec
        lea     dx,CountYellowMsg
        call    Say
NoYellows:

        mov     ax,CountRed
        test    ax,ax
        jz      noReds
        inc     CountTypes
        call    SayDec
        lea     dx,CountRedMsg
        call    Say
NoReds:

        mov     ax,CountBlue
        test    ax,ax
        jz      NoBlues
        inc     CountTypes
        call    SayDec
        lea     dx,CountBlueMsg
        call    Say
NoBlues:


        mov     ax,CountGreen
        test    ax,ax
        jz      NoGreens
        inc     CountTypes
        call    SayDec
        lea     dx,CountGreenMsg
        call    Say
NoGreens:



        mov     ax,CountCyan
        test    ax,ax
        jz      NoCyans
        inc     CountTypes
        call    SayDec
        lea     dx,CountCyanMsg
        call    Say
NoCyans:

        mov     ax,countOther
        test    ax,ax
        jz      NoOthers
        inc     CountTypes
        call    SayDec
        lea     dx,CountOtherMsg
        call    Say
NoOthers:

        mov     ax,CountYellow          ; calc UseCount
        add     ax,CountRed
        add     ax,CountBlue
        add     ax,CountGreen
        add     ax,CountCyan
        add     ax,countOther           ; don't include CountUnprocessed
        mov     CountTotal,ax
                                        ; show 0 total, just don't
                                        ; duplicate if only one type.
        cmp     CountTypes,1
        je      NoTotals
        call    SayDec
        lea     dx,CountTotalMsg
        call    Say
NoTotals:

        ret
ShowCounts      EndP

;=============================================
;       K E Y B O A R D   R O U T I N E S
;=============================================


FlushKeystrokes Proc    near

;       Flush pre-typed keystrokes, including Ctrl-Break

IgChars:                        ; flush typeahead buffer
        Call    CheckForBreak   ; Ctrl-Break recently?
                                ; ignore result
        mov     ah,01h          ; test for presence of pre-typed char
        int     16h
        jz      NoMorePending
        mov     ah,0
        int     16h             ; swallow the char
        jmp     Igchars         ; do we need to swallow 2nd half?

NoMorePending:
        ret

FlushKeystrokes EndP

;=============================================

ShutdownKeyboard        Proc    Near

;       Put Ctrl-Break handler back to the way it was.
;       We need to restore int 1Bh.  DOS will restore 23h

        push    DS
        mov     dx,word ptr Old1BVect
        mov     ax,word ptr Old1BVect+2
        ASSUME  DS:nothing
        mov     DS,ax
        mov     ax,251Bh        ; set vector 1B
        int     21h
        pop     DS
        ASSUME  DS:DATA
        ret

ShutdownKeyboard        Endp

;============================================

CheckForProd Proc       Near

;       Checks if has been a keystroke.
;       ESC will terminate program, and space will
;       we treated as a probe, i.e. restart the motors and read the boot.
;       Other characters are ignored with a eep-tone.
;       Return carry if user prodded us with a space bar.
;       Ctrl-Break and Ctrl-C will be treated as ESC

        Call    CheckForBreak
        jc      Stop
        mov     ah,01h          ; test if keystroke avail, using BIOS
        int     16h
        jz      NoChar          ; Jump if no keystroke.
                                ; was char, read it
        mov     ah,0
        int     16h             ; get char result in al, scan in ah
        cmp     al,27           ; is it an esc?
        je      Stop            ; YES, DIE, don't return
        cmp     al,03           ; is it a ctrl-C?
        je      Stop            ; YES, DIE, don't return
        cmp     al,32           ; is it a Space?
        je      Spacechar       ; YES, jump

        Call    IgTone          ; something else, make EEP noise
        clc                     ; and ignore it
NoChar:
        ret

Spacechar:                      ; user hit spacebar
        stc
        ret

Stop:                           ; user hit ESC or Ctrl-Break
        jmp     QUIT

CheckForProd EndP

;=============================================

AskYorN Proc    Near

;       Wait until the user hits Y or N
;       Set carry if yes

WaitForYorN:
        Call    CheckForBreak
        jc      Stop
        mov     ah,00h          ; read/wait for keystroke using BIOS
        int     16h             ; get char result in al, scan in ah
        cmp     al,27           ; is it an esc?
        je      Stop            ; YES, DIE, don't return
        cmp     al,03           ; is it a ctrl-C?
        je      Stop            ; YES, DIE, don't return
        cmp     al,'Y'          ; is it a Y
        je      SaidYes         ; YES, jump
        cmp     al,'y'          ; is it a y?
        je      SaidYes         ; YES, jump
        cmp     al,'N'          ; is it an N?
        je      SaidNo          ; YES, jump
        cmp     al,'n'          ; is it an n?
        je      SaidNo          ; YES, jump
        Call    IgTone          ; something else, make EEP noise
        jmp     WaitForYorN     ; and ignore it

SaidYes:
        stc
        ret
SaidNo:
        clc
        ret

AskYorN EndP

;=============================================

TrapBreak       Proc    Near

;       install our trap for Control Break.  That way Ctrl-Break will
;       be ignored.

        push    DS
        push    ES
        mov     ax,351Bh        ; save old 1B vector
        int     21h             ; result in ES:BX
        mov     word ptr Old1BVect, bx
        mov     word ptr Old1BVect+2, ES
        pop     ES
        push    CS
        pop     DS

        lea     dx,CS:BreakHandler
        mov     ax,2523h        ; set vector 23
        int     21h
        mov     al,1Bh          ; set vector 1B as well
        int     21h
        pop     DS
        ret

WasBreak        DB      0       ; if Ctrl-Break seen recently
                                ; MUST BE IN CODE SEGMENT
                                ; or interrupt handler will not find it.

BreakHandler:                   ; does nothing.  Ignores Ctrl-Break
        mov     CS:WasBreak,-1
        iret

TrapBreak       EndP

;=============================================

CheckForBreak   Proc    Near

;       Checks for Ctrl-Break hit recently
;       Detected two ways -- via INT 1B, and via peeking at low RAM
;       in case BIOS has not yet registered the 1B interrupt
;       Sets carry if break detected.  Clears break.

        test    CS:WasBreak,-1
        jz      NoBreakInt
        mov     CS:WasBreak,0   ; was recent 1B break, clear it.
        stc
        ret
NoBreakInt:

        mov     ax,BIOSDATA     ; check for Break not yet registered
        push    ES              ; as an interrupt
        mov     ES,ax
        assume  ES:BIOSDATA
        mov     al,ES:BIOSbreak
        test    al,80h          ; test bit 7
        jz      NoBreakKey
        and     al,7Fh          ; clear bit 7
        mov     ES:BIOSBreak,al
        assume  ES:NOTHING
        pop     ES
        stc
        ret

NoBreakkey:
        assume  ES:NOTHING
        pop     ES
        clc
        ret

CheckForBreak   EndP

;=============================================

SleepTillProd   Proc    Near

;       Wait until the user hits some key

; ask to prod to wake from sleep
; We don't erase the screen.  We allow the diskette trivia to remain.

        lea     Dx,WakeMsg              ; ask user to prod to wake up
        call    Say

        call    LetMotorStop            ; turn off motor

WaitForProd:
        call    CheckForProd            ; Don't start till user
                                        ; gives the go-ahead, hitting SPACE
        jnc     WaitForProd
        ret

SleepTillProd   EndP

;=============================================
;       S C R E E N   D I S P L A Y   R O U T I N E S
;=============================================

ClearScreen     proc    near

;       use BIOS to clear a window comprising the whole screen
;       on entry ColourScheme contains the foreground, background & border
;       colours.
;       Leaves cursor in top left corner.

        mov     bx,ColourScheme
        push    bx
        Call    SetBorder
        pop     bx
        Call    CalcDimensions  ; calc # rows & cols on screen
        mov     al,0            ; whole screen
        mov     cx,0            ; upper left = 0,0
        mov     dh,LastRow      ; lower right row
        mov     dl,LastCol      ; lower right col
        mov     ah,06           ; scroll up to clear screen
        int     10h
        sub     dx,dx           ; dh=row dl=col
        Call    CursorTo
        ret

ClearScreen     EndP

;===============================================================

CursorTo        Proc    Near

;       move the cursor to dh=row 0..24 dl=col 0..79
;       top left is 0,0

        mov     ah,02           ; set cursor position function
        sub     bx,bx           ; bh =display page
        int     10h             ; bios video
                                ; destroys  AX, SP, BP, SI, DI
        ret

CursorTo        EndP


;===============================================================

CalcDimensions  Proc    Near
;       Calculate the last row & col on the screen
        mov     ax,BIOSDATA
        push    ES
        mov     ES,ax
        assume  ES:BIOSDATA
        mov     al,BIOSLastRow  ; usually 24
        cmp     al,019d         ; if < 20 lines, (0..19) something is wrong
        jb      UseDefaultRow
        mov     LastRow,al
UseDefaultRow:                  ; leave default row 24 (0..24)

        mov     al,BIOSNumCols  ; usually 80
        dec     al              ; convert from cols to last col
        cmp     al,39d          ; if < 40 cols, (0..39) something is wrong
        jb      UseDefaultCol
        mov     LastCol,al
UseDefaultCol:                  ; leave default 80 cols

        pop     ES
        assume  ES:NOTHING
        ret

CalcDimensions  EndP

;===============================================================

SetBorder       Proc    Near
;       set border to defined colour
;       on entry bl contains attribute to use for border
;       in form irgb

        mov     bh,0
        mov     ah,0bh
        int     10h
        ret

SetBorder       EndP

;===============================================================

Say             Proc    Near

;       on entry DS:DX points to a string to display on screen
;       We don't use Int 21h function 9 because that stirs up ANSI.SYS.
;       We cannot use BIOS write string, int 10 function 13h either.
;       This is not supported on the XT.  We want to at least apologize.
;       So we use int 10 function 0E which displays without overwriting
;       the attribute.
;       Trashes ax
;       Leaves a 5 space left margin.  String must be null-terminated.
        push    bx
        push    si
        mov     si,dx
        mov     ah,0Eh
        mov     bl,ScreenAttrib ; dummy screen attribute, ignored in text mode
SayNextChar:
        lodsb                   ; get next char in AL
        cmp     al,0            ; null marks end of string
        je      StringSaid
        cmp     al,0ah          ; is it a linefeed
        je      NewLine
        int     10h
        jmp     SayNextChar

NewLine:
        int     10h
        mov     al,20h          ; 5 spaces after the LF
        int     10h
        int     10h
        int     10h
        int     10h
        int     10h
        jmp     SayNextChar

StringSaid:
        pop     si
        pop     bx
        ret

Say             EndP

;============================================

SayByCount      Proc    Near

;       display a string that does not contain Cr, Lf
;       starts at DS:SI length CX, possibly 0
;       trashes ax
        jcxz    NothingToSay
        push    bx
        push    cx
        push    si
        mov     ah,0Eh
        mov     bl,ScreenAttrib ; dummy screen attribute, ignored in text mode
SayNextCountChar:
        lodsb                   ; get next char in AL
        int     10h
        Loop    SayNextCountChar
        pop     si
        pop     cx
        pop     bx
NothingToSay:
        ret

SayByCount              EndP

;============================================

InitVideo       Proc    Near

;       Save current screen colours so we can put them back later
;       Turn off the blink enable bit so we can have extra background
;       colours.
        mov     ah,0fh          ; find out if colour or gray
        int     10h             ; get current video mode
        mov     mono,0          ; presume colour
        cmp     al,07h          ; vmode 7, 2, 0 are considered mono
        jne     NotVmode7
        mov     mono,-1
NotVmode7:
        cmp     al,02h
        jne     NotVmode2
        mov     mono,-1
NotVmode2:
        cmp     al,00h
        jne     NotVmode0
        mov     mono,-1
NotVmode0:
        mov     bh,0            ; first page
        mov     ah,08h          ; get attribute of char
        int     10h
                                ; al=char ah=attrib

;       We need to get the orginal colourscheme to this format
;              bk  fore     bor
;              bRGBiRGB____iRGB
        mov     al,ah
        shr     al,4
;                  iRGBiRGB____iRGB
        and     ax,0111111100000111b
                                        ; mask off intensity bits in
                                        ; background or border
        mov     OrigColourScheme,ax
        mov     ColourScheme,ax         ; and also use it to get started

;       Allow 16 colours, not just 8 for background
        mov     bl,0
        mov     ax,1003h        ; bios disable blink
        int     10h

                                ; for CGA/MDA BIOS will not work,
                                ; Disable blink manually.
                                ; Clear bit 5 of port 3d8h
        push    ES
        mov     ax,BIOSDATA
        mov     ES,ax           ; get video BIOS data seg
        assume  ES:BIOSDATA
        mov     dx,es:[63h]     ; 3B4 cga or 3D4 mono, base port
        add     dl,4            ; 3D8 or 4D8
        mov     al,ES:[65h]     ; BIOS's idea of 3d8 register
;                  76543210
        and     al,11011111b    ; zero out bit 5, the blink enable
        out     dx,al
        mov     ES:[65h],al     ; keep BIOS up to date on our change
        pop     ES
                ASSUME  ES:NOTHING
        ret

InitVideo       EndP

;============================================


ShutDownVideo   Proc    Near

;       Restore original screen colours
;       Turn blink enable bit back on so blink will work for others.
        mov     ax,OrigColourScheme
        cmp     ax,ColourScheme ; bypass restore if screen is already
                                ; the right colours.  We do this to avoid
                                ; erasing startup error messages.
        je      BypassRestore
        mov     ColourScheme,ax
        call    ClearScreen     ; clear back to original attributes.
                                ; Original special border will turn into
                                ; border to match screen.
BypassRestore:
;       Turn blink back on
        mov     bl,1
        mov     ax,1003h        ; bios enable blink
        int     10h

                                ; for CGA, BIOS might not work,
                                ; Reenable blink manually.
                                ; Set bit 5 of port 3d8h
        push    ES
        mov     ax,BIOSDATA
        mov     ES,ax           ; get video BIOS data seg
        assume  ES:BIOSDATA
        mov     dx,es:[63h]     ; 3B4 cga or 3D4 mono, base port
        add     dl,4            ; 3D8 or 4D8
        mov     al,ES:[65h]     ; BIOS's idea of 3d8 register
;                  76543210
        or      al,00100000b    ; turn bit 5 back on
        out     dx,al
        mov     ES:[65h],al     ; keep BIOS up to date on our change
        pop     ES
        ASSUME  ES:NOTHING
        ret

ShutDownVideo   EndP

;============================================

SayDec PROC     NEAR

;       call with number in range 0..65535 in ax
;       converts it to ASCII and displays it on the screen
;       If it is 0 shows as 0.
;       leading 0's are suppressed.
;       field is exactly wide enough to hold the number.
;       No leading or trailing spaces.  DISPLAYED IN DECIMAL

Data    Segment
Pad             db '00000',0
                        ; where numeric output built by SayDec
                        ; null terminated
Data    EndS

        push    di              ; preserve di
        mov     bx,10D
        mov     di,5            ; work right to left building digits at PAD
SayDecLoop:
        dec     di
        xor     dx,dx           ; dx:ax / 10
        div     bx              ; ax=quot dx=remdr
        add     dl,'0'          ; convert digit to ASCII
        mov     pad[di],dl
        or      ax,ax
        jnz     SayDecLoop
SayDecDone:
;       Number is ready
        lea     dx,pad[di]
        call    Say
        pop     di
        ret
SayDec  endp

;=============================================


Banner  Proc    Near

;       Display the copyright banner
        call    ClearScreen

        mov     dx,0100h                ; dh=row dl=col
                                        ; leave 1 blank line at top
        lea     dx, copyrightMsg        ; Announce ourselves
        Call    Say
        Call    ShowCounts

        mov     dx,0F00h                ; dh=row dl=col
        Call    CursorTo

        ret

Banner  EndP

;============================================


UnBanner        Proc    Near

;       Display a screen without the banner
        call    ClearScreen
        mov     dx,0800h                ; dh=row dl=col
        Call    CursorTo
        ret

UnBanner        EndP

;============================================

PleaseInsert    Proc    Near

; ask user to insert a diskette

        call    Banner
        lea     dx,InsertEraseMsg               ; ask to insert

        test    SlashKeep,-1
        jz      NoKeep
        lea     dx,InsertKeepMsg
NoKeep:
        test    SlashSecure,-1
        jz      NoSecure
        lea     dx,InsertSecureMsg
NoSecure:

        test    SlashGovt,-1
        jz      NoGovt
        lea     dx,InsertGovtMsg
NoGovt:

        call    Say
        ret

PleaseInsert    EndP

;===========================================

PleaseWait      Proc    Near

;       ask user to wait, but hit space bar if erase stalls

        call    Unbanner
        lea     dx,StallMsg             ; Let user know that we noticed
        call    say                     ; his disk is now inserted.
                                        ; and that SPACE will help if stall.
        ret

PleaseWait      EndP

;============================================

DisplayFloppyType       Proc    Near

; display type of disk we have now.

        Call    Unbanner
        mov     dx,BestDesc
        Call    Say
        ret

DisplayFloppyType       EndP

;===========================================

MakeExcuse      Proc    Near

; Explain why we failed
; on entry dx points to excuse message

        call    say             ; say excuse
        lea     dx,FailedMsg
        call    Say             ; consider discarding
        Call    PrangTone
        ret


MakeExcuse      EndP

;===========================================

PleaseRemove    Proc    Near

;       ask user to remove the disk.
;       We don't erase the screen.  We allow the diskette trivia to remain.

        lea     dx,RemoveMsg
        call    Say
        ret

PleaseRemove    EndP

;===========================================

DisplayThermo   Proc    Near

;       display a thermometer, grow by one increment.
;       To keep it to one line, we use thin and fat blobs
;       4 stages per column on the screen

        mov     al,ThermoStage
        cmp     al,0
        je      UseThinBlob
        cmp     al,2
        je      UseFatBlob
        jmp     short NextThermoStage
UseThinBlob:
        lea     dx,ThinBlobMsg
        Call    Say
        jmp     short NextThermoStage
UseFatBlob:
        lea     dx,FatBlobMsg
        Call    Say
NextThermoStage:
        mov     al,ThermoStage
        inc     al
        and     al,3            ; modulo 4
        mov     ThermoStage,al
        ret

DisplayThermo   EndP

;=============================================
;       D I S K E T T E   B I O S   R O U T I N E S
;=============================================

        ASSUME  ES:Buffer

ReadBootViaBIOS Proc    Near

;       reads current boot record
;       Sets carry if some problem with read -- e.g. no disk inserted
;       Does 3 retries, so can should recover if drive not up to speed
;       etc.  DOES try various rate settings, so can recover if
;       type of floppy has changed.

        mov     word ptr dta, 0         ; start of buffer
        mov     word ptr dta+2, ES
        mov     LogSector,0             ; first sector on disk
        mov     LogCount,1              ; read only 1 sector
        Call    ReadViaBios             ; since we are reading first rec,
                                        ; we don't need to know accurate disk
                                        ; geometry yet, e.g. Sects Heads Cyls

        Ret

ReadBootViaBIOS EndP

;===================

WriteTheWorksViaBIOS Proc       Near

;       writes boot record we have built in Boot_Sector
;       followed by two Fats, followed by Root Dir
;       all in one efficient fell swoop.

        mov     word ptr dta, 0         ; starting point
        mov     word ptr dta+2, ES
        mov     LogSector,0             ; start with boot
        mov     ax,OverheadLen          ; sum total of boot+fat1+fat2+rootdir
        mov     LogCount,ax
        Call    WriteViaBios
        jnc     goodwrite               ; if no problem, exit cleanly
        JMP     WriteTrouble
GoodWrite:
        RET

WriteTheWorksViaBIOS EndP

;===================

WriteBootViaBIOS Proc   Near

;       writes boot record we have built in Boot_Sector
;       We don't write any other stuff because we are not erasing files.

        mov     word ptr dta, 0         ; starting point
        mov     word ptr dta+2, ES
        mov     LogSector,0             ; start with boot
        mov     LogCount,1              ; just one sector
        Call    WriteViaBios
        jnc     goodbootwrite           ; if no problem, exit cleanly
        JMP     WriteTrouble
GoodBootWrite:
        RET

WriteBootViaBIOS EndP

;===================

SayStatus       Proc    Near
;       Display diskette status, when it is bad
        mov     al,BiosStatus

        cmp     al,80h
        jne     NotTimeout
        lea     dx,TimeoutMsg
        call    say
        ret
NotTimeout:

        cmp     al,40h
        jne     NotBadSeek
        lea     dx,BadSeekMsg
        call    say
        ret
NotBadSeek:

        cmp     al,20h
        jne     NotBadNEC
        lea     dx,BadNECMsg
        call    say
        ret
NotBadNEC:

        cmp     al,10h
        jne     NotBadCRC
        lea     dx,BadCRCMsg
        call    say
        ret
NotBadCRC:

        cmp     al,09h
        jne     NotBadDMA
        lea     dx,BadDMAMsg
        call    say
        ret
NotBadDMA:

        cmp     al,04h
        jne     NotRecNotFound
        lea     dx,RecNotFoundMsg
        call    say
        ret
NotRecNotFound:

        cmp     al,02h
        jne     NotBadAddrMark
        lea     dx,BadAddrMarkMsg
        call    say
        ret
NotBadAddrMark:


        cmp     al,01h
        jne     NotBadCMD
        lea     dx,BadCMDMsg
        call    say
        ret
NotBadCMD:

;       Something unknown, display in hex
        mov     al,BiosStatus
        Call    SayHexByte
        lea     dx,UnknownStatusMsg
        call    say
        ret

SayStatus       EndP
;===================

ReadViaBios     Proc Near

;       on entry must set LogSector and LogCount to give the 0-based
;       logical sector number and # of sectors to read.  These may span
;       tracks and heads.  The read will automatically be broken into
;       track-sized chunks.  DTA segment:offset must point to buffer
;       Sets carry if read fails.  Does three automatic retries.
;       Buffer may not span 64K DMA boundary.

        mov     iocode,02h              ; int 13 read function code
        mov     WholeBuffer,-1          ; read into complete buffer
        call    ioViaBios
        ret

ReadViaBios     EndP

;======================

WriteViaBios    Proc Near

;       on entry must set LogSector and LogCount to give the 0-based
;       logical sector number and # of sectors to write.  These may span
;       tracks and heads.  The write will automatically be broken into
;       track-sized chunks.  DTA segment:offset must point to buffer
;       Sets carry if write fails.  Does three automatic retries.
;       Buffer may not span 64K DMA boundary.

        mov     iocode,03h              ; int 13 write function code
        mov     WholeBuffer,-1          ; write complete buffer
        call    ioViaBios
        ret

WriteViaBios    EndP

;======================

IOViaBios       Proc    Near

;       on entry must set LogSector and LogCount to give the 0-based
;       logical sector number and # of sectors to read/write.  These may span
;       tracks and heads.  The read/write will automatically be broken into
;       track-sized chunks.  DTA segment:offset must point to buffer
;       Sets carry if read/write fails.  Does TWO automatic tries.
;       I dropped the third to speed up Virgin processing.  Since the disk
;       is nearly always spinning, we don't need to worry as much.
;       Buffer may not span 64K DMA boundary.  Must set iocode to determine
;       if 2=read or 3=write done.

        mov     ThermoStage,0           ; reset therometer
        push    ES
AnotherChunk:
        test    logCount,-1             ; are we done yet?
        jeL     OverallIoSuccess

        test    wholebuffer,-1
        jnz     NoThermoNeeded
                                        ; only for long i/os that recycle
                                        ; the buffer, e.g. /SECURE writes
                                        ; do we need the thermo.
        Call    DisplayThermo           ; grow thermometer by one blob
                                        ; to keep user amused during long
                                        ; i/o.
        Call    CheckForProd            ; give user a chance to abort with
                                        ; ESC or Ctrl-Break
                                        ; but only on wipes, not little writes.
NoThermoNeeded:

        Call    TickleTimer             ; This may take a while, and there
                                        ; is no danger the motors will go off.
        Call    NextChunk               ; get track-sized chunk to i/o

        les     bx,DTA                  ; ES:bx = buffer
        mov     dl,DriveNo              ; set up for read A=0 B=1
        mov     dh,PhysHead             ; dh=head
        mov     ch,PhysTrack            ; ch=track
        mov     cl,PhysSector           ; cl=sector, 1 based
        inc     cl

        mov     al,PhysCount            ; al=count of sectors to read
        mov     ah,IoCode               ; ah=02 read function 03=Write
        int     13h                     ; first try
        mov     BIOSStatus,AH
        jc      FirstIoFailed           ; Phoenix fails to set carry on fail
                                        ; so we must also
        cmp     al,PhysCount            ; compare counts to see if success
        je      ChunkIoSuccess          ; prepare for next chunk
FirstIOFailed:
        call    ClearError
        call    CheckForProd            ; We need to check for ESC
                                        ; deep inside this inner level routine
                                        ; or else would stall too long.
        les     bx,DTA                  ; ES:bx = buffer
        mov     dl,DriveNo              ; set up for read A=0 B=1
        mov     dh,PhysHead             ; dh=head
        mov     ch,PhysTrack            ; ch=track
        mov     cl,PhysSector           ; cl=sector, 1 based
        inc     cl
        mov     al,PhysCount            ; al=count of sectors to read
        mov     ah,IoCode               ; ah=02 read function 03=Write
        int     13h                     ; second try
        mov     BIOSStatus,AH
        jc      SecondIoFailed
        cmp     al,PhysCount
        je      ChunkIoSuccess          ; prepare for next chunk
SecondIOFailed:
        call    ClearError
        stc                             ; WE FAILED TO READ/WRITE
        pop     ES
        ret

ChunkIoSuccess:
        sub     ax,ax
        mov     al,PhysCount
        add     LogSector,ax            ; increment starting point
        sub     LogCount,ax             ; decrement sectors to go
        shl     ax,9                    ; chunksize mult by 512 = 2^9
        and     ax,WholeBuffer          ; convert inc to 0 to recycle
                                        ; the first track of the buffer
                                        ; if needed.
        add     word ptr DTA,ax         ; increment buffer address
        jmp     AnotherChunk

OverallIoSuccess:

        pop     ES
        clc
        ret

IOViaBios       EndP

;======================

NextChunk       Proc    Near

;       Calculates the physical address of the next chunk of a logical i/o.
;       It breaks logical i/o up so they no not span tracks or heads.
;       On entry LogSector and LogCount must be set.
;       On exit PhysTrack, PhysHead, PhysSector and PhysCount will be set
;       ready to do the physical i/o.
;       You know when you are done if Physcount=0.
;       You can also check for Logcount=0 after the i/o.
;       Clobbers dx,ax
;       Does not increment logSector or decrement LogCount.
        call    LogToPhys               ; get start for this chunk of the i/o
        mov     ax,SectsPerTrack        ; sectors/track
        sub     al,PhysSector           ; calc how long this chunk could be
        cmp     ax,LogCount
        jle     FillToEnd
        mov     ax,LogCount             ; don't fill end of track
FillToEnd:
        mov     PhysCount,al            ; ax has size of this chunk
        ret

NextChunk       EndP

;======================

LogToPhys       Proc    Near

;       Computes physical floppy address from logical sector number.
;       All numbers are 0-based including physical Sector number.
;       On entry must set Sects, Heads, Cyls, LogSector
;       On exit PhysTrack, PhysHead and PhysSector will be set.
;       Clobbers dx,ax

        sub     dx,dx
        mov     ax,LogSector
        div     SectsPerTrack   ;dx:ax/sects -> ax=quot dx=remdr
        mov     PhysSector,dl
        sub     dx,dx
        div     Heads           ; dx:ax/heads -> ax=quot dx=remdr
        mov     PhysHead,dl
        mov     PhysTrack,al
        ret

LogToPhys       EndP

;======================

AlignBuffer     Proc    Near

;       allocate a 16.5K buffer that does not span a 64K DMA boundary
;       Leaves result in Buffseg and ES:
;       We already own all of the rest of ram.  We are simply
;       adjusting BuffSeg up a little to avoid a boundary.

buffsizeP       equ     1056 ;  (16.5*1024/16) size in paragraphs


        mov     ax,BuffSeg
        add     ax,buffsizeP-1  ; head and tail in same 64K segment?
        xor     ax,BuffSeg
        and     ax,0F000h       ; same dma page?
        jz      BufferReady     ; yes, ok as is
        mov     ax,Buffseg      ; move buffer to start of next 64K boundary
        add     ax,01000h
        and     ax,0F000h
        mov     Buffseg,ax

BufferReady:
        mov     ES,Buffseg
        ret

AlignBuffer     EndP

;========================================

ClearError      Proc

;       resets the floppy drive after an error

        mov     ah,0
        int     13h                     ; reset the floppy system

        ret

ClearError      EndP

;=============================================
;       D I S K E T T E   H A R D W A R E   R O U T I N E S
;=============================================

ChangeLineViaPorts      Proc

;       Determines if Diskette has changed
;       Sets carry if has changed (i.e. removed, or new one inserted )
;       Works by examining the diskette status port directly


        mov     dx,03f7h                ; presume BIOS did i/o recently
        in      al,dx                   ; so status for this floppy will
        test    al,80h                  ; be presented
        jnz     DidChange               ; WE DON'T ack the change with a
        clc                             ; seek to 0.  This way BIOS will
        ret                             ; also see the change.
DidChange:
        stc
        ret

ChangeLineViaPorts      EndP

;======================

KeepMotorOnViaCheat     Proc    Near

;       If BIOS has started the floppy motor, keep it going at least
;       another 10 seconds (185 ticks)

        push    ES
        mov     ax,BIOSDATA
        mov     ES,ax
        assume  ES:BIOSDATA
        mov     BIOSCountDown,185
        assume  ES:Buffer
        pop     ES
        ret

KeepMotorOnViaCheat     EndP

;======================

LetMotorStop    Proc    Near

;       If BIOS has started the floppy motor, allow it to stop soon
;       We put 1 instead of 0 in the BIOS location because
;       BIOS stops the motor on seeing a transition from 1 to 0.

        push    ES
        mov     ax,BIOSDATA
        mov     ES,ax
        assume  ES:BIOSDATA
        mov     BIOSCountDown,1
        assume  ES:Buffer
        pop     ES
        ret

LetMotorStop    EndP

;======================

ProbeViaPorts   Proc    Near

;       Attempts to read ANYTHING on a diskette.  If fails sets carry.
;       Used to detect presence of a diskette.
;       DOES NOT RETRY OR RECALIBRATE.
;       See IBM AT BIOS listings Page 5-112
;       NEC_OUTPUT READ_ID and NEC_TERM
;       See IBM XT tech ref on floppy disk controller page 1-168
;       Set carry if no disk present
;       clear carry if disk present, even if could not read it successfully.
;       Even though I do not set the data rate, it seems to succeed
;       and detect a disk at EITHER data rate.  How rare a program works
;       better than you expected!

        mov     al,4Ah                  ; command code for read-id
        Call    NEC_OUTPUT
        mov     al,DriveNo              ; A:=0 B:=1
        Call    NEC_OUTPUT

;       Let the READ_ID operation happen, wait for interrupt
        mov     cx,0
        mov     dx,60000
        mov     ah,086h                 ; at 300 rpm should get back
                                        ; within 2 sector times i.e.
        int     15h                     ; within 2/8 rev = 0.050 secs
                                        ; = 50,000 mics
                                        ; So wait 60,000 mics for safety.
                                        ; wait cx:dx  mics

;       Read-Id sends back 7 bytes of sense status
;       st0 st1 st2 cyl, hd, sect, size

        mov     bl,7
        lea     di,NECstatus            ; where 7 bytes of status go

MoreSense:
        Call    NEC_INPUT               ; get sense status byte from NEC
        jc      DiskIsAbsent
        stosb                           ; save sense
        dec     bl
        jnz     MoreSense
                                        ; at this point we have 7 sense
                                        ; bytes, only the first ST0 is relevant
        test    NECStatus,11011000b     ;test int code, equip check, not ready
        jnz     DiskIsAbsent

DiskIsPresent:
        clc                             ; we have a live one.
        ret

DiskIsAbsent:
        stc                             ; no disk present
        ret

ProbeViaPorts   EndP

;======================

NEC_OUTPUT      Proc    Near

;       Sends byte in AL to NEC floppy disk controller
;       sets carry on fail

        mov     ah,al                   ; save data byte
        mov     dx,03f4h                ; NEC floppy controller status port
        sub     cx,cx                   ; max timeout loop
NECOutReadyLoop:
        in      al,dx                   ; get status
        and     al,11000000b            ; isolate ready and direction
        cmp     al,10000000b            ; insist on ready=1 direction=0
        je      NECOutReady             ; ready=1 means ready
        loop    NECOutReadyLoop         ; dir=0 means ctrlr ready to rcv byte
                                        ; dir=1 means ctrlr has byte to send

        stc                             ; fail
        ret

NECOutReady:
        mov     al,ah                   ; Get Byte to send
        inc     dx                      ; NEC floppy command port
        out     dx,al                   ; send command
        clc                             ; indicate success
        ret

NEC_OUTPUT      EndP

;======================

NEC_INPUT       Proc    Near

;       read one byte from the NEC diskette controller into AL
;       sets carry on fail

        mov     cx,0                    ; wait 30 mics to avoid hammering
        mov     dx,30                   ; the chip too quickly
        mov     ah,086h                 ; wait cx:dx = 30  mics
        int     15h

        mov     dx,03f4h                ; NEC status port
        in      al,dx                   ; get status
        sub     cx,cx                   ; max timeout loop

NECInReadyLoop:
        and     al,11000000b            ; isolate status and direction
        cmp     al,11000000b            ; insist on status=1 direction=1
        je      NECInReady              ; in other words, ctrlr has byte for us
        loop    NECInReadyLoop
        stc                             ; failed
        ret

NECInReady:
        inc     dx                      ; NEC data port, to get sense data
        in      al,dx                   ; read data byte
        clc                             ; indicate success
        ret

NEC_INPUT       EndP

;=============================================
;       D I S K E T T E   G E O M E T R Y  C A L C U L A T I O N
;=============================================

SnaffleDiskGeom Proc     near

;       look at RAM-based boot record and squirrel away numbers from it
;       that we need for calculations to do disk i/o.
;
        mov     ax,boot_BPB.BP_SectsPerTrack
                                        ; sectors per track
        CORRAL  ax,8,BiggestSectsPerTrack               ; make safely in range 8..18
        mov     SectsPerTrack,ax

        mov     ax,boot_BPB.BP_Heads    ; number of heads
        CORRAL  ax,1,2                  ; heads can be only 1 or 2
        mov     Heads,ax

        mov     ax, Boot_BPB.BP_RootEntries
                                        ; number of 32-byte entries
                                        ; in root dir, 16 per sector
        CORRAL  ax,64,BiggestDir
        mov     RootEntries,ax

        mov     ax, Boot_BPB.BP_SectsPerFAT
                                        ; size of FAT in sectors
        CORRAL  ax,1,BiggestFAT
        mov     SectsPerFat,ax

        sub     ah,ah
        mov     al,Boot_BPB.BP_SectsPerClust
        CORRAL  ax,1,2                  ; sectors per cluster
        mov     SectsPerClust,ax

;       Calculate the starting points/lengths of the 4 sections, in sectors

        mov     ax,bootStart            ; Boot
        mov     bx,Bootlen
        add     ax,bx
        mov     Fat1Start,ax            ; Fat1
        mov     bx,SectsPerFat
        mov     Fat1len,bx
        add     ax,bx
        mov     Fat2Start,ax            ; Fat2
        mov     bx,SectsPerFat
        mov     Fat2len,bx
        add     ax,bx
        mov     RootStart,ax            ; Root
        mov     bx,RootEntries          ; there are 512/32 = 16 entries/sector
        shr     bx,4                    ; divide by 16 to get sectors
        mov     RootLen,bx
        add     ax,bx
        mov     OverheadLen,ax          ; total overhead of Boot+fat1+fat2+rootdir

;       Calculate offsets/sizes in big buffer of 4 sections, in bytes

        mov     ax,BootOff
        add     ax,BootSize
        mov     Fat1Off,ax              ; Fat starts 1 sector later
        mov     bx,Fat1Len
        shl     bx,9                    ; 512 bytes per sector
        mov     Fat1Size,bx
        add     ax,bx
        mov     Fat2Off,ax
        mov     bx,Fat2Len
        shl     bx,9
        mov     Fat2Size,bx
        add     ax,bx
        mov     RootOff,ax
        mov     bx,Rootlen
        shl     bx,9
        mov     RootSize,bx

        Call    CalcMaxClust            ; calculate the highest cluster#
                                        ; on the disk.
        Ret

SnaffleDiskGeom EndP

;======================

CalcMaxClust    proc    Near

;       Calculate the maximum cluster number used on the floppy.
;       Needed to determine how many items in the FAT there are.
;       Calc how many sectors used by boot, two fats, and root directory
;       eg. for 360 K floppy with 1 boot, 2 fats of 2 sectors
;       7 sectors in the root directory and 720 sectors altogether,
;       MaxClust will be 355.  Sector number of the last cluster is 718.

        mov     ax,Boot_BPB.BP_TotalSects
                                        ; ax=total sectors avail
        sub     ax,Overheadlen          ; ax=sectors left for files
                                        ; subtract off overhead of boot+fat1+
                                        ; fat2+root
        sub     dx,dx                   ; prepare for DIV dx:ax by bx
        mov     bx,dx
        mov     bl,Byte Ptr SectsPerClust
        div     bx                      ; divide by cluster size
                                        ; to get free space measured
                                        ; in clusters.  Remainder will
                                        ; always be 0.
                                        ; In other words, there are no
                                        ; partial clusters.
        inc     ax                      ; adjust since clusters start
                                        ; counting at 2 instead of 1.
        mov     MaxClust,ax             ; save in variable
        ret

CalcMaxClust    EndP
;=============================================
InitDisk        Proc    Near

;       Prepare diskette system for manual control

        Call    ClearError              ; Clear BIOS diskette system

        mov     ah,0Dh                  ; Reset DOS diskette system
                                        ; We don't want DOS doing anything
                                        ; funny while we are working
                                        ; behind DOS's back.
        int     21h
        Call    ClearError              ; Clear BIOS diskette system
        ret

InitDisk        EndP

;=============================================

ShutDownDisk    Proc    Near

;       Shutdown diskette preparatory to quitting

        call    LetMotorStop            ; it would stop in 10 seconds anyway,
                                        ; but we are polite.
        Call    ClearError              ; Clear BIOS diskette system
        mov     ah,0Dh                  ; Reset DOS diskette system
                                        ; We have been doing a lot behind
                                        ; DOS's back.
        int     21h
        ret

ShutDownDisk    EndP

;=============================================
;       D I S K E T T E   T Y P E   D E T E R M I N A T I O N   R O U T I N E S
;=============================================

Handle_Norton   Proc    Near

;       there are two kinds of Norton Backup disks:
;       DOS compatible -- normal except Boot_Signature is missing.
;       Proprietary format -- no longer used.
;       We can handle DOS compatible, but not the proprietary.
;       In either case, the boot track looks reasonably normal, so we
;       have already classified and coloured based on that.

        lea     di,Boot_Norton_Kilroy   ; area in boot where Norton leaves mark.
        lea     si,My_Norton_Kilroy     ; model to match
        mov     cx,22d                  ; length of signature
        REPE    cmpsb
        jne     Not_Norton

; Read Root Dir to see if this is a proprietary Norton, vs ordinary
; DOS type Norton.
        mov     bx,RootOff
        mov     word ptr        dta, bx ; where root fits in RAM
        mov     word ptr dta+2, ES      ; buffer at end of prog
        mov     ax,RootStart            ; starting sector of rootdir
        mov     LogSector,ax            ; get Root dir
        mov     LogCount,1              ; just one sector, not whole dir
        Call    ReadViaBios

        lea     si,My_Norton_Kilroy     ; expected signature
        mov     di,RootOff              ; where Root fits in buffer
        add     di,160h                 ; where signature in proprietary Root is
        mov     cx,6/2                  ; length of signature word "Norton"
        REPE    cmpsw
        jne     Not_Norton
        jmp     IsNorton                ; is a Norton Proprietary disk

Not_Norton:
        ret

Handle_Norton   ENDP

;===========================================

Guess           Proc    Near

;       On entry AL contains a media descriptor byte.
;       We see if any diskette type matches it.
;       If so, we set BestBPB to point to a matching model BPB
;       that we guess is correct based on media byte.
;       This is not fool proof as media bytes are not unique.
;       We set the carry flag to indicate failure
;       on exit dx points to English string describing the disk type.
;       BestBPB points to model BPB.
;       ColourScheme contains the screen colours for this kind of diskette.
;       BestDesc points to description of diskette type.

TryD160:
        cmp     al, D160.BP_MediaByte   ; next comparison
        jne     TryD320                 ; not equal, try the next
        lea     si, D160                ; set up for BPB rewrite
        jmp     go_on                   ; and go do it

TryD320:
        cmp     al, D320.BP_MediaByte   ; next comparison
        jne     TryD180                 ; etc., etc.
        lea     si, D320
        jmp     go_on

TryD180:
        cmp     al, D180.BP_MediaByte
        jne     TryD360
        lea     si, D180
        jmp     go_on

TryD360:
        cmp     al, D360.BP_MediaByte
        jne     TryD176
        lea     si, D360
        jmp     go_on

TryD176:
        cmp     al, D176.BP_MediaByte
        jne     TryD144
;       We have a problem. Both 1.76 MB and 984K diskettes use the
;       same fa media byte. Drive type is the same for both, so that
;       won't help. We use BP_TotalSects to discriminate
        mov     bx,Boot_BPB.BP_TotalSects
        cmp     bx,D176.BP_TotalSects
        jne     TryD984
        lea     si, D176
        jmp     go_on

TryD984:
        cmp     bx,D984.BP_TotalSects
        jne     no_More
        lea     si, D984
        jmp     go_on


TryD144:
        cmp     al, D144.BP_MediaByte
        jne     TryD720
;       We have a problem. Both 1.44 MB and 1.41 MB diskettes use the
;       same f0 media byte. We can discriminate by drive type.

        push    ax              ; save media byte
        call    GetDriveType
        ; BL = drive type 01=360 02=1.2 03=720 04=1.44 05=2.88
        pop     ax              ; restore media byte
        cmp     bl,02d          ; 1.2 MB drive is type 02
        je      TryD141
        lea     si, D144
        jmp     go_on

TryD141:
        lea     si,D141
        jmp     go_on

TryD720:
        cmp     al, D720.BP_MediaByte
        jne     no_More
;       We have a problem,  Both 720 KB and 1.2 MB diskettes use
;       same f9 media byte.  Discriminate by drive type
        push    ax              ; save media byte
        call    GetDriveType
        ; BL = drive type 01=360 02=1.2 03=720 04=1.44 05=2.88
        pop     ax              ; restore media byte
        cmp     bl,02d          ; 1.2 MB drive is type 02
        je      TryD12
        lea     si, D720
        jmp     go_on

TryD12:
        lea     si,D12
        jmp     go_on

no_more:                                ; couldn't find a match
        jmp     IsUnknown

go_on:                                  ; did find a match
        Call    DiskIs                  ; save best from si

        clc                             ; indicate success
        ret

Guess           EndP

;=============================================

DiskIs  Proc    Near

;       on entry SI points to a BPB best match
;       Save this as our best bet to describe the disk

        mov     BestBPB,SI
        mov     bx,[si+ColourForModel]  ; get colour attributes
        mov     ColourScheme,bx
                                        ; save both screen + border
                                        ; exit with dx pointing to English
        test    mono,-1
        jz      NotMono
        mov     bx,[si+GrayForModel]    ; Use gray attributes for colours
                                        ; instead
        mov     ColourScheme,bx
NotMono:
        mov     bx,[si+SoundForModel]
        mov     BestSound,bx            ; address of sound routine

        lea     bx,[si+DescripForModel]
                                        ; address of description string
        mov     BestDesc,bx

        mov     bx,[si+CounterForModel] ; which counter to use
        mov     BestCounter,bx
        ret

DIskIs  EndP

;=============================================
GetDriveType    PROC    Near

        ; on entry:
        ; DriveNo is A:=0 B:=1
        ; on exit:
        ; BL = drive type 01=360 02=1.2 03=720 04=1.44 05=2.88
        ; NOTE.  This gets the drive type, not the media type.

        mov     ah,0
        int     13h             ; reset the floppy system
        mov     dh,0
        mov     dl,DriveNo
        push    ES
        mov     ah,8h           ; code for current drive parms
        int     13h             ; ( abs diskette i/o)
        pop     ES              ; restore trashed ES register
        ret

GetDriveType    ENDP

;============================================

DetectDamage    Proc    Near

;       Detect if disk is currently damaged by comparing how
;       it is now with how it will be after it is repaired using the models.
;       We only compare a crucial section, not the whole boot sector.
;       on entry BestBPB contains a pointer to the new proper BPB

        cmp     Boot_Signature,0AA55h   ; signature ok?
        jne     Is_Damaged
;       see if we will actually be changing the BPB
        mov     cx, (size BPBStruc)     ; number of bytes to compare
        mov     si, BestBPB             ; pointer to replacement BPB
        lea     di, Boot_BPB            ; destination
        repe    cmpsb                   ; compare current with proper BPB
        JE      Is_Not_Damaged
Is_Damaged:
        Lea     dx, MinorDamageMsg      ; Warn user we will be fixing BPB
        Call    Say                     ; based on media byte.
        RET
Is_Not_Damaged:
        RET
                        ; say nothing
DetectDamage    ENDP

;=============================================
;       B U I L D   N E W   B O O T   R O U T I N E S
;=============================================

Build_DOS6_Boot PROC    Near


;       Build improved boot sector DOS 6.0 style
;       ES: covers the boot sector we are building.

; clear whole record before patching.  We build it totally from scratch.
        Call    Clear_Boot_Sector


; patch short jump to actual boot code : EB 3C 90
        mov     cx,3
        lea     di, Boot_jump
        lea     si, My_jump
        rep     movsb

; patch oem
        mov     cx,8/2
        lea     di, Boot_oem
        lea     si, My_OEM_DOS6
        rep     movsw


; patch in replacement BPB
        mov     cx, (size BPBStruc)     ; number of bytes to move
                                        ; sect-size thru nhidden
        mov     si,BestBPB              ; DS:SI points to
                                        ; replacement BPB
        lea     di, Boot_BPB            ; destination
        rep     movsb                   ; move proper BPB to record


        Call    Calc_VolID              ; Calculate a pseudorandom Volume ID

; patch binary volume ID serial number  ; Boot_VolID
                                        ; 8 hex digits e.g. 1D35-1ECB unique
        mov     cx,2                    ; 8 hex = 4 bytes = 2 words
        lea     di, Boot_VolID
        lea     si, My_VolID
        rep     movsw

; patch Boot_VolLab                     ; 11 char volume label name
        mov     cx,11d
        lea     di, Boot_VolLab
        mov     al,' '                  ; set Volume Label to blank
        rep     stosb                   ; We cannot patch the Volume Label
                                        ; yet since we have not yet read the
                                        ; directory.

; patch FAT_Type                        ;       patch in FAT12___
        mov     cx,8/2                  ; 8 bytes = 4 words
        lea     di,Boot_FAT_Type
        lea     si,My_Boot_FAT_Type
        rep     movsw

; patch physical drive to reboot from. Would be A: if no reboot facility.
; We leave it as A: since we have a handler than swaps A: and B:
        test    SlashBootb,-1
        jz      RebootfromC
        mov     PhysDriveNo,00h         ; A:
        jmp     DrivePatched
RebootfromC:
        mov     PhysDriveNo,80h         ; C:
DrivePatched:

; patch the boot code itself
        test    SlashBootB,-1
        jnz     UseBTemplate

UseCTemplate:
        mov     cx,C_EndMy_Boot - C_MY_BOOT_CODE
                                        ; better be 448 bytes or less.
        lea     si, C_MY_BOOT_CODE      ; template
        jmp     CopyTemplate

UseBTemplate:
        mov     cx,B_EndMy_Boot - B_MY_BOOT_CODE
                                        ; better be 448 bytes or less.
        lea     si, B_MY_BOOT_CODE      ; template

CopyTemplate:
        lea     di, Boot_Code           ; actual boot track.
        rep     movsb

; patch extended boot signature
        mov     Boot_ESignature,029H

; patch the signature word at the very end
        mov     Boot_Signature,0AA55h
        ret

Build_DOS6_Boot ENDP


;========================================

Clear_Boot_Sector       PROC    Near

;       clear entire boot sector to zeroes, preparatory to filling in fields
;       ES: covers boot sector.

        mov     cx,512d/2
        mov     ax,0
        lea     di, Boot_Sector
        rep     stosw
        RET

Clear_Boot_Sector       ENDP

;========================================

Calc_VolID      PROC    Near

;       VolID is a 32-bit binary number.  Ideally it should be unique
;       in all the universe. We generate a pseudo-random number this way:
;       lsw  = (hundredths of sec) + Day + [(sec + month) * 256]
;       msw  =  Year + Min + (hour *256)
;       This is the way DOS 6.0 FORMAT.EXE does it.
        mov     ah,2ch
        int     21h                     ; get dos time
        add     My_Volid+3,ch           ; ch = hh
        add     My_Volid+2,cl           ; cl = min
        add     My_Volid+1,dh           ; dh = sec
        add     My_Volid+0,dl           ; dl = hundredths
        mov     ah,2ah
        int     21h                     ; get dos date
        add     word ptr My_Volid+2,cx  ; cx = yyyy
        add     My_Volid+1,dh           ; dh = mm
        add     My_Volid+0,dl           ; dl = dd
        RET

Calc_VolID      ENDP

;========================================

KeepVolLab      Proc    Near

;       Display files in the recently read root directory.
;       entries are 32 bytes long.
;       8 : filename
;           00 = no more files
;           2E = dummies for parent and current
;           E5 = file is erased
;           05 = first char is really  (E5)
;       3 : extension
;       1 : attribute 08 - volume label.

        ASSUME  ES:Buffer

        mov     cx,RootEntries          ; number of 32-byte entries
        mov     si,Rootoff              ; where dir starts
LookForVolLab:
        mov     al,ES:[si]              ; get first char of filename
        cmp     al,0
        je      NoLab                   ; zero marks last file.
        cmp     al,0E5h
        je      BypassThisEntry         ; E5 marks erased file
        cmp     al,02Eh
        je      BypassThisEntry         ; 2E marks dummy directories
        cmp     al,020h
        jl      BypassThisEntry         ; don't want to deal with screwy
                                        ; filenames containing control chars.
                                        ; WE DO want to display this file
        test    byte ptr ES:[si+11],08h ; test attribute byte, see if vollab
        jnz     FoundVolLab
BypassThisEntry:
        add     si,32d
        loop    LookForVolLab
NoLab:                                  ; was no volume label.  nothing to do.
        ret
FoundVolLab:
        push    ds
        mov     ax,ES
        mov     DS,ax
        lea     di,Boot_VolLab
        mov     cx,11
        rep movsb                       ; DS:SI points to vollab in directory
                                        ; ES:DI points to vollab in boot sector
                                        ; resync boot copy from one in directory.
        pop     ds
        ret
KeepVolLab      endp

;=============================================

;=============================================
;       F A T   R O U T I N E S
;=============================================

ReadOneFatViaBIOS       Proc    Near

;       read first copy of the FAT into RAM
;       ES: covers the buffer we use to read into

        mov     bx, Fat1off
        mov     word ptr dta, bx
        mov     word ptr dta+2, ES      ; buffer at end of prog
        mov     ax,Fat1Start
        mov     LogSector,ax            ; 2nd sector, offset 1
        mov     ax, Fat1Len             ; up to 9 sectors long
        mov     LogCount,ax
        Call    ReadViaBIOS
        jnc     FullReadok              ; carry indicates failure
        cmp     BIOSStatus,6h           ; code 6 = media removed
        jeL     RemovedTooSoon

        cmp     BIOSstatus,80h          ; code 80 = disk timed out -- probably
        jeL     RemovedTooSoon          ; disk removed.
        Call    SayStatus               ; explain technically how it failed
        lea     dx,BadFatMsg
        jmp     FAILED
FullReadOk:
        ret

ReadOneFatViaBIOS       EndP

;===================

EraseFAT1       Proc    Near

;       We have 12 bit (1.5 byte) entries.  The first 3 bytes are reserved.
;       The 12 bit entries may span sectors.
;       We want to clear all entries to 0, except
;       000FF0..000FF7 which mark bad clusters.  We want to preserve
;       These, but warn the user.
;       pair stored like this:
;       if hex pairs were abc  xyz, would be stored as:
;       bc  za  xy      in other words least significant first
;       consider this as an overlapping pair of words:
;       zabc and xyza
;       in other words, a bad sector on an empty disk would look like:
;       00 70 FF 00   or 00 F7 0F 00
;       ES: covers the buffer

        Call    EraseFatFarTail         ; erase junk in FAT out past
                                        ; the end of the entries

        Call    EraseFatOddTail         ; erase possible odd dummy entry
                                        ; at the end of the active FAT region

        mov     Imperfect,0             ; presume disk is perfect
                                        ; set imperfection count to 0
                                        ; so we can count the imperfections.

                                        ; We might go too far, but that
                                        ; won't hurt since we have padded
                                        ; out past the end with 0.
        mov     cx,MaxClust             ; last cluster #
                                        ; decrement by 1 to account for
                                        ; fact we start at cluster 2.
                                        ; increment by 1 to round up to
                                        ; next full pair
                                        ; There can be an ODD number of
                                        ; clusters on a disk.
                                        ; Net effect, dec/inc cancel out.

        shr     cx,1                    ; how many PAIRS to process
        mov     si,Fat1Off
        add     si,3                    ; where first entry is


WipeLoop:
                                        ; wipe out two 12-bit entries each
                                        ; time through the loop
WipeEven:
        mov     ax,ES:[si]              ; get 2 bytes, FIRST 12 bits of pair
        mov     dx,ax                   ; save copy
        and     dx,0FFFh                ; isolate from next entry
        cmp     dx,0FF0h                ; don't touch bad sectors
        jb      canwipeEven
        cmp     dx,0FF7h
        ja      CanWipeEven
        inc     imperfect               ; bad spot on floppy.
        inc     si                      ; on to the next
        jmp     WipeOdd
CanWipeEven:
        and     ax,0F000h               ; wipe out, but don't touch next entry
                                        ; places with 0 will get wiped.
        mov     ES:[si],ax
        inc     si

WipeOdd:
        mov     ax,ES:[si]              ; get 2 bytes, SECOND 12 bits of pair

        mov     dx,ax                   ; save copy
        and     dx,0FFF0h               ; isolate from prev entry
        cmp     dx,0FF00h               ; don't touch bad sectors
        jb      canwipeOdd
        cmp     dx,0FF70h
        ja      canwipeOdd
        inc     imperfect               ; bad spot on floppy.
        add     si,2
        jmp     nextwipe
canwipeOdd:
        and     ax,000Fh                ; wipe out, but don't touch prev entry
        mov     ES:[si],ax
        add     si,2

NextWipe:
        loop    WipeLoop                ; loop till all entries in all
                                        ; sectors in FAT processed.
        test    imperfect,-1
        jnz     DiskFlawed
        ret

DiskFlawed:
                                        ; if /SECURE or /GOVERNMENT
                                        ; must destroy a disk with bad
                                        ; sectors
        mov     al,SlashSecure
        or      al,SlashGovt
        jz      DiskCanBeRecycled
        jmp     DESTROYIT               ; cannot erase, must vapourize.
DiskCanBeRecycled:
        lea     dx,FlawedMsg
        jmp     FAILED

EraseFAT1       endP

;===================

DupFat  Proc    Near

;       Make a second copy of FAT1 in ram at FAT2
;       The first is already built.
;       ES cover the buffer with both fats.

        mov     cx,Fat1Size
        shr     cx,1                    ; convert to words
        mov     si,fat1off
        mov     di,fat2off
        push    ds
        mov     ax,ES
        assume  DS:Nothing
        mov     DS,ax
        REP     movsw                   ; move from fat1 to fat2
        pop     ds
        assume  DS:DATA
        ret

DupFat  EndP

;===================

EraseFATOddTail Proc    Near

;       Erase possible dummy entry in FAT after the active region.
;       If there are an odd number of clusters, we need to wipe out
;       the second half of the last pair.
;       if hex pairs were abc  xyz, would be stored as:
;       bc  za  xy      in other words least significant first
;       If there were an odd number of clusters, we would have to zap xyz
;       ES: cover the buffer

        mov     ax,MaxClust             ; last cluster #
        dec     ax                      ; decrement by 1 to account for
                                        ; fact we start at cluster 2.
                                        ; count of clusters
        test    ax,1                    ; test oddness
        jz      EasyCase                ; even number of clusters
        shr     ax,1                    ; how many PAIRS to process
        mov     bx,3                    ; 3 bytes each
        mul     bx                      ; size region up to but not
                                        ; including the last real entry
        mov     bx,ax
        mov     si,Fat1Off              ; where first fat starts
        lea     si,3+1[bx+si]           ; where 2nd half of pair starts.
                                        ; part is good, rest is dummy
                                        ; ie. point to za xy
                                        ; considered as word is xyza
        and     word ptr ES:[si],000Fh  ; wipe it all out, except
                                        ; bit from last real entry (a)
EasyCase:
        ret

EraseFATOddTail EndP

;===================

EraseFATFarTail Proc    Near

;       Erase stuff out past the end of the FAT -- the pad area to make
;       the FAT an even number of sectors.
;       There might be one 1.5 byte entry at the start of the tail
;       we don't nail here.
;       ES: cover the buffer

        mov     ax,MaxClust             ; last cluster #
                                        ; decrement by 1 to account for
                                        ; fact we start at cluster 2.
                                        ; increment by 1 to round up to
                                        ; next full pair
                                        ; Net effect, dec/inc cancel out.
        shr     ax,1                    ; how many PAIRS to process
        mov     bx,3                    ; 3 bytes each
        mul     bx                      ; get size of active fat region
                                        ; (Might be 1.5 bytes too big)
        mov     bx,ax
        mov     di,Fat1Off
        lea     di,3[bx+di]             ; where pad region starts
        mov     cx,Fat2Off              ; where next Fat starts
        sub     cx,di                   ; size of pad region in bytes
        jle     IsNoTail                ; FAT might be completely full
                                        ; of real entries.
                                        ; Signed arith ok as FAT at most
                                        ; BiggestFAT sectors
        inc     cx                      ; round up to next word
        shr     cx,1                    ; convert to words
        sub     ax,ax
        rep     stosw                   ; fill pad region with 0s
IsNoTail:
        ret

EraseFATFarTail EndP

;===================


FullCheck       Proc    Near
;       handle /Full -- ensure last sector on disk is readable

        ASSUME  ES:buffer

        mov     word ptr dta, 0         ; starting point of buffer
        mov     word ptr dta+2, ES
        mov     bx,BestBPB
        mov     ax,[bx+ClearTo]         ; start with last sector on floppy
        mov     LogSector,ax
        mov     LogCount,1              ; count of sectors to read
        call    ReadViaBIOS
        jnc     goodLastSector          ; if no problem, exit cleanly
        jmp     PARTIALFORMAT           ; can't read, must be reformatted.
GoodLastSector:
        ret
FullCheck       Endp
;===================

SecureWipe      Proc    Near
;       Clear out the data area past the directory
;       Handles a /SECURE wipe


        lea     dx,WipingMsg            ; Let user know why this is taking
                                        ; so long.
        Call    Say
        mov     ax,0                    ; wipe to 0
        mov     iocode,03h              ; int 13 write function code
        Call    WipePass
        ret

SecureWipe      endp

;===================

GovtWipe        Proc    Near
;       Clear out the data area past the directory
;       Handles a /SECURE wipe

        lea     dx,Govt1Msg             ; Let user know why this is taking
                                        ; so long.
        Call    Say
        mov     ax,0                    ; wipe to 0
        mov     iocode,03h              ; int 13 write function code
        Call    WipePass

        lea     dx,Govt2Msg             ; Let user know why this is taking
                                        ; so long.
        Call    Say
        mov     ax,-1                   ; wipe to all 1s
        Call    WipePass

        lea     dx,Govt3Msg             ; Let user know why this is taking
                                        ; so long.
        Call    Say
        mov     ax,0f6f6h               ; wipe to all division signs
        Call    WipePass

        mov     iocode,04h              ; int 13 verify function code
        lea     dx,GovtVerifyMsg
        Call    Say
        mov     ax,0f6f6h               ; verify last pass
        Call    WipePass

        ret

GovtWipe        endp

;===================

WipePass        Proc    Near
;       Does one pass of a /SECURE or /GOVERMENT data wipe.
;       Wipes the entire data surface.
;       on entry ax has wipe value
;       iocode must be set to whether want write or verify


        ASSUME  ES:buffer
        mov     cx,15*512/2             ; allow tracks up to 7.5K long
        mov     di,0                    ; start of buffer
        rep     stosw                   ; clear buffer
        mov     word ptr dta, 0         ; starting point of buffer
        mov     word ptr dta+2, ES
        mov     bx,BestBPB
        mov     ax,[bx+ClearFrom]
        mov     LogSector,ax            ; start with first sector after dir
        mov     ax,[bx+ClearTo]         ; finish with last sector on floppy
        sub     ax,LogSector
        inc     ax
        mov     LogCount,ax             ; count of sectors to write
                                        ; iocode set by caller
        mov     WholeBuffer,0           ; break i/o into separate track fulls
        call    ioViaBios
        jnc     goodwipe                ; if no problem, exit cleanly
        jmp     DESTROYIT               ; can't wipe, must be destroyed.
GoodWipe:
        ret

WipePass        endp

;=============================================
;       R O O T   D I R   R O U T I N E S
;=============================================

ReadRootDir     Proc    Near
;       Read root directory so that we can display a list of the current
;       files.
        mov     bx,RootOff
        mov     word ptr dta, bx        ; where root fits in RAM
        mov     word ptr dta+2, ES      ; buffer at end of prog
        mov     ax,RootStart            ; starting sector of rootdir
        mov     LogSector,ax            ; get Root dir
        mov     ax,RootLen
        mov     LogCount,ax             ; entire thing, we want to list
                                        ; files.  Size in sectors.
        Call    ReadViaBios
        ret

ReadRootDir     EndP

;=============================================

PromptToKill    Proc    Near
;       Prompt user before erasing the diskette
;       Sets carry if ok to erase files

        Call    Showfiles               ; show user a dir listing of root

        test    SlashKeep,-1            ; for /Keep ask if update boot
        jz      PromptKill              ; without it ask if erase files
        lea     dx,AskScatMsg
        jmp     AskUser
PromptKill:
        lea     dx,AskKillMsg
AskUser:
        call    say
        Call    TickleTimer
        Call    KeepMotorOnViaCheat     ; keep motor on another 10 secs
        Call    AskYorN                 ; Ok if motor goes off.  Y or N will
                                        ; prod things back to life.
                                        ; This gives about 10 seconds to
                                        ; respond before shutoff.
        ret

PromptToKill    EndP

;=============================================

ShowFiles       Proc    Near

;       Display files in the recently read root directory.
;       entries are 32 bytes long.
;       8 : filename
;           00 = no more files
;           2E = dummies for parent and current
;           E5 = file is erased
;           05 = first char is really  (E5)
;       3 : extension
;       1 : attribute - bit 4 = directory.
;       display in form:  12345678.123___ for files in field 15 wide
;                         [12345678.123]_ for directories
;                         four files per line
;       ES: covers the buffer
        mov     FilesOnLine,0           ; nothing displayed yet
        mov     cx,RootEntries          ; number of 32-byte entries
        mov     si,Rootoff              ; where dir starts
ShowAnotherFile:
        mov     al,ES:[si]              ; get first char of filename
        cmp     al,0
        je      ShowDone                ; zero marks last file.
        cmp     al,0E5h
        je      BypassThisFile          ; E5 marks erased file
        cmp     al,02Eh
        je      BypassThisFile          ; 2E marks dummy directories
        cmp     al,020h
        jl      BypassThisFile          ; don't want to deal with screwy
                                        ; filenames containing control chars.
                                        ; WE DO want to display this file
        test    byte ptr ES:[si+11],10h ; test attribute byte, see if dir
        jnz     ShowADir
        call    ShowOneFile             ; show one file
        jmp     short BypassThisFile
ShowADir:
        call    ShowOneDir              ; show one directory
BypassThisFile:
        add     si,32d
        loop    ShowAnotherFile
ShowDone:
        ret

ShowFiles       EndP

;=============================================

ShowOneFile     Proc    Near

;       Show file pointed at by ES:SI
;       displays as 12345678.12___ padded out to 15 characters 8+1+3+3
;       trashes ax

        push    bx
        push    cx
        push    dx
        Call    FourPerLine
        Call    ShowTrimFileName
        mov     cx,15                   ; size of string wanted
        sub     cx,Charcount
        push    si
        lea     si,SpacesMsg            ; pad out to 15 with spaces
        Call    SayByCount
        pop     si
        pop     dx
        pop     cx
        pop     bx
        ret

ShowOneFile     EndP

;=============================================


ShowOneDir      Proc    Near

;       Show file pointed at by ES:SI
;       displays as [12345678.123]_ padded out to 15 characters 1+8+1+3+1+1
;       trashes ax

        push    bx
        push    cx
        push    dx
        push    si
        Call    FourPerLine
        lea     dx,LSqMsg               ; display [
        call    Say
        Call    ShowTrimFilename
        lea     dx,RSqMsg               ; display ]
        call    Say
        mov     cx,15                   ; size of string wanted
        sub     cx,Charcount
        sub     cx,2                    ; cx now has # spaces to pad to 15
        lea     si,SpacesMsg            ; pad out to 14 with spaces
        Call    SayByCount
        pop     si
        pop     dx
        pop     cx
        pop     bx
        ret

ShowOneDir      EndP

;=============================================

ShowTrimFileName        Proc    Near
;       Show file pointed at by ES:SI
;       displays as XXXXXX not padded out
;       trashes ax.  Leaves length in CharCount.

        push    bx
        push    cx
        push    dx
        mov     bx,si                   ; where filename starts
        mov     cx,8                    ; length of filename part
        call    Mtrailing               ; get rid of trailing spaces
        mov     CharCount,cx            ; track length of display

        push    DS
        mov     ax,ES
        mov     DS,ax
        call    SayByCount              ; display the filename portion
        pop     DS

        mov     al,ES:[si+8]            ; test if is extension
        cmp     al,' '
        je      NoExtension

        lea     dx,DotMsg               ; display separator Dot if there
                                        ; is an extension
        call    Say
        inc     CharCount

        push    si
        add     si,8                    ; start of extension
        mov     bx,si
        mov     cx,3
        Call    Mtrailing
        add     Charcount,cx

        push    DS
        mov     ax,ES
        mov     DS,ax
        call    SayByCount              ; display extension trimmed
        pop     DS
        pop     si
NoExtension:

        pop     dx
        pop     cx
        pop     bx
        ret

ShowTrimFileName        EndP


;=============================================

FourPerLine     Proc    Near

;       Put four filenames per line
;       Emit a newline every 4 times this routine is called.

        test    FilesOnLine,-1
        jnz     SameLine
        lea     dx,CrMsg                ; New line
        call    Say
SameLine:

        inc     FilesOnLine
        and     FilesOnline,3
        ret

FourPerLine     EndP

;=============================================

EraseRootDir    Proc    Near

;       prepares a mess of zeroes to write over the entire root directory
;       ES: covers the buffer

        mov     cx,RootSize             ; size of root in bytes
        shr     cx,1                    ; convert to words

        sub     ax,ax                   ; store zeroes
        mov     di,Rootoff              ; store in buffer at end of prog
        rep     stosw
        ret

EraseRootDir    EndP

;=============================================
;       S O U N D   R O U T I N E S
;=============================================

PrangTone       Proc    Near

;       make noise to indicate just had a dud diskette
;       makes a reverberant "prang" noise.

        mov     cx,150          ; loop 150 times, lowering freq
        mov     bx,1331         ; 1331 = 1331*1000/1000
PrangLoop:
        push    cx
        mov     cx,0            ; cx:dx is duration in mics
        mov     dx,5000         ; bx is divisor
        call    Beep            ; tone for 5 ms
        add     bx,50           ; lower the frequency a little
        pop     cx
        loop    PrangLoop

        ret

PrangTone       EndP

;========================================


EhTone  Proc    Near

;       make noise to indicate just had write-protected diskette
;       makes an "eh?" querying noise.

        mov     cx,100          ; loop 150 times, raising freq
        mov     bx,32463        ; 32463 = 1331*1000/41
EhLoop:
        push    cx
        mov     cx,0            ; cx:dx is duration in mics
        mov     dx,2500         ; bx is divisor
        call    Beep            ; tone for 2.6 ms
        mov     ax,31           ; mult by 31/32 to raise the frequency
        mul     bx              ; a little
        mov     bx,32
        div     bx
        mov     bx,ax
        pop     cx
        loop    ehLoop

        ret

EhTone  EndP

;========================================

StrangeTone     Proc    Near

;       make noise to indicate just did a weird diskette of some kind

        mov     bx,8319         ; 8319 = 1331*1000/160
        mov     cx,0
        mov     dx,50000
        call    Beep            ; 160 hz for 50 ms

        mov     bx,0
        mov     cx,0
        mov     dx,50000
        call    Beep            ; silence

        mov     bx,8319         ; 8319 = 1331*1000/160
        mov     cx,0
        mov     dx,50000
        call    Beep            ; 160 hz for 50 ms

        mov     bx,0
        mov     cx,0
        mov     dx,50000
        call    Beep            ; silence

        mov     bx,8319         ; 8319 = 1331*1000/160
        mov     cx,0
        mov     dx,50000
        call    Beep            ; 160 hz for 50 ms

        ret

StrangeTone             EndP

;========================================

LowTone Proc    Near

;       make noise to indicate just did a low density diskette of some kind

        mov     bx,2080         ; 2080 = 1331*1000/640
        mov     cx,0
        mov     dx,50000
        call    Beep            ; 640 hz for 50 ms

        mov     bx,0
        mov     cx,0
        mov     dx,50000
        call    Beep            ; silence

        mov     bx,4159         ; 4159 = 1331*1000/320
        mov     cx,0
        mov     dx,50000
        call    Beep            ; 320 hz for 50 ms


        ret

LowTone EndP

;========================================

HighTone        Proc    Near

;       make noise to indicate just did a high density diskette of some kind

        mov     bx,16637        ; 16637 = 1331*1000/80
        mov     cx,0
        mov     dx,50000
        call    Beep            ; 80 hz for 50 ms

        mov     bx,4159         ; 4159 = 1331*1000/320
        mov     cx,0
        mov     dx,50000
        call    Beep            ; 320 hz for 50 ms


        mov     bx,2080         ; 2080 = 1331*1000/640
        mov     cx,0
        mov     dx,50000
        call    Beep            ; 640 hz for 50 ms

        ret

HighTone        EndP

;========================================


DoneTone        Proc    Near

;       Makes quiet noise to indicate ready for next disk
;       different noise depending on disk type.

        mov     bx,BestSound
        call    bx
        ret

DoneTone        EndP

;========================================

IgTone  Proc    Near

;       EEP noise to indicate ignoring a keystroke

        mov     bx,1699         ; 1699 = 1331*1000/783
        mov     cx,0
        mov     dx,50000
        call    Beep            ; 783 hz for 80 ms

        ret

IgTone  EndP

;========================================

Beep    proc    Near

; on entry CX:DX is time in mics to keep sound on
; bx is frequency divisor
; 1000Hz needs divisor 1331.  Lower frequencies need bigger divisors.
; This routine needs AT BIOS to work since it uses INT 15h function 86h
; see IBM PC tech ref page 5-163
; divisor of 0 means silence
; preserves bx, cx, dx
        test    slashquiet,-1   ; /Quiet turns off all sound
        jnz     BeepDone
        test    bx,bx
        jz      silence
        push    bx
        push    cx
        push    dx
        mov     al,0b6h         ; select divisor register
        out     043h,al
        mov     ax,bx
        jmp     $+2             ; give port time to recuperate
        out     042h,al         ; lsb divisor
        mov     al,ah
        jmp     $+2             ; give port time to recuperate
        out     042h,al         ; msb divisor
        jmp     $+2             ; give port time to recuperate
        in      al,061h         ; get port b setting
        mov     bh,al           ; save port setting
        or      al,3            ; turn speaker on

        jmp     $+2             ; give port time to recuperate
        out     061h,al
        mov     ah,086h         ; timed wait function
        int     15h             ; cx:dx is time in mics to wait

        mov     al,bh           ; recover original port value
        out     061h,al         ; put speaker back the way it was
        pop     dx
        pop     cx
        pop     bx
        ret

silence:
        mov     ah,086h         ; timed wait function
        int     15h             ; cx:dx is time in mics to wait
BeepDone:
        ret

Beep    EndP

;=============================================
;       C O M M A N D   L I N E   P A R S I N G   R O U T I N E S
;=============================================

MLeading        PROC    Near

;       Remove leading blanks
;       on entry ES:BX is addr of string, CX its length
;       trims off any leading blanks, leaving result in BX CX
;       length may also be 0 or 1, but not -ve
;       If the entire string is blank the result is the null string
;       This routine is designed for use in EXE programs.

        mov     di,bx
        mov     al,20H          ; AL = blank  -- the search char
        jcxz    mleading2       ; jump if null string
        repe    scasb           ; scan ES:DI forwards till hit non blank
                                ; DI points just after it (wrap ok)
                                ; cx IS ONE TOO SMALL, OR 0 IF NONE FOUND
        je      mleading1       ; jump if entire string was blank
        inc     cx              ; CX is length of remainder of string
mleading1:
        dec     di              ; DI points to non-blank
mleading2:
        mov     bx,di           ; put address back
        ret

MLeading        ENDP

;========================================

MTrailing       PROC    Near

;       Remove  trailing blanks.
;       on entry ES:BX is addr of string, CX its length
;       trims off any trailing blanks, leaving result in BX CX
;       length may also be 0 or 1, but not -ve
;       If the entire string is blank the result is the null string
;       trashes ax
;       This routine is designed for use in EXE programs.

        push    di
        mov     di,bx
        add     di,cx           ; calc addr last char in string
        dec     di
        mov     al,20H          ; AL = blank  -- the search char
        jcxz    mtrailing1      ; jump if null string
        std
        repe    scasb           ; scan ES:DI backwards till hit non blank
                                ; DI points just ahead of it (wrap ok)
                                ; CX is one too small, or 0 if none found
        cld
        je      mtrailing1      ; jump if whole string was blank
        inc     cx
mtrailing1:
        pop     di
        ret

MTrailing       ENDP

;========================================

Parse   Proc    near
;       Parse the command line and process each parameter.
;       sample inputs
;       LAUNDER A: /G
;       LAUNDER B:
;       LAUNDER
                                ; counted string at HEX 80 PSP
                                ; contains command line.
                                ; Preceeded by unwanted spaces.
                                ; possibly followed by unwanted spaces.
                                ; currently missing a trailing null.
                                ; ES points to PSP, DS does NOT!!
                                ; because this is an EXE program.
        call    CommandLine     ; string addr ES:bx, length cx.
        jcxz    NullParms

        mov     ParmIndex,1     ; start parsing with the 1st parm
                                ; note start with 1 not 0!
                                ; We don't want the the program name.
        jmp     Short Parseloop

NullParms:
NoMoreParms:
        ret                     ; we are done

Parseloop:
        call    CommandLine     ; get first parm
                                ; string=ES:bx, length=cx
        mov     dx,ParmIndex
        call    NthParm         ; work left to right
        jcxz    NoMoreParms     ; null param means no more
                                ; e.g. ES:bx points to A: or /Government
                                ; cx is length of that piece
        mov     ax,ES:[bx]      ; al=A ah=:  or  al=/ ah=G
        call    ToUc            ; Convert both chars to upper case
        xchg    ah,al
        call    ToUc
        cmp     ah,'/'          ; drive or Switch?
        jne     ProcessDrive
                                ; was a switch with slash
                                ; split on  B F G K P Q S
        cmp     al,'B'
        JE      ProcessB
        cmp     al,'F'
        je      ProcessF
        cmp     al,'G'
        je      ProcessG
        cmp     al,'K'
        je      ProcessK
        cmp     al,'P'
        je      ProcessP
        cmp     al,'Q'
        je      ProcessQ
        cmp     al,'S'
        je      ProcessS
                                ; something else, give up.
BadCmd:
        LEA     dx,UsageMsg
        Call    Say
        Jmp     Quit    ; need to leave time to read message. !!!

ProcessDrive:
        xchg    ah,al
                                ; al has drive letter, ah has :
        cmp     ah,':'          ; make sure second char is :
        jne     BadCmd
                                ; should have A: B: 3: or 4:
                                ; A->0 B->1 3->2 4->3
        cmp     al,'A'
        je      Letterdrive
        cmp     al,'B'
        je      Letterdrive
        cmp     al,'3'
        je      DigitDrive
        cmp     al,'4'
        je      DigitDrive
        jmp     BadCmd
LetterDrive:
        sub     al,'A'-0
        jmp     KeepDrive
DigitDrive:
        sub     al,'3'-2
KeepDrive:
        mov     Driveno,al
        jmp     short Next

ProcessB:                       ; handle /BootB
        mov     SlashBootB,-1
        jmp     short Next

ProcessF:
        mov     SlashFull,-1    ; handle /Full
        jmp     short Next

ProcessG:                       ; handle /Government
        mov     SlashGovt,-1
        jmp     short Next

ProcessK:                       ; handle /Keep
        mov     SlashKeep,-1
        jmp     short Next

ProcessP:                       ; handle /Prompt
        mov     SlashPrompt,-1
        jmp     short Next

ProcessQ:                       ; handle /Quiet
        mov     SlashQuiet,-1
        jmp     short Next

ProcessS:                       ; handle /Secure
        mov     SlashSecure,-1
        jmp     short Next

Next:
        inc     ParmIndex       ; bump loop counter
        jmp     Parseloop       ; loop till hit null param

Parse   EndP

;==============================================================

Conflicts       Proc    Near

;       Resolve conflicts in / options
        test    SlashGovt,-1
        jz      GovtConflictsDone
        mov     SlashSecure,0           ; If have /Government, turn
                                        ; off /Secure since it is included.
GovtConflictsDone:
        Test    SlashKeep,-1            ; Turn off /Secure /Govt if have
                                        ; /Keep.
        jz      KeepConflictsDone       ; However, /Prompt is still ok.
        mov     SlashSecure,0           ; You might use it to avoid making
        mov     SlashGovt,0             ; a disk unbootable.
KeepConflictsDone:

        ret

Conflicts       EndP

;==============================================================

CommandLine Proc        near
;       Gets command line string into ES:di
;       Command line does not include the program name.
;       ES: points to PSP since we are an EXE file.
;       When Done ES:BX points to start of string.
;       String will be terminated by 2 nulls
;       CX counts bytes in string exclusive of nulls
                                ; counted string at HEX 80 PSP
                                ; contains command line.
                                ; Preceeded by unwanted spaces.
                                ; possibly followed by unwanted spaces.
                                ; currently missing a trailing null.
        xor     ch,ch
        mov     cl,es:[80H]
        mov     bx,81H
        ret

CommandLine EndP

;==============================================================

NthParm Proc    near
;       Parses string for Nth Parameter delimited by blanks
;       e.g.  "  A: /Government " with bx=1 would give string "/Government"
;       on entry:
;       ES:bx - string
;       cx - length of string
;       dx - which parm wanted 1=parm1 2=parm2 etc.
;       NthParm only finds one parm per call.
;       On exit ES:bx points to string and cx is its length.
;       If there is no parm, the length will be 0.
;       It also handles multiple leading/trailing blanks on parms.
        mov     al,20h          ; al = blank  -- the search char
        mov     di,bx
Parmloop:
;       Remove leading blanks on parm
        jcxz    NullParm        ; jump if null string
        repe    scasb           ; scan ES:di forwards till hit non blank

                                ; di points just after it
                                ; cx is one too small, or 0 if none found
        je      NullParm        ; jump if entire string was blank
        inc     cx              ; cx is length of remainder of string
        dec     di              ; di points to non-blank
        mov     si,di           ; remember start of string
;       Search for terminating blank on parm
        jcxz    NullParm        ; jump if null string
        repne   scasb           ; scan ES:di forwards till hit blank
                                ; di points just after it
                                ; cx is one too small, or 0 if none found
        jne     NoBlank         ; jump if entire string was non blank
        inc     cx              ; cx is length of remainder of string
        dec     di              ; backup di to point to blank at string end
NoBlank:
                                ; di=addr tail end of command string,
                                ; cx=len tail end of command string
                                ; si=addr parm just parsed
;       Major loop for each parm
        dec     dx
        jnz     Parmloop        ; loop once for each parm

        mov     cx,di
        sub     cx,si           ; cx is length of parameter.
        mov     bx,si
        ret
NullParm:                       ; was no nth parameter
        mov     cx,0
        mov     bx,si
        ret
NthParm EndP

;==============================================================

ToUC            PROC    NEAR
;       converts char in AL to upper case
        cmp     al,'a'
        jb      FineAsIs
        cmp     al,'z'
        ja      FineAsIs
        sub     al,20H          ; convert a to A
FineAsIs:
        ret

ToUc            ENDP

;======================================

PatchDrive      Proc    Near

;       Patch the drive letter into all the prompting messages

        mov     al,DriveNo      ; A:=0 B:=1 3:=2 4:=3
        cmp     al,2
        jge     SecondPair
        add     al,"A"          ; convert to A or B
        jmp     FirstPair
SecondPair:
        add     al,"3"-2
FirstPair:
        mov     DrPatch1,al     ; patch prompt error message with drive B:
        mov     DrPatch2,al
        mov     DrPatch3,al
        mov     DrPatch4,al
        mov     DrPatch5,al
        mov     DrPatch6,al
        ret

PatchDrive      EndP

;=============================================

GetTime         Proc

;       Get TimeNow in ticks

        mov     ah,0            ; get time in ticks
        int     1Ah
        mov     word Ptr TimeNow,dx
        mov     word Ptr TimeNow+2,cx
        ret

GetTime         EndP

;=============================================

TickleTimer     Proc

;       restart the timer, because there was some activity

        call    GetTime
        mov     word Ptr LastActivity,dx
        mov     word Ptr LastActivity+2,cx
        ret

TickleTimer     Endp

;=============================================

CheckTimer      Proc

;       Check timer to see if time is up
;       Sets carry flag if it is
;       Ignore the 24 hour rollover problem.

        call    GetTime
        sub     dx,word Ptr LastActivity        ; now - (then + timeout)
        sbb     cx,word Ptr LastActivity+2
        sub     dx,Timeout
        sbb     dx,0
        jge     TimesUp
        clc
        ret

TimesUp:
        stc
        ret

CheckTimer      Endp

;=============================================

NoXT    Proc    near

;
;       We don't support XT computers.  Apologize and quit if we have one.
;       Determines what kind of BIOS you have by looking at the model ID
;       byte in ROM location F000:FFFE.

        Call    GetModID        ; get the model ID in ax

        cmp     al,0ffh         ; FF -> XT
        je      IsXT
        cmp     al,0feh         ; FE -> XT
        je      IsXT
        cmp     al,0fdh         ; FD -> XT
        je      IsXT
        cmp     al,0fbh         ; FB -> XT
        je      IsXT
        ret

IsXT:
        lea     dx,noXTmsg
        call    Say
        jmp     Quit
        ret

NoXT    EndP

; = = = = = = = = = = = = = = = = = = = = = =

GetModId        Proc    Near

;       Returns models ID byte from F000:FFFE in AX
;       See IBM Tech Ref Bios listing

                push    ES
                mov     ax,ROMBIOS      ; we DON'T use int 15h, since
                                        ; old machines don't support it.
                mov     ES,ax
                ASSUME  ES:ROMBIOS
                mov     al,ES:BiosMachineId
                sub     ah,ah
                pop     ES
                ASSUME  ES:NOTHING
                ret

GetModId        EndP

;=============================================

MustSupportChangeLine   Proc    near

;       Refuse to operate on an old drive without changeline support.
;       Also insist drive present.

        call    ClearError      ; helps get correct response after a reboot.

        mov     ah,01           ; get drive status -- to reset diskette
        mov     dl,driveno      ; after a reboot
        int     13h

;       Windows 95 does not give correct answer on changeline support
;       until after some DOS activity after the boot.
;       Unfortunately the activity needed requires a formatted floppy in
;       place, so we can't fake some.

        call    ClearError

        mov     dl,DriveNo      ; A=0
        mov     ah,15h
        int     13h
;       al=0 no drive, 1=no changeline, 2 changeline supported, 3=fixed disk
;       Some bioses erroneously set carry even when all is ok.
;       so we do not test it.
        cmp     ah,02
        je      ChangelineOk
        cmp     ah,01
        je      MissingChangeLine

MissingDrive:
        lea     dx,MissingDriveMsg
        Call    Say
        jmp     Quit

MissingChangeLine:
        lea     dx,MissingChangeLineMsg
        Call    Say
        jmp     Quit

ChangeLineOk:
        ret

MustSupportChangeLine   EndP

;=============================================

DisableNCACHE   Proc    Near

;       Ensure Norton cache flushes its buffers.
;       It does not complete the flush on Disk Reset the way other caches do.
;       Then disable it so it cannot possibly interfere.

        mov     NcachePresent,0 ; presume NOT present
;       Detect if Norton Cache 6.01 is present
        mov     ax,0FE00h       ; set up mux interrupt signature
                                ; function 00 --is NCACHE present?
        mov     di,04E55h       ; "NU"
        mov     si,04346h       ; "CF"
        stc                     ; set carry to indicate failure
        push    ES              ; wrecks AX,BX,ES,CX.  Only ES important
        int     2fh             ; multiplex interrupt
        pop     ES

        jc      NoNCache        ; carry means not present
        cmp     si,06366h       ; "cf" signature
        jne     NoNCache        ; False hit
        mov     NcachePresent,-1; record its presence for later enable
        lea     dx,NCACHEMsg    ; explain the delay
        call    Say

        mov     ax,0FE02h       ; flush then disable Norton Cache.
        mov     di,04E55h       ; "NU"
        mov     si,04346h       ; "CF"
        push    ES              ; wrecks AX,BX,ES,CX.  Only ES important
        int     2fh             ; multiplex interrupt
        pop     ES

NoNcache:
        ret

DisableNCACHE   EndP

; = = = = = = = = = = = = = = = = = = = = = =

EnableNcache    Proc    Near

;       Re-enable Norton Cache just before quitting

        test    NCachePresent,-1
        jz      NcacheWasNotHere
        mov     ax,0FE01h       ; reenable Norton Cache.
        mov     di,04E55h       ; "NU"
        mov     si,04346h       ; "CF"
        push    ES              ; wrecks AX,BX,ES,CX.  Only ES important
        int     2fh             ; multiplex interrupt
        pop     ES
NcacheWasNotHere:
        ret

EnableNcache    EndP

;=============================================

SayHexByte      Proc    Near

;       displays 2 digit (8 bits) hex number in AL
;       Used for debug

        push    ax
        push    bx
        push    cx
        push    si
        mov     AsHexBuf+1,al
        shr     al,4
        mov     AsHexBuf,al
        mov     cx,2
        lea     si,AsHexBuf
AsHexLoop:
        lodsb                   ; fix up each character in turn
        and     al,0Fh
        cmp     al,0Ah
        jle     IsDigit
        add     al,'A'-0ah
        jmp     short saveDigit
IsDigit:
        add     al,'0'
SaveDigit:
        mov     [si-1],al       ; lodsb incremented si already
        loop    AsHexLoop
        lea     dx,AsHexBuf
        Call    Say
        pop     si
        pop     cx
        pop     bx
        pop     ax
        ret

Data    segment
AsHexBuf        db      '00',0
Data    Ends

SayHexByte      EndP

;=============================================

NoDos4  Proc    Near

;       Warn of DOS 4.x bugs

        mov     ax,3000h
        int     21h             ; get version number
                                ; AL=major AH=minor
                                ; we want major*100 + minor
                                ; BH = OEM id, FF for MS, 0 for IBM
        cmp     al,4
        jne     notDos4

        lea     dx,noDOS4Msg
        call    Say
        jmp     Quit

NotDos4:
        ret

NoDos4  EndP

;=============================================

code    ends

end Beginning
