                PAGE    60,132
NAME    IsStac
        TITLE   IsStac Version 1.3
COMMENT 

IsStac C:
Detect if drive is a stacker drive.
  IsStac C:
  If Errorlevel 3 GoTo SyntaxError
  If ErrorLevel 2 GoTo WontWorkInDESQview
  If ErrorLevel 1 GoTo IsStackerDrive
  GoTo IsOrdinaryDrive

Isstac by itself detects if CURRENT drive is a stacker drive.

Sets errorlevel to 1 if drive is a stacker drive, 0 otherwise.


This code is based on the C-callable MASM routines in the
Stacker 2.0 manual.


Please report bugs and problems to:

Roedy Green
Canadian Mind Products
#208 - 525 Ninth Street
New Westminster BC Canada
V5H 2N6
tel:(604) 777-1804
mailto:roedy@mindprod.com
http://mindprod.com


Version 1.3 1998 November 8
- embed Barker address

Version 1.2 1996 October 25
- embed POB 707 Quathiaski Cove address

Future

- echo result
- give syntax summary if user enters a blank command line.

       ; end of comment

;======
stack   segment stack           ; keep MS link happy by providing null stack
stack   ends

;==============================================================

CODE    SEGMENT PARA            ; start off in code.

;==============================================================

data    segment word            ; provide a separate DATA segment
                                ; Even though it appears in the source
                                ; before the code, it the COM file it


;=============================================
;       E R R O R   M E S S A G E S
;=============================================

CopyrightMsg    label   byte
        db 13,10
        db      ' IsStac 1.3 ۲',13,10
        db      'Determines if the specified drive is a virtual Stacker volume.',13,10
        DB      'Copyright 1993-1999 Roedy Green Canadian Mind Products 1992,1996.',13,10
        DB      '#208 - 525 Ninth Street, New Westminster, BC Canada V3M 5T9',13,10
        DB      'tel:(604) 777-1804   mailto:roedy@mindprod.com   http://mindprod.com',13,10
        db      'May be freely distributed and used for any purpose except military.',13,10
        db      '$'
UsageMsg        label   Byte
 db 'Error in command line.  Try:',13,10
 db '  IsStac C:',13,10
 db '  If ErrorLevel 3 GoTo SyntaxError',13,10
 db '  If ErrorLevel 2 GoTo WontWorkInDESQview',13,10
 db '  If ErrorLevel 1 GoTo IsStackerDrive',13,10
 db '  GoTo IsOrdinaryDrive',13,10,'$'

DESQApology     label   Byte
 db 'Unfortunately IsStac does not work under DESQview.',13,10,"$"


st_ptr  dd      0               ; pointer to Stacker.

driveno dw      0               ; drive working on 0=A:

Result  db      0               ; sum of 3 trails

data    endS

;==============================================================

com     group   code,data

        ASSUME  CS:COM,DS:COM,ES:NOTHING
        ORG     100H
Start:
        Call    GetCurDrive     ; get default drive
        Call    Parse           ; prepare the command line
        Call    Analyse         ; analyse the command line for drive letter

        Call    TestDESQver     ; we can't work under DESQview
        test    ax,ax
        jnz     HaveDESQ        ; oh no! DESQview

TryAgain:
        mov     result,0

        mov     ax,DriveNo
        Call    StackerDrive    ; find out if drive is a Stacker Drive
                                ; al 0=not stacker 1=is stacker
        add     result,al

        mov     ax,DriveNo
        Call    StackerDrive    ; three times altogether
        add     result,al

        mov     ax,DriveNo
        Call    StackerDrive
        add     al,result

        cmp     al,0
        je      CertainNo       ; Certain is not stacker -- three 0 in a row

        cmp     al,3
        je      CertainYes      ; Certain is stacker -- three 1 in a row
        jmp     TryAgain

CertainYes:
        mov     ax,4c01h        ; exit back to DOS, with 1 errorlevel
        int     21h

CertainNo:
        mov     ax,4c00h        ; exit back to DOS, with 0 errorlevel
        int     21h


HaveDESQ:
        lea     dx,Copyrightmsg
        call    say
        lea     dx,DESQapology
        call    say
        mov     ax,4c02h        ; exit back to DOS with error code 2
        int     21h

Failed:
        lea     dx,Copyrightmsg
        call    say
        lea     dx,usagemsg
        call    say
        mov     ax,4c03h        ; exit back to DOS with error code 3
        int     21h

;==============================================================

StackerDrive    Proc Near

;       input AX 0=A: 1=B: 2=C: 3=D: 4=E: 5=F: etc
;       output AL 0=not stacker drive 1=is stacker drive

;       For bizarre multitasking reasons, you must call this routine until
;       you get the same answer 3 times in a row, in other words till the
;       sum is either 0 or 3 of the results.

;       Works in DOS with the removeable media IOCTL, but in DRDOS with
;       get logical device IOCTL

Unit_Offs       equ     3Eh     ; offset of unit # inside Stacker

        mov     driveno,ax      ; save drive
        cmp     word ptr st_ptr+2,0
                                ; have we already found Stacker
        jnz     AlreadyFoundStacker
        call    StackerVersion  ; look for Stacker
        test    ax,ax
        jnz     AlreadyFoundStacker
        ret                     ; no Stacker driver, so drive could not be.

AlreadyFoundStacker:
                                ; we have the driver, not necessarily controlling
                                ; this drive though
        mov     ah,30h          ; check for DOS 3.31 (DR DOS or Compaq)
        int     21h
        cmp     ax,1f03h
        mov     ax,4408h        ; do ioctl call (MS DOS)
        jnz     ChkDrive
        mov     ax,440Eh        ; get logical device (DR DOS)
ChkDrive:
        mov     bx,driveno
        inc     bx              ; adjust for 1 base
        les     di,st_ptr
        mov     byte ptr es:Unit_Offs[di],0ffh
                                ; set unit #
        int     21h             ; make the ioctl call
        les     di,st_ptr       ; see if unit# changed during call
        mov     bl,byte ptr es:Unit_Offs[di]
        xor     ax,ax
        cmp     bl,0ffh         ; set carry unless BL=0ffh
        adc     al,0            ; propagate carry into AL
        ret
StackerDrive    EndP


;==============================================================

StackerVersion Proc Near

;       Returns Stacker version *100 in AX, 0 if Stacker not loaded.
;       detect stacker by making an int 25 call with invalid parms

        push    bp
        push    si
        push    di
        sub     sp,1024         ; use stack as temp buffer
        mov     ax,0cdcdh       ; invalid drive
        mov     bx,sp           ; set up DS:bx as buffer for INT 25H
        mov     cx,1
        xor     dx,dx           ; read boot sector of invalid drive
        mov     word ptr [bx],dx; clear buffer first word result area
        push    ds              ; set ES:bp as well to fix DOS 3.0 int 25H bug
        pop     es
        mov     bp,bx
        int     25h
        pop     cx              ; kill flags
        xor     ax,ax           ; default no Stacker
        mov     bx,sp           ; point at result
        cmp     word ptr [bx],0cdcdH
                                ; stacker fills fields
        jnz     NoStacker
        cmp     word ptr 2[bx],1
        jnz     NoStacker
        les     di,4[bx]        ; pointer into Stacker
        cmp     word ptr es:[di],0a55ah
                                ; look for signature
        jnz     NoStacker
        mov     word ptr st_ptr,   di
        mov     word ptr st_ptr+2, ES
        mov     ax,ES:[di+2]    ; return stacker version *100
NoStacker:
        add     sp,1024
        pop     di              ; restore regs
        pop     si
        pop     bp
        ret

StackerVersion  EndP


;=============================================
;       C O M M A N D   L I N E   P A R S I N G   R O U T I N E S
;=============================================

MLeading        PROC    Near

;       Remove leading blanks
;       on entry ES:BX is addr of string, CX its length
;       trims off any leading blanks, leaving result in BX CX
;       length may also be 0 or 1, but not -ve
;       If the entire string is blank the result is the null string

        mov     di,bx
        mov     al,20H          ; AL = blank  -- the search char
        jcxz    mleading2       ; jump if null string
        repe    scasb           ; scan ES:DI forwards till hit non blank
                                ; DI points just after it (wrap ok)
                                ; cx IS ONE TOO SMALL, OR 0 IF NONE FOUND
        je      mleading1       ; jump if entire string was blank
        inc     cx              ; CX is length of remainder of string
mleading1:
        dec     di              ; DI points to non-blank
mleading2:
        mov     bx,di           ; put address back
        ret

MLeading        ENDP

;========================================

MTrailing       PROC    Near

;       Remove trailing blanks.
;       on entry ES:BX is addr of string, CX its length
;       trims off any trailing blanks, leaving result in BX CX
;       length may also be 0 or 1, but not -ve
;       If the entire string is blank the result is the null string

        mov     di,bx
        add     di,cx           ; calc addr last char in string
        dec     di
        mov     al,20H          ; AL = blank  -- the search char
        jcxz    mtrailing1      ; jump if null string
        std
        repe    scasb           ; scan ES:DI backwards till hit non blank
                                ; DI points just ahead of it (wrap ok)
                                ; CX is one too small, or 0 if none found
        cld
        je      mtrailing1      ; jump if whole string was blank
        inc     cx
mtrailing1:
        ret

MTrailing       ENDP

;========================================

Parse           PROC    NEAR
;       Parse the command line to remove lead/trail blanks from
;       the single drive parameter and terminate it by 2 nulls.
;       sample inputs
;       IsStac A:
;       IsStac  B:
;       IsStac
;       ES: points to PSP
;       When Done ES:BX points to start of string.
;       String will be terminated by 2 nulls
;       CX counts bytes in string exclusive of nulls
                                ; counted string at HEX 80 PSP
                                ; contains command line.
                                ; Preceeded by unwanted spaces.
                                ; possibly followed by unwanted spaces.
                                ; currently missing a trailing null.
        xor     ch,ch
        mov     cl,es:[80H]
        mov     bx,81H
        call    Mleading        ; get rid of leading blanks
        call    MTrailing       ; get rid of trailing blanks
        mov     di,bx           ; calc addr of byte just past end
        add     di,cx
        mov     word ptr ES:[di],0 ; plop in pair of nulls after string
        ret

Parse           ENDP

;======================================

ToUC            PROC    NEAR
;       converts char in AL to upper case
        cmp     al,'a'
        jb      FineAsIs
        cmp     al,'z'
        ja      FineAsIs
        sub     al,20H          ; convert a to A
FineAsIs:
        ret

ToUc            ENDP

;======================================

Analyse         PROC    NEAR
;       analyses the command line allowing A: or B: or null
;       On entry ES:BX points to start of string.
;       String will be terminated by 2 nulls
;       CX counts bytes in string exclusive of nulls
;       lead/trail spaces are gone.
        jcxz    AnalDone        ; was no command, treat as A:
        cmp     cx,2
        jne     BadCmd          ; kick out A   A:/X
        mov     ax,ES:[bx]      ; get chars AL<-A  AH<-:
        cmp     ah,':'          ; make sure second char is :
        jne     BadCmd
        call    ToUc
        sub     al,'A'          ; a->0 b->1 z->25
        cmp     al,25
        ja      BadCmd          ; allow only A: .. Z:
        mov     Byte Ptr DriveNo,AL
AnalDone:
        RET
BadCmd:
        Jmp     Failed

Analyse         ENDP

;=============================================
GetCurDrive    PROC    near

;       Get default drive, store as char in DriveNo

        mov     ah,19h          ; ask DOS what default drive is
        int     21h
                                ; result it AL, 0=A 1=B
                                ; NOTE THIS IS NOT THE USUAL DOS
                                ; CONVENTION WHERE 1=A
        mov     byte ptr DriveNo,al
        ret

GetCurDrive     EndP

;=======================================

Say             Proc    Near
;       on entry DX points to a string to display on screen
        MOV     AH,9
        Int     21h
        ret
Say             EndP

;=======================================

TestDESQVer     Proc    Near

; What version of DesqView is present?
; Returns version *100 in AX if present, 0 otherwise.
; Method from Tech support on BIX

; This about the fifth version of this code. The following techniques
; do NOT work on all machines.  The problems are DOS and BIOS bugs.
; The approach we have here depends more actively on DESQview itself
; so it should be safer.
; Technique from DV manual, appendix J.
; @CALL DVPRESENT from API manual page 29
; Trashes CX DX AX

        mov     cx,'DE'         ; deliberately invalid set date
        mov     dx,'SQ'
        sub     bx,bx           ; in case DOS just ignores us
        mov     ax,2b01h
        int     21h
        mov     ax,bx           ; version # to AX
        cmp     ax,2            ; early DV 2.00 ?
        jne     NotOldDESQ      ; jump if not
        xchg    ah,al           ; swap bytes if old version
NotOldDESQ:
        test    ax,ax           ; did we get back 0 we sent in bx?
        JZ      NoDESQ
                                ; ah=major version al=minor version
        mov     bl,100d         ; convert 2.31 -> 231
        mov     cl,al
        sub     ch,ch
        mov     al,ah           ; mult major version by 100
        mul     bl
        add     ax,cx           ; add on the minor version
        ret

NODESQ:
        mov     ax,0
        ret

TestDESQVer     EndP

;=======================================

CODE ends
end start
