                PAGE    60,132
NAME    IsDbl
        TITLE   IsDbl Version 1.3
COMMENT 

IsDbl C:
Detect if drive is a DBLSPACE drive.
  IsDbl C:
  If Errorlevel 2 GoTo SyntaxError
  If ErrorLevel 1 GoTo IsDblDrive
  GoTo IsOrdinaryDrive

IsDbl by itself detects if CURRENT drive is a dblspace drive.

Sets errorlevel to 1 if drive is a dblspace drive, 0 otherwise.

This code is based on the Dan Wright's MASM prgram of the same
name.  This version has slightly fancier error messages, and
will assemble under both MASM and OPTASM.


Please report bugs and problems to:

Roedy Green
Canadian Mind Products
#208 - 525 Ninth Street
New Westminster BC Canada
V5H 2N6
tel:(604) 777-1804
mailto:roedy@mindprod.com
http://mindprod.com


Version 1.2 1996 October 25
- embed POB 707 Quathiaski Cove address

Futures
- give syntax information if user enters a blank command line.
- echo status of drive, not just set errorlevel.

       ; end of comment

;======
stack   segment stack           ; keep MS link happy by providing null stack
stack   ends

;==============================================================

CODE    SEGMENT PARA            ; start off in code.

;==============================================================

data    segment word            ; provide a separate DATA segment
                                ; Even though it appears in the source
                                ; before the code, it the COM file it
                                ; follows

;=============================================
;       E R R O R   M E S S A G E S
;=============================================

CopyrightMsg    label   byte
        db      13,10
        db      ' IsDbl 1.3 ۲',13,10
        db      13,10
        db      'Determines if the specified drive is a virtual Dblspace volume.',13,10
        db      13,10
        DB      'Copyright 1993-1999 Roedy Green Canadian Mind Products.',13,10
        DB      '#208 - 525 Ninth Street, New Westminster, BC Canada V3M 5T9',13,10
        DB      'tel:(604) 777-1804   mailto:roedy@mindprod.com   http://mindprod.com',13,10
        db      'May be freely distributed and used for any purpose except military.',13,10
        db      13,10,'$'
UsageMsg        label   Byte
 db 'Error in command line.  Try:',13,10
 db '  IsDbl C:',13,10
 db '  If ErrorLevel 2 GoTo SyntaxError',13,10
 db '  If ErrorLevel 1 GoTo IsDblDrive',13,10
 db '  GoTo IsOrdinaryDrive',13,10,'$'

ExpectedSig     db      "DBLSPAC"       ; apparent signature field
ExpectedSigLen  EQU     7
DriveNo         DW      0               ; A: = 0 drive #

data    endS

;==============================================================

com     group   code,data

        ASSUME  CS:COM,DS:COM,ES:COM
        ORG     100H
Start:
        Call    GetCurDrive     ; get default drive in AL
        Call    Parse           ; prepare the command line
        Call    Analyse         ; analyse the command line for drive letter
                                ; AL has drive letter A: = 0
        Call    DblDrive        ; find out which type it was
                                ; al has ret code 0=no 1=yes
        mov     ah,4ch          ; exit back to DOS, with 0/1 errorlevel
        int     21h

Failed:
        lea     dx,Copyrightmsg
        call    say
        lea     dx,usagemsg
        call    say
        mov     ax,4c02h        ; exit back to DOS with error code 2
        int     21h

;==============================================================

DBLDrive        Proc Near

;       input AL 0=A: 1=B: 2=C: 3=D: 4=E: 5=F: etc
;       output AL 0=not stacker drive 1=is stacker drive

        push    DS
        mov     dl,al                   ; fetch DPB for this drive
        inc     dl                      ; A: = 1, uses 1 based.
        mov     ah,32H                  ; See undocumented DOS page 507
        int     21H                     ; Get Drive Parameter Block
                                        ; FF is usual bad code, but any
                                        ; non-zero we will reject.
        or      al,al                   ; Drive invalid or network?

        jnz     Not_DBL                 ; yes, therefore not DBLSPACEd
        lds     si,ds:[bx].13H          ; get ptr to device header
        add     si,11                   ; point at second byte of name field
        mov     di,offset COM:ExpectedSig
                                        ; ES: still covers it
        mov     cx, ExpectedSigLen
        rep cmpsb                       ; compare signatures
        jne     Not_DBL
        mov     ax,1                    ; drive is DBLSPACEd, exit code=1
        pop     DS
        ret

Not_DBL:
        mov     ax,0                    ; drive is not DBLSPACEd, exit code=0
        pop     DS
        ret
DblDrive        EndP

;==============================================================
;=============================================
;       C O M M A N D   L I N E   P A R S I N G   R O U T I N E S
;=============================================

MLeading        PROC    Near

;       Remove leading blanks
;       on entry ES:BX is addr of string, CX its length
;       trims off any leading blanks, leaving result in BX CX
;       length may also be 0 or 1, but not -ve
;       If the entire string is blank the result is the null string

        mov     di,bx
        mov     al,20H          ; AL = blank  -- the search char
        jcxz    mleading2       ; jump if null string
        repe    scasb           ; scan ES:DI forwards till hit non blank
                                ; DI points just after it (wrap ok)
                                ; cx IS ONE TOO SMALL, OR 0 IF NONE FOUND
        je      mleading1       ; jump if entire string was blank
        inc     cx              ; CX is length of remainder of string
mleading1:
        dec     di              ; DI points to non-blank
mleading2:
        mov     bx,di           ; put address back
        ret

MLeading        ENDP

;========================================

MTrailing       PROC    Near

;       Remove trailing blanks.
;       on entry ES:BX is addr of string, CX its length
;       trims off any trailing blanks, leaving result in BX CX
;       length may also be 0 or 1, but not -ve
;       If the entire string is blank the result is the null string

        mov     di,bx
        add     di,cx           ; calc addr last char in string
        dec     di
        mov     al,20H          ; AL = blank  -- the search char
        jcxz    mtrailing1      ; jump if null string
        std
        repe    scasb           ; scan ES:DI backwards till hit non blank
                                ; DI points just ahead of it (wrap ok)
                                ; CX is one too small, or 0 if none found
        cld
        je      mtrailing1      ; jump if whole string was blank
        inc     cx
mtrailing1:
        ret

MTrailing       ENDP

;========================================

Parse           PROC    NEAR
;       Parse the command line to remove lead/trail blanks from
;       the single drive parameter and terminate it by 2 nulls.
;       sample inputs
;       IsDbl A:
;       IsDbl   B:
;       IsDbl
;       ES: points to PSP
;       When Done ES:BX points to start of string.
;       String will be terminated by 2 nulls
;       CX counts bytes in string exclusive of nulls
                                ; counted string at HEX 80 PSP
                                ; contains command line.
                                ; Preceeded by unwanted spaces.
                                ; possibly followed by unwanted spaces.
                                ; currently missing a trailing null.
        xor     ch,ch
        mov     cl,es:[80H]
        mov     bx,81H
        call    Mleading        ; get rid of leading blanks
        call    MTrailing       ; get rid of trailing blanks
        mov     di,bx           ; calc addr of byte just past end
        add     di,cx
        mov     word ptr ES:[di],0 ; plop in pair of nulls after string
        ret

Parse           ENDP

;======================================

ToUC            PROC    NEAR
;       converts char in AL to upper case
        cmp     al,'a'
        jb      FineAsIs
        cmp     al,'z'
        ja      FineAsIs
        sub     al,20H          ; convert a to A
FineAsIs:
        ret

ToUc            ENDP

;======================================

Analyse         PROC    NEAR
;       analyses the command line allowing A: or B: or null
;       On entry ES:BX points to start of string.
;       String will be terminated by 2 nulls
;       CX counts bytes in string exclusive of nulls
;       lead/trail spaces are gone.
        jcxz    AnalDone        ; was no command, treat as A:
        cmp     cx,2
        jne     BadCmd          ; kick out A   A:/X
        mov     ax,ES:[bx]      ; get chars AL<-A  AH<-:
        cmp     ah,':'          ; make sure second char is :
        jne     BadCmd
        call    ToUc
        sub     al,'A'          ; a->0 b->1 z->25
        cmp     al,25
        ja      BadCmd          ; allow only A: .. Z:
        mov     Byte Ptr DriveNo,AL
AnalDone:
        RET
BadCmd:
        Jmp     Failed

Analyse         ENDP

;=============================================
GetCurDrive    PROC    near

;       Get default drive, store as char in DriveNo

        mov     ah,19h          ; ask DOS what default drive is
        int     21h
                                ; result it AL, 0=A 1=B
                                ; NOTE THIS IS NOT THE USUAL DOS
                                ; CONVENTION WHERE 1=A
        mov     byte ptr DriveNo,al
        ret

GetCurDrive     EndP

;=======================================

Say             Proc    Near
;       on entry DX points to a string to display on screen
        MOV     AH,9
        Int     21h
        ret
Say             EndP

;=======================================

CODE ends
end start
