PROGRAM HyperWin;
{**********************************************
 *  Windows Keyboard-Interface for Hyperdisk  *
 *  Simulates Keyboardpresses for Hyperwares  *
 *              -= Hyperdisk =-               *
 *  Copyright 1994 Kay Bruns Ilmenau/Germany  *
 **********************************************}

{$C Fixed,Preload,Permanent}
{$M 1024,256}
{$R HyperWin.RES}

USES HyperApi,Win31,WinProcs,WinTypes,MMSystem,Strings;

VAR KeyHook:tHookProc;
    Hook:hHook;
    i:LongInt;

VAR CtrlState:pByte;

PROCEDURE HDPowerOff;ASSEMBLER;
ASM
  {frist Controller primary Disk}
  xor al,al
  mov dx,$1F6
  out dx,al
  mov al,$E0
  inc dx
  out dx,al
  {frist Controller Secondary Disk}
  mov al,$10
  dec dx
  out dx,al
  mov al,$E0
  inc dx
  out dx,al
  {second Controller primary Disk}
  xor al,al
  mov dx,$176
  out dx,al
  mov al,$E0
  inc dx
  out dx,al
  {second Controller Secondary Disk}
  mov al,$10
  dec dx
  out dx,al
  mov al,$E0
  inc dx
  out dx,al
END;

PROCEDURE Sound(Freq:Word;Delay:Longint);ASSEMBLER;
ASM
        {NoSound}
        IN      AL,61H
        AND     AL,0FCH
        OUT     61H,AL
        {Sound(Freq)}
        MOV     BX,Freq
        MOV     AX,34DDH
        MOV     DX,0012H
        CMP     DX,BX
        JNC     @@2
        DIV     BX
        MOV     BX,AX
        IN      AL,61H
        OR      AL,3
        OUT     61H,AL
        MOV     AL,0B6H
        OUT     43H,AL
        MOV     AL,BL
        OUT     42H,AL
        MOV     AL,BH
        OUT     42H,AL
@@2:    {Delay(Delay)}
        Call TimeGetTime
        add  word ptr Delay,ax
        adc  word ptr Delay+2,dx
@Loop:  call Yield
        Call TimeGetTime
        DB 66h; shl ax,16
        DB 66h; shl dx,16
        DB 66h; shr ax,16
        DB 66h; add ax,dx
        DB 66h; cmp ax,word ptr delay
        jb @Loop
        {NoSound}
        IN      AL,61H
        AND     AL,0FCH
        OUT     61H,AL
END;
PROCEDURE Delay(Delay:Longint);ASSEMBLER;
ASM
        {Delay(Delay)}
        Call TimeGetTime
        add  word ptr Delay,ax
        adc  word ptr Delay+2,dx
@Loop:  call Yield
        Call TimeGetTime
        DB 66h; shl ax,16
        DB 66h; shl dx,16
        DB 66h; shr ax,16
        DB 66h; add ax,dx
        DB 66h; cmp ax,word ptr delay
        jb @Loop
END;

FUNCTION KeyHookProc(Code:Integer;wP:Word;lP:Pointer):Longint; FAR;
BEGIN
  {Datensegment laden : }ASM push ds; mov ax,seg @data; mov ds,ax; END;
  WITH pMsg(lP)^ DO
  IF ((message=wm_KeyDown)OR(message=wm_KeyUp))AND((CtrlState^ AND $0F)=$0C)THEN
  BEGIN
    CASE wParam OF
      Word('D'),Word('d'):
      BEGIN
        IF (message=wm_KeyDown)AND(LoWord(lParam)=1)THEN
        BEGIN
          sound(1600,100);
          i:=TimeGetTime;
          HyperSetState(HyperGetState AND NOT(CacheEnable));
          i:=TimeGetTime-i;
          IF i>100 THEN BEGIN sound(1600,100); Delay(100); END ELSE Delay(100-i);
          sound(1450,100);
        END;
        message:=wm_NULL;
      END;
      Word('E'),Word('e'):
      BEGIN
        IF (message=wm_KeyDown)AND(LoWord(lParam)=1)THEN
        BEGIN
          HyperSetState(HyperGetState OR CacheEnable);
          sound(1600,100);
        END;
        message:=wm_NULL;
      END;
      Word('W'),Word('w'):
      BEGIN
        IF (message=wm_KeyDown)AND(LoWord(lParam)=1)THEN
        BEGIN
          HyperSetState(HyperGetState AND NOT(StagedHard));
          sound(1600,100); IF HyperGetState AND CacheEnable=0 THEN BEGIN Delay(100); sound(1450,100);END;
        END;
        message:=wm_NULL;
      END;
      Word('S'),Word('s'):
      BEGIN
        IF (message=wm_KeyDown)AND(LoWord(lParam)=1)THEN
        BEGIN
          HyperSetState(HyperGetState OR StagedHard);
          sound(1600,100); IF HyperGetState AND CacheEnable=0 THEN BEGIN Delay(100); sound(1450,100);END;
        END;
        message:=wm_NULL;
      END;
      Word('Q'),Word('q'):
      BEGIN
        IF (message=wm_KeyDown)AND(LoWord(lParam)=1)THEN
        BEGIN
          HyperSetState(HyperGetState AND NOT(StagedFloppy));
          sound(1600,100); IF HyperGetState AND CacheEnable=0 THEN BEGIN Delay(100); sound(1450,100);END;
        END;
        message:=wm_NULL;
      END;
      Word('A'),Word('a'):
      BEGIN
        IF (message=wm_KeyDown)AND(LoWord(lParam)=1)THEN
        BEGIN
          HyperSetState(HyperGetState OR StagedFloppy);
          sound(1600,100); IF HyperGetState AND CacheEnable=0 THEN BEGIN Delay(100); sound(1450,100);END;
        END;
        message:=wm_NULL;
      END;
      Word('H'),Word('h'):
      BEGIN
        IF (message=wm_KeyDown)AND(LoWord(lParam)=1)THEN
        BEGIN
          sound(1600,100); Delay(100);
          sound(1450,100); Delay(100);
          sound(1600,100); Delay(1000);
          HDPowerOff;
        END;
        message:=wm_NULL;
      END;
      ELSE CallNextHookEx(Hook,Code,wP,Longint(lP));
    END;
  END ELSE CallNextHookEx(Hook,Code,wP,Longint(lP));
  {altes Datensegment wieder laden : }ASM pop DS END;
END;

VAR Msg:tMsg;
    s:STRING;
    pc:pChar;
BEGIN
  IF NOT HyperDskInstalled THEN
  BEGIN
    MessageBox(0,'No Hyperdisk Cache found!'+#10#10+'Ciao till you have it installed...'
                ,'Hyperdisk Interface - Fatal Error!',0);
    Exit;
  END;
  IF hPrevInst<>0 THEN
  BEGIN
    Hook:=GetProfileInt('HyperDiskInterface','hTask',0);
    PostAppMessage(Hook,WM_Quit,0,0);
    Halt(0);
  END ELSE
  BEGIN
    IF GlobalFindAtom('HyperWin')<>0 THEN Exit;
    GlobalAddAtom('HyperWin');
    GetProfileString('HyperDiskInterface','I am Here','',@s[1],254); s[0]:=Char(StrLen(@s[1]));
    IF s='' THEN
    BEGIN
      pc:=globalallocptr(0,1024);
      StrCopy(pc,'Welcome to the Hyperdisk Keyboard Interface!'+#10#10);
      StrCat(pc ,'This is a little program to control your cache in Windows via the following hotkeys:'+#10#10);
      StrCat(pc ,'CTRL + ALT + D: disable cache'+#10#10);
      StrCat(pc ,'CTRL + ALT + E: enable cache'+#10#10);
      StrCat(pc ,'CTRL + ALT + W: disable staged hard disk writes'+#10#10);
      StrCat(pc ,'CTRL + ALT + S: enable staged hard disk writes'+#10#10);
      StrCat(pc ,'CTRL + ALT + Q: disable staged floppy disk writes'+#10#10);
      StrCat(pc ,'CTRL + ALT + A: enable staged floppy disk writes'+#10#10#10);
      StrCat(pc ,'CTRL + ALT + H: turn off all IDE Harddisks'+#10#10#10);
      StrCat(pc ,'--== Start HyperWin again to unload itself ==--'+#10#10);
      StrCat(pc ,'1994 Kay Bruns, Max-Planck-Ring 6e/5, D-98693 Ilmenau, Germany');
      MessageBox(0,pc,'Hyperdisk Interface',0);
      globalfreeptr(pc);
      WriteProfileString('HyperDiskInterface','I am Here','1');
    END;
    CtrlState:=Ptr(LoWord(Longint(GetProcAddress(GetModuleHandle('kernel'),'__0040H'))),0);
    IF CtrlState=NIL THEN Exit;
    Inc(CtrlState,$17);
    Str(GetCurrentTask,s);
    s[length(s)+1]:=#0;
    @KeyHook:=MakeProcInstance(@KeyHookProc,hInstance);
    Hook:=SetWindowsHookEx(WH_GetMessage,KeyHook,hInstance,0);
    WriteProfileString('HyperDiskInterface','hTask',@s[1]);
    WHILE GetMessage(Msg,0,0,0) DO BEGIN TranslateMessage(Msg); DispatchMessage(Msg); END;
    WriteProfileString('HyperDiskInterFace','hTask',NIL);
    IF NOT UnHookWindowsHookEx(Hook)
    THEN MessageBox(0,'FATAL: Could not remove Windows Hook!'+#10#10+'Windows is coming down...NOW!'
                     ,'Hyperdisk Interface Error!',0)
    ELSE MessageBox(0,'HyperWin Hook successfully removed'+#10#10
                      +'Thanks for using HyperWin. Have a nice day.'+#10
                      +'1994 Kay Bruns, Max-Planck-Ring 6e/5, D-98693 Ilmenau, Germany.','Hyperdisk Interface - Exit',0);
    FreeProcInstance(@KeyHook);
    GlobalDeleteAtom(GlobalFindAtom('HyperWin'));
  END;
END.