UNIT HyperApi;
INTERFACE
{ HyperDisk installation check. }
FUNCTION HyperdskInstalled:Boolean;
CONST StagedFloppy=$01;
      StagedHard  =$02;
      VerifyFloppy=$04;
      VerifyHard  =$08;
      FloppyEnable=$40;
      CacheEnable =$80;

{ Get Current HyperDisk Cache State
; Call and return register descriptions for Interrupt 2Fh:
; Calling Registers:
;	AH = Multiplex Number	; Value determined by Install Check
;	AL = 01h		; Get current HyperDisk Cache State
;	BX ='DH'		; Product = Disk, HyperWare
; Return Registers:
;	AX = 0000h		; function supported
;	BX = UsedBuffers	; number of cache buffers in use
;	CX = ModifiedBuffers	; number of modified buffers
;	DL = Current Cache values: 0 = Disabled, 1 = Enabled
;	     Bit 0..StagedFloppy: Stage Write floppy drive write operations
;	     Bit 1....StagedHard: Stage Write hard drive write operations
; 	     Bit 2..VerifyFloppy: Verify floppy drive write operations
; 	     Bit 3....VerifyHard: Verify hard drive write operations
; 	     Bit 4.....Reserved0: Reserved always 0
; 	     Bit 5.....Reserved1: Reserved always 0
; 	     Bit 6..FloppyEnable: Enable floppy caching
; 	     Bit 7..CacheEnabled: Enable all caching functions}
FUNCTION HyperGetState:Byte;

{ Set HyperDisk Cache State, return previous Cache State
; Call and return register descriptions for Interrupt 2Fh:
; Calling Registers:
;	AH = Multiplex Number	; Value determined by Install Check
;	AL = 01h		; Get current HyperDisk Cache State
;	BX ='DH'		; Product = Disk, HyperWare
;	DL = New Cache values
; Return Registers:
;	AX = 0000h		; function supported and asynchronously queued
;	BX = UsedBuffers	; number of cache buffers in use
;	CX = ModifiedBuffers	; number of modified buffers
;	DH = Previous Cache values }
PROCEDURE HyperSetState(State:Byte);

IMPLEMENTATION

CONST HyperCallOut:Byte=$DF;
      HyperInstalled:Boolean=False;

FUNCTION HyperdskInstalled:Boolean;ASSEMBLER;
ASM
        cmp     HyperInstalled,1
        je      @SearchHyAPIFound
	mov	ax,352fh
	int	21h
	mov	cx,es
	jcxz	@SearchHyAPIRet
@SearchHyAPILp:
	xor	cx,cx
	xor	dx,dx
	mov	bx,'DH'
	mov	ah,HyperCallOut
	xor	al,al
	push	ds
	int	2fh
	pop	ds
	or	al,al
	je	@SearchHyAPIRet
	cmp	al,-1
	jne	@SearchHyAPINxt
	cmp	cx,'YH'
	jne	@SearchHyAPINxt
	or	dx,dx
	jz	@SearchHyAPIRet
@SearchHyAPIFound:
        mov     ax,1
        mov HyperInstalled,al
        jmp     @ret
@SearchHyAPINxt:
	inc	HyperCallOut
	jnz	@SearchHyAPILp
@SearchHyAPIRet:
	xor ax,ax
@ret:
END;

FUNCTION HyperGetState:Byte;ASSEMBLER;
ASM
        cmp     HyperInstalled,1
        jne     @OUT
	mov	ah,HyperCallOut
	mov	bx,'DH'
	mov	al,01h
	int	2fh
        mov     al,dl
@Out:
END;

PROCEDURE HyperSetState(State:Byte);ASSEMBLER;
ASM
        cmp     HyperInstalled,1
        jne     @OUT
	mov	ah,HyperCallOut
	mov	bx,'DH'
	mov	al,02h
        mov     dl,State
	int	2fh
@Out:
END;



BEGIN
END.
