        PAGE    60,132
NAME    FBIOS
        TITLE   FBIOS.Exe Version 1.3
        .286            ; sorry no XT
COMMENT 
FBIOS.EXE Copyright Roedy Green Canadian Mind Products

May be freely distributed for non-military use only.
Tests Floppy BIOS to see which parts work.

NOTE THIS IS AN EXE -- NOT A COM!!!


Please report bugs and problems to:

Roedy Green
Canadian Mind Products
#208 - 525 Ninth Street
New Westminster BC Canada
V5H 2N6
tel:(604) 777-1804
mailto:roedy@mindprod.com
http://mindprod.com


version 1.3 1998 November 8
- embed Barker address

Version 1.2 1996 October 25
- embed POB 707 Quathiaski Cove address

Version 1.1 1993 June 12
- embed new address

Version 1.0 1992 June 23

How it works
************

We read with a floppy in place, then without one.  We compare
statuses against the expected ones.


       ; end of comment
;======

ImAt    Macro   char ; displays character to let you know where
                ; you are executing in the program
                ; debugging tool.
        push    ax
        push    bx
        mov     ah,0Eh
        mov     al,"&char"
        mov     bl,Screenattrib
        int     10h
        pop     bx
        pop     ax
        endM

;======

CR      MACRO   ; Carriage return line feed
        DB 0dh,0ah
        ENDM

;======

EOS     MACRO   ; marks end of display string
        DB 0dh,0ah,'$'
        ENDM
;======
jcL     MACRO   Where
        local   isok
;; jc when target is out of range.
;; OPTASM does this automatically, but MASM needs help
        jnc     isok
        jmp     &Where          ; might generate SHORT JMP
isok:
        ENDM
;======
jeL     MACRO   Where
        local   isok
;; je when target is out of range.
;; OPTASM does this automatically, but MASM needs help
        jne     isok
        jmp     &Where          ; might generate SHORT JMP
isok:
        ENDM
;======
Corral  MACRO   r1,lb,ub  ; forces a register to lie in a safe range.
        local   bigenough,smallenough
        cmp     &r1,&lb
        jge     bigenough
        mov     &r1,&lb
bigenough:
        cmp     &r1,&ub
        jle     smallenough
        mov     &r1,&ub
smallenough:

        ENDM
;==============================================================

Stack           SEGMENT para stack

        db      512 dup (?)

Stack           ends

;==============================================================

CODE    SEGMENT PARA            ; start off in code.
Code    Ends
;==============================================================

data    SEGMENT para            ; provide a separate DATA segment
                                ; Even though it appears in the source
                                ; before the code, it the EXE file it
                                ; will appear at the end.  This is as dodge
                                ; to avoid forward references that confuse
                                ; MASM.


data    endS

;==============================================================

Buffer  SEGMENT para
        db      (3*512) dup (?) ; It might need to hold 33 sectors
                                ; to do the i/o.
                                ; Put this at the end, because it is just
                                ; empty workspace.
                                ; However if we are unlucky, we might need
                                ; 66 sectors to avoid spanning a DMA
                                ; boundary.  So the buffer needs to be 33K
                                ; big enough to handle
                                ; erasing a 1.44 floppy in a single i/o


Buffer          EndS

;=============================================
;       G E N E R A L   M E S S A G E S
;=============================================

Data            Segment

;   General Display Strings


copyrightmsg    label   byte
        CR
        db      ' FBIOS 1.3 ۲'
        CR
        CR
        DB      'Tests your floppy BIOS for bugs.'
        CR
        CR
        DB      'Copyright 1992-1999 Roedy Green Canadian Mind Products.'
        CR
        DB      '#208 - 525 Ninth Street, New Westminster, BC Canada V3M 5T9'
        CR
        DB      'tel:(604) 777-1804   mailto:roedy@mindprod.com   http://mindprod.com'
        CR
        db      'May be freely distributed and used for any purpose except military.'
        CR
        eos

InsertMsg       Label   Byte
                cr
                cr
                db      '     '
                db      'Please insert a known good formatted diskette in A:'
                cr
                db      '     '
                db      'It will not be harmed.'
                cr
                db      '     '

                db      'Then HIT THE SPACE BAR.'
                cr
                EOS

TestingMsg      Label   Byte
                db      '     '
                db      'Testing . . . Please be patient.'
                cr
                EOS

RemoveMsg Label Byte
                cr
                cr
                db      '     '
                db      'Please remove the diskette from A:'
                cr
                db      '     '
                db      'Then HIT THE SPACE BAR.'
                cr
                EOS


;=============================================
;       E R R O R   M E S S A G E S
;=============================================


bugs            db      0       ; count of bugs

SCarryMsg       db      '     '
                db      'BUG: On success, BIOS fails to clear the carry flag.'
                EOS

SCountMsg       db      '     '
                db      'BUG: On success, BIOS fails to set the sector count.'
                EOS

SStatus02Msg    db      '     '
                db      'BUG: On success, BIOS fails to clear the 13:02 status byte.'
                EOS

SStatus01Msg    db      '     '
                db      'BUG: On success, BIOS fails to clear the 13:01 status byte.'
                EOS

FCarryMsg       db      '     '
                db      'BUG: On failure, BIOS fails to set the carry flag.'
                EOS

FcountMsg       db      '     '
                db      'BUG: On failure, BIOS fails to clear the sector count.'
                EOS

FStatus02Msg    db      '     '
                db      'BUG: On failure, BIOS fails to set the int 13 function 02 status byte.'
                EOS

FStatus01Msg    db      '     '
                db      'BUG: On failure, BIOS fails to set the int 13 function 01 status byte.'
                EOS

AllOkMsg        db      '     '
                db      'No bugs found.'
                EOS


;======================================
;    B I O S   I / O   V A R I A B L E S
;======================================

Buffseg         dw      Buffer
Status02        db      0       ; diskette status according to BIOS
Status01        db      0       ; diskette status according to BIOS
Count           db      0       ; count of sectors read.
Carry           db      0       ; -1 if carry set

data    EndS

Code    Segment

;======================================
;   M A I N L I N E   R O U T I N E
;======================================

        ASSUME  CS:Code,DS:Nothing,ES:nothing,SS:Stack

MAIN    Proc    Near
Beginning:
                                ; This is an EXE file, and this is the
                                ; first instruction of program executed.
                                ; CS:IP points to Beginning
                                ; SS:SP points to stack
                                ; DS: ES: point to PSP

        mov     ax,SEG Data
        mov     DS,ax

        ASSUME  CS:Code,DS:Data,ES:nothing,SS:nothing
        Call    InitTheWorks            ; parse command line
                                        ; initialize everything
        ASSUME  ES:Buffer               ; for all our i/o.
        call    PleaseInsert            ; ask for first diskettee
        Call    SuccessTests
        Call    PleaseRemove
        Call    FailTests
        test    Bugs,-1                 ; if no bugs at all, let them know.
        jnz     SomeBugs
        lea     dx,AllOkMsg
        Call    say
SomeBugs:
QUIT:
        mov     ax,4c00h                ; exit back to DOS
        int     21h

MAIN    EndP

;=============================================

SuccessTests    Proc    Near

;       disk is inserted
        lea     dx,TestingMsg
        call    Say
        call    ReadBoot

        cmp     Carry,0
        je      scarryok
        inc     bugs
        lea     dx,ScarryMsg
        call    Say
Scarryok:


        cmp     Count,1
        je      sCountok
        inc     bugs
        lea     dx,SCountMsg
        call    Say
SCountok:


        cmp     Status01,0
        je      sStatus01ok
        inc     bugs
        lea     dx,SStatus01Msg
        call    Say
SStatus01ok:

        cmp     Status02,0
        je      sStatus02ok
        inc     bugs
        lea     dx,SStatus02Msg
        call    Say
SStatus02ok:
        ret

SuccessTests    Endp

;=============================================


FailTests       Proc    Near

;       disk is removed, all should fail
        lea     dx,TestingMsg
        call    Say

        call    ReadBoot

        cmp     Carry,0
        jne     Fcarryok
        inc     bugs
        lea     dx,FcarryMsg
        call    Say
Fcarryok:

        cmp     Count,0
        je      FCountok
        inc     bugs
        lea     dx,FCountMsg
        call    Say
FCountok:

        cmp     Status01,0
        jne     FStatus01ok
        inc     bugs
        lea     dx,FStatus01Msg
        call    Say
FStatus01ok:

        cmp     Status02,0
        jne     FStatus02ok
        inc     bugs
        lea     dx,FStatus02Msg
        call    Say
FStatus02ok:
        ret

FailTests       Endp

;=============================================



InitTheWorks    Proc    near

;       initialize FBIOS, parse command line

        Call    Banner                  ; Announce ourselves
        Call    Alignbuffer             ; Align buffer so does not cross
                                        ; a DMA boundary
                                        ; from now on ES: covers DMA buffer
        ret

InitTheWorks    EndP


;=============================================

PleaseInsert    Proc    Near

;       ask user to insert a diskette
        lea     dx,InsertMsg
        call    say
        Call    WaitForProd
        ret

PleaseInsert    EndP

;=============================================

PleaseRemove    Proc    Near

;       ask user to remove a diskette
        lea     dx,RemoveMsg
        call    say
        Call    WaitForProd
        ret

PleaseRemove    EndP

;=============================================
;       K E Y B O A R D   R O U T I N E S
;=============================================

WaitForProd Proc        Near

;       Checks if has been a keystroke.
;       ESC will terminate program, and space will
;       we treated as a probe, i.e. restart the motors and read the boot.
;       Other characters are ignored with a eep-tone.
;       Return carry if user prodded us with a space bar.=
;       Ctrl-Break and Ctrl-C will be treated as ESC

NoChar:
        mov     ah,06h
        mov     dl,0ffH
        int     21h
        jz      NoChar          ; Jump if no keystroke.
        cmp     al,27           ; is it an esc?
        je      Stop            ; YES, DIE, don't return
        cmp     al,03           ; is it a ctrl-C?
        je      Stop            ; YES, DIE, don't return
        cmp     al,32           ; is it a Space?
        je      Spacechar       ; YES, jump
        jmp     NoChar

Spacechar:                      ; user hit spacebar
        ret

Stop:                           ; user hit ESC or equivalent
        jmp     Quit

WaitforProd EndP

;=============================================
;       S C R E E N   D I S P L A Y   R O U T I N E S
;=============================================

Say             Proc    Near

;       on entry DS:DX points to a string to display on screen
;       We don't use Int 21h function 9 because that stirs up ANSI.SYS.
;       We cannot use BIOS write string, int 10 function 13h either.
;       This is not supported on the XT.  We want to at least apologize.
;       So we use int 10 function 0E which displays without overwriting
;       the attribute.
;       Trashes ax, bx, si

        mov     si,dx
        mov     ah,0Eh
        mov     bl,07
SayNextChar:
        lodsb                   ; get next char in AL
        cmp     al,'$'          ; $ marks end of string
        je      StringSaid
        int     10h
        jmp     SayNextChar

StringSaid:
        ret

Say             EndP

;============================================


Banner  Proc    Near

;       Display the copyright banner

        lea     dx, copyrightMsg        ; Announce ourselves
        Call    Say

        ret

Banner  EndP

;=============================================
;       D I S K E T T E   B I O S   R O U T I N E S
;=============================================


Readboot Proc Near

;       reads boot sector

        mov     bx,0                    ; ES:0 is buffer
        mov     dl,0                    ; set up for read A=0 B=1
        mov     dh,0                    ; dh=head
        mov     ch,0                    ; ch=track
        mov     cl,1                    ; cl=sector, 1 based

        mov     al,1                    ; al=count of sectors to read
        mov     ah,02                   ; ah=02 read function 03=Write
        int     13h                     ; first try

        mov     ah,0                    ; clear the error
        int     13h

        mov     al,1                    ; al=count of sectors to read
        mov     ah,02                   ; ah=02 read function 03=Write
        int     13h                     ; Second try

        mov     ah,0                    ; clear the error
        int     13h

        mov     al,1                    ; al=count of sectors to read
        mov     ah,02                   ; ah=02 read function 03=Write
        int     13h                     ; third try -- this one counts

        mov     Status02,AH
        mov     Count,AL
        sbb     al,al
        mov     Carry,AL                ; save -1=carry set

        mov     ah,1
        int     13h
        mov     Status01,AH

        mov     ah,0                    ; clear the error
        int     13h

        ret

        pop     ES

Readboot        EndP

;======================

AlignBuffer     Proc    Near

;       allocate a 16.5K buffer that does not span a 64K DMA boundary
;       Leaves result in Buffseg and ES:
;       We already own all of the rest of ram.  We are simply
;       adjusting BuffSeg up a little to avoid a boundary.

buffsize        equ     32      ; size in paragraphs


        mov     ax,BuffSeg
        add     ax,buffsize-1   ; head and tail in same 64K segment?
        xor     ax,BuffSeg
        and     ax,0F000h       ; same dma page?
        jz      BufferReady     ; yes, ok as is
        mov     ax,Buffseg      ; move buffer to start of next 64K boundary
        add     ax,01000h
        and     ax,0F000h
        mov     Buffseg,ax

BufferReady:
        mov     ES,Buffseg
        ret

AlignBuffer     EndP

;========================================


CODE ends
end Beginning
