;
; (c) 1996 by MCA Software Group
;

cr	equ	0dh
lf	equ	0ah
ht	equ	09h

BLOCKSIZE	equ	32768

puts	macro	string
	mov	ah,9
	mov	dx,offset string
	int	21h
endm

ERR_PARAMS	equ 1
ERR_XMM		equ 2
ERR_READ	equ 3
ERR_BAD_IMAGE	equ 4
ERR_NOT_INST	equ 10
ERR_HOOKED	equ 11
ERR_FREE	equ 12

xmm_copyblk	struc
	count		dw	0
			dw	0
	src_handle	dw	0
	src_offset	dw	0
			dw	0
	dest_handle	dw	0
	dest_offset	dw	0
			dw	0
xmm_copyblk	ends

;Values for XMS error code returned in BL:
; 00h	successful
; 80h	function not implemented
; 81h	Vdisk was detected
; 82h	an A20 error occurred
; 8Eh	a general driver error
; 8Fh	unrecoverable driver error
; 90h	HMA does not exist or is not managed by XMS provider
; 91h	HMA is already in use
; 92h	DX is less than the /HMAMIN= parameter
; 93h	HMA is not allocated
; 94h	A20 line still enabled
; A0h	all extended memory is allocated
; A1h	all available extended memory handles are allocated
; A2h	invalid handle
; A3h	source handle is invalid
; A4h	source offset is invalid
; A5h	destination handle is invalid
; A6h	destination offset is invalid
; A7h	length is invalid
; A8h	move has an invalid overlap
; A9h	parity error occurred
; AAh	block is not locked
; ABh	block is locked
; ACh	block lock count overflowed
; ADh	lock failed
; B0h	only a smaller UMB is available
; B1h	no UMB's are available
; B2h	UMB segment number is invalid

;Values for disk operation status:
ERR_OK		  equ	00h	; successful completion
ERR_INVALID_FN	  equ	01h     ; invalid function in AH or invalid parameter
ERR_WRITE_PROT	  equ	03h	; disk write-protected
ERR_SEC_NOT_FOUND equ	04h	; sector not found/read error

; 02h	address mark not found
; 05h	reset failed (hard disk)
; 05h	data did not verify correctly (TI Professional PC)
; 06h	disk changed (floppy)
; 07h	drive parameter activity failed (hard disk)
; 08h	DMA overrun
; 09h	data boundary error (attempted DMA across 64K boundary or >80h sectors)
; 0Ah	bad sector detected (hard disk)
; 0Bh	bad track detected (hard disk)
; 0Ch	unsupported track or invalid media
; 0Dh	invalid number of sectors on format (PS/2 hard disk)
; 0Eh	control data address mark detected (hard disk)
; 0Fh	DMA arbitration level out of range (hard disk)
; 10h	uncorrectable CRC or ECC error on read
; 11h	data ECC corrected (hard disk)
; 20h	controller failure
; 31h	no media in drive (IBM/MS INT 13 extensions)
; 32h	incorrect drive type stored in CMOS (Compaq)
; 40h	seek failed
; 80h	timeout (not ready)
; AAh	drive not ready (hard disk)
; B0h	volume not locked in drive (INT 13 extensions)
; B1h	volume locked in drive (INT 13 extensions)
; B2h	volume not removable (INT 13 extensions)
; B3h	volume in use (INT 13 extensions)
; B4h	lock count exceeded (INT 13 extensions)
; B5h	valid eject request failed (INT 13 extensions)
; BBh	undefined error (hard disk)
; CCh	write fault (hard disk)
; E0h	status register error (hard disk)
; FFh	sense operation failed (hard disk)

code	segment
	assume cs:code

	org	2ch
env_seg		dw	?

	org	100h
start:
xmm_entry	label	dword
	jmp	init

	org	104h
emb_handle	dw	0
drv_num		db	?
active		db	0

bps	dw	?	; bytes per sector
spt  	db	?	; sectors per track
heads	db	?	; number of heads

int_13h:
	pushf
	cmp	dl,drv_num
	je	check_fn_reset

chain_13h:
	popf
	db	0eah			; jump to old int 13h handler
old_13h	dd	?

check_fn_reset:
	cmp	ah,0
	jne	check_active

	cmp	si,'MS'
	je	ms_service
	cmp	active,0
	je	chain_13h

	xor	ah,ah
	popf
	clc
	retf	2

ms_service:
	xchg	ax,si
	push	cs
	pop	es
	popf
	clc
	retf	2

check_active:
	cmp	active,0
	je	chain_13h

	cmp	ah,2
	jne	check_fn_write

	push	ax
	push	cx
	push	dx
	push	ds
	push	si
	sub	sp,size xmm_copyblk

	push	ss
	pop	ds
	mov	si,sp

	push	ax

	mov	al,ch			; (cyl*heads+head)*spt
	mul	heads
	add	al,dh
	adc	ah,0
	mul	spt

	xor	ch,ch
	add	ax,cx
	dec	ax
	mul	bps

	mov	[si].src_offset,ax
	mov	[si].src_offset+2,dx
	mov	ax,emb_handle
	mov	[si].src_handle,ax
	mov	[si].dest_offset,bx
	mov	[si].dest_offset+2,es
	mov	[si].dest_handle,0

	pop	ax

	xor	ah,ah
	mul	bps
	mov	[si].count,ax
	mov	[si].count+2,dx

	mov	ah,0bh
	call	xmm_entry

	add	sp,16
	pop	si
	pop	ds
	pop	dx
	pop	cx

	or	ax,ax
	jnz	read_ok

	pop	ax
	mov	ah,ERR_SEC_NOT_FOUND
	popf
	stc
	retf	2

read_ok:
	pop	ax
	xor	ah,ah
	popf
	clc
	retf	2

check_fn_write:
	cmp	ah,03
	jne	fn_not_supported

	push	ax
	push	cx
	push	dx
	push	ds
	push	si
	sub	sp,size xmm_copyblk

	push	ss
	pop	ds
	mov	si,sp

	push	ax

	mov	al,ch			; (cyl*heads+head)*spt
	mul	heads
	add	al,dh
	adc	ah,0
	mul	spt

	xor	ch,ch
	add	ax,cx
	dec	ax
	mul	bps

	mov	[si].src_offset,bx
	mov	[si].src_offset+2,es
	mov	[si].src_handle,0
	mov	[si].dest_offset,ax
	mov	[si].dest_offset+2,dx
	mov	ax,emb_handle
	mov	[si].dest_handle,ax

	pop	ax

	xor	ah,ah
	mul	bps
	mov	[si].count,ax
	mov	[si].count+2,dx

	mov	ah,0bh
	call	xmm_entry

	add	sp,16
	pop	si
	pop	ds
	pop	dx
	pop	cx

	or	ax,ax
	jnz	write_ok

	pop	ax
	mov	ah,ERR_SEC_NOT_FOUND
	popf
	stc
	retf	2

write_ok:
	pop	ax
	xor	ah,ah
	popf
	clc
	retf	2

fn_not_supported:
	mov	ah,ERR_INVALID_FN
	popf
	stc
	retf	2

res_tail	label

msg_params  	db 'fakedisk 1.00 beta (c) 1996 by MCA Software Group',cr,lf
		db 'This program is freely copyable; source must be available; NO WARRANTY.',cr,lf
		db 'See the file COPYING.DOC for details',cr,lf,cr,lf
		db 'Syntax: fakedisk drive: [option] [imagename]',cr,lf
		db 'Options:',cr,lf
		db '  -u        = uninstall',cr,lf
		db '  -e        = enable fakedisk',cr,lf
		db '  -d        = disable fakedisk',cr,lf
		db '  -f        = free XMS and disable fakedisk',cr,lf
		db '  -o offset = start offset in disk image file (default 0)',cr,lf
		db '              use C syntax for offset: 01000 - octal',cr,lf
		db '                                         512 - decimal',cr,lf
		db '                                       0x200 - hexadecimal',cr,lf
		db 'E.g.: fakedisk b: -o 0x2400 disk1.ddi',cr,lf
		db '      fakedisk b: -u',cr,lf
		db '      fakedisk a: disk1.xdf',cr,lf
msg_crlf	db cr,lf,'$'
msg_no_xmm  	db 'XMS driver is not installed',cr,lf,'$'
msg_drv_letter	db 'Drive letter must be A: or B:',cr,lf,'$'
msg_not_inst	db 'Fakedisk is not installed',cr,lf,'$'
msg_enabled	db 'Fakedisk enabled',cr,lf,'$'
msg_disabled	db 'Fakedisk disabled',cr,lf,'$'
msg_hooked	db 'Int 13h vector is hooked by another program',cr,lf,'$'
msg_13h_ok	db 'Int 13h vector restored',cr,lf,'$'
msg_free_err	db 'Could not free EMB',cr,lf,'$'
msg_free_ok	db 'EMB freed successfully',cr,lf,'$'
msg_uninst_ok	db 'Fakedisk uninstalled successfully',cr,lf,'$'
msg_open_err	db 'Could not open disk image file',cr,lf,'$'
msg_seek_err	db 'Disk image file seek failed',cr,lf,'$'
msg_read_err	db cr,'Could not read disk image file',cr,lf,'$'
msg_alloc_err 	db 'Could not allocate XMS',cr,lf,'$'
msg_bad_size	db 'Disk image file too short',cr,lf,'$'
msg_bad_boot	db 'Disk image file does not contain boot record at offset 0x$'
msg_bytes_read	db ' bytes read$'
msg_emb_size	db 'EMB size: $'
msg_emb_handle  db 'K, EMB handle: 0x$'
msg_xmm_error	db 'XMM error: 0x$'

in_handle	dw	?
start_offset	dw	?
		dw	?
bytes_left	dw	?
		dw	?
fd_id	dw	0
fd_seg	dw	0

copyblk	xmm_copyblk	<>

init:
	assume	ds:code

	mov	ax,4300h		; check if XMS driver installed
	int	2fh
	cmp	al,80h
	je	xmm_installed

	puts	msg_no_xmm
	mov	ax,4c00h+ERR_XMM
	int	21h

xmm_installed:
	mov	ax,4310h		; get XMS driver entry point
	int	2fh
	mov	word ptr xmm_entry,bx
	mov	word ptr xmm_entry+2,es

	mov	si,81h
	call	skip_blanks

	cmp	al,cr			; end of command line?
	jne	get_drive

help:					; no parameters specified
	puts	msg_params		; print help info
	mov	ax,4c00h
	int	21h

get_drive:
	mov	drv_num,al
	inc	si
	lodsb
	cmp	al,':'
	jne	params_err
	lodsb
	cmp	al,' '
	je	drive_ok
	cmp	al,ht
	je	drive_ok

params_err:
	puts	msg_params
	mov	ax,4c00h+ERR_PARAMS
	int	21h

drive_ok:
	or	drv_num,' '		; to lowercase
	sub	drv_num,'a'
	cmp	drv_num,2		; support only a: or b:
	jb	letter_ok

	puts	msg_drv_letter
	mov	ax,4c00h+ERR_PARAMS
	int	21h

letter_ok:
	push	si
	push	cs
	pop	es
	xor	ah,ah			; reset disk
	mov	dl,drv_num
	mov	si,'MS'			; 'MS' - MCA Software
	int	13h			; Returns: AX = 'MS'
					;          ES = fakedisk segment
					;          if fakedisk is installed
	pop	si
	mov	fd_id,ax
	mov	fd_seg,es

	call	skip_blanks
	cmp	al,cr
	je	params_err

	cmp	al,'-'
	je	get_option
	jmp	get_name

get_option:
	inc	si
	lodsb
	or	al,' '
	cmp	al,'o'
	je	get_offset
	cmp	al,'u'
	je	check_eol
	cmp	al,'f'
	je	check_eol
	cmp	al,'d'
	je	check_eol
	cmp	al,'e'
	je	check_eol
	jmp	params_err

get_offset:
	mov	di,offset start_offset
	call	get_number
	jc	params_err
	lodsb
	cmp	al,' '
	je	offset_ok
	cmp	al,ht
	je	offset_ok
	jmp	params_err

offset_ok:
	jmp	get_name

check_eol:
	push	ax
	call	skip_blanks
	cmp	al,cr
	je	check_id
	jmp	params_err

check_id:
	pop	ax

	cmp	fd_id,'MS'
	je	check_option

	puts	msg_not_inst
	mov	ax,4c00h+ERR_NOT_INST
	int	21h

check_option:
	cmp	al,'d'
	je	disable
	cmp	al,'f'
	je	free
	cmp	al,'u'
	je	uninstall

enable:
	mov	es:active,1
        puts	msg_enabled

	mov	ax,4c00h
	int	21h

disable:
	mov	es:active,0		; disable fakedisk
	puts	msg_disabled

	mov	ax,4c00h
	int	21h

free:
	mov	dx,es:emb_handle
	or	dx,dx
	jz	free_ok
	mov	ah,0ah			; free EMB
	call	es:xmm_entry
	or	ax,ax
	jnz	free_ok

	puts	msg_free_err
	call	print_xmm_errcode
	mov	ax,4c00h+ERR_FREE
	int	21h

free_ok:
	mov	es:active,0
	mov	es:emb_handle,0
	puts	msg_free_ok
	mov	ax,4c00h
	int	21h

uninstall:
	mov	ax,3513h
	int	21h
	cmp	bx,offset int_13h
	jne	hooked
	mov	bx,es
	cmp	bx,fd_seg
	je	restore_int_13h

hooked:
	puts	msg_hooked
	mov	ax,4c00h+ERR_HOOKED
	int	21h

restore_int_13h:
	mov	ax,2513h
	lds	dx,es:old_13h
	int	21h
	push	cs
	pop	ds
	puts	msg_13h_ok

	push	es			; free MCB
	mov	bx,es
	dec	bx
	mov	es,bx
	mov	word ptr es:[1],0
	pop	es

	mov	dx,es:emb_handle
	or	dx,dx
	jz	uninst_ok
	mov	ah,0ah			; free EMB
	call	es:xmm_entry
	or	ax,ax
	jnz	uninst_ok

	puts	msg_free_err
	call	print_xmm_errcode
	mov	ax,4c00h+ERR_FREE
	int	21h

uninst_ok:
	puts	msg_free_ok
	puts	msg_uninst_ok
	mov	ax,4c00h
	int	21h

get_name:
	call	skip_blanks
	mov	dx,si
	cmp	al,cr
	jne	search_blank
	jmp	params_err

search_blank:
	lodsb
	cmp	al,' '
	je	blank_found
	cmp	al,cr
	je	blank_found
	cmp	al,ht
	jne	search_blank

blank_found:
	dec	si
	call	skip_blanks
	cmp	al,cr
	je	open_file
	jmp	params_err

open_file:
	mov	byte ptr [si],0
	mov	ax,3d00h		; open for reading
	int	21h
	jnc	open_ok

	puts	msg_open_err
	mov	ax,4c00h+ERR_READ
	int	21h

open_ok:
	mov	in_handle,ax
	mov	bx,ax
	mov	ax,4200h
	mov	dx,start_offset
	mov	cx,start_offset+2
	int	21h
	jnc	seek_ok

	puts	msg_seek_err
	mov	ax,4c00h+ERR_READ
	int	21h

seek_ok:
	mov	ah,3fh
	mov	cx,BLOCKSIZE
	mov	dx,offset free_space
	int	21h
	jnc	read_boot_ok

read_boot_ok:
	cmp	ax,512
	jae	size_ok

	puts	msg_bad_size
	mov	ax,4c00h+ERR_BAD_IMAGE
	int	21h

size_ok:
	mov	copyblk.count,ax

	mov	si,dx
	cmp	[si+1feh],0aa55h
	je	boot_ok

	puts	msg_bad_boot
	mov	ax,start_offset
	mov	dx,start_offset+2
	call	dwordout
	puts	msg_crlf
	mov	ax,4c00h+ERR_BAD_IMAGE
	int	21h

boot_ok:
	mov	es:active,0		; disable fakedisk
	mov	dx,[si+0bh]		; bytes per sector
	mov	es:bps,dx
	mov	dl,[si+18h]		; sectors per track
	mov	es:spt,dl
	mov	dl,[si+1ah]		; number of heads
	mov	es:heads,dl

	mov	ax,[si+13h]		; total sectors
	mul	es:bps
	mov	bytes_left,ax
	mov	bytes_left+2,dx
	add	ax,1023
	adc	dx,0
	mov	cx,1024
	div	cx
	mov	cx,ax

	mov	dx,es:emb_handle
	or	dx,dx
	jz	alloc_emb

	mov	ah,0ah			; free EMB
	call	xmm_entry
	or	ax,ax
	jnz	alloc_emb

	puts	msg_free_err
	call	print_xmm_errcode

alloc_emb:
	mov	ah,9
	mov	dx,cx
	call	xmm_entry
	or	ax,ax
	jnz	alloc_ok

	puts	msg_alloc_err
	call	print_xmm_errcode
	mov	ax,4c00h+ERR_READ
	int	21h

alloc_ok:
	mov	es:emb_handle,dx
	mov	copyblk.dest_handle,dx
	mov	copyblk.src_offset,si
	mov	copyblk.src_offset+2,cs

	push	dx
	puts	msg_emb_size
	mov	ax,cx
	xor	dx,dx
	call	decout
	puts	msg_emb_handle
	pop	ax
	call	wordout
	puts	msg_crlf

	mov	ax,copyblk.count
read_loop:
	or	ax,ax
	jz	read_done

	cmp	bytes_left+2,0
	jne	copy_all

	cmp	bytes_left,ax
	ja	copy_all

	mov	ax,bytes_left
	mov	copyblk.count,ax
copy_all:
	test	copyblk.count,1
	jz	copy_size_ok
	inc	copyblk.count		; size must be even

copy_size_ok:
	mov	ah,0bh			; move EMB
	mov	si,offset copyblk
	call	xmm_entry
	or	ax,ax
	jnz	copy_ok
	jmp	read_err_free

copy_ok:
	mov	ax,copyblk.count
	add   	copyblk.dest_offset,ax
	adc	copyblk.dest_offset+2,0
	sub	bytes_left,ax
	sbb	bytes_left+2,0

	mov	ah,2
	mov	dl,cr
	int	21h

	mov	ax,copyblk.dest_offset
	mov	dx,copyblk.dest_offset+2
	call	decout
	puts	msg_bytes_read

	cmp	copyblk.count,BLOCKSIZE
	jne	read_done

	mov	ah,3fh
	mov	bx,in_handle
	mov	cx,BLOCKSIZE
	mov	dx,offset free_space
	int	21h
	mov	copyblk.count,ax
	jnc	read_loop
	jmp	read_err_free

read_done:
	mov	ah,3eh
	mov	bx,in_handle
	int	21h

	mov	es:active,1

	cmp	fd_id,'MS'
	jne	set_int_13h

	mov	ax,4c00h
	int	21h

set_int_13h:
	mov	ax,3513h
	int	21h
	mov	word ptr old_13h,bx
	mov	word ptr old_13h+2,es

	mov	ax,2513h
	mov	dx,offset int_13h
	int	21h

	mov	ah,49h			; free environment MCB
	mov	es,env_seg
	int	21h

	mov	dx,offset res_tail
	int	27h

read_err_free:
	mov	ah,0ah			; free EMB
	mov	dx,es:emb_handle
	call	xmm_entry

	or	ax,ax
	jnz	read_err
	puts	msg_free_err
	call	print_xmm_errcode

read_err:
	puts	msg_read_err
	mov	ax,4c00h+ERR_READ
	int	21h

print_xmm_errcode:
	puts	msg_xmm_error
	mov	al,dl
	call	byteout
	puts	msg_crlf
	ret

include skipblk.asm
include decout.asm
include digout.asm
include chrout.asm
include getdig.asm
include getnum.asm

free_space	label

code	ends
end	start
