{ Recovers individual files from a recovered CVF }

{$I+}

type filedata_ptr = ^filedata;
     clusterdata_ptr = ^clusterdata;
     filedata = record
                  name:string;
                  given_length:longint;
                  lastcluster_bytes:word;
                  firstcluster:clusterdata_ptr;
                  next:filedata_ptr;
                end;
     clusterdata = record
                     useCVF:boolean;
                     cluster:longint;
                     consecutive:longint;
                     next:clusterdata_ptr;
                   end;
     cluster = array[0..$7FFF] of byte;
     sector = array[0..$1FF] of byte;



var recoverylist:text;
    datafile:file of cluster;
    CVFfile:file of sector;
    firstfile:filedata_ptr;




function hextodec(const s:string; var err:integer):longint;
var p:byte;
    result:longint;
begin
  p:=0;
  result:=0;
  while p<length(s) do
    begin
      result:=result shl 4;
      inc(p);
      if (s[p]>='0') and (s[p]<='9') then inc(result,ord(s[p])-ord('0'))
      else if (upcase(s[p])>='A') and (upcase(s[p])<='F')
        then inc(result,ord(upcase(s[p]))-ord('A')+10)
      else
        begin
          err:=p;
          result:=0;
          p:=length(s);
        end;
    end;
  hextodec:=result;
end;




procedure removewhitespace(var s:string);
var c:byte;
    new_s:string;
begin
  new_s:='';
  c:=1;
  while (c<=length(s)) and (s[c]<>';') do
    begin
      if (s[c]<>' ') and (s[c]<>#9) and (s[c]<>#10) and (s[c]<>#13)
        then new_s:=new_s+s[c];
      inc(c);
    end;
  s:=new_s;
end;




procedure parseinputfile;
var current_cluster,cl:clusterdata_ptr;
    current_file,cf:filedata_ptr;
    noname_count,n,m,calclength:longint;
    p,q,len,cshift:byte;
    errcode:integer;
    useCVF:boolean;
    csize:longint;
    s:string;
begin
  noname_count:=1;
  current_file:=nil;
  while not(eof(recoverylist)) do
    begin
      readln(recoverylist,s);
      removewhitespace(s);
      len:=length(s);
      if len>0 then if s[1]='#' then
        begin
          calclength:=0;
          new(cf);
          cf^.next:=nil;
          cf^.firstcluster:=nil;
          current_cluster:=nil;
          if firstfile=nil then
            begin
              firstfile:=cf;
              current_file:=cf;
            end
          else
            begin
              current_file^.next:=cf;
              current_file:=cf;
            end;
          p:=2;
          while (p<=len) and (s[p]<>',') do inc(p);
          if p=2 then
            begin
              str(noname_count,current_file^.name);
              inc(noname_count);
              current_file^.name:='UNKNOWN.'+current_file^.name;
            end
          else current_file^.name:=copy(s,2,p-2);
          if p>=len then current_file^.given_length:=0 else
            begin
              if s[p+1]='$'
                then current_file^.given_length:=hextodec(copy(s,p+2,len-p-1),errcode)
                else val(copy(s,p+1,len-p),current_file^.given_length,errcode);
              if errcode<>0 then current_file^.given_length:=0;
            end;
        end
      else if (current_file<>nil) then
        begin
          if (len>0) and (s[1]='U') then
            begin
              useCVF:=true;
              csize:=$200;
              cshift:=9;
              p:=2;
            end
          else
            begin
              useCVF:=false;
              csize:=$8000;
              cshift:=15;
              p:=1;
            end;
          while (p<=len) do
            begin
              q:=p;
              while (q<=len) and (s[q]<>',') and (s[q]<>'-') do inc(q);
              n:=hextodec(copy(s,p,q-p),errcode);
              if (p<q) and (errcode=0) then
                begin
                  new(cl);
                  cl^.next:=nil;
                  cl^.cluster:=n shr cshift;
                  cl^.consecutive:=1;
                  cl^.useCVF:=useCVF;
                  if current_file^.firstcluster=nil then
                    begin
                      current_file^.firstcluster:=cl;
                      current_cluster:=cl;
                    end
                  else
                    begin
                      if (current_cluster^.useCVF and
                          (current_file^.lastcluster_bytes<>$200))
                        then inc(calclength,$200-current_file^.lastcluster_bytes)
                      else if (not(current_cluster^.useCVF) and
                               (current_file^.lastcluster_bytes<>$8000))
                        then inc(calclength,$8000-current_file^.lastcluster_bytes);
                      current_cluster^.next:=cl;
                      current_cluster:=cl;
                    end;
                  current_file^.lastcluster_bytes:=csize;
                  if (q<=len) and (s[q]='-') then
                    begin
                      inc(q);
                      p:=q;
                      if (q=len) and (s[q]='.') then
                        begin
                          if current_file^.given_length=0
                            then m:=n+csize
                            else m:=n+current_file^.given_length-calclength;
                          if m<=0 then m:=n+csize;
                          inc(q);
                          errcode:=0;
                        end
                      else
                        begin
                          while (q<=len) and (s[q]<>',') do inc(q);
                          m:=hextodec(copy(s,p,q-p),errcode);
                        end;
                      if (p<q) and (errcode=0) and (m>n) then
                        begin
                          current_cluster^.consecutive:=(m shr cshift)-(n shr cshift);
                          if (m and (csize-1))<>0 then
                            begin
                              inc(current_cluster^.consecutive);
                              current_file^.lastcluster_bytes:=m and (csize-1);
                            end;
                          inc(calclength,current_file^.lastcluster_bytes+
                                 ((current_cluster^.consecutive-1) shl cshift));
                        end;
                    end
                  else inc(calclength,csize);
                end;
              p:=q+1;
            end;
        end;
    end;
end;





procedure recoverfiles;
var buffer:cluster;
    sectorbuffer:sector absolute buffer;
    recovered_file:file;
    f:filedata_ptr;
    c:clusterdata_ptr;
    i:longint;
begin
  f:=firstfile;
  while f<>nil do
    begin
      assign(recovered_file,f^.name);
      rewrite(recovered_file,1);
      c:=f^.firstcluster;
      while c<>nil do
        begin
          if c^.useCVF then seek(CVFfile,c^.cluster)
                       else seek(datafile,c^.cluster);
          for i:=1 to c^.consecutive do
            begin
              if c^.useCVF then read(CVFfile,sectorbuffer)
                           else read(datafile,buffer);
              if (c^.next=nil) and (i=c^.consecutive)
                then blockwrite(recovered_file,buffer,f^.lastcluster_bytes)
              else if c^.useCVF then blockwrite(recovered_file,buffer,$200)
                                else blockwrite(recovered_file,buffer,$8000);
            end;
          c:=c^.next;
        end;
      close(recovered_file);
      f:=f^.next;
    end;
end;






procedure free_datastructures;
var cl1,cl2:clusterdata_ptr;
    f:filedata_ptr;
    numchunks,i:longint;
begin
  while firstfile<>nil do
    begin
      cl1:=firstfile^.firstcluster;
      while cl1<>nil do
        begin
          cl2:=cl1^.next;
          dispose(cl1);
          cl1:=cl2;
        end;
      f:=firstfile^.next;
      dispose(firstfile);
      firstfile:=f;
    end;
end;



begin
  if (paramcount<>3) then
    begin
      writeln;
      writeln('Usage:  RECOVER <corrupt CVF> <decompressed file> <recovery data file>');
      writeln;
      writeln('See accompanying README.TXT file for more information');
      halt;
    end;
  firstfile:=nil;

  assign(CVFfile,paramstr(1));
  assign(datafile,paramstr(2));
  assign(recoverylist,paramstr(3));

  reset(recoverylist);
  parseinputfile;
  close(recoverylist);

  reset(datafile);
  reset(CVFfile);
  recoverfiles;
  close(CVFfile);
  close(datafile);

  free_datastructures;
end.