{$DEFINE EXE}

{$IFDEF EXE}
PROGRAM drivetyp;
USES wincrt, windos, WinProcs, WinTypes;
{$ELSE EXE}
UNIT drivetyp;

INTERFACE
{$ENDIF}

CONST
 Drive:ARRAY[0..25]OF Byte=(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
 EX_DRIVE_INVALID    = 0;
 EX_DRIVE_REMOVABLE  = 1;
 EX_DRIVE_FIXED      = 2;
 EX_DRIVE_REMOTE     = 3;
 EX_DRIVE_CDROM      = 4;
 EX_DRIVE_FLOPPY     = 5;
 EX_DRIVE_RAMDISK    = 6;

{$IFNDEF EXE}
FUNCTION GetDriveTypeEx (nDrive : integer) : integer;
FUNCTION IsCDRomDrive (nDrive : integer) : boolean;

IMPLEMENTATION
USES windos, winprocs, wintypes;
{$ENDIF}

VAR
 DeviceParams:RECORD
  bSpecFunc    :byte;	 { Special functions                }
  bDevType     :byte;	 { Device TYPE                      }
  wDevAttr     :word;    { Device attributes                }
  wCylinders   :word;	 { Number OF cylinders              }
  bMediaType   :byte;	 { Media TYPE                       }
  { Beginning OF BIOS parameter block (BPB)                 }
  wBytesPerSec :word;	 { Bytes per sector                 }
  bSecPerClust :byte;	 { Sectors per cluster              }
  wResSectors  :word;    { Number OF reserved sectors       }
  bFATs	       :byte;    { Number OF FATs                   }
  wRootDirEnts :word;    { Number OF root-directory entries }
  wSectors     :word;    { Total number OF sectors          }
  bMedia       :byte;    { Media descriptor                 }
  wFATsecs     :word;    { Number OF sectors per FAT        }
  wSecPerTrack :word;    { Number OF sectors per track      }
  wHeads       :word;    { Number OF heads                  }
  dwHiddenSecs :longint; { Number OF hidden sectors         }
  dwHugeSectors:longint; { Number OF sectors IF wSectors=0  }
  { END OF BIOS parameter block (BPB)                       }
 END;

FUNCTION GetDeviceParameters(nDrive:Integer):boolean;
VAR r		: TRegisters;
BEGIN
 fillchar(r,sizeof(r),#0);
 r.ax:=$440d;	 { IOCTL }
 r.ch:=$08;	 { block device }
 r.cl:=$60;	 { get device parameters }
 r.bx:=nDrive+1; { 1 = A:, 2 = B:, etc... }
 r.ds:=seg(DeviceParams);
 r.dx:=ofs(DeviceParams);
 msdos(r);
 GetDeviceParameters:=(r.flags and fCarry)=0
END;

FUNCTION IsCDRomDrive(nDrive:integer):boolean;ASSEMBLER;
ASM
  xor bx,bx
  mov ax,1500h
  int 2fh
  xor ax,ax
  or  bx,bx
  je @out
  mov ax,150bh
  mov cx,nDrive
  INT 2fh
@out:
END;

FUNCTION GetDriveTypeEx (nDrive : Integer) : integer;
BEGIN
{ fillchar (DeviceParams,sizeof(DeviceParams), #0);	{ clear the DPB }
 CASE GetDriveType(nDrive) OF
  DRIVE_REMOTE: IF IsCDRomDrive(nDrive)
    THEN GetDriveTypeEx := EX_DRIVE_CDROM
    ELSE GetDriveTypeEx := EX_DRIVE_REMOTE;
  DRIVE_REMOVABLE:
  {bDevType: 0=320/360kB DD; 1=1.2Mb HD; 2=720kb DD; 3=8" SD; 4=8" DD; 7=1.44Mb HD; 8=optical; 9=2.88Mb ED}
   IF GetDeviceParameters(nDrive)AND(DeviceParams.bDevType in [0..4,7..9])
    THEN GetDriveTypeEx := EX_DRIVE_FLOPPY
    ELSE GetDriveTypeEx := EX_DRIVE_REMOVABLE;
  DRIVE_FIXED:
   IF GetDeviceParameters(nDrive) AND (DeviceParams.bDevType = 5)
    THEN GetDriveTypeEx := EX_DRIVE_FIXED
    ELSE GetDriveTypeEx := EX_DRIVE_RAMDISK;
  ELSE
   GetDriveTypeEx := EX_DRIVE_INVALID
 END
END;

VAR
 i:integer;
BEGIN
 FOR i:=0 to 25 DO Drive[i]:=GetDriveTypeEx(i);
{$IFDEF EXE}
 ScreenSize.y:=27;
 FOR i:=0 to 25 DO
 BEGIN
   write (chr(i + ord('A')), ': ');
   CASE Drive[i] OF
     EX_DRIVE_INVALID:  Writeln ('NOT Installed');
     EX_DRIVE_REMOVABLE:Writeln ('Removable');
     EX_DRIVE_FIXED:	Writeln ('Harddisk');
     EX_DRIVE_REMOTE:	Writeln ('Network');
     EX_DRIVE_CDROM:	Writeln ('CDROM');
     EX_DRIVE_FLOPPY:	Writeln ('Floppy');
     EX_DRIVE_RAMDISK:	Writeln ('RAMdisk');
    END
  END
{$ENDIF}
END.