NAME
     dd -- copy and convert input blocks

SYNOPSIS
     dd [bs=s] [cbs=s] [conv=conversion] [count=n] [ibs=s] [if=file]
     [imsg=string] [iseek=n] [obs=s] [of=file] [omsg=string] [seek=n]
     [skip=n]

DESCRIPTION
     dd reads and  writes data by blocks.  It can convert the data between for-
     mats.  dd is frequently used for devices such as tapes which have discrete
     block sizes, or  for fast multi-sector  reads from disks.  The conversions
     can accommodate  computers  that require  de-blocking, conversion  to/from
     EBCDIC and fixed length records.

     dd processes input data as follows:

       1. dd reads an input block.

       2. If you specified  conv=sync and this  input block is smaller than the
          specified input  block size, dd  pads it to  the specified size  with
          null bytes.  When  you also specify a block or unblock conversion, dd
          uses spaces instead of null bytes.

       3. If you specified  bs=size and requested no conversion other than sync
          or noerror, dd  writes the input  block (padded if  necessary) to the
          output as a single block and omits the remaining steps.

       4. If you  specified the swab  conversion, dd swaps  each pair of  input
          bytes.  If there is an odd number of input bytes, dd does not attempt
          to swap the last byte.

       5. dd performs all remaining conversions on the input data independently
          of the input block boundaries.  A fixed-length input or output record
          may span these boundaries.

       6. dd gathers  the converted  data into output  blocks of the  specified
          size.  When dd  reaches the end of the input, it writes the remaining
          output as  a block (with  padding if conv=sync  is specified).  As  a
          result, the final  output block may  be shorter than the output block
          size.

Parameters
     dd accepts the following parameters:

     bs=size
          sets both input and output block sizes to size bytes.  You can suffix
          this decimal number  with w, b,  k, or xnumber  to multiply it  by 2,
          512, 1024, or  number respectively.  You can also specify size as two
          decimal numbers (with or without suffixes) separated by x to indicate
          the product of the two values.  Processing is faster when ibs and obs
          are equal, since  this avoids buffer copying.  The default block size
          is 1b. bs=size supercedes any settings of ibs=size or obs=size.

          If you  specify  bs=size and  you request  no other conversions  than
          noerror, notrunc, or  sync, dd writes  the data from each input block
          as a separate  output block; if  the input data  is less than  a full
          block and you  did not request  sync conversion, the  output block is
          the same size as the input block.

     cbs=size
          sets the size  of the conversion buffer used by various conv options.
          You specify it in the same way as bs.

     conv=conversion[, conversion, ...]
          where conversion can be any of the following:

          ascii     converts EBCDIC input  to ASCII for  output.  dd copies cbs
                    bytes at  a  time to  the conversion  buffer, maps them  to
                    ASCII. It then  strips trailing blanks,  adds a newline and
                    copies this line to the output buffer.

          block     converts variable-length  records to fixed-length  records.
                    dd treats the  input data as  a sequence of variable-length
                    records (each terminated  by a newline or an EOF character)
                    independent  of the  block  boundaries.  dd  converts  each
                    input record by first removing any newline characters, then
                    padding (with spaces)  or truncating the record to the size
                    of the conversion  buffer.  dd reports  the number of trun-
                    cated records  on  the standard  error.   You must  specify
                    cbs=size with this conversion.

          ebcdic    converts ASCII  input  to EBCDIC for  output.  dd copies  a
                    line of ASCII  to the conversion  buffer, discards the new-
                    line, pads it with trailing blanks to cbs bytes, maps it to
                    EBCDIC and copies it to the output buffer.

          ibm       converts ASCII to  a variant of  EBCDIC which gives  better
                    output on many IBM printers.

          lcase     converts uppercase input to lowercase.

          noerror   ignores errors on input.

          notrunc   does not truncate  the output file.   If a block  is expli-
                    citly written,  it replaces the  existing block; all  other
                    blocks are unchanged.  See also of=file and seek=n.

          retry     retries the write  system call when DOS critical errors for
                    write fault and paper out occur.

          swab      swaps the order  of every pair of input bytes.  If the cur-
                    rent input record  has an odd number of bytes, this conver-
                    sion does not attempt to swap the last byte of the record.

          sync      pads any  input block  shorter than ibs  to that size  with
                    null  bytes  before conversion  and  output.  If  you  also
                    specified block or  unblock, dd uses spaces instead of null
                    bytes for padding.

          ucase     converts lowercase input to uppercase.

          unblock   converts fixed-length records to variable-length records by
                    reading a number  of bytes equal to the size of the conver-
                    sion buffer (or the number of bytes remaining in the input,
                    if less  than  the conversion  buffer  size), deleting  all
                    trailing spaces,  and appending  a newline character.   You
                    must specify cbs=size with this conversion.

          convfile  uses convfile as  a translation table  if it is  not one of
                    the conversion formats  listed here and it is the name of a
                    file of exactly 256 bytes.

          You may perform  multiple conversions at  the same time by separating
          arguments to conv with commas; however, some conversions are mutually
          exclusive (for example, ucase and lcase).

     count=n   copies only n input blocks to the output.

     ibs=size  sets the input  block size to size bytes.  You specify it in the
               same way as bs.

     if=file   reads input data from file. If you don't specify this option, dd
               reads data from the standard input.

     imsg=string
               displays string  when all  data has been  read from the  current
               volume, replacing all  occurrences of %d in string with the num-
               ber of the next volume to be read.  dd then reads and discards a
               line from  the  controlling terminal,  giving  you a  chance  to
               change volumes (usually diskettes).

     iseek=n   seeks to  the  nth block  of  the input  file.  The  distinction
               between this and  skip is that iseek does not read the discarded
               data; however there  are some devices,  such as tape  drives and
               communication lines, on  which seeking is  not possible, so only
               skip is appropriate.

     obs=size  sets the output block size to size bytes.  You specify it in the
               same way as the bs value.  The size of the destination should be
               a multiple  of the value  chosen for size.  For example, if  you
               choose obs=10k, the  destination's size should  be a multiple of
               10k.

     of=file   writes output data to file. If you don't specify this option, dd
               writes data  to  the standard output.   dd truncates the  output
               file before  writing  to it,  unless  you specified  the  seek=n
               operand.   If   you   specify  seek=n,   but   do  not   specify
               conv=notrunc, dd preserves  only those blocks in the output file
               over which it  seeks.  If the  size of the seek plus the size of
               the input file  is less than  the size of  the output file, this
               can result in a shortened output file.

     omsg=string
               displays string when  dd runs out  of room while  writing to the
               current volume.  Any  occurrences of %d  in string are  replaced
               with the number of the next volume to be written.  dd then reads
               and discards a  line from the controlling terminal, giving you a
               chance to change volumes (usually diskettes).

     seek=n    initially seeks to the nth block of the output file.

     skip=n    reads and discards the first n blocks of input.

     It is possible  to speed up  the operation of  dd on diskettes by matching
     the dd parameters  to the disk  format used.  The  input and output  block
     size should be  large enough to hold an entire track from the disk, allow-
     ing an entire track to be read in one pass.  If the input and output block
     size do not  match the track size, a number of passes must be done to com-
     plete the operation.

     The number of  blocks copied to  the output is set to the number of tracks
     on the disk.   For example, a  360K DOS diskette  is double sided  and has
     nine sectors per  track.  Therefore, there are eighteen 512 byte blocks on
     each track of the diskette.  The diskette has 40 tracks.

        dd if=a: bs=18b count=40

     reads all  of the information  of the diskette.   Values suitable for  use
     with common PC diskette formats on DOS, OS/2, NT, and Windows 95  are sum-
     marized in the following table:

                       ---------------------------------------
                       -Size Cap.   Command Line             -
                       ---------------------------------------
                       -5.25 360K   dd if=a: bs=18b count=40 -
                       -5.25 1.2M   dd if=a: bs=30b count=80 -
                       -3.5  720K   dd if=a: bs=18b count=80 -
                       -3.5  1.44M  dd if=a: bs=36b count=80 -
                       ---------------------------------------

                 Table 1: dd Values for Common PC Diskette Formats

EXAMPLES

        dd if=file of=a:

     Copies a file  to drive A:,  ignoring any DOS file system on the diskette.
     You can put data on a diskette more quickly and densely in this manner.

        dd if=c: of=a: omsg='Please put disk %d in drive A'

     dd copies everything from drive C: to drive A:.  When the disk in drive A:
     is full, the  utility prompts you  to put the  next disk in  the drive and
     when you press ENTER, it continues.

        dd if=in of=out conv=ascii cbs=80 ibs=6400 obs=512

     Converts 80-byte fixed length EBCDIC card images in 6400 byte input blocks
     to variable length ASCII lines, 512 bytes to the output block.

DIAGNOSTICS
     Possible exit status values are:

     0  Successful completion.

     1  Failure due to any of the following:
          -- I/O errors on read/write
          -- insufficient memory
          -- invalid argument to a conversion

     2  Failure resulting in a usage message, such as:
          -- an option that should contain = does not
          -- unknown or invalid command line option

PORTABILITY
     POSIX.2.  x/OPEN Portability  Guide 4.0.  All  UNIX systems.  DOS  3.1 and
     up.  OS/2 2.0 and up.  Windows 95. NT 3.1 - 3.5.

     The conv=ascii, conv=ebcdic, and conv=ibm options are x/OPEN extensions to
     the POSIX standard.   The conv=retry, conv=convfile, iseek, imsg, and omsg
     options plus the  w suffix described  in the bs= option are all extensions
     to both the POSIX and x/OPEN standards.

     On DOS, OS/2,  NT and Windows 95, dd recognizes disk drive names and reads
     from or writes to them in a raw manner.

     On NT, dd  recognizes device names  only if you  apply the prefix  //./ to
     every device reference, as follows:

        //./TAPE0   instead of TAPE0

     We strongly recommend, however, that you specify tape devices as described
     under tape(4) in the MKS Toolkit Reference Manual. For example

        /dev/mt0

     has the same effect as specifying //./TAPE0, with the added advantage that
     pax automatically senses and sets the correct block size of the tape.


WARNING
     Before performing a  raw disk input/output  operation on a  given disk you
     must first access  a properly formatted  disk of the same size in the same
     drive.  For example,  if you want to use a 1.44MB disk in drive A: for raw
     disk input, you  first perform a  command like ls  or dir on  a different,
     properly formatted 1.44  MB disk in  that drive.  Once this is done, place
     the disk that you want to use for raw disk input/output in the appropriate
     drive and issue  the MKS Toolkit  command that you  want to use.  When DOS
     opens the  disk,  a critical  error  exception occurs.   If you are  using
     command.com or you are using MKS KornShell and you have turned on critical
     error handling with

        set -o criterror

     a DOS critical error message appears and asks if you want to abort, retry,
     or fail.  To continue with the raw disk operation, type F (for fail).

     If you are  using MKS KornShell  with critical error  handling turned off,
     either by default or by using

        set +o criterror

     no message appears  and the shell  proceeds as though you had chosen F, as
     described previously.

SEE ALSO
     mt(1), tr(1), tape(4)
