; a small tool to figure out how much space is free on disk.
; Public Domain by Eric Auer (written in 3/2004, updated 3/2005).
;
; compile:		nasm -o freetest.com freetest.asm
; (nasm is a free open source Assembler: http://nasm.sf.net/)
;
; syntax:		FREETEST a: 3
; where 3 is a single digit number (optional, default is 0) and
; a: is the drive selection (default is current drive)
; errorlevel: amount of free kbytes shifted right by 3*2 bits
; and clipped to at most 255. Invalid drives return 0 kb free.
; The shift factor, here 3, is the command line digit.
;
; Digit / Unit of errorlevel / Overflow ("errorlevel 256") at...:
; 0   1k  256k    5   1M  256M
; 1   4k    1M    6   4M    1G
; 2  16k    4M    7  16M    4G
; 3  64k   16M    8  64M   16G
; 4 256k   64M    9 256M   64G


%define FAT32 1		; (define after adding the int 21.7303 call!)


	org 100h	; a COM program

start:	mov ax,2524h	; install critical error handler, no need to save
	mov dx,i24handler	; previous one: int 22-24 get restored
	int 21h			; at program exit.

	mov ah,19h	; get current drive
	int 21h
	add al,'A'	; this call returns 0 for A:, 1 for B: ...
	mov [drvnam],al	; set drive letter

%if FAT32
	mov ax,7300h	; get a FAT32 property
	mov dl,0	; current drive
	mov cl,1	; "dirty-buffers flag"
	int 21h
	cmp ax,7300h	; AX still unchanged?
	jz oldkernel
	; ignore the actual results of int 21.7300 (AL, AH)
	mov byte [kern32],1	; kernel has FAT32 support
oldkernel:
%endif

	xor bp,bp	; drive, 1 for A:, 2 for B: ... or 0 for "current"
	xor cx,cx	; shift value (we divide space by 1024*2^shiftvalue)

	mov si,81h	; command line arguments

cline:	mov ax,[si]	; 2 chars at a time
	inc si
	cmp al,13	; end?
	jz main
	cmp al,'?'
	jz help
	cmp al,'0'
	jb cline	; nothing for us
	cmp al,'9'
	ja nbits	; no digit
	sub al,'0'
	mov cl,al	; store into bits
	add cx,cx	; digit is bits/2 (you can shift by 0,2,4..,18 bits)
	jmp short cline

nbits:	cmp al,' '	; space (tab/digit already checked above)
	jz cline
	cmp al,'/'	; ignore slashes...
	jz cline
	cmp al,'-'	; ...and dashes
	jz cline
	cmp ah,':'	; is the FOLLOWING char a colon?
	jnz help	; else there is a syntax error
	cmp al,'a'	; is it lower case?
	jb nlower
	sub al,'a'-'A'	; then make it upper case!
nlower:	cmp al,'A'
	jb help
	cmp al,'Z'
	ja help
	inc si		; skip over the already parsed colon!
	mov [drvnam],al	; update drive letter
	sub al,'A'-1	; turn A: into 1, B: into 2, etc.
	mov bp,ax	; store drive number
	and bp,31	; zap extra bits
	jmp short cline


help:	mov dx,helpmsg
	mov ah,9	; show message
	int 21h
	mov ax,4c00h	; return errorlevel 0
	int 21h


i24handler:
	mov al,3	; auto-answer "abort/retry/fail" question
	iret		; with "fail". No prompt will be shown.


main:	mov al,[drvnam]	; fetch selected drive letter
	mov [drvchr],al	; put it into our message

	mov bx,cx		; shift factor, a multiple of 2
	add bx,bx		; now a multiple of 4
	mov ax,[units+bx]	; fetch unit name, part one
	mov [drvunit],ax
	mov ax,[units+bx+2]	; fetch unit name, part two
	mov [drvunit+2],ax

	; drvmsg is shown right before the size info,
	; drvmsg2 is shown right after the size info.

	push cx		; shift factor


%if FAT32
	cmp byte [kern32],0
	jz usefat16
	mov al,[drvnam]	; drive letter
	mov [what32],al	; plug letter into "x:\",0 string
	mov dx,what32	; in DS: string
	mov di,size32	; in ES: size info buffer
	mov cx,30h	; buffer size, at least 2ch
	mov ax,7303h	; get extended free space
	int 21h
	jc bug2		; error?
			; Else: dd [free32+8]   = bytes per sector
			;       dd [free32+14h] = free sectors
	mov ax,[di+10]
	or ax,ax
	jnz bug2	; sector size > 64k not supported
	mov ax,[di+8]	; sector size
; ---	cmp ax,512
; ---	jb bug2		; sector size < 512 not supported
	mov bx,ax	; sector size
	mov ax,[di+14h]	; free sector count, low
	mov dx,[di+16h]	; free sector count, high
makebigger:
	cmp bx,1024	; normalize to bigger sector size 1024
	jae makesmaller
	shr dx,1	; do "sectors = sectors / 2"
	rcr ax,1
	shl bx,1	; do "sector size = sector size * 2"
	jmp short makebigger

makesmaller:
	cmp bx,1024	; if sector size above 1024, normalize
	jbe normalized	; to smaller sector size 1024 now...
	add ax,ax	; do "sectors = sectors * 2"
	adc dx,0
	shr bx,1	; do "sector size = sector size / 2"
	jmp short makebigger

normalized:
	pop cx		; shift factor (can be 0 here)
	; sector size already processed, already normalized to 1024
	; byte units, no need to add anything to the shift factor...
	jmp short shloop

bug2:	jmp short bug

usefat16:
%endif


	mov ah,36h	; get free disk space (old MS DOS 2+ style)
	mov dx,bp	; DL is the drive number (0 default, 1 A:, 2 B: ...)
	int 21h
	cmp ax,-1	; error?
	jz bug
	xor dx,dx	; ignore clusters on drive, prepare for 32bit mul
	mul cx		; multiply AX (sectors per cluster) by CX (bytes per sector)
	mul bx		; multiply result by BX (number of free clusters)

	pop cx		; shift factor
	add cx,10	; always shift by 10 bits more (divide by 1024)


shloop:	jcxz done	; nothing to do shift-wise
	shr dx,1	; high part of result (shift out low bit into carry)
	rcr ax,1	; low part of result (fetch high bit from carry)
	loop shloop

done:	push ax
	push dx
	mov dx,drvmsg	; announce size info
	mov ah,9	; show message
	int 21h
	pop dx
	pop ax
	or dx,dx	; overflow?
	jnz maxed
	or ah,ah	; overflow?
	jnz maxed

	push ax		; show AL as decimal value
	mov ah,' '
	cmp al,100
	jb ltX00	; less than 100
	sub al,100
	mov ah,'1'
	cmp al,100
	jb ltX00	; less than 200
	sub al,100
	mov ah,'2'	; (always less than 300)
ltX00:	mov [drvmsg2],ah	; fill in first digit
	aam		; ah=al/10, al=al mod 10
	add ax,'00'	; convert to ASCII
	xchg al,ah	; make 10s digit first: AL
	cmp al,'0'
	jnz gtX09
	cmp byte [drvmsg2],' '
	jnz gtX09
	mov al,' '	; if number was " 0x", make it "  x"
gtX09:	mov [drvmsg2+1],ax	; 3 digit value string is ready
	pop ax

clipped:
	push ax
	mov dx,drvmsg2	; tell about size and size unit
	mov ah,9	; show message
	int 21h
	pop ax
	mov ah,4ch	; return errorlevel AL
	int 21h


bug:	pop cx		; throw away shift factor
	mov dx,nomsg	; problems encountered (e.g. no such FAT drive)
	mov ah,9
	int 21h
	mov ax,4c00h	; return 0 (error)
	int 21h


maxed:	mov al,0ffh	; return maximum errorlevel 255: overflow
	jmp short clipped	; (we skipped the convert-to-decimal)


nomsg	db "Cannot determine free space.",13,10,"$"


helpmsg	db "Public domain free disk space checker by EA 2004-2005",13,10
	db 13,10
	db "Usage:",13,10
	db "  FREETEST [X:] [4]",13,10
	db "Drive spec is optional, default is the current drive.",13,10
	db "The digit is an optional size unit selector, default 1 kByte:",13,10
	db "  0->1k, 1->4k, 2->16k, 3->64k, 4->256k,",13,10
	db "  5->1M, 6->4M, 7->16M, 8->64M, 9->256M.",13,10
	db "Free space information is returned in errorlevel, 0 on error.",13,10
	db 13,10
	db "Example: FREETEST C: 5 returns errorlevel 50 if at least",13,10
	db "  50 MBytes are free on C:. Errorlevel is never above 255.",13,10
	db 13,10
%if FAT32
	db "FAT32 drives are fully supported by FREETEST.",13,10
%else
	db "This FREETEST ignores free space above 2 GBytes.",13,10
%endif
	db "$"


drvnam	db "?:\",0	; fails if drive letter not given, so use int 21.19


drvmsg	db "Free space on drive "
drvchr	db "?: at least $"

drvmsg2	db "256"	; default: overflow case
	db " * "
%if FAT32
drvunit	db "????byte(s).",13,10,"$"
%else
drvunit	db "????Byte(s).",13,10,"$" ; "... max 2 GBytes ..."
%endif


units:	; must be 4 bytes each
un0	db " 1 k"
un1	db " 4 k"
un2	db "16 k"
un3	db "64 k"
un4	db " ",0ach," M"	; "1/4 M"
un5	db " 1 M"
un6	db " 4 M"
un7	db "16 M"
un8	db "64 M"
un9	db " ",0ach," G"	; "1/4 G"


%if FAT32

kern32	db 0		; flag: set to 1 if kernel supports FAT32
what32	db "Q:\",0	; the drive which we want to have checked

	; filled by int 21.7303.dsdx=&drvnam.esdi=&sizeinf.cx=2ch
	; which returns ax=7300 for non-FAT32 DOS versions or carry set
	; if FAT32 is supported but an error (AX) occurred during the call.
size32	dw 30h	; returns size
	dw 0	; returns version
%if 0	; rest of the data can be in uninitialized (BSS) space in RAM...
	dd 0,0,0,0	; sec/clust1, by/clust, free clusters1, total clusters
	dd 0,0,0,0	; free sect2, total sect2, free clust2, total clust2
	dd 0,0		; reserved
%endif	; 1: with compression adjustment / 2: without compression adjustment
	; even this can be clipped to 2 GB in Win9x: if a DOS TSR hooks int21,
	; some FAT1x compatibility feature triggers and clipping happens.
%endif
