@echo off
::
:: Lines beginning with "::" are inactive.
::
::-@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@-<
::
:: Purpose:
:: ~~~~~~~~
:: This batch code will detect if a drive exists with a disk present, and
:: SET the "DrvExist" environment variable.
::
::-------------------------------------------------------------------------<
::
:: Requirements:
:: ~~~~~~~~~~~~~
:: * MS-DOS [*] Protected-mode ... (with Win9x ... running)
::          [*] Real-mode ........ (with Win9x NOT running)
:: * MS-DOS External Command Program(s):
::   -     FIND.EXE
::   - FREETEST.COM (by Eric Auer)
::                  (MD5:  207e93220ea6fa033d3f48a30ddc5a64  FREETEST.COM)
::                  http://www.coli.uni-saarland.de/~eric/
::                   stuff/soft/specials/free-disk-space-tester-freetest.zip
::
::-------------------------------------------------------------------------<
::
:: Notes:
:: ~~~~~~
:: * For usage, type "DRVEXIST /?".
::
::- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -<
::
::                                                   /
::                                                   | Example: DRVEXIST A
::        Usage: DRVEXIST [letter]                   \---------------------/
::               DRVEXIST ... Case iNsEnSiTiVe (except cannot be "drveXist")
::                 letter ... Drive letter A-Z (except B)
::       Output:   YES/NO ... ECHOed to screen
::
::                                                   /
::  Batch Usage: drveXist [letter]                   | Example: drveXist j
::  ------------ drveXist ... Case sEnSiTiVe         \---------------------/
::                 letter ... Drive letter A-Z (except B)
:: Batch Output:      1/0 ... Value SET to "DrvExist" EV (1=YES,0=NO)
:: -------------
::
:: Requirements: FREETEST.COM
::
::- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -<
::
:: * For command-line usage:  If the test result is positive, "YES" is
::   ECHOed to screen.  If negative, "NO" is ECHOed to screen.
::
:: * For batch usage (drveXist):  If the test result is positive, the
::   environment variable %DrvExist% is given a value of 1.  If negative, it
::   is given a value of 0.
::
::-------------------------------------------------------------------------<
::
:: About:                                               (06-06-2009)
:: ~~~~~~
:: DRVEXIST.BAT (v1.3)
::
::      Bla
::      P.O. Box NUL
::      Valley View, Ohio 44125 USA
::
::      E-Mail:   Blaware@FastMail.fm
::      Webpage:  http://www.NUL.nul/index.html
::
:: Feed the birds.  (Why?)  Well, they haven't pecked your eyes out!
::
::-#######################################################################-<
::
set DrvExist=
if .%1.==.. goto MESSAGE
if not .%2.==.. goto HELP
echo -h/H?-?/?--HELP | find /i "%1" > NUL
if not errorlevel 1 goto HELP
freetest /? | find "Public domain free disk space checker by EA 2004-2005" > NUL
if errorlevel 1 goto MESSAGE
echo ACDEFGHIJKLMNOPQRSTUVWXYZ | find /i "%1" > NUL
if not errorlevel 1 goto 0G
goto HELP
:0G
freetest %1: | find "Cannot determine free space." > NUL
if not errorlevel 1 goto 0H
freetest %1: | find "Free space on drive" > NUL
if not errorlevel 1 goto 0I
::
:MESSAGE
echo.
echo  DRVEXIST.BAT -- Detect if a drive exists with a disk present, and SET the
echo                  "DrvExist" environment variable.
echo                  Type "DRVEXIST /?" for usage.
echo.
goto END
::
:HELP
echo.
echo  DRVEXIST.BAT -- Detect if a drive exists with a disk present, and SET the
echo  ************    "DrvExist" environment variable.
echo                                                      
echo                                                       Example: DRVEXIST A
echo           Usage: DRVEXIST [letter]                   
echo                  DRVEXIST ... Case iNsEnSiTiVe (except cannot be "drveXist")
echo                    letter ... Drive letter A-Z (except B)
echo          Output:   YES/NO ... ECHOed to screen
echo.
echo                                                      
echo     Batch Usage: drveXist [letter]                    Example: drveXist f
echo     ------------ drveXist ... Case sEnSiTiVe         
echo                    letter ... Drive letter A-Z (except B)
echo    Batch Output:      1/0 ... Value SET to "DrvExist" EV (1=YES,0=NO)
echo    -------------
echo.
echo  Requirements: FREETEST.COM
echo.
goto END
::
:0H
echo .%0. | find "drveXist" > NUL
if errorlevel 1 echo  NO
if not errorlevel 1 set DrvExist=0
goto END
:0I
echo .%0. | find "drveXist" > NUL
if errorlevel 1 echo  YES
if not errorlevel 1 set DrvExist=1
:END