@echo off
::
:: Lines beginning with "::" are inactive.
::
::-@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@-<
::
:: Purpose:
:: ~~~~~~~~
:: This batch code will get 2 random colors from the standard 16-color
:: palette and SET them to the EVs (environment variables) %BG% (background)
:: and %FG% (foreground).
::
::-------------------------------------------------------------------------<
::
:: Requirements:
:: ~~~~~~~~~~~~~
:: * MS-DOS [*] Protected-mode ... (with Win9x ... running)
::          [*] Real-mode ........ (with Win9x NOT running)
:: * MS-DOS External Command Program(s):
::   -     FIND.EXE
::   -   MD5SUM.EXE (Branko Lankester, Colin Plumb, & Michael Paul Johnson)
::                  (MD5:  ffbfbcc238f518b079dc8e00452c0ce1  MD5SUM.EXE)
::                  ftp://ftp.elf.stuba.sk/pub/pc/security/md5sum.zip
::                  http://ebible.org/mpj/software.htm
::   -     NSET.COM (v2.1) (by Horst Schaeffer)
::                  (MD5:  2d09602c021592df1659c78b3df8ec6c  NSET.COM)
::                  ftp://ftp.elf.stuba.sk/pub/pc/utiltask/horst31.zip
::
::-------------------------------------------------------------------------<
::
:: Notes:
:: ~~~~~~
:: * For usage, type "16COLOR /?".
::
::- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -<
::
::                                                 /
:: Usage: 16COLOR [D/d/W/w] [e]                    | Examples: 16COLOR w
::                                                 |           16COLOR D e
::    / - Choose only one of these options         \-----------------------/
::    D - DOS .. EVs: BG=(0-7), FG=(0-F); Color combos NOT contrast-filtered
::    d - DOS .. EVs: BG=(0-7), FG=(8-F); Color combos are contrast-filtered
::    W - Win .. EVs: BG=(0-F), FG=(0-F); Color combos NOT contrast-filtered
::    w - Win .. EVs: BG=(0-F), FG=(0-F); Color combos are contrast-filtered
::    e - Echo . Just ECHO result to screen (don't SET "BG" and "FG" EVs)
::              /---------------------------------------------------------\
:: Color Chart: | Dark Colors | Light Colors | Dark Colors | Light Colors |
::              | ----------- | ------------ | ----------- | ------------ |
::              |   Black - 0 | 8 - Gray     |  Maroon - 4 | C - Red      |
::              |    Navy - 1 | 9 - Blue     |  Purple - 5 | D - Fuchsia  |
::              |   Green - 2 | A - Lime     |   Olive - 6 | E - Yellow   |
::              |    Teal - 3 | B - Aqua     |  Silver - 7 | F - White    |
::              \---------------------------------------------------------/
:: Requirements: MD5SUM.EXE / NSET.COM (v2.1)
::
::- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -<
::
:: * All options [D/d/W/w] disallow a color combination where the background
::   color is the same as the foreground color.
::
:: * For options [d/w], an attempt is made to disallow color combinations
::   that don't contrast well enough, thus making their text displayed on
::   screen difficult to read.
::
:: * In real-mode DOS (with Windows NOT running), use of any of these colors
::   (8 9 A B C D E F) as a background color will cause a blinking effect on
::   screen.  This program filters out these colors as possible background
::   colors if the "D" or "d" option is specified.  (Of course, reverse the
::   EVs and a blinking color combo is possible, yes?!                    ;)
::
:: * Be careful when reversing the %BG% and %FG% EVs for use in a real-mode
::   DOS batch application.  A filter will need to be in place to catch any
::   of these color combinations (80 91 A2 B3 C4 D5 E6 F7) as they produce
::   an effect where nothing appears on screen (blinking text that is the
::   same color as the background).  So while 4C is fine, C4 is not.
::
:: * Ironically, while the pairs (00 11 22 33 44 55 66 77) produce nothing
::   (same color text as background), in real-mode DOS the color pairs
::   (88 99 AA BB CC DD EE FF) actually produce readable text on screen
::   (though blinking).  This batch program does not take advantage of this
::   (though it would require an EV reversal), since all duplicates (same BG
::   color as FG color) are filtered out.
::
::   Of course, under Windows the color combos (88 99 AA BB CC DD EE FF)
::   produce nothing (same color text as background).
::
:: * For the "w" option, the colors (8 9) are considered with the dark color
::   set as they tend to contrast better with (A-F) than (0-6).
::
:: * Color (7) is allowed to pair with both dark and light color sets
::   [except that it is disallowed to pair with (2 3 4 5 6), as it does not
::   seem to contrast well with these].
::
:: * For option "d" color (8) is disallowed to pair with colors (0 1) due to
::   lack of contrast.
::
::- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -<
::
:: * Color Combinations That Are Disallowed (Contrast-Filtered):
::   -----------------------------------------------------------
::   D: 00 11 22 33 44 55 66 77 8? 9? a? b? c? d? e? f?
::
::   d: 00 11 22 33 44 55 66 77 8? 9? a? b? c? d? e? f?
::      08 18 27 37 47 57 67 72 73 74 75 76
::      Any Dark/Dark combos, where Dark=(0 1 2 3 4 5 6)
::
::   W: 00 11 22 33 44 55 66 77 88 99 aa bb cc dd ee ff
::
::   w: 00 11 22 33 44 55 66 77 88 99 aa bb cc dd ee ff
::      27 37 47 57 67 72 73 74 75 76
::      Any Dark/Dark or Light/Light combos, where...
::      Dark=(0 1 2 3 4 5 6 8 9) and Light=(a b c d e f)
::
::-------------------------------------------------------------------------<
::
:: About:                                               (06-06-2009)
:: ~~~~~~
:: 16COLOR.BAT (v1.3)
::
::      Bla
::      P.O. Box NUL
::      Valley View, Ohio 44125 USA
::
::      E-Mail:   Blaware@FastMail.fm
::      Webpage:  http://www.NUL.nul/index.html
::
:: Feed the birds.  (Why?)  Well, they haven't pecked your eyes out!
::
::-#######################################################################-<
::
ctty nul
if .%1.==.. goto MESSAGE
if not .%3.==.. goto HELP
echo -h/H?-?/?--HELP | find /i "%1" > NUL
if not errorlevel 1 goto HELP
if .%2.==.. goto 0G
for %%A in (e E) do if .%2.==.%%A. goto 0G
goto HELP
:0G
for %%B in (d D w W) do if .%1.==.%%B. goto 0H
goto HELP
:0H
md5sum -b nuL | find "d41d8cd98f00b204e9800998ecf8427e *nuL" > NUL
if errorlevel 1 goto HELP
nset /? | find "NSET 2.1 (c) 1997 Horst Schaeffer - see DOC file" > NUL
if errorlevel 1 goto HELP
goto 0I
::
:MESSAGE
ctty con
echo  16COLOR.BAT -- Gets 2 random colors from standard 16-color palette; SETs EVs
echo                 "BG" (background) and "FG" (foreground), or ECHOes to screen.
echo                 Type "16COLOR /?" for usage.
echo.
goto END
::
:HELP
ctty con
echo  16COLOR.BAT -- Gets 2 random colors from standard 16-color palette; SETs EVs
echo  ***********    "BG" (background) and "FG" (foreground), or ECHOes to screen.
echo                                                  
echo  Usage: 16COLOR [D/d/W/w] [e]                     Examples: 16COLOR w
echo                                                             16COLOR D e
echo     / - Choose only one of these options         
echo     D - DOS  EVs: BG=(0-7), FG=(0-F); Color combos NOT contrast-filtered
echo     d - DOS  EVs: BG=(0-7), FG=(8-F); Color combos are contrast-filtered
echo     W - Win  EVs: BG=(0-F), FG=(0-F); Color combos NOT contrast-filtered
echo     w - Win  EVs: BG=(0-F), FG=(0-F); Color combos are contrast-filtered
echo     e - Echo  Just ECHO result to screen (don't SET "BG" and "FG" EVs)
echo               Ŀ
echo  Color Chart:  Dark Colors  Light Colors  Dark Colors  Light Colors 
echo                -----------  ------------  -----------  ------------ 
echo                  Black - 0  8 - Gray       Maroon - 4  C - Red      
echo                   Navy - 1  9 - Blue       Purple - 5  D - Fuchsia  
echo                  Green - 2  A - Lime        Olive - 6  E - Yellow   
echo                   Teal - 3  B - Aqua       Silver - 7  F - White    
echo               
echo  Requirements: MD5SUM.EXE / NSET.COM (v2.1)
echo.
goto END
::
:0I
set CZ8=
set CZ9=0
echo. | time | md5sum | nset /P01,29 /L1 CZ8=$0
:0J
set CZ5=
set CZ7=1
if .%CZ9%.==.9. goto 0I
if .%CZ9%.==.8. set CZ9=9
if .%CZ9%.==.7. set CZ9=8
if .%CZ9%.==.6. set CZ9=7
if .%CZ9%.==.5. set CZ9=6
if .%CZ9%.==.4. set CZ9=5
if .%CZ9%.==.3. set CZ9=4
if .%CZ9%.==.2. set CZ9=3
if .%CZ9%.==.1. set CZ9=2
if .%CZ9%.==.0. set CZ9=1
echo %CZ8% | nset /P0%CZ9%,01 /L1 CZ6=$0
for %%C in (w W) do if .%1.==.%%C. goto 0K
for %%D in (0 1 2 3 4 5 6 7) do if .%CZ6%.==.%%D. goto 0K
if .%CZ6%.==.f. set CZ6=7
if .%CZ6%.==.e. set CZ6=6
if .%CZ6%.==.d. set CZ6=5
if .%CZ6%.==.c. set CZ6=4
if .%CZ6%.==.b. set CZ6=3
if .%CZ6%.==.a. set CZ6=2
if .%CZ6%.==.9. set CZ6=1
if .%CZ6%.==.8. set CZ6=0
:0K
if .%CZ5%.==.9. goto 0L
if .%CZ5%.==.8. set CZ5=9
if .%CZ5%.==.7. set CZ5=8
if .%CZ5%.==.6. set CZ5=7
if .%CZ5%.==.5. set CZ5=6
if .%CZ5%.==.4. set CZ5=5
if .%CZ5%.==.3. set CZ5=4
if .%CZ5%.==.2. set CZ5=3
if .%CZ5%.==.1. set CZ5=2
if .%CZ5%.==.0. set CZ5=1
if .%CZ5%.==.. set CZ5=0
goto 0M
:0L
if .%CZ7%.==.2. goto 0J
set CZ5=0
set CZ7=2
:0M
echo %CZ8% | nset /P%CZ7%%CZ5%,01 /L1 CZ4=$0
for %%E in (00 11 22 33 44 55 66 77) do if .%CZ6%%CZ4%.==.%%E. goto 0K
if .%1.==.D. goto 0P
for %%F in (88 99 aa bb cc dd ee ff) do if .%CZ6%%CZ4%.==.%%F. goto 0K
if .%1.==.W. goto 0P
if .%CZ6%.==.7. for %%G in (2 3 4 5 6) do if .%CZ4%.==.%%G. goto 0K
if .%CZ4%.==.7. for %%H in (2 3 4 5 6) do if .%CZ6%.==.%%H. goto 0K
if .%1.==.w. goto 0N
if .%CZ6%.==.7. goto 0P
for %%I in (0 1 2 3 4 5 6) do if .%CZ4%.==.%%I. goto 0K
if .%CZ4%.==.8. for %%J in (0 1) do if .%CZ6%.==.%%J. goto 0K
goto 0P
:0N
for %%K in (0 1 2 3 4 5 6 8 9) do if .%CZ6%.==.%%K. goto 0O
for %%L in (a b c d e f) do if .%CZ4%.==.%%L. goto 0K
goto 0P
:0O
for %%M in (0 1 2 3 4 5 6 8 9) do if .%CZ4%.==.%%M. goto 0K
:0P
ctty con
for %%N in (e E) do if .%2.==.%%N. goto 0Q
set BG=%CZ6%
set FG=%CZ4%
goto 0R
:0Q
echo  BG:%CZ6%  FG:%CZ4%
echo.
:0R
for %%O in (CZ9 CZ8 CZ7 CZ6 CZ5 CZ4) do set %%O=
:END