UNIT PCIfaceP;

INTERFACE
TYPE
  PCIinfo = RECORD
    hardware_characteristics : BYTE;
    Version : BYTE;
    Revision : BYTE;
    LastBus : BYTE;
  END;
  PCIinfoPtr = ^PCIinfo;
  
FUNCTION PCI_InstChk(info : PCIinfoPtr) : Word;
FUNCTION pci_find_dev(DevID : Word; VenID : Word; Index : Word; VAR bus : BYTE; VAR DevFun : BYTE) : Word;
FUNCTION pci_find_class(Class : LongInt; Index : Word; VAR bus : BYTE; VAR DevFun : BYTE) : Word;
FUNCTION pci_crd_dw(bus : Word; DevFun : Word; Regnum : Word; VAR value : LongInt) : Word;
FUNCTION pci_crd_w(bus : Word; DevFun : Word; Regnum : Word; VAR value : Word) : Word;
FUNCTION pci_crd_b(bus : Word; DevFun : Word; Regnum : Word; VAR value : Byte) : Word;

IMPLEMENTATION
{$L PCIFACEP.OBJ}
  FUNCTION PCI_InstChk(info : PCIinfoPtr) : Word; External;
  FUNCTION pci_find_dev(DevID : Word; VenID : Word; Index : Word; VAR bus : BYTE; VAR DevFun : BYTE) : Word; External;
  FUNCTION pci_find_class(Class : LongInt; Index : Word; VAR bus : BYTE; VAR DevFun : BYTE) : Word; External;
  FUNCTION pci_crd_dw(bus : Word; DevFun : Word; Regnum : Word; VAR value : LongInt) : Word; External;
  FUNCTION pci_crd_w(bus : Word; DevFun : Word; Regnum : Word; VAR value : Word) : Word; External;
  FUNCTION pci_crd_b(bus : Word; DevFun : Word; Regnum : Word; VAR value : Byte) : Word; External;

BEGIN
END. (* PCIface *)
