{$B-}
{$S-}
{$R-}
{$A+}
(* PCI-SPY 1.04 by Matthias Dehof and Martin Hohl
   This code is distributed as Copyrighted Freeware,
   that means you are free to use it for any purpose
   but you may not sell the code.
   You may redistribute the code in unmodified state,
   but only the complete archive PCISPY.ZIP containing
   both PCI_SPY.PAS and PCI_SPY.EXE. If you transfer
   pcispy.zip via Email, please use uuencode.
   If you make any changes to this program, please send
   them (as context-diffs, if possible) to the current
   code maintainer Martin Hohl <martinh@caverna.tynet.sub.org>.
   This program is based on a little piece of code written
   by Matthias Dehof, largely extended by Martin Hohl. *)
(* If you find out any unknown device ID with this program,
   send a mail to the above email address describing the
   following:
   - manufacturer and model of your PCI-mainboard, further
     the PCI chipset used on this mainboard, if known
     (e.g. Intel Saturn Rev. 4)
   - manufacturer and model of your PCI-adaptor cards
     and corresponding slot number, also any information
     about chipsets used on those boards with unknown devices
     will be useful.
   - The output of PCI_SPY. Just type "pci_spy >pci_spy.out".

   This information will help me to add more PCI device IDs
   to PCI_SPY's internal device list.
   I would also appreciate to receive PCI device ID
   lists, if you have any.                            *)

(* Read PCI Config registers from Intel Saturn chipset            *)
PROGRAM PCIconf;

USES PCIfaceP;

CONST

{ some useful hex-values                                        }

  hx : array[0..15] of char =
    ('0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F');

{ CSE Configuration Space Enable Register                       }
{ Setting bit 7 will cause the CDC to enter config mode         }

  initport : word = $0cf8;

{ Base address for configuration space                          }

  baseport : word = $c000;

{ Base addresses for PCI device 0, 1, 2 and 3, further devices, }
{ up to 16, will follow this scheme                             }

  device0 = $0000;
  device1 = $0100;
  device2 = $0200;
  device3 = $0300;

{ some addresses within CDC configuration space, PCI device 0   }

  reg_vid = $000;            { Vendor Identification register  W }
  reg_did = $002;            { Device Identifitcation register W }
  reg_cmd = $004;            { PCI Command register            W }
  reg_classrev = $008;       { PCI Class & Revision            D }
  reg_wbc = $053;            { Write Buffer Control register   B }
  reg_pfc = $054;            { PCI features control            B }
  reg_base0 = $010;          { PCI Base Address 0              D }
  reg_base1 = $014;          { PCI Base Address 1              D }
  reg_base2 = $018;          { PCI Base Address 2              D }
  reg_base3 = $01C;          { PCI Base Address 3              D }
  reg_base4 = $020;          { PCI Base Address 4              D }
  reg_base5 = $024;          { PCI Base Address 5              D }
  reg_irq = $03c;            { PCI IRQ Line                    B }
  reg_intpin = $03d;         { PCT INT Pin                     B }

VAR
  ByteValue : Byte;
  WordValue, VenID, DevID : Word;
  Revision : Word;
  BaseHi1, BaseLo1 : Word;
  BaseHi2, BaseLo2 : Word;
  ClassHi, ClassLo : Word;
  I82424_present : BOOLEAN;
  ActualPCIinfo : PCIinfo;
  i : INTEGER;

PROCEDURE OpenPCI;           { Enter config mode }
VAR b : byte;
BEGIN
  b := port[initport];
  b := b or $80;
  port[initport] := b;
END; (* OpenPCI *)

PROCEDURE ClosePCI;          { leave config mode }
VAR b : byte;
BEGIN
  b := port[initport];
  b := b and $7f;
  port[initport] := b;
END; (* ClosePCI *)

(* Routine to read a byte from PCI config register *)
PROCEDURE ReadConfigByte(DevNum : Word; RegNum : Word; VAR b: Byte);
BEGIN
  b:=Port[baseport+device1*DevNum+RegNum];
END; (* ReadConfigByte *)

(* Routine to read a word (2 Bytes) from PCI config register *)
PROCEDURE ReadConfigWord(DevNum : Word; RegNum : Word; VAR w: Word);
BEGIN
  w:=PortW[baseport+device1*DevNum+RegNum];
END; (* ReadConfigWord *)

FUNCTION state(b: Byte): string;
BEGIN
  IF b=0 THEN state:='DISABLED' ELSE state:='ENABLED';
END; (* state *)

PROCEDURE PrintHexWord(WordValue : Word);
BEGIN
  Write(hx[WordValue shr 12]);
  Write(hx[(WordValue and $0f00) shr 8]);
  Write(hx[(WordValue and $00f0) shr 4]);
  Write(hx[WordValue and $0f]);
END; (* PrintHexWord *)

PROCEDURE PrintHexByte(ByteValue : Byte);
BEGIN
  Write(hx[(ByteValue and $0f0) shr 4]);
  Write(hx[ByteValue and $0f]);
END; (* PrintHexByte *)

(* Decode & Print Vendor ID *)
PROCEDURE PrintVID(VID : Word);
BEGIN
  CASE VID OF
    $8086 : Write('Intel');
    $1000 : Write('NCR');
    $1002 : Write('ATI Technologies Inc.');
    $1005 : Write('Avance Logics Inc.');
    $100B : Write('National Semiconductor');
    $100C : Write('TsengLabs Inc.');
    $100E : Write('Weitek');
    $1013 : Write('Cirrus Logic');
    $101C : Write('Western Digital');
    $1022 : Write('AMD');
    $1036 : Write('Future Domain');
    $1039 : Write('SiS');
    $1043 : Write('AsusTek Computer Inc.');
    $1044 : Write('DPT');
    $1045 : Write('OPTi');
    $104B : Write('Buslogic');
    $1060 : Write('UMC');
    $1061 : Write('IIT');
    $1077 : Write('Q-Logic');
    $107F : Write('DTC');
    $1083 : Write('Forex');
    $1095 : Write('CMD Technology Inc.');
    $10B8 : Write('SMC');
    $10B9 : Write('Acer Labs Inc.');
    $10E0 : Write('IMS');
    $110D : Write('Zynx');
    $5333 : Write('S3');
    $9004 : Write('Adaptec');
  ELSE
    Write(' unknown');
  END;
END; (* PrintVID *)

(* Decode & Print Device ID *)
PROCEDURE PrintDID(VID,DID : Word);
BEGIN
  CASE VID OF
    $8086 : CASE DID OF
              $0482 : Write('82375 PCI-to-EISA Bridge');
              $0483 : BEGIN
                        Write('82424CTC Saturn PCI Chipset');
                        I82424_present:=TRUE;
                      END;
              $0484 : Write('82378 PCI-to-ISA Bridge');
              $0486 : Write('82420 PCI-to-ISA Bridge & EIDE');
              $04A3 : Write('82434 Mercury or Neptune Chipset for P5');
              $1222 : Write('82092 EIDE Adapter');
            ELSE
              Write('unknown');
            END;
    $1000 : CASE DID OF
              1 : Write('53C810 SCSI hostadapter');
              2 : Write('53C820 SCSI hostadapter');
              3 : Write('53C825 SCSI hostadapter');
              4 : Write('53C815 SCSI hostadapter');
            ELSE
              Write('unknown');
            END;
    $1002 : CASE DID OF
              $4158 : Write('ATI 68800AX 32-Bit GUI Accelerator');
            ELSE
              Write('unknown');
            END;
    $100E : CASE DID OF
              $9000 : Write('P9000 32-Bit GUI Accelerator');
              $9001 : Write('P9001 32-Bit GUI Accelerator');
              $9100 : Write('P9100 32-Bit GUI Accelerator');
            ELSE
              Write('unknown');
            END;
    $100C : CASE DID OF
              $3202 : Write('ET4000W32P GUI Accelerator (old version)');
              $3207 : Write('ET4000W32P GUI Accelerator');
            ELSE
              Write('unknown');
            END;
    $1013 : CASE DID OF
              $00A8 : Write('CL GD5434 Graphics Accelerator');
            ELSE
              Write('unknown');
            END;
    $101C : CASE DID OF
              $0196 : Write('WD33C196A PCI SCSI adapter');
            ELSE
              Write('unknown');
            END;
    $1022 : CASE DID OF
              $2000 : Write('AM 79C970 PCI Ethernet Adapter');
              $2020 : Write('AM 53C974 PCI SCSI Adapter');
              $2040 : Write('AM 79C974 PCI Ethernet & SCSI Adapter');
            ELSE
              Write('unknown');
            END;
    $1036 : CASE DID OF
              $0000 : Write('TMC 3260 PCI SCSI adapter (36C70)');
            ELSE
              Write('unknown');
            END;
    $1039 : CASE DID OF
              $0001 : Write('86C201 True Color Graphics Accelerator');
              $0006 : Write('85C501/2/3 Pentium PCI Chipset (?)');
              $0406 : Write('85C501/2/3 Pentium PCI Chipset (?)');
              $0496 : Write('85C496/7 i486 PCI Chipset');
              $0601 : Write('83C602 EIDE Adapter');
              $0008 : Write('83C503 PCI-to-ISA Bridge (?)');
            ELSE
              Write('unknown');
            END;
    $104B : CASE DID OF
              $0140 : Write('BT 946C PCI SCSI-II Hostadapter');
            ELSE
              Write('unknown');
            END;
    $1060 : CASE DID OF
              $0001 : Write('UM82C881 i486 PCI Chipset');
              $0002 : Write('UM82C886 PCI-to-ISA Bridge');
              $0881 : Write('UM8881-HB4 i486 PCI Chipset');
              $0886 : Write('UM8886 PCI-to-ISA Bridge');
              $8881 : Write('UM8881-HB4 i486 PCI Chipset');
              $8886 : Write('UM8886 PCI-to-ISA Bridge');
            ELSE
              Write('unknown');
            END;
    $1083 : CASE DID OF
              $0001 : Write('FR710 PCI EIDE Adapter');
            ELSE
              Write('unknown');
            END;
    $1095 : CASE DID OF
              $0640 : Write('0640A PCI EIDE Adapter');
            ELSE
              Write('unknown');
            END;
    $5333 : CASE DID OF
              $88C0 : Write('S3 86C864-P graphics controller Rev. 1');
              $88C1 : Write('S3 86C864-P graphics controller Rev. 2');
              $88D0 : Write('S3 86C964-P graphics controller Rev. 1');
              $88D1 : Write('S3 86C964-P graphics controller Rev. 2');
              $8880 : Write('S3 86C868 graphics controller');
              $8811 : Write('S3 86C811 graphics controller');
            ELSE
              Write('unknown');
            END;
    $9004 : CASE DID OF
              $7178 : Write('AIC 7870P PCI SCSI hostadapter');
            ELSE
              Write('unknown');
            END;
  ELSE
    Write('unknown');
  END;
END; (* PrintDID *)

(* Print PCI Base Adress *)
PROCEDURE PrintPCIaddress(VAR HiWord, LoWord : Word);
BEGIN
  (* Bit 1 of low word is IO-Mask, used to distinguish IO
     address space from memory address space *)
  IF (LoWord AND 1) = 1 THEN Write('PCI I/O-Adress: ')
  ELSE Write('PCI Memory-Adress: ');
  PrintHexWord(HiWord);
  IF (LoWord AND 1) = 1 THEN LoWord := (LoWord AND $FFFE);
  PrintHexWord(LoWord);
END; (* PrintPCIaddress *)

PROCEDURE PrintPCIClass(ClassHi, ClassLo : Word);
BEGIN
  IF ClassLo = 0 THEN BEGIN
    CASE ClassHi OF
      $0000: Write('Old Undefined Device');
      $0001: Write('Old VGA Display Device');
      $0100: Write('SCSI Storage Device');
      $0101: Write('IDE Storage Device');
      $0102: Write('Floppy Storage Device');
      $0103: Write('IPI Storage Device');
      $0180: Write('Other Storage Device');

      $0200: Write('Ethernet Network Device');
      $0201: Write('Token Ring Network Device');
      $0202: Write('FDDI Network Device');
      $0280: Write('Other Network Device');

      $0300: Write('VGA-Display');
      $0301: Write('XGA-Display');
      $0380: Write('Other Display');

      $0600: Write('Host-Bridge');
      $0601: Write('ISA-Bridge');
      $0602: Write('EISA-Bridge');
      $0603: Write('MC-Bridge');
      $0604: Write('PCI-Bridge');
      $0605: Write('PCMCIA-Bridge');
      $0680: Write('Other Bridge');
    ELSE
      Write('Unknown Class: ');
      PrintHexWord(ClassHi);
      PrintHexWord(ClassLo);
    END
  END
  ELSE BEGIN
    Write('Unknown Class: ');
    PrintHexWord(ClassHi);
    PrintHexWord(ClassLo);
  END;
END; (* PrintPCIClass *)

BEGIN
  WriteLn('PCI-SPY 1.04 (1994 by Matthias Dehof and Martin Hohl)');
  WriteLn;
  IF PCI_InstChk(@ActualPCIinfo)=$FFFF THEN BEGIN
    WriteLn('PCI-BIOS call is not properly supported on this system');
    Halt;
  END;
  IF (ActualPCIinfo.hardware_characteristics AND 2) = 0 THEN BEGIN
    WriteLn('PCI configuration space access method 2 is not supported on this system');
    Halt;
  END;
  OpenPCI;
  I82424_present:=FALSE;
  (* Scan the first 15 devices on PCI bus 0 *)
  FOR i:=0 TO 15 DO BEGIN
    { VID and DID are 16-bit register ! }

    ReadConfigWord(i,reg_vid,WordValue);
    IF (WordValue <> $FFFF) THEN BEGIN
      WriteLn('--PCI Device ',i,'---------------------------------------------------');
      Write('Vendor Identification  : ');
      VenID:=WordValue;
      PrintHexWord(VenID);
      Write('  ');
      PrintVID(VenID);
      WriteLn;

      Write('Device Identification  : ');
      ReadConfigWord(i,reg_did,WordValue);
      DevID:=WordValue;
      PrintHexWord(DevID);
      Write('  ');
      PrintDID(VenID,DevID);
      WriteLn;

      ReadConfigWord(i,reg_classrev,ClassLo);
      ReadConfigWord(i,reg_classrev+2,ClassHi);
      Revision:=ClassLo AND $0FF;
      Write('Device-Class: ');
      PrintPCIClass(ClassHi,ClassLo AND $FF00);
      Write('    Revision: ');
      PrintHexByte(Revision);
      WriteLn;
      Write('PCI INT Pin : ');
      ReadConfigByte(i,reg_intpin,ByteValue);
      IF ByteValue=0 THEN Write('None')
      ELSE Write(Chr(ByteValue+64));

      IF ByteValue<>0 THEN BEGIN
        Write(' --> PCI IRQ Line : ');
        ReadConfigByte(i,reg_irq,ByteValue);
        PrintHexByte(ByteValue);
      END;
      WriteLn;

      ReadConfigWord(i,reg_base0,BaseLo1);
      ReadConfigWord(i,reg_base0+2,BaseHi1);
      IF (BaseLo1 OR BaseHi1) <> 0 THEN BEGIN
        PrintPCIaddress(BaseHi1,BaseLo1);
      
        ReadConfigWord(i,reg_base1,BaseLo2);
        ReadConfigWord(i,reg_base1+2,BaseHi2);
        IF (BaseLo2 OR BaseHi2) <> 0 THEN BEGIN
          Write('    ');
          PrintPCIaddress(BaseHi2,BaseLo2);
        END;
        WriteLn;
      END;
    END;
  END;

  IF I82424_present THEN BEGIN
  WriteLn('--82424 settings-------------------------------------------------');
    ReadConfigByte(0,reg_wbc,ByteValue);
    WriteLn('Host-to-PCI-Posting    : ',state(ByteValue and 2));
    WriteLn('Host-to-Memory-Posting : ',state(ByteValue and 1));

    ReadConfigByte(0,reg_pfc,ByteValue);
    WriteLn('CPU-to-PCI-Burst       : ',state(ByteValue and 2));
    WriteLn('PCI-to-Memory-Posting  : ',state(ByteValue and 1));
  END;

  ClosePCI;
END.
