#ifndef _MemStat_Header
#define _MemStat_Header

#include <windows.h>
#include "resource.h"

// --- Global Constants ---
static char AppName[] = "Mini Mem Stat" ;

// --- Definitions ---
typedef struct { int x, y, width, height, onTop, clientWnd; } WinInfo;

// --- Prototypes ---
int WINAPI MemStat (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
int MakeNewWindow (void);
void LoadWindowInfo (void);
BOOL CALLBACK AboutDialog (HWND hwndDlg,  UINT uMsg, WPARAM wParam,	 LPARAM lParam );

// --- Pop-up menu identifiers ---
const int IDPOPMENU_TOPMOST = 50;
const int IDPOPMENU_QUIT    = 100;
const int IDPOPMENU_ABOUT   = 200;
const int IDPOPMENU_CLWND   = 300;


const char* pPopMenuClientWnd = "&Client Wnd";
const char* pPopMenuTopmost   = "&Top Most";
const char* pPopMenuQuit      = "&Quit";
const char* pPopMenuAbout     = "&About";

#endif // _MemStat_Header
