//***************************************
//**** MEM stat by Steven De Toni 97 ****
//***************************************

#include <windows.h>
#include <winperf.h>
#include <winuser.h>
#include <stdio.h>
#include <string.h>
#include "memStat.h"
#include "NTCounters.h"

// --- Constants ---
// Uncomment the following if they have not been defined (old compiler)
// #define HKEY_DYN_DATA           ((HKEY) 0x80000006 )
// #define WS_EX_TOOLWINDOW        0x00000080L
// #define WS_EX_CLIENTEDGE        0x00000200L

// --- Global Variables ---
HANDLE      HInst = NULL;
WNDCLASS    MemWndClass;
WinInfo     WindowInfo = {10, 10, 200, 100, -1, 0};

// ***********************************************************************************

int WINAPI WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdParam, int nCmdShow)
{
    MSG         msg;

    HInst = hInstance;

    if (!hPrevInstance)
    {
        memset(&MemWndClass, 0, sizeof (MemWndClass));

        // **** Create a new class ****
        MemWndClass.style         = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
        MemWndClass.lpfnWndProc   = (WNDPROC) MemStat;
        MemWndClass.cbClsExtra    = 0;
        MemWndClass.cbWndExtra    = 0;
        MemWndClass.hInstance     = hInstance;
        MemWndClass.hIcon         = NULL;        
        MemWndClass.hCursor       = LoadCursor     (NULL, IDC_ARROW);
        MemWndClass.lpszMenuName  = NULL;
        MemWndClass.lpszClassName = AppName;

        RegisterClass (&MemWndClass) ;
    }
    else
        return -1;                                      // Only one instance of this program is allow in memory !

    LoadWindowInfo ();
    
    // Create and show the window.
    if (MakeNewWindow () != 0)
        return -1;
        
    while (GetMessage (&msg, NULL, 0, 0))
    {
        TranslateMessage (&msg);
        DispatchMessage (&msg);
    }

    return msg.wParam ;
}

// ***********************************************************************************

// return 0 up succes, -1 upon error
int MakeNewWindow (void)
{
    LONG wndExtStyle = WS_EX_TOOLWINDOW;     
    HWND hMainWnd;
    
    if (WindowInfo.onTop != 0)
        wndExtStyle |= WS_EX_TOPMOST;

    if (WindowInfo.clientWnd != 0)
        wndExtStyle |= WS_EX_CLIENTEDGE;
     
    hMainWnd = CreateWindowEx (wndExtStyle ,    
                               AppName,               // window class name
                               "",                    // window caption                                  
                               WS_POPUP | WS_SIZEBOX,
                               WindowInfo.x,          // initial x position
                               WindowInfo.y,          // initial y position
                               WindowInfo.width,      // initial x size
                               WindowInfo.height,     // initial y size
                               GetDesktopWindow(),                  // parent window handle
                               NULL,                  // window menu handle
                               HInst,                 // program instance handle
                               NULL);                 // creation parameters
    if (hMainWnd == NULL)
    {
        MessageBox (NULL, "Unable to create memstat window!", "error" , MB_ICONSTOP | MB_OK);        
        return -1;
    }

    ShowWindow (hMainWnd, SW_SHOW);
    return 0;
}
// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
// return details in ranges from 0-100%
void GetMemDetails (HKEY HCPULoadKey, int& realMem, int& pageFile, int& memLoad, DWORD& cpuLoad, BOOL notUpdateCPU)
{
    MEMORYSTATUS ms;
    ULONG        type      = REG_DWORD;
    DWORD        cpuSize   = sizeof (cpuLoad);

    GlobalMemoryStatus(&ms);
    memLoad  = ms.dwMemoryLoad;
    realMem  = 100 - (int) (((float)ms.dwAvailPhys / (float)ms.dwTotalPhys) * 100.0);
    pageFile = 100 - (int) (((float)ms.dwAvailPageFile / (float)ms.dwTotalPageFile) * 100.0);

    if (notUpdateCPU == FALSE)
    {
        if (HCPULoadKey != NULL)
        {
            int a = RegQueryValueEx(HCPULoadKey, "KERNEL\\CPUUsage", NULL, &type, (LPBYTE) &cpuLoad, &cpuSize);
            if (a != 0)
                cpuLoad = (DWORD)-1;
        }
        else
            cpuLoad = CPUPercentage ();
    }
}

// ***********************************************************************************

// open the registry for windows 95.
HKEY OpenCPUStatus95 (void)
{
    LONG    result;
    LPCSTR  pDir = "PerfStats\\StatData";
    HKEY    statKey;


    if ((result = RegOpenKey (HKEY_DYN_DATA, pDir , &statKey)) != 0)
        return NULL;  // not a windows 95 system!

    return statKey;
}

// ***********************************************************************************

void StartCPULoadProfiling95 (void)
{
   LPCSTR  pDir = "PerfStats\\StartStat";
   HKEY    statKey;
   ULONG   type      = REG_DWORD;
   DWORD   cpuLoad   = 1;
   DWORD   cpuSize   = sizeof (cpuLoad);


   if (RegOpenKey (HKEY_DYN_DATA, pDir , &statKey) != 0)
        return;  // not a windows 95 system!

   if (RegQueryValueEx(statKey, "KERNEL\\CPUUsage", NULL, &type, (LPBYTE) &cpuLoad, &cpuSize) != 0)
       RegCloseKey (statKey);                
}

// ***********************************************************************************

void LoadWindowInfo (void)
{
    const int     BuffSize = 128;
    char          profileBuff[BuffSize];
    HKEY          hWindowInfo = NULL;
    unsigned long type        = REG_SZ;
    unsigned long fucked      = BuffSize;
    LONG          result      = RegOpenKey (HKEY_CURRENT_USER, (LPCTSTR)"software\\De Toni Ware", &hWindowInfo);

    if (result != 0)
        return;

    RegQueryValueEx(hWindowInfo, (LPTSTR)"Window Info", NULL, &type, (LPBYTE)profileBuff, &fucked);

    sscanf (profileBuff, "%d %d %d %d %d %d", &WindowInfo.x,     &WindowInfo.y, 
                                              &WindowInfo.width, &WindowInfo.height, 
                                              &WindowInfo.onTop, &WindowInfo.clientWnd);

    RegCloseKey(hWindowInfo); 
}

// ***********************************************************************************

void SaveWindowInfo (HWND hwnd)
{
    const int       BuffSize = 128;
    char            profileBuff[BuffSize];
    HKEY            hWindowInfo = NULL;
    RECT            rect;
    LONG            result      = RegCreateKey (HKEY_CURRENT_USER, (LPCTSTR)"software\\De Toni Ware", &hWindowInfo);

    GetWindowRect(hwnd, &rect);

    WindowInfo.x      = (int)rect.left;  
    WindowInfo.y      = (int)rect.top;
    WindowInfo.width  = (int)rect.right - rect.left; 
    WindowInfo.height = (int)rect.bottom - rect.top;

    if (result != 0)
    {
        MessageBox (NULL, "Unable to open/create registry key!" , "Registry Error", MB_ICONSTOP | MB_OK);
        return;
    }

    wsprintf (profileBuff, "%d %d %d %d %d %d", WindowInfo.x,      WindowInfo.y, 
                                                WindowInfo.width,  WindowInfo.height,
                                                WindowInfo.onTop,  WindowInfo.clientWnd);

    RegSetValueEx (hWindowInfo, (LPCTSTR)"Window Info", NULL, REG_SZ, (CONST BYTE*)profileBuff, (DWORD) strlen (profileBuff));
    RegCloseKey(hWindowInfo); 
}

// ***********************************************************************************

void DrawBars (HWND hwnd, HKEY HCPULoadKey, BOOL upDateAll, BOOL notUpdateCPU)
{
    static LOGFONT DescribFont = {-10, 0, 0, 0, 400, 0, 0, 0, 0, 1, 2, 1, 32, "MS LineDraw"}; 
    const  int     FontHeight  = 10;
    const  int     BuffSize    = 16;

    static char smallBuffer[BuffSize];
    HFONT  printFont, oldFont;
    RECT   paintArea;
    HBRUSH paintBrush;
    HDC    hDC;
    int    barSpacing;
    int    realMem, pageFile, memLoad;  
    static DWORD  cpuLoad    = 0;
    static int    oldReal    = 0, oldPage = 0, oldMemLoad = 0;        
    static DWORD  oldcpuLoad = 0;
    int    curWidth;

    // get the info.
    GetMemDetails (HCPULoadKey, realMem, pageFile, memLoad, cpuLoad, notUpdateCPU);

    // Define the paint area                
    GetClientRect(hwnd, &paintArea);
    curWidth             = paintArea.right;
    barSpacing           = (paintArea.bottom / 4);
    DescribFont.lfHeight = -barSpacing;

    // -------------------------------M E M  U S A G E--------------------------------------------
    // draw the real memory bar                             
    if ((realMem != oldReal) || (upDateAll != FALSE))
    {                                                   
        // nuke old bar
        hDC = GetDC (hwnd);
        paintArea.right  = curWidth;
        paintArea.bottom = barSpacing;                           
        paintBrush       = CreateSolidBrush (RGB (0, 0, 0));         
        FillRect (hDC, &paintArea, paintBrush);
        ReleaseDC (hwnd, hDC);                
        DeleteObject (paintBrush);


        // create new bar
        hDC = GetDC (hwnd);
        paintArea.right  = (int) (((float)curWidth / 100.0) * (float)realMem);                
        paintBrush       = CreateSolidBrush (RGB (155 + realMem, 0, 0));        
        FillRect (hDC, &paintArea, paintBrush);
        ReleaseDC (hwnd, hDC);                
        DeleteObject (paintBrush);
        oldReal = realMem;

        // Display new font if we have space
        if (barSpacing >= 8)
        {
            hDC = GetDC (hwnd);
            // create new font    
            printFont = CreateFontIndirect(&DescribFont);
            oldFont   = SelectObject (hDC, printFont);

            // output the content to the device context
            wsprintf ((LPTSTR)smallBuffer, (LPCTSTR)"%d%%", realMem);
            SetTextColor (hDC, RGB (255, 255, 255));
            SetBkMode(hDC, TRANSPARENT);
            paintArea.right = curWidth;
            DrawText(hDC, smallBuffer, strlen (smallBuffer), &paintArea, DT_CENTER);

            SelectObject (hDC, oldFont);
            ReleaseDC (hwnd, hDC);                
            DeleteObject (printFont);
        }
    }

    // ------------------------------- P A G E  F I L E -----------------------------------------
    // draw the page file bar
    if ((pageFile != oldPage) || (upDateAll != FALSE))
    {   
        // nuke old bar
        hDC = GetDC (hwnd);
        paintArea.right  = curWidth;
        paintArea.top    = barSpacing;
        paintArea.bottom = barSpacing * 2;                           
        paintBrush       = CreateSolidBrush (RGB (0, 0, 0));         
        FillRect (hDC, &paintArea, paintBrush);
        ReleaseDC (hwnd, hDC);                
        DeleteObject (paintBrush);

        // create new bar
        hDC = GetDC (hwnd);
        paintArea.right  = (int) (((float)curWidth / 100.0) * (float)pageFile);        
        paintBrush       = CreateSolidBrush (RGB (0, 155 + pageFile, 0));       
        FillRect (hDC, &paintArea, paintBrush);
        ReleaseDC (hwnd, hDC);                
        DeleteObject (paintBrush);
        oldPage = pageFile;

        // Display new font if we have space
        if (barSpacing >= 8)
        {
            hDC = GetDC (hwnd);
            // create new font    
            printFont = CreateFontIndirect(&DescribFont);
            oldFont   = SelectObject (hDC, printFont);

            // output the content to the device context
            wsprintf ((LPTSTR)smallBuffer, (LPCTSTR)"%d%%", pageFile);

            SetTextColor (hDC, RGB (255, 255, 255));
            SetBkMode(hDC, TRANSPARENT);
            paintArea.right = curWidth;
            DrawText(hDC, smallBuffer, strlen (smallBuffer), &paintArea, DT_CENTER);
    
            SelectObject (hDC, oldFont);
            ReleaseDC (hwnd, hDC);                
            DeleteObject (printFont);
        }
    }

    // -------------------------------M E M  L O A D--------------------------------------------
    // draw the mem load bar
    if ((memLoad != oldMemLoad) || (upDateAll != FALSE))
    {   
        // nuke old bar
        hDC = GetDC (hwnd);
        paintArea.right  = curWidth;
        paintArea.top    = barSpacing * 2;
        paintArea.bottom = (barSpacing * 3);  // make sure there is no remainder!
        paintBrush       = CreateSolidBrush (RGB (0, 0, 0));         
        FillRect (hDC, &paintArea, paintBrush);
        ReleaseDC (hwnd, hDC);                
        DeleteObject (paintBrush);

        // create new bar
        hDC = GetDC (hwnd);
        paintArea.right  = (int) (((float)curWidth / 100.0) * (float)memLoad);        
        paintBrush       = CreateSolidBrush (RGB (0, 0, 155 + memLoad));       
        FillRect (hDC, &paintArea, paintBrush);
        ReleaseDC (hwnd, hDC);                
        DeleteObject (paintBrush);
        oldMemLoad = memLoad;

        // Display new font if we have space
        if (barSpacing >= 8)
        {
            hDC = GetDC (hwnd);
            // create new font    
            printFont = CreateFontIndirect(&DescribFont);
            oldFont   = SelectObject (hDC, printFont);

            // output the content to the device context
            wsprintf ((LPTSTR)smallBuffer, (LPCTSTR)"%d%%", memLoad);
            SetTextColor (hDC, RGB (255, 255, 255));
            SetBkMode(hDC, TRANSPARENT);
            paintArea.right = curWidth;
            DrawText(hDC, smallBuffer, strlen (smallBuffer), &paintArea, DT_CENTER);

            SelectObject (hDC, oldFont);
            ReleaseDC (hwnd, hDC);                
            DeleteObject (printFont);
        }      
    }

    // -----------------------------------C P U  B A R --------------------------------------------
    // draw the CPU load bar 
    if ((cpuLoad != oldcpuLoad) || (upDateAll != FALSE))
    {   
        // nuke old bar
        hDC = GetDC (hwnd);
        paintArea.right  = curWidth;
        paintArea.top    = barSpacing * 3;
        paintArea.bottom = (barSpacing * 4) + 3;  // make sure there is no remainder!
        paintBrush       = CreateSolidBrush (RGB (0, 0, 0));         
        FillRect (hDC, &paintArea, paintBrush);
        ReleaseDC (hwnd, hDC);                
        DeleteObject (paintBrush);

        // create new bar
        hDC = GetDC (hwnd);
        paintArea.right  = (int) (((float)curWidth / 100.0) * (float)cpuLoad);        
        paintBrush       = CreateSolidBrush (RGB (155+cpuLoad, 0, 155 + cpuLoad));       
        FillRect (hDC, &paintArea, paintBrush);
        ReleaseDC (hwnd, hDC);                
        DeleteObject (paintBrush);
        oldcpuLoad = cpuLoad;

        // Display new font if we have space
        if (barSpacing >= 8)
        {
            hDC = GetDC (hwnd);
            // create new font    
            printFont = CreateFontIndirect(&DescribFont);
            oldFont   = SelectObject (hDC, printFont);

            // output the content to the device context
            wsprintf ((LPTSTR)smallBuffer, (LPCTSTR)"%d%%", cpuLoad);
            SetTextColor (hDC, RGB (255, 255, 255));
            SetBkMode(hDC, TRANSPARENT);
            paintArea.right = curWidth;
            DrawText(hDC, smallBuffer, strlen (smallBuffer), &paintArea, DT_CENTER);

            SelectObject (hDC, oldFont);
            ReleaseDC (hwnd, hDC);                
            DeleteObject (printFont);
        }      
    }
}

// ***********************************************************************************

BOOL CALLBACK AboutDialog (HWND hwndDlg,  UINT uMsg, WPARAM wParam,	 LPARAM lParam)
{   
    switch (uMsg)
    {
        case WM_INITDIALOG:
            {
                const int  buffSize = 1024;
                char       output[buffSize];                
                RECT area;
                GetWindowRect (hwndDlg, &area);
                MEMORYSTATUS  ms;

                // move window to middle of screen
                SetWindowPos(hwndDlg, HWND_TOPMOST,  
                             (GetSystemMetrics(SM_CXSCREEN) / 2) - ((area.right - area.left)/2),
                             (GetSystemMetrics(SM_CYSCREEN) / 2) - ((area.bottom - area.top)/2),
                             0, 0, SWP_NOSIZE | SWP_SHOWWINDOW);

                GlobalMemoryStatus(&ms);

                sprintf (output, 
                         "Brief Information\r\n"
                         "--------------\r\n"
                         "Current memory usage    (red)   : %u%%\r\n"
                         "Current page-file usage (green) : %u%%\r\n"
                         "Current memory load     (blue)  : %u%%\r\n"
                         "Current CPU load        (purple): ?%%\r\n\r\n"
                         "Detail Infomation\r\n"
                         "-----------------\r\n"
                         "Bytes of physical memory    : %u\r\n"
                         "Free physical memory bytes  : %u\r\n"
                         "Bytes of paging file        : %u\r\n"
                         "Free bytes of paging file   : %u\r\n"
                         "User bytes of address space : %u\r\n" 
                         "Free user bytes             : %u\r\n",

                         (DWORD)100 - (int) (((float)ms.dwAvailPhys / (float)ms.dwTotalPhys) * 100.0),
                         (DWORD)100 - (int) (((float)ms.dwAvailPageFile / (float)ms.dwTotalPageFile) * 100.0), 
                         ms.dwMemoryLoad,

                         ms.dwTotalPhys, ms.dwAvailPhys, ms.dwTotalPageFile,
                         ms.dwAvailPageFile, ms.dwTotalVirtual, ms.dwAvailVirtual);

                SetWindowText (GetDlgItem (hwndDlg, IDC_MEMSTATOUTPUT), (LPCTSTR) output);
            }
            return TRUE;

        case WM_COMMAND:
            switch (LOWORD (wParam))
            {
                case IDOK:
                    EndDialog (hwndDlg, TRUE);
                    break;
            }
            break;

        case WM_CLOSE:
            EndDialog(hwndDlg, FALSE);
            break;
    }

    return FALSE;
}

// -------------------------------------------------------------------------

DWORD WINAPI GetInfoThread (LPVOID pData) 
{
    HWND hwnd        = (HWND) ((DWORD) pData);  
    HKEY hCPULoadKey;     

    // used to obtain the cpu load of the system.
    hCPULoadKey = OpenCPUStatus95 ();
    if (hCPULoadKey != NULL)
        StartCPULoadProfiling95 ();
    else // NT system
    {
        if (InitCPUCounter () == FALSE)
        {
            MessageBox (hwnd, "Unable to obtain NT CPU counter info", 
                        "CPU Counter Error", MB_ICONINFORMATION | MB_OK);
        }
    }

    for (;;)
    {
        DrawBars (hwnd, hCPULoadKey, FALSE, FALSE);
        Sleep (1000);
    }

    return 0;
}

// -------------------------------------------------------------------------

int WINAPI MemStat (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    // Windows variables & objects
    static HMENU   hPopupMenu    = NULL;
    static HKEY    hCPULoadKey   = NULL;
    static POINTS  lastLButtonDn; // used to move the window
    static DWORD   threadID;
    static HANDLE  hThread = NULL;
    
    switch (message)
    {
        case WM_CREATE:
            // Add menu item to popupmenu.
            hPopupMenu = CreatePopupMenu();

            // Add menu items to popup menu.                                    
            InsertMenu(hPopupMenu, 0, MF_STRING, IDPOPMENU_CLWND,   (LPCSTR) pPopMenuClientWnd);
            InsertMenu(hPopupMenu, 0, MF_STRING, IDPOPMENU_TOPMOST, (LPCSTR) pPopMenuTopmost);
            InsertMenu(hPopupMenu, 0, MF_STRING, IDPOPMENU_ABOUT,   (LPCSTR) pPopMenuAbout);
            InsertMenu(hPopupMenu, 0, MF_STRING | MF_SEPARATOR, 1,  (LPCSTR) NULL);                
            InsertMenu(hPopupMenu, 0, MF_STRING, IDPOPMENU_QUIT,    (LPCSTR) pPopMenuQuit);

            if (WindowInfo.onTop != 0)
                CheckMenuItem(hPopupMenu, IDPOPMENU_TOPMOST, MF_BYCOMMAND | MF_CHECKED);

            if (WindowInfo.clientWnd != 0)
                CheckMenuItem(hPopupMenu, IDPOPMENU_CLWND, MF_BYCOMMAND | MF_CHECKED);

            hThread = CreateThread (NULL, 0, GetInfoThread, (LPDWORD) (DWORD)hwnd, 0, &threadID);
            break;

        // ---- Process user commands ----
        case WM_COMMAND:
            switch (LOWORD(wParam))
            {
                case IDPOPMENU_CLWND:                    
                    // set and check selected menu items
                    if (WindowInfo.clientWnd != 0)
                    {
                        WindowInfo.clientWnd = 0;
                        CheckMenuItem(hPopupMenu, IDPOPMENU_CLWND, MF_BYCOMMAND | MF_UNCHECKED);
                    }
                    else
                    {
                        WindowInfo.clientWnd = -1;
                        CheckMenuItem(hPopupMenu, IDPOPMENU_CLWND, MF_BYCOMMAND | MF_CHECKED);
                    }

                    DestroyWindow (hwnd);
                    MakeNewWindow ();
                    break;

                case IDPOPMENU_TOPMOST:                    
                    // set and check selected menu items
                    if (WindowInfo.onTop != 0)
                    {
                        WindowInfo.onTop = 0;
                        CheckMenuItem(hPopupMenu, IDPOPMENU_TOPMOST, MF_BYCOMMAND | MF_UNCHECKED);
                    }
                    else
                    {
                        WindowInfo.onTop = -1;
                        CheckMenuItem(hPopupMenu, IDPOPMENU_TOPMOST, MF_BYCOMMAND | MF_CHECKED);
                    }

                    DestroyWindow (hwnd);
                    MakeNewWindow ();
                    break;

                case IDPOPMENU_ABOUT:   // display hi there window
                    DialogBox (HInst, MAKEINTRESOURCE(IDD_ABOUT), hwnd, (DLGPROC)AboutDialog);
                    break;              

                case IDPOPMENU_QUIT:    // quit the window and clean up!
                    DestroyWindow (hwnd);

                    // -- notify message loop to quit --
                    PostQuitMessage(0);
                    break;

                default:
                    break;
            }
            break;

        case WM_PAINT:
            DrawBars (hwnd, hCPULoadKey, TRUE, TRUE);
            break;

        // ----- Move the Window -----
        case WM_MOUSEMOVE:
            if (wParam == MK_LBUTTON)
            {
                RECT newRect;
                int  xMove = (lastLButtonDn.x - (short)LOWORD(lParam));
                int  yMove = (lastLButtonDn.y - (short)HIWORD(lParam));

                // move the window
                GetWindowRect(hwnd, &newRect);

                MoveWindow(hwnd, 
                           newRect.left-xMove, newRect.top-yMove,
                           (newRect.right - newRect.left),
                           (newRect.bottom - newRect.top), TRUE);
            }
            else
                ReleaseCapture();
            break;

        case WM_LBUTTONDOWN:
            lastLButtonDn.x = LOWORD(lParam);
            lastLButtonDn.y = HIWORD(lParam);
            
            SetCapture(hwnd);
            break;

        case WM_LBUTTONUP:            
            lastLButtonDn.x = LOWORD(lParam);
            lastLButtonDn.y = HIWORD(lParam);

            ReleaseCapture ();
            break;

        // ---- Create popup menu ----
        case WM_RBUTTONDOWN:            
            {
                POINT pos;
               
                GetCursorPos(&pos); 
                TrackPopupMenu(hPopupMenu, // TPM_TOPALIGN | 
                                           TPM_LEFTALIGN , pos.x, pos.y, 0, hwnd, NULL);                             
            }
            break;

        // ---- Clean up ----
        case WM_DESTROY:                       
            SaveWindowInfo (hwnd);

            // de-allocate system objects
            DestroyMenu(hPopupMenu);
            TerminateThread(hThread, 0);

            if (hCPULoadKey == NULL)
                CloseCPUCounter ();
            break;
    }

    return DefWindowProc (hwnd, message, wParam, lParam);
}
