// HILibTestDlg.cpp : implementation file
//

#include "stdafx.h"
#include "HILibTest.h"
#include "HILibTestDlg.h"
#include "infodlg.h"
#include "..\cpu.h"
#include "..\display.h"
#include "..\hardware.h"
#include "..\storages.h"
#include "..\cdrom.h"
#include "..\aspi.h"
#include "..\network.h"
#include "..\mci.h"
#include "..\pci.h"
#include "..\printers.h"
#include "..\system.h"
#include "..\scsi.h"
#include "..\Win32Process.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	    void InitializeNT();
        CAboutDlg();

        // Dialog Data
        //{{AFX_DATA(CAboutDlg)
        enum { IDD = IDD_ABOUTBOX };
        //}}AFX_DATA

        // ClassWizard generated virtual function overrides
        //{{AFX_VIRTUAL(CAboutDlg)
protected:
        virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
        //}}AFX_VIRTUAL

        // Implementation
protected:
        //{{AFX_MSG(CAboutDlg)
        //}}AFX_MSG
        DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
        //{{AFX_DATA_INIT(CAboutDlg)
        //}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
        CDialog::DoDataExchange(pDX);
        //{{AFX_DATA_MAP(CAboutDlg)
        //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
//{{AFX_MSG_MAP(CAboutDlg)
// No message handlers
//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHILibTestDlg dialog

CHILibTestDlg::CHILibTestDlg(CWnd* pParent /*=NULL*/)
: CDialog(CHILibTestDlg::IDD, pParent)
{
        //{{AFX_DATA_INIT(CHILibTestDlg)
        // NOTE: the ClassWizard will add member initialization here
        //}}AFX_DATA_INIT
        // Note that LoadIcon does not require a subsequent DestroyIcon in Win32
        m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CHILibTestDlg::DoDataExchange(CDataExchange* pDX)
{
        CDialog::DoDataExchange(pDX);
        //{{AFX_DATA_MAP(CHILibTestDlg)
        // NOTE: the ClassWizard will add DDX and DDV calls here
        //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CHILibTestDlg, CDialog)
//{{AFX_MSG_MAP(CHILibTestDlg)
ON_WM_SYSCOMMAND()
ON_WM_PAINT()
ON_WM_QUERYDRAGICON()
ON_BN_CLICKED(IDC_CPU, OnCpu)
ON_BN_CLICKED(IDC_CDISPLAY, OnCdisplay)
ON_BN_CLICKED(IDC_STORAGE, OnStorage)
ON_BN_CLICKED(IDC_CDROMB, OnCdrom)
        ON_BN_CLICKED(IDC_NETWORKB, OnNetworkb)
        ON_BN_CLICKED(IDC_MCIBUTTON, OnMci)
        ON_BN_CLICKED(IDC_PCI, OnPci)
        ON_BN_CLICKED(IDC_PRINTERS, OnPrinters)
        ON_BN_CLICKED(IDC_SYSTEMB, OnSystem)
        ON_BN_CLICKED(IDC_SCSIB, OnScsi)
        ON_BN_CLICKED(IDC_WIN32P, OnWin32p)
        //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHILibTestDlg message handlers

BOOL CHILibTestDlg::OnInitDialog()
{
        CDialog::OnInitDialog();

        // Add "About..." menu item to system menu.

        // IDM_ABOUTBOX must be in the system command range.
        ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
        ASSERT(IDM_ABOUTBOX < 0xF000);

        CMenu* pSysMenu = GetSystemMenu(FALSE);
        if (pSysMenu != NULL)
        {
                CString strAboutMenu;
                strAboutMenu.LoadString(IDS_ABOUTBOX);
                if (!strAboutMenu.IsEmpty())
                {
                        pSysMenu->AppendMenu(MF_SEPARATOR);
                        pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
                }
        }

        // Set the icon for this dialog.  The framework does this automatically
        //  when the application's main window is not a dialog
        SetIcon(m_hIcon, TRUE);                 // Set big icon
        SetIcon(m_hIcon, FALSE);                // Set small icon

        HHardware hard;
        if (hard.m_bWinNT==TRUE) SetDlgItemText(IDC_PLATFORM,"Windows NT");
        else SetDlgItemText(IDC_PLATFORM,"Windows 95/98");
        // TODO: Add extra initialization here
        return TRUE;  // return TRUE  unless you set the focus to a control
}

void CHILibTestDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
        if ((nID & 0xFFF0) == IDM_ABOUTBOX)
        {
                CAboutDlg dlgAbout;
                dlgAbout.DoModal();
        }
        else
        {
                CDialog::OnSysCommand(nID, lParam);
        }
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CHILibTestDlg::OnPaint()
{
        if (IsIconic())
        {
                CPaintDC dc(this); // device context for painting

                SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

                // Center icon in client rectangle
                int cxIcon = GetSystemMetrics(SM_CXICON);
                int cyIcon = GetSystemMetrics(SM_CYICON);
                CRect rect;
                GetClientRect(&rect);
                int x = (rect.Width() - cxIcon + 1) / 2;
                int y = (rect.Height() - cyIcon + 1) / 2;

                // Draw the icon
                dc.DrawIcon(x, y, m_hIcon);
        }
        else
        {
                CDialog::OnPaint();
        }
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CHILibTestDlg::OnQueryDragIcon()
{
        return (HCURSOR) m_hIcon;
}



void CHILibTestDlg::OnCpu()
{
        CInfoDlg idlg;
        static HCPU cpu;

        CString str,tmpstr;

        str="CPU Information using HCPU class...";

        str+="\r\n\r\nCPU Type: ";
        str+=cpu.GetCPUType();

        str+="\r\nCPU Frequency: ";
        str+=cpu.GetCPUFrequency();

        str+="\r\nCPU Vendor: ";
        str+=cpu.GetCPUVendor();

        str+="\r\nCPU Family: ";
        str+=cpu.GetCPUFamily();

        str+="\r\nCPU Model: ";
        str+=cpu.GetCPUModel();

        str+="\r\nCPU Stepping: ";
        str+=cpu.GetCPUStepping();

        if (cpu.m_bMMX==TRUE) str+="\r\nMMX present.";
        else str+="\r\nMMX is not present.";

        str+="\r\nComment: ";
        str+=cpu.GetCPUComment();

        str+="\r\nTotal CPUs: ";
        tmpstr.Format("%d",cpu.GetTotalProcessors());
        str+=tmpstr;

        str+="\r\nActive CPUs: ";
        tmpstr.Format("%d",cpu.GetActiveProcessors());
        str+=tmpstr;

        //AfxMessageBox(str);
        idlg.m_InfoEdit=str;
        idlg.DoModal();
}

void CHILibTestDlg::OnCdisplay()
{
        CInfoDlg idlg;
        HDisplay display;
        int i;
        DWORD dwv, dwp;

        CString str,tmpstr;
        CStringArray stra;

        str="Display Information using HDisplay class...";

        str+="\r\n\r\nVideo Card Name/Model: ";
        str+=display.GetVideoCardName();

        str+="\r\nTotal Video Memory: ";
        tmpstr.Format("%d MB",display.GetVideoMem());
        str+=tmpstr;

        str+="\r\n\r\nDevice Driver Version: ";
        str+=display.GetDeviceVersion();

        str+="\r\nDirectX: ";
        display.GetDXVersion(&dwv, &dwp);
        switch (dwv) {
        case 0:str+="DirectX is not Installed.";break;
        case 0x100:str+="DirectX 1 installed.";break;
        case 0x200:str+="DirectX 2 installed.";break;
        case 0x300:str+="DirectX 3 installed.";break;
        case 0x500:str+="DirectX 5 installed.";break;
        case 0x501:str+="DirectX 5a installed.";break;
		case 0x600:str+="DirectX 6 installed.";break;
		case 0x601:str+="DirectX 6.1 installed.";break;
		case 0x700:str+="DirectX 7 installed.";break;
        default:str+="Unknown Version.";break;
        }

        str+="\r\nChip Type/Model: ";
        str+=display.GetDisplayChip();

        str+="\r\nDAC Type: ";
        str+=display.GetDisplayDAC();

        str+="\r\nChip Revision: ";
        str+=display.GetChipRevision();

        str+="\r\n\r\nCurrent Resolution Information: ";
        str+="\r\nResolution: ";
        tmpstr.Format("%dx%d",display.GetCurrentHRes(),display.GetCurrentVRes());
        str+=tmpstr;

        str+="\r\nBits Per Pixel: ";
        tmpstr.Format("%d bits",display.GetCurrentBPP());
        str+=tmpstr;

        str+="\r\nNumber of Colors: ";
        tmpstr.Format("%d Colors",display.GetCurrentNrOfColors());
        str+=tmpstr;

        str+="\r\nPixel Format: ";
        switch (display.GetCurrentPixelFormat()) {
        case 555: str+="5-5-5";break;
        case 565: str+="5-6-5";break;
        case 111: str+="B-G-R";break;
        case 222: str+="R-G-B";break;
        default: str+="Unknown"; break;
        }

        str+="\r\n\r\nSupported Video Modes: ";

        stra.Copy(display.GetSupportedVideoModes());
        for (i=0; i<stra.GetSize(); i++) {
                str+="\r\n";
                str+=stra[i];
        }

        str+="\r\n\r\nMonitor Name/Model: ";
        str+=display.GetMonitorName();

        str+="\r\nMonitor Maximum Reolution: ";
        str+=display.GetMonitorMaxRes();

        idlg.m_InfoEdit=str;
        idlg.DoModal();
}

void CHILibTestDlg::OnStorage()
{
        CInfoDlg        idlg;
        HStorages       stor;
        CString         str,tmpstr;
        char            tmps[50];
        int i;

        str="Memory:\r\n";
        str+="Total Physical Memory: ";
        str+=_itoa(stor.GetTotalPhysicalMemory(),tmps,10);
        str+=" MB\r\nFree Physical Memory: ";
        str+=stor.GetFreePhysicalMemory();
        str+="\r\nMemory Load Percent: ";
        str+=stor.GetMemoryLoadPercent();
        str+="\r\n\r\n";
        for (i=0; i<stor.m_saDrivesList.GetSize(); i++)
        {
                str+="Drive: ";
                str+=stor.m_saDrivesList[i];
                str+="\r\nFile System: ";
                str+=stor.m_saFileSystemList[i];
                str+="-------------------\r\n\r\n";
        }

        idlg.m_InfoEdit=str;
        idlg.DoModal();
}

void CHILibTestDlg::OnCdrom()
{
        HCDROM cd;
        CInfoDlg idlg;
        CString tmpstr,str,sVendor,sProduct,sRevision,sInterface;
        int ret,i,n;
        struct cappage caps;
        WORD    w;

        ::ZeroMemory(&caps,sizeof(caps));
        ret=cd.Initialize();
        if (ret<=0) {
                AfxMessageBox("No CD-ROM Devices Installed!",MB_ICONEXCLAMATION);
                return;
        }

        str="CD-ROM Drive(s) Information...\r\n\r\n";
        for (i=0; i<ret; i++) {
                cd.GetCDInfo(i,sVendor.GetBuffer(512),
                        sProduct.GetBuffer(512),sRevision.GetBuffer(512),
                        sInterface.GetBuffer(512));
                sVendor.ReleaseBuffer();
                sProduct.ReleaseBuffer();
                sRevision.ReleaseBuffer();
                sInterface.ReleaseBuffer();
                tmpstr.Format("CD-ROM Drive Number: %d",i+1);
                str+=tmpstr;
                str+="\r\nVendor Name: ";
                str+=sVendor;
                str+="\r\nProduct: ";
                str+=sProduct;
                str+="\r\nRevision: ";
                str+=sRevision;
                str+="\r\nInterface Type: ";
                str+=sInterface;
                ///
				n=i; // Copy device ID in 'n', because it will be destroyed.

                cd.GetCDCaps(n,&caps);
                str+="\r\n\r\n -= CD-ROM Capabilities =-\r\n\r\n";
                str+="CD-ROM Status: ";
                switch (caps.medium_type) {
                case MDT_UNKNOWN: str+="Unknown.";break;
                case MDT_DATA_120:str+="120mm Data Disc Loaded."; break;
                case MDT_AUDIO_120:str+="120mm Audio Disc Loaded."; break;
                case MDT_COMB_120:str+="120mm Data+Audio Disc Loaded.";break;
                case MDT_PHOTO_120:str+="120mm PhotoCD Loaded."; break;
                case MDT_DATA_80:str+="80mm Data Disc Loaded.";break;
                case MDT_AUDIO_80:str+="80mm Audio Disc Loaded.";break;
                case MDT_COMB_80:str+="80mm Data+Audio Disc Loaded.";break;
                case MDT_PHOTO_80:str+="80mm PhotoCD Disc Loaded.";break;
                case MDT_NO_DISC:str+="No Disc Loaded.";break;
                case MDT_DOOR_OPEN:str+="CD-ROM Door is Open";break;
                case MDT_FMT_ERROR:str+"Unknown Media Loaded in CD";break;
                default:str+="Unknown.";break;
                }
                str+="\r\nDrive Supports Audio Play: ";
                //////////////////
                if (caps.audio_play==1) str+="Yes";
                else str+="No";

                str+="\r\nDrive Supports Audio/Video Composite: ";
                if (caps.composite==1) str+="Yes";
                else str+="No";

                str+="\r\nDrive Supports Digital Audio on Port 1: ";
                if (caps.dport1==1) str+="Yes";
                else str+="No";

                str+="\r\nDrive Supports Digital Audio on Port 2: ";
                if (caps.dport2==1) str+="Yes";
                else str+="No";

                str+="\r\nDrive Supports Mode 2 Form 1 (XA) Read: ";
                if (caps.mode2_form1==1) str+="Yes";
                else str+="No";

                str+="\r\nDrive Supports Mode 2 Form 2 Read: ";
                if (caps.mode2_form2==1) str+="Yes";
                else str+="No";

                str+="\r\nDrive Supports Multi-Session PhotoCD: ";
                if (caps.multisession==1) str+="Yes";
                else str+="No";

                str+="\r\nDrive Supports AudioCD Read: ";
                if (caps.cd_da==1) str+="Yes";
                else str+="No";

                str+="\r\nDrive Supports CD-Digital Audio Streaming: ";
                if (caps.cd_da_stream==1) str+="Yes";
                else str+="No";

                str+="\r\nDrive Supports Combined R-W Subchannels: ";
                if (caps.rw==1) str+="Yes";
                else str+="No";

                str+="\r\nDrive Supports R-W Subchannel Data Corrected: ";
                if (caps.rw_corr==1) str+="Yes";
                else str+="No";

                str+="\r\nDrive Supports C2 Error Pointers Supported: ";
                if (caps.c2==1) str+="Yes";
                else str+="No";

                str+="\r\nDrive can Return the ISRC Info: ";
                if (caps.isrc==1) str+="Yes";
                else str+="No";

                str+="\r\nDrive can Return the Catalog Number UPC: ";
                if (caps.upc==1) str+="Yes";
                else str+="No";

                str+="\r\nDrive could be Locked: ";
                if (caps.lock==1) str+="Yes";
                else str+="No";

                str+="\r\nDrive Lock Status: ";
                if (caps.locked==1) str+="Yes";
                else str+="No";

                str+="\r\nPrevent Jumper Installed: ";
                if (caps.prevent==1) str+="Yes";
                else str+="No";

                str+="\r\nDrive can Eject: ";
                if (caps.eject==1) str+="Yes";
                else str+="No";

                str+="\r\nLoading Mechanism Type: ";
                switch (caps.mech) {
                case MECH_CADDY:str+="Caddy";break;
                case MECH_TRAY:str+="Tray";break;
                case MECH_POPUP:str+="Popup";break;
                case MECH_CHANGER:str+="Changer";break;
                case MECH_CARTRIDGE:str+="Cartridge";break;
                default:str+="Unknown";break;
                }
                str+="\r\nSupports Independed Volume of Channels: ";
                if (caps.sep_vol==1) str+="Yes";
                else str+="No";

                str+="\r\nSupports Independent Mute of Channels: ";
                if (caps.sep_mute==1) str+="Yes";
                else str+="No";

                w=MAKEWORD(HIBYTE(caps.max_speed),LOBYTE(caps.max_speed));
                str+="\r\nMaximum Raw Data Rate: ";
                tmpstr.Format("%dKB/sec.",w);
                str+=tmpstr;

                w=MAKEWORD(HIBYTE(caps.max_vol_levels),LOBYTE(caps.max_vol_levels));
                str+="\r\nNumber of Discrete Volume Levels: ";
                tmpstr.Format("%d Levels",w);
                str+=tmpstr;

                w=MAKEWORD(HIBYTE(caps.buf_size),LOBYTE(caps.buf_size));
                str+="\r\nInternal Buffer Size (Cache): ";
                tmpstr.Format("%dKB",w);
                str+=tmpstr;

                w=MAKEWORD(HIBYTE(caps.cur_speed),LOBYTE(caps.cur_speed));
                str+="\r\nCurrent Data Rate: ";
                tmpstr.Format("%dKB/sec.",w);
                str+=tmpstr;

                str+="\r\n\r\nDigital Drive Output Format Description...";
                str+="\r\nData Valid on Failing Edge of BCK: ";
                if (caps.bckf==1) str+="Yes";
                else str+="No";

                str+="\r\nHigh LRCK Indicates Left Channel: ";
                if (caps.rch==1) str+="Yes";
                else str+="No";

                str+="\r\nLSB First: ";
                if (caps.lsbf==1) str+="Yes";
                else str+="No";

                str+="\r\nDLEN: ";
                switch(caps.dlen) {
                case DLEN_32:str+="32 BCKs";break;
                case DLEN_16:str+="16 BCKs";break;
                case DLEN_24:str+="24 BCKs";break;
                case DLEN_24_I2S:str+="24 BCKs I2S";break;
                default:str+="Unknown";break;
                }

                str+="\r\n----------------\r\n";
        }

        idlg.m_InfoEdit=str;
        idlg.DoModal();
}


void CHILibTestDlg::OnNetworkb()
{
        CInfoDlg idlg;
        CString str,tmpstr;
        HNetwork net;

        str="Network Information...\r\n\r\n";
        str+="Host Name: ";
        str+=net.GetHostName();

        str+="\r\nDomain: ";
        str+=net.GetDomain();
        str+="\r\nName Server: ";
        str+=net.GetNameServer();
//////////////
        str+="\r\n\r\n -= Windows Sockets Information -=\r\n\r\n";
        str+="Sockets Desc.: ";
        str+=net.GetSockDesc();

        str+="\r\nSockets Status: ";
        str+=net.GetSockStatus();

        tmpstr.Format("%d bytes",net.GetMaxUDPDatagramSize());
        str+="\r\nMax. UDP Datagram Size: ";
        str+=tmpstr;

        tmpstr.Format("%d sockets.",net.GetMaxSockets());
        str+="\r\nMax. Sockets: ";
        str+=tmpstr;
        ///////////////
        str+="\r\n\r\n -= Network Adapters Information =-\r\n";
        int i;
        for (i=0; i<net.GetTotalAdapters(); i++) {
                tmpstr.Format("\r\nAdapter Nr. %d", i);
                str+=tmpstr;
                str+="\r\nDevice Desc.: ";
                str+=net.GetDeviceDesc(i);
                str+="\r\nVendor: ";
                str+=net.GetVendor(i);
                str+="\r\nSlot Number: ";
                str+=net.GetSlotNumber(i);
                str+="\r\nAdapter/MAC Address: ";
                str+=net.GetMacAddress(i);
                str+="\r\nIP Address: ";
                str+=net.GetIPAddress(i);
                str+="\r\nSubnet Mask: ";
                str+=net.GetSubnetMask(i);
                str+="\r\nGateway: ";
                str+=net.GetGateway(i);
                str+="\r\n-------------------\r\n";
        }

        idlg.m_InfoEdit=str;
        idlg.DoModal();
}

void CHILibTestDlg::OnMci()
{
        CInfoDlg idlg;
        HMCI     mci;
        CString  str,tmpstr;
        int             i;

        str="MCI (Multimedia) Information...\r\n\r\n";
        for (i=0; i<mci.GetTotalDevices(); i++) {
                tmpstr.Format("Device Nr. %d\r\n",i);
                str+=tmpstr;
                str+="Device ID: ";
                str+=mci.GetDeviceID(i);
                str+="\r\nDevice Type: ";
                str+=mci.GetDeviceType(i);
                str+="\r\nDevice Desc.: ";
                str+=mci.GetDeviceDesc(i);
                str+="\r\n------------------\r\n";
        }
        idlg.m_InfoEdit=str;
        idlg.DoModal();
}


void CHILibTestDlg::OnPci()
{
        CInfoDlg idlg;
        CString str,tmpstr;
        HPCI    pci;
        int i;

        str="PCI Devices Information...\r\n\r\n";
        for (i=0; i<pci.GetTotalDevices(); i++) {
                str+="Device ID: ";
                str+=pci.GetDeviceID(i);
                str+="\r\nDevice Desc.: ";
                str+=pci.GetDeviceDesc(i);
                str+="\r\nClass: ";
                str+=pci.GetClass(i);
                str+="\r\nSubclass: ";
                str+=pci.GetSubclass(i);
                str+="\r\nVendor: ";
                str+=pci.GetVendor(i);
                str+="\r\nModel: ";
                tmpstr.Format("%d",pci.GetModel(i));
                str+=tmpstr;
                str+="\r\nRevision: ";
                str+=pci.GetRevision(i);
                str+="\r\n-------------------\r\n";
        }

        idlg.m_InfoEdit=str;
        idlg.DoModal();
}




void CHILibTestDlg::OnPrinters()
{
        CInfoDlg idlg;
        CString str,tmpstr;
        HPrinters       printers;
        int             i;

        str+="Printers Information...\r\n\r\n";
        for (i=0; i<printers.GetTotalPrinters(); i++) {
                str+="Printer Name: ";
                str+=printers.GetPrinterName(i);
                str+="\r\nDriver Name: ";
                str+=printers.GetDriverName(i);
                str+="\r\nDriver Version: ";
                str+=printers.GetDriverVersion(i);
                str+="\r\nTechnology: ";
                str+=printers.GetTechnology(i);
                str+="\r\nIs Default Printer: ";
                if (printers.IsDefaultPrinter(i)) str+="Yes.";
                else str+="No.";
                str+="\r\n-----------------------\r\n\r\n";
        }

        idlg.m_InfoEdit=str;
        idlg.DoModal();
}

/////////////////////////////////////////
// Display System Information
/////////////////////////////////////////
void CHILibTestDlg::OnSystem()
{
        CInfoDlg idlg;
        CString str,tmpstr;
        HSystem sys;
		DWORD	wServicePack;

        str="System Information...";
        str+="\r\n\r\nTotal  Nr. of CPUs: ";
        tmpstr.Format("%d",sys.GetNrOfCPUs());
        str+=tmpstr;
        str+="\r\nActive CPUs: ";
        tmpstr.Format("%d",sys.GetActiveCPUs());
        str+=tmpstr;

        str+="\r\n\r\nOS Version: ";
        str+=sys.GetWinVer();
        
		str+="\r\nVersion No.: ";
        str+=sys.GetWinVerNo();
        
		str+="\r\nUser Name: ";
        str+=sys.GetUserName();

		str+="\r\nRegistered To: ";
		str+=sys.GetRegisteredTo();

		str+="\r\nCompany Name: ";
		str+=sys.GetCompanyName();

		str+="\r\nProduct ID: ";
		str+=sys.GetProductID();

		// Display Service pack if running on NT
		/*
		if (sys.GetNTServicePack(wServicePack)==TRUE) {
			tmpstr.Format("\r\nService Pack: %d",wServicePack);
			str+=tmpstr;
		}
		*/

        idlg.m_InfoEdit=str;
        idlg.DoModal();
}


void CHILibTestDlg::OnScsi()
{
        HSCSI scsi;
        CInfoDlg idlg;
        CString str,tmpstr;
        int     i;

		if (scsi.m_bError==TRUE) return;

        str="SCSI Host Adapters Information...\r\n\r\n";
        str+="Driver Name: ";
        str+=scsi.GetDriverName();
        str+="\r\nManager Type: ";
        str+=scsi.GetManagerType();
        str+="\r\n-----------------\r\n";
        for (i=0; i<scsi.GetTotalHostAdapters(); i++) {
                tmpstr.Format("\r\nHost Adapter Nr. %d",i+1);
                str+=tmpstr;

                str+="\r\nPeripheral Type: ";
                str+=scsi.GetPeripheralType(i);

                str+="\r\nDevice Type: ";
                str+=scsi.GetDevType(i);

                str+="\r\nSCSI ID: ";
                tmpstr.Format("%d",scsi.GetSCSIID(i));
                str+=tmpstr;

                str+="\r\nProduct: ";
                str+=scsi.GetProduct(i);

                str+="\r\nVendor: ";
                str+=scsi.GetVendor(i);

                str+="\r\nRevision: ";
                str+=scsi.GetRevision(i);
                str+="\r\n-------------------";
        }

        idlg.m_InfoEdit=str;
        idlg.DoModal();
}

void CHILibTestDlg::OnWin32p()
{
        Win32Process proc;
        CString str,tmpstr;
        int     i,size;
    CInfoDlg idlg;


        if(!proc.Init()) {
                AfxMessageBox(proc.GetLastError());
                return;
        }

        if (!proc.EnumAllProcesses())
        {
                AfxMessageBox(proc.GetLastError());
                return;
        }

        idlg.m_InfoEdit="Current Running Processes...\r\n\r\n";
        size=proc.GetAllProcessesNames()->GetSize();
        for (i=0;i<size;i++) {
                idlg.m_InfoEdit+=proc.GetAllProcessesNames()->GetAt(i);
                idlg.m_InfoEdit+="\r\n";
        }

        idlg.DoModal();
}


void CAboutDlg::InitializeNT()
{

}

