; ----------------------------------------------------------------------
;  File :  StdError.Inc    Standard Error Message Tables
; ----------------------------------------------------------------------
;       (c) 1996   Propriety Use ONLY - All Rights Reserved

; Error Tables:                                         <==  MUST sync!
               .DATA
; DOS Rel 6
ERR_TBLD       DW      ERR0,ERR1,ERR2,ERR3,ERR4,ERR5,ERR6,ERR7,ERR8,ERR9
               DW      ERR10,ERR11,ERR12,ERR13,ERR14,ERR15,ERR16,ERR17
               DW      ERR18,ERR19,ERR20,ERR21,ERR22,ERR23,ERR24,ERR25
               DW      ERR26,ERR27,ERR28,ERR29,ERR30,ERR31,ERR32,ERR33
               DW      ERR34,ERR35,ERR36
               DW      13 DUP(ERRUNK)  ; 37 thru 49 Reserved
               DW      ERR50,ERR51,ERR52,ERR53,ERR54,ERR55,ERR56,ERR57
               DW      ERR58,ERR59,ERR60,ERRUNK,ERR62,ERR63,ERR64,ERR65
               DW      ERR66,ERR67,ERR68,ERR69,ERR70,ERR71,ERR72
               DW      7 DUP(ERRUNK)  ; 73 thru 79 Reserved
               DW      ERR80,ERR81,ERR82,ERR83,ERR84,ERR85,ERR86,ERR87
               DW      ERR88,ERR89,ERR90
; User / Custom
               DW      ERR91,ERR92,ERR93,ERR94,ERR95,ERR96,ERR97,ERR98
               DW      ERR99,ERR100,ERR101,ERR102,ERR103,ERR104,ERR105
               DW      ERR106,ERR107,ERR108,ERR109,ERR110,ERR111,ERR112
ERR_TBLDL      EQU     $-ERR_TBLD
               DW      ERRUNK

               Include DOSError.Inc  ; Text ( 0 - 36, 80 - ???, UNK )

; Network Errors ( 50 - 72 )
ERR50          DB      'Unsupported Network Request',0,'$'
ERR51          DB      'Remote Machine not Listening',0,'$'
ERR52          DB      'Duplicate Name on Network',0,'$'
ERR53          DB      'Network Name not found',0,'$'
ERR54          DB      'Network Busy',0,'$'
ERR55          DB      'Device no longer exists on Network',0,'$'
ERR56          DB      'NetBIOS Command Limit exceeded',0,'$'
ERR57          DB      'Error in Network Adapter Hardware',0,'$'
ERR58          DB      'Incorrect Response from Network',0,'$'
ERR59          DB      'Unexpected Network Error',0,'$'
ERR60          DB      'Remote Adapter incompatible',0,'$'
ERR62          DB      'Not enough Space for Print File',0,'$'
ERR63          DB      'Print File Cancelled',0,'$'
ERR64          DB      'Network Name deleted',0,'$'
ERR65          DB      'Network Access denied',0,'$'
ERR66          DB      'Incorrect Network Device Type',0,'$'
ERR67          DB      'Network Name not found',0,'$'
ERR68          DB      'Network Name Limit exceeded',0,'$'
ERR69          DB      'NetBIOS Session Limit exceeded',0,'$'
ERR70          DB      'File Sharing temporarily Paused',0,'$'
ERR71          DB      'Network Request not accepted',0,'$'
ERR72          DB      'Print or Disk Redirection Paused',0,'$'

; ----------------------------------------------------------------------
; Extended :  14 Classes { 0 thru 13 }
CLS_MAX        DB      13

ERR_TBLC       DW      CLS0,CLS1,CLS2,CLS3,CLS4,CLS5,CLS6
               DW      CLS7,CLS8,CLS9,CLS10,CLS11,CLS12,CLS13

CLS0           DB      '{ None }',0,'$'
CLS1           DB      'Out of Resource',0,'$'
CLS2           DB      'Temporary Situation { Expected to End }',0,'$'
CLS3           DB      'Authorization Problem',0,'$'
CLS4           DB      'Internal Error in System Software',0,'$'
CLS5           DB      'Hardware Failure',0,'$'
CLS6           DB      'External { Inactive } Process Failure',0,'$'
CLS7           DB      'Application Program Error',0,'$'
CLS8           DB      'File or Item Not Found',0,'$'
CLS9           DB      'Invalid Type or Format { File or Item }',0,'$'
CLS10          DB      'File or Item Locked',0,'$'
CLS11          DB      'Wrong or Damaged Disk { Media Problem }',0,'$'
CLS12          DB      'Item Already Exists',0,'$'
CLS13          DB      'Unknown Condition',0,'$'

; Extended :  8 Actions { 0 thru 7 }
ACT_MAX        DB      7

ERR_TBLA       DW      ACT0,ACT1,ACT2,ACT3,ACT4,ACT5,ACT6
               DW      ACT7

ACT0           DB      '{ Prayer }',0,'$'
ACT1           DB      'Re-try, Abort or Ignore Condition',0,'$'
ACT2           DB      'Pause, then Re-try or Abort',0,'$'
ACT3           DB      'Get Corrected Information from End User',0,'$'
ACT4           DB      'Abort Application { Restart OK }',0,'$'
ACT5           DB      'Exit Immediately from Program',0,'$'
ACT6           DB      'Ignore the Error',0,'$'
ACT7           DB      'Correct Erroneous Condition then Restart',0,'$'

; Extended :  6 Locus { 0 thru 5 }
LOC_MAX        DB      5

ERR_TBLL       DW      LOC0,LOC1,LOC2,LOC3,LOC4,LOC5

LOC0           DB      '{ Indeterminate }',0,'$'
LOC1           DB      'O/S or Application Software',0,'$'
LOC2           DB      'Block Device or Disk',0,'$'
LOC3           DB      'Communications Network',0,'$'
LOC4           DB      'Serial Device',0,'$'
LOC5           DB      'Random Access Memory',0,'$'

; ----------------------------------------------------------------------
; ROM Bios Floppy/Hard Disk Drive Error Table (ASCII-Z format)

ROM0           DB      0,'{ None }',0
ROM1           DB      1,'Invalid Command',0
ROM2           DB      2,'Address Mark not found',0
ROM3           DB      3,'Disk Write Protected',0
ROM4           DB      4,'Sector not found',0
ROM5           DB      5,'Reset failed',0
ROM6           DB      6,'Floppy Disk removed',0
ROM7           DB      7,'Bad Parameter table',0
ROM8           DB      8,'DMA overrun',0
ROM9           DB      9,'DMA crossed 64k boundary',0
ROM10          DB      10,'Bad Sector Flag',0  ; 0Ah
ROM11          DB      11,'Bad Track Flag',0  ; 0Bh
ROM12          DB      12,'Media Type not found',0  ; 0Ch
ROM13          DB      13,'Invalid # of Sectors on Format',0  ; 0Dh
ROM14          DB      14,'Control Data Address Mark detected',0  ; 0Eh
ROM15          DB      15,'DMA Arbitration Level out of range',0  ; 0Fh
ROM16          DB      16,'Uncorrectable CRC or ECC Data',0  ; 10h
ROM17          DB      17,'ECC corrected Data',0  ; 11h
ROM18          DB      32,'Controller failure',0  ; 20h
ROM19          DB      64,'Seek failed',0  ; 40h
ROM20          DB      128,'Disk timed-out',0  ; 80h
ROM21          DB      170,'Disk not ready',0  ; 0AAh
ROM22          DB      187,'Undefined or unsupported',0  ; 0BBh
ROM23          DB      204,'Write fault',0  ; 0CCh
ROM24          DB      224,'Invalid Status Register',0  ; 0E0h
ROM25          DB      255,'Sense operation failed',0  ; 0FFh
               DB      4 DUP(0FFh)  ; End of table

; *** End of StdError.Inc ***

