PAGE 60,132
TITLE SCopy.Exe  Special Copy program
; ----------------------------------------------------------------------

;  Syntax      SCOPY d:\Path\FSpec {d:\Path\FSpec}

;   Copyright  (c) 1996   Ben Ritchey Jr., et al
;                         Propriety Licensed use only
;                            All rights reserved

               DOSSEG
               .MODEL  small
               .STACK  400h    ; 1kB
; Note : Place .386 here for 16-bit Segments
               .386            ; Base Architecture

; ----------------------------------------------------------------------
; Un-initialized Data
               .DATA?
DTABUFF        DB      32768 DUP(?)  ; 32k File Buffer
DTABL          EQU     $-DTABUFF 

DTAFIND        DB      21 DUP(?)  ; 256 Byte DTA
DTAATTRIB      DB      9 DUP(?)  ; Attribute @ 21 (x1)
DTAFSPEC       DB      226 DUP(?)  ; FSpec @ 30 (AsciiZ)

               PAGE
; ----------------------------------------------------------------------
; Data Variables - 59kB Max ( 64kB - .DATA? - .STACK )
               .DATA
; PassThru Buffer Area
PASSBUFF       Label   Byte    ; PassThru Buffer
PBADDR         DD      PASSBUFF  ; Far Ptr to Here!
PBDRIVE        DB      'd'     ; Cur Drive
PBPATH         DB      64 DUP(0)  ; Cur Path
PBFH           DW      0       ; File Handle OUT
PBFH2          DW      0       ; File Handle IN
PBDTA          DW      0       ; Disk Transfer Addr
PBSDTA         DW      0       ; DTA Seg
PBFSA          DW      0       ; FSpec Addr

FSPECWC        DB      64 DUP(0)  ; Input Args
FSOUTWC        DB      'd:\'      ; Output Prefix
FSOUTWCP       DB      64 DUP(0)  ; Out Path (Current d:\Path)
FSPATH         DB      64 DUP(0)  ; Return Path
FSINPUT        DB      64 DUP(0)  ; Curr Input FSpec
FSOUTPUT       DB      'd:\'      ; Curr Output FSpec
FSOUTPATH      DB      64 DUP(0)  ;  "   (Path Start)
FSMIDDLE       DB      ' ',240,' ',0,'$'
DTALEN         DW      0
FSPFX          DB      'SCopy ',0,'$'
FSARHS         DB      ' {A}$'
FSOKX          DB      32,251,32,13,10,'$'
FSERR          DB      32,16,' Error '
ECODE          DB      'nnn ',17,7,'  Aborted!',13,10,'$'

OUTFLAG        DB      0       ; 1=Dest spec'd
CPYFLAG        DB      0       ; 1=in progress
ERRFLAG        DB      0       ; 1=1st Error, 2=2nd (Consecutive)

RUNDS          DW      0       ; Data Seg
RUNES          DW      0       ; Extra Seg
PSPES          DW      0       ; PSP Seg
RUNSP          DW      0       ; Stack OFFSET

INT_SEG        DW      0       ; Interrupts x1k (#x4=Addr)
BIOS_SEG       DW      40h     ; ROM Bios RAM Data
SYS_SEG        DW      0F000h  ; ROM Bios System Code
VBUF_SEG       DW      0B800h  ; Video Buffer Addr
VBUF_MODE      DB      3       ; Video Mode
VPAGE_LEN      DW      0       ; DOS Screen Bytes

CSR_LOC        Label   Word    ; Cursor Location
CSR_ROW        DB      0       ; Csr Row (0-43)
CSR_COL        DB      0       ; Csr Col (0-131)

TME_LOC        Label   Word    ; Clock
               DB      0,68
MSG_LOC        Label   Word
               DB      23,1    ; Msg Row/Col
SAV_LOC        DW      0

ZERO           DB      0
SPACE          DB      ' '
DOLLAR         DB      '$'
HEXTABLE       DB      '0123456789ABCDEF'

CRLF           DB      13,10,'$'
ROOT           DB      'd:\',0  ; Root Path
RC             DB      0       ; Return Code
PROCESS        DB      'SCopy.Exe',0

; Memory Map  ( Data Seg = .DATA + .DATA? + .STACK )
;     Seg Name :   HDR   +  PSP  +  Data  +  Code  =   Total
;    Max Alloc :    16   +  256  +  64kB  +  64kB  = 131,344
;   16 =Pages :     1   +   16  +  4096  +  4096  =   8,209
; ( also PSPSeg:0002 xWord = 1st Byte Unused RAM! )
PBPAGES        DW      8209

BIOSVID        EQU     10h     ; BIOS Video Int
BIOSDSK        EQU     13h     ;  "   Floppy Disk
BIOSEXT        EQU     15h     ;  "   Extended
DOS            EQU     21h     ; DOS Sys Func Req Int

               PAGE
; ----------------------------------------------------------------------
; Mainline Code (Logic Stuff) - 64kB Max
               .CODE
START:         mov     ax,@data  ; Data Seg Addr
               mov     ds,ax
               mov     RUNDS,ax
               mov     es,ax     ; Extra Seg=Data
               mov     RUNES,ax

               cli             ; Stack Seg=Data (Top) 
               mov     ss,ax
               mov     sp,Offset STACK
               sti
               mov     RUNSP,sp

; Free extra RAM
               mov     ah,62h  ; Get PSP Seg
               int     DOS
               mov     PSPES,bx  ; 1st Seg/Page
               mov     es,bx

               mov     ax,RUNDS  ; Calculate ACTUAL Size  <==
               mov     bx,RUNSP  ; Convert Stack Ptr to Paras
               shr     bx,4    ;   to get Data + Stack (/16)
               inc     bx
               add     ax,bx   ; Add Stack Pages to DS (End of Pgm)
               mov     bx,es   ; Get Start of Program (PSP)
               sub     ax,bx   ; Subtract Start from End
               inc     ax      ; +1 for Ctl Blk
               mov     bx,ax   ; Now actual Seg/Page Size

;               mov     bx,PBPAGES  ; (to Plug Max No. Pages)
               xor     al,al
               mov     ah,4Ah  ; Re-Allocate
               int     DOS
               jnc     Short @F
               jmp     ERR_SET

; Get DOS Version - Verify DOS >= 5.0
;      Out  al = Bin Major    ah = Bin Minor
@@:            mov     ah,30h
               int     DOS       
               cmp     al,5
               jge     Short @F
               mov     RC,99
               jmp     ERR_EXIT

; Get Disk Transfer Addr
;      Out  es:bx = Current DTA (es:80h = VLI, es:82h = Args)
;           PBDTA = Saved DTA Offset    PBSDTA = Saved DTA Seg
@@:            mov     ah,2Fh
               int     DOS       
               mov     PBDTA,bx
               mov     PBSDTA,es

               push    ds
               push    es
               mov     es,RUNES
               mov     di,Offset FSPECWC
               pop     ds      ; Store FSpec
               mov     si,bx
               mov     al,[si]
               cmp     al,1    ; Len=0 if No args
               jg      Short @F
               pop     ds      ; Restore ds!
               mov     RC,102  ; Syntax Error
               jmp     ERR_EXIT

@@:            xor     ch,ch
               mov     cl,al
               dec     cl
               inc     si
               inc     si
               cld
@@:            lodsb
               cmp     al,' '
               je      Short @F
               stosb
               loop    @B
               jmp     Short ENDARG

@@:            cmp     cx,2    ; Need sp+d:...
               jle     Short ENDARG
               mov     Byte Ptr es:[di],0
               mov     Byte Ptr es:[di+1],'$'
               dec     cx
               mov     es:OUTFLAG,1
               mov     di,Offset FSOUTWC  ; Rest is Dest.
               rep     movsb

ENDARG:        pop     ds
               mov     Byte Ptr [di],0
               mov     Byte Ptr [di+1],'$'

; Set Disk Transfer Addr
;      In   ds:dx = Addr of Buffer
;      Out  PBDTA = Saved Offset (dx)    PBSDTA = Saved Segment (ds)
               mov     dx,Offset DTAFIND  ; Private DTA
               mov     PBSDTA,ds
               mov     PBDTA,dx
               mov     ah,1Ah
               int     DOS

               PAGE
; ----------------------------------------------------------------------
; Re-entrant

; Get Current Drive
;      Out  al = Bin Drive (0=A, 1=B, etc.)    ah = ASCII Drive 'A'
;           PBDRIVE = ah
RESTART:       mov     ah,19h
               int     DOS
               mov     ah,al   ; Save #
               add     ah,65   ; Cv to ASCII
               mov     PBDRIVE,ah  ; Save
               cmp     OUTFLAG,1
               jne     Short @F
               mov     ah,FSOUTWC

@@:            mov     FSOUTWC,ah
               mov     FSOUTPUT,ah

; Get Current Path
;      Out  PBPATH = Path Name (excl. d:\)
               xor     dl,dl
               mov     si,OFFSET PBPATH
               mov     ah,47h
               int     DOS
               jnc     Short @F
               jmp     ERR_SET

@@:            mov     ax,@data
               mov     ds,ax
               mov     cx,16
               mov     si,Offset PBPATH
               cmp     OUTFLAG,1
               jne     Short @F
               mov     si,Offset FSOUTWCP
               cmp     FSOUTWCP-1,'\'
               je      Short @F
               mov     si,Offset FSOUTWCP-1

@@:            mov     di,Offset FSOUTPATH
               cld
               rep     movsd
               cmp     OUTFLAG,1
               je      Short @F

               mov     cx,16
               mov     si,Offset PBPATH
               mov     di,Offset FSOUTWCP
               cld
               rep     movsd

@@:            mov     cx,16   ; File(s)
               mov     si,Offset FSPECWC
               mov     di,Offset FSINPUT
               cld
               rep     movsd

               cmp     FSPECWC+1,':'
               jne     Short @F
               cmp     FSOUTWC+1,':'
               je      Short GETDIR1

@@:            mov     RC,112
               jmp     ERR_EXIT

; Find 1st File :
;      In   Current DTA Set   ds:dx = ASCIIZ Path/Wildcard
;           cx = Attribute Mask:  +0h-n/a  +1h-R/O  +2h-Hidden  +4h-System
;                           +8h-Vol Label  +10h-Sub Dir  +20h-Archive
;      Out  DTA+00 x21 = Find Next Pointer (Binary)
;              +21 x 1 = Attribute (1=R/O 2=Hid 4=Sys 8=Vol 10h=Dir 20h=Arc
;              +22 x 2 = Time (ax=hhhhhmmm.mmmsssss (sec/2))
;              +24 x 2 = Date (ax=yyyyyyym.mmmddddd (yr-80))
;              +26 x 4 = Size in Bytes (L/Msb)  4,294,967,295 = 0FFFFFFFFh
;              +30 x13 = FName.Ext (AsciiZ) Len 1 to 12, 0
GETDIR1:       mov     cx,0FFh  ; R/O, Hidden, Sub-Dir or Archive
               mov     dx,Offset FSPECWC
               mov     PBFSA,dx
               mov     ah,4Eh
               int     DOS
               jnc     Short @F
               jmp     ERR_SET

@@:            jmp     Short DOCOPY

; Find Next File :
;      In/Out  (DTAFIND : See Find 1ST)
NEXTFS:        mov     ah,4Fh
               int     DOS
               jnc     Short @F
               cmp     al,18   ; No more Ok
               je      Short @F
               jmp     ERR_SET

@@:            cmp     al,18
               jne     short DOCOPY
               jmp     ERR_EXIT  ; all done

DOCOPY:        test    DTAATTRIB,8  ; skip Vol?
               jnz     Short NEXTFS
               cmp     OUTFLAG,1  ; Sys Ok if Dest spec'd
               je      Short @F
               test    DTAATTRIB,4  ; skip Sys?
               jnz     Short NEXTFS

@@:            cmp     DTAFSPEC,0E5h  ; Skip Nulls
               je      Short NEXTFS
               test    DTAATTRIB,10h  ; Sub-Dir?
               jnz     Short @F
               jmp     Short DOCOPY2  ; No, must be OK to Copy

@@:            cmp     DTAFSPEC,'.'  ; Skip Back Ptrs
               je      Short NEXTFS

; Create Sub-Dir
;      In   ds:dx = ASCIIZ Path
               mov     dx,Offset DTAFSPEC
               mov     PBFSA,dx
               mov     ah,39h
               int     DOS
               jnc     Short @F
               jmp     ERR_SET

@@:            jmp     Short NEXTFS

DOCOPY2:       mov     es,RUNES
               mov     di,Offset FSOUTPATH
               mov     si,Offset DTAFSPEC
               mov     cx,64
               cld

@@:            cmp     Byte Ptr [di],0
               je      Short @F
               inc     di
               loop    @B
               mov     RC,110
               jmp     ERR_EXIT

@@:            cmp     OUTFLAG,1
               je      Short NODTA
               cmp     Byte Ptr [di-1],'\'
               je      Short @F
               mov     Byte Ptr [di],'\'
               inc     di
               mov     Byte Ptr [di],0

@@:            cmp     Byte Ptr [si],0
               je      Short @F
               movsb
               loop    @B
               mov     RC,110
               jmp     ERR_EXIT

@@:            movsb
               dec     di

NODTA:         mov     Byte Ptr [di+1],'$'

               mov     al,FSPECWC
               cmp     al,FSOUTWC  ; Diff Drives Ok
               jne     Short @F
               mov     eax,DWord Ptr FSPECWC+3
               cmp     eax,DWord Ptr FSOUTWC+3  ; d:\Path must differ
               jne     Short @F
               mov     RC,111
               jmp     ERR_EXIT

; Display String
;      In   [ds:dx] = String Addr (end with $)
@@:            mov     dx,Offset FSPFX
               mov     ah,09h
               int     DOS
               mov     dx,Offset FSINPUT
               mov     ah,09h
               int     DOS
               mov     dx,Offset FSMIDDLE
               mov     ah,09h
               int     DOS
               mov     dx,Offset FSOUTPUT
               mov     ah,09h
               int     DOS
               mov     CPYFLAG,1  ; in progress

; Open Input File
;      In   [ds:dx] = ASCIIZ FSpec    al = Access (0-Read, 1-Write, 2-R/W)
;      Out  ax = File Handle    PBFH2 = ax
               mov     dx,Offset FSPECWC
               mov     ax,3D10h
               int     DOS
               jnc     Short @F
               jmp     ERR_SET

@@:            mov     PBFH2,ax

; Create Output File
;      In   [ds:dx] = ASCIIZ FSpec
;           cx = Attribute (0h-Std, 1h-R/O, 2h-Hid, 4h-Sys, 8h-Vol,
;                           10h-Sub Dir, 20h-Archive)
;      Out  ax = File Handle    PBFH = ax
;           PBFSA = ASCIIZ FSpec Addr (dx)
@@:            mov     dx,Offset DTAFSPEC
               cmp     OUTFLAG,1
               jne     Short @F
               mov     dx,Offset FSOUTWC

@@:            xor     ch,ch
               mov     cl,DTAATTRIB
               mov     PBFSA,dx
               mov     ah,3Ch
               int     DOS
               jnc     Short @F
               jmp     ERR_SET

@@:            mov     PBFH,ax

; Read File Block
;      In   [ds:dx] = DTA Buffer    cx = # Bytes    bx = File Handle
;      Out  ax = # Bytes Read
RLOOP:         mov     dx,Offset DTABUFF
               mov     cx,DTABL  ; try 32k
               mov     bx,PBFH2
               mov     ah,3Fh
               int     DOS 
               jnc     Short @F
               jmp     ERR_SET

@@:            mov     DTALEN,ax  ; Vli found
               cmp     ax,0
               je      Short CLOSEEM

; Write File Block
;      In   [ds:dx] = DTA Buffer    cx = # Bytes    bx = File Handle
;      Out  ax = # Bytes Written
               mov     dx,Offset DTABUFF
               mov     cx,ax
               mov     bx,PBFH
               push    cx
               mov     ah,40h
               int     DOS
               jnc     Short @F
               pop     cx
               jmp     ERR_SET

@@:            pop     cx
               cmp     ax,cx
               je      Short @F
               mov     RC,103
               jmp     ERR_EXIT

@@:            cmp     ax,DTABL
               je      Short RLOOP

; Close Files
;      In   bx = File Handle
CLOSEEM:       mov     bx,PBFH
               mov     cx,Word Ptr DTAFIND+22  ; Time
               mov     dx,Word Ptr DTAFIND+24  ; Date
               mov     ax,5701h  ; Set Date/Time
               int     DOS

               mov     bx,PBFH  ; Close Out
               mov     ah,3Eh
               int     DOS
               mov     bx,PBFH2  ; Close In
               mov     ah,3Eh
               int     DOS

               mov     FSARHS+5,250
               test    DTAATTRIB,4
               jz      Short @F
               mov     FSARHS+5,'S'  ; System

@@:            mov     FSARHS+4,250
               test    DTAATTRIB,2
               jz      Short @F
               mov     FSARHS+4,'H'  ; Hidden

@@:            mov     FSARHS+3,250
               test    DTAATTRIB,1
               jz      Short @F
               mov     FSARHS+3,'R'  ; Read Only

@@:            nop
DONE:          mov     dx,Offset FSARHS  ; Attributes
               mov     ah,09h
               int     DOS
               mov     dx,Offset FSOKX  ; Ok
               mov     ah,09h
               int     DOS

               jmp     Short ERR_EXIT

PATCH          DD      16 DUP(0FFh)  ; 64 Byte Patch

               PAGE
; ----------------------------------------------------------------------
; Error Handler

ERR_SET:       mov     RC,al   ; Save Err #

ERR_EXIT:      mov     al,RC   ; Error #
               cmp     al,0
               je      Short EXITP

               mov     es,RUNES
               cmp     CPYFLAG,0  ; in progress?
               je      Short @F

; BIN_DEC  Convert Binary to ASCII Decimal
;   In    al  = Binary Value (0-255)    Out   ECODE = ASCII Dec (nnn)
               xor     ah,ah
               xor     bx,bx
               mov     cx,100  ; Hunds
               div     cl
               mov     bl,al
               mov     al,HEXTABLE[bx]
               mov     ECODE,al
               mov     al,ah   ; Tens
               xor     ah,ah
               mov     cx,10
               div     cl
               mov     bl,al
               mov     al,HEXTABLE[bx]
               mov     ECODE+1,al
               mov     bl,ah   ; Ones
               mov     al,HEXTABLE[bx]
               mov     ECODE+2,al

               mov     dx,Offset FSERR  ; Err msg
               mov     ah,09h
               int     DOS
               jmp     Short EXITP

@@:            mov     bx,Offset PROCESS  ; Process Addr
               xor     di,di
               cmp     PBFSA,0
               je      Short @F
               mov     di,PBFSA  ; FSpec Addr

@@:            mov     al,RC
               mov     ah,0FFh  ; Calls Int Routine
               int     BIOSEXT

               mov     es,RUNES
               cmp     ah,0FFh  ; Ignore Ok
               je      Short @F
               cmp     ah,0AAh  ; Abort Ok
               je      Short @F
               cmp     ah,0EEh  ; Retry = Tone
               jne     Short @F

@@:            nop

; Exit to DOS
EXITP:         mov     al,RC   ; ErrorLevel
               mov     ah,4Ch
               int     DOS     ; Exit
               ret

               END     START   ; Start Addr!
;*** End of Program ***
