Page 60,132
Title DTRSys.Com  Startup/Int Trap routines for DTRate
; ---------------------------------------------------------------------

;  Config.Sys :  DEVICE=DTRSys.Com

;              (c) 1996   Ben Ritchey Jr., et al
;                         Propriety use only - All rights reserved

               .8086           ; Base Architecture

; Interrupts (ah=Func)
BIOSVID        Equ     10h     ; BIOS Video Int
BIOSEXT        Equ     15h     ;  "   Extended
DOS            Equ     21h     ; DOS Sys Func Req

               Include Macro.Inc

               Page
; ---------------------------------------------------------------------
; Device Header

CSEG           Segment Public 'CODE'
               Org     0
               Assume  cs:CSEG, ds:CSEG, es:CSEG

SECURE         Proc    Far

HEADER         Equ     $
               DD      0FFFFFFFFh  ; Addr of Nxt Driver (-1)

; Bits ON :  b15 = Char Dev (else Block), b14 = IOCTL Supported
;            b13 = IBM Block Format, b3 = CLOCK, b2 = NUL
;            b1 = Std Output (Video), b0 = Std Input (Kybd)
               DW      08000h      ; Attrib = + 8xxxh Char Device

               DW      SCINIT      ; Strategy Addr
               DW      SCDRVR      ; Driver Addr

               DB      'DoNotUse'  ; Device Name
; File I/O : Use Int 21h, Func 3Fh:Input, 40h:Output, Handle 3 if AUX

               Page
SCINIT:        mov     cs:RQHDRES,es  ; Save Request Header Seg
               mov     cs:RQHDRBX,bx  ;  "   Offset...
               ret

RQHDRBX        DW      ?       ; DOS Data I/O Addr for Device AUX
RQHDRES        DW      ?       ;  "  Seg...

               Page
; ---------------------------------------------------------------------
; Start-up - 2nd Loader Init at BOOT time

INITIALIZE:    lea     ax,SEG_END
               mov     es:Word Ptr [bx]+14,ax  ; End Addr
               mov     es:Word Ptr [bx]+16,cs

               mov     ax,cs
               mov     ds,ax
               mov     RUNDS,ax
               mov     es,ax
               mov     RUNES,ax

               mov     es,INT_SEG  ; Save Break
               mov     ax,cs   ; Break = LOCK (Int 1Bh,27 = Here!)
               mov     es:[110],ax
               mov     ax,Offset LOCKIT
               mov     es:[108],ax

               mov     es,RUNES
               mov     ax,100h  ; Block Cursor (DOS)
               mov     cx,13    ; ch=Top(0)
               xor     bx,bx
               xor     dx,dx
               int     BIOSVID

               mov     ax,MSG_LOC
               mov     CSR_LOC,ax
               @SET_CSR

               mov     dx,Offset MSG_OK  ; Auth msg
               @PUT_STR

               mov     es,VBUF_SEG
               mov     di,1928
               mov     cx,7
               cld
@@:            mov     ax,es:[di]
               or      ah,128
               stosw
               loop    @B

               jmp     Short SCEXIT

CB:            int     1Bh     ; 27 = Ctrl-Break = LOCKIT

LOCKIT:        lock    jmp     Short LOCKIT  ; ad infinitum

               Page
; ---------------------------------------------------------------------
; Driver Mainline Code

SCDRVR:        push    ds      ; Driver main
               push    es
               push    ax
               push    bx
               push    cx
               push    dx
               push    si
               push    di
               push    bp

               push    ax
               mov     ax,cs
               mov     ds,ax
               mov     ax,cs:RQHDRES
               mov     es,ax
               mov     bx,cs:RQHDRBX
               xor     ah,ah
               mov     al,es:[bx]+2  ; Function
               shl     al,1    ; *2 = Word Offset
               lea     di,FCTABLE  ; Jump Table Start
               add     di,ax     ; Start + Offset = Addr
               pop     ax
               jmp     Word Ptr [di]  ; Near jump

FCTABLE        Label   Word    ; Function Jump Table
               DW      INITIALIZE
               DW      CHECK_MEDIA  ; Block only
               DW      MAKE_BPB     ;  "
               DW      IOCTL_IN
               DW      INPUT_DATA
               DW      NONDESTRUCT_IN
               DW      INPUT_STATUS
               DW      CLEAR_INPUT
               DW      OUTPUT_DATA
               DW      OUTPUT_VERIFY
               DW      OUTPUT_STATUS
               DW      CLEAR_OUTPUT
               DW      IOCTL_OUT
               DW      0FFh

; Un-used functions return Error Status from IOCTL
CHECK_MEDIA:
MAKE_BPB:
IOCTL_IN:
INPUT_DATA:
NONDESTRUCT_IN:
INPUT_STATUS:
CLEAR_INPUT:
OUTPUT_DATA:
OUTPUT_VERIFY:
OUTPUT_STATUS:
CLEAR_OUTPUT:
IOCTL_OUT:
               or      es:Word Ptr [bx]+3,8103h  ; Status Word = Error#
               jmp     Short SCEXIT

               Page
; ---------------------------------------------------------------------
; Common Exit

SCEXIT:        mov     ax,cs:RQHDRES
               mov     es,ax
               mov     bx,cs:RQHDRBX
               or      es:Word Ptr [bx]+3,100h  ; Bit 8 = Done

               pop     bp
               pop     di
               pop     si
               pop     dx
               pop     cx
               pop     bx
               pop     ax
               pop     es
               pop     ds
               ret

; ---------------------------------------------------------------------
; Data Variables
               Align   16

RUNDS          DW      0       ; Data Seg
RUNES          DW      0       ; Extra Seg
INT_SEG        DW      0       ; Interrupts
BIOS_SEG       DW      40h     ; ROM Bios RAM Data
VBUF_SEG       DW      0B000h

CSR_LOC        DW      0
MSG_LOC        DW      0F0Ah   ; Col 15, Row 11
MSG_OK         DB      ' ... ',251,32
               DB      13,10,10,4 DUP(32)
               DB      'Warning : Do NOT use [Ctrl+BREAK], as th'
               DB      'is will LOCK up the System ! '
               DB      13,10,10,'$'

; Note : This MUST be last 5 lines of Program - NO Exceptions !!!
SEG_END:
LOADPAGES      DW      (SEG_END-HEADER)/16
SECURE         EndP
CSEG           EndS
               End     SECURE
; *** End of DTRTRAP program ***

