PAGE 60,132
TITLE DTRSave.Exe  Saves IPL Console Screen to Disk (80x25)
; ----------------------------------------------------------------------

; Syntax:  DTRSave { d:\Path\FSpec }    default = DTRSave.RPT

; Note: Program will save Monochrome Buffer at B000h if Mode 7, 86 or 87
;         else Color Buffer is assumed, using BIOS parameters

;      (c) 1996  Ben Ritchey Jr.
;              Propriety Licensed Use Only 

               DOSSEG
               .8086           ; Base Architecture
               .MODEL  small
               .STACK  100h
               INCLUDE macro.inc
               INCLUDE called.inc
               INCLUDE error.inc

; ----------------------------------------------------------------------
; Un-initialized Data
               .DATA?
DTAFIND        DB      30 DUP (?)      ; 256 Byte DTA
DTAFSPEC       DB      226 DUP (?)     ; Offset 30=FSpec

;  Screen Data (no Attr)    Actual Len = Lines x ( Cols +Cr +Lf )
;    80x25 = 25 x ( 80 + 2 ) = 2,050    132x61 = 8,174 (Max DOS)

DTASCREEN      DB      2050 DUP(?)  ; 10 lines

; ----------------------------------------------------------------------
; Data Variables
               .DATA
; PassThru Buffer Area
PASSBUFF       Label   Byte    ; PassThru Buffer
PBADDR         DD      PASSBUFF  ; Far Ptr to Here!
PBDRIVE        DB      'd'     ; Cur Drive
PBPATH         DB      64 DUP(0)  ; Cur Path
PBFH           DW      0       ; File Handle
PBDTA          DW      0       ; Disk Transfer Addr
PBSDTA         DW      0       ; DTA Seg
PBFSA          DW      0       ; Cur FSpec Addr (See Macro.Inc)

RUNDS          DW      0       ; Data Seg
RUNES          DW      0       ; Extra Seg
RUNSS          DW      0       ; Stack Seg
PSPES          DW      0       ; PSP Seg

BIOS_SEG       DW      40h     ; ROM Bios RAM Data
VBUF_SEG       DW      0B800h  ; Video Buffer Addr
VBUF_MONO      DW      0B000h  ; if Mode 7, 86 or 87
VBUF_MODE      DB      3       ; Video Mode
VPAGE_LEN      DW      0       ; DOS Screen Bytes

XMODE          DB      0       ; Byte Mode
XCOLS          DW      0       ; Word Columns
XBYTES         DW      0       ; Word Bytes
XPAGE          DB      0       ; Byte Page

SCCOLS         DB      0       ; Columns
SCROWS         DB      0       ; Rows

HANDLE         DW      0       ; Cur File Handle
FSPECWC        DB      64 DUP (0)  ; Arg FSpec
FSVLI          DB      0       ; from PSP Args

FILEMSG1       DB      12,13,10,10
               DB      16,' Output to '
FILEML1        EQU     $-FILEMSG1

FILEMSG2       DB      '   on '
STDATE         DB      15 DUP (32)
               DB      '   at '
STTIME         DB      11 DUP (32)
               DB      13,10,13,10
FILEML2        EQU     $-FILEMSG2

DFS            DB      'DTRSave.Rpt'  ; Default FSpec
DFSLEN         EQU     $-DFS
CRLF           DB      13,10,'$'

RESTFLAG       DB      0
KBSTAT         DB      0               ;Kybd Stat Flag
CLOCK          DB      0       ; .nn last

ROOT           DB      'd:\',0         ;Root Path
RC             DB      0               ;Return Code
RCC            DB      0               ;Return Code/Child
PROCESS        DB      'DTRSave.EXE',0
PATCH          DD      16 DUP (0FFh)   ;64 Byte Patch Area

; ----------------------------------------------------------------------
; Data Constants
               .CONST

BIOSVID        EQU     10h     ; BIOS Video Int
BIOSEXT        EQU     15h     ; BIOS Spec Int
BIOSKBD        EQU     16h     ; BIOS Kybd Int
BIOSPRT        EQU     17h     ; BIOS Printer Int
BIOSTOD        EQU     1Ah     ; BIOS RealTime Clock
DOS            EQU     21h     ; DOS Sys Func Req Int

MSG_LOC        Label   Word
               DB      23,0    ; Msg Row/Col
TME_LOC        Label   Word    ; Clock
               DB      0,68
CO_TME         DB      3       ; Clock      Cyan on Black
CO_MSG         DB      11      ; Messages   Hi-Cyan
ZERO           DB      0
SPACE          DB      ' '
DOLLAR         DB      '$'
ERR99          DB      ' DOS VERSION 3.0 or > is Required',0,'$'
ERR102         DB      ' Syntax is [ DTRSave d:\Path\FSpec ]',0,'$'

; ----------------------------------------------------------------------
; Mainline Code (Logic Stuff)
               .CODE
START          Label   Proc
               mov     ax,@data        ;Data Seg
               mov     ds,ax
               mov     RUNDS,ax
               mov     es,ax           ;Extra Seg
               mov     RUNES,ax

               cli                     ;Stack Seg
               mov     ss,ax
               mov     RUNSS,ax
               mov     sp,Offset STACK
               sti

; Free extra RAM
               mov     ah,62h  ; Get PSP Seg
               int     DOS
               mov     PSPES,bx  ; 1st Seg/Page
               mov     es,bx

               mov     ax,RUNDS  ; Calculate ACTUAL Size  <==
               mov     bx,sp   ; Convert Stack Ptr to Paras
               mov     cl,4
               shr     bx,cl   ;   to get Stack Size (/16)
               add     ax,bx   ; Add Stack Pages to DS (End of Pgm)
               mov     bx,es   ; Get Start of Program (PSP)
               sub     ax,bx   ; Subtract Start from End
               inc     ax      ; +1 for ?
               mov     bx,ax   ; Now actual Seg/Page Size

;               mov     bx,PBPAGES  ; (to Plug Max No. Pages)
               xor     al,al
               mov     ah,4Ah  ; Re-Allocate
               int     DOS
               jnc     @F
               jmp     ERR_SET

; Get DOS Version - Verify DOS >= 3.0
;      Out  al = Bin Major    ah = Bin Minor
@@:            mov     ax,3000h
               int     DOS
               cmp     al,3
               jge     @F
               mov     al,99
               mov     RC,al
               jmp     ERR_EXIT
@@:
; Get Disk Transfer Addr - PSP +80h = Cmd Args
;   Out  es:bx = Current DTA   PBDTA = DTA Offset   PBSDTA = DTA Seg
               mov     ax,2F00h
               int     DOS
               mov     PBDTA,bx
               mov     PBSDTA,es

               push    ds
               push    es              ;Save DTA Seg
               mov     ax,RUNES
               mov     es,ax
               pop     ds
               mov     di,Offset FSPECWC
               mov     si,bx
               mov     al,[si]
               cmp     al,0            ;Len=0 if No args
               jne     @F

               mov     al,DFSLEN       ;Use Default FSpec
               inc     al
               mov     si,Offset DFS
               dec     si
               dec     si
               pop     ds              ;Reset source Seg
               push    ds
@@:
               xor     ch,ch
               mov     cl,al
               dec     cl
               push    cx
               inc     si
               inc     si
               cld

NXT_BYTE:      lodsb
               cmp     al,97
               jl      @F
               cmp     al,122
               jg      @F
               sub     al,32   ; Cv to Upper Case
@@:
               cmp     al,' '
               je      Short @F  ; Skip all after 1st space
               stosb
               loop    NXT_BYTE
@@:
               pop     ax
               pop     ds
               mov     FSVLI,al

; Set Disk Transfer Addr
;      In   ds:dx = Addr of Buffer
;      Out  PBDTA = Saved Offset (dx)   PBSDTA = Saved Segment (ds)
               mov     dx,Offset DTAFIND ;Private DTA
               mov     PBSDTA,ds
               mov     PBDTA,dx
               mov     ax,1A00h
               int     DOS

               call    GET_DTE  ; Sys Date
               mov     cx,15
               mov     si,Offset ASC_DATE
               mov     di,Offset STDATE
               cld
               rep     movsb

               call    GET_TME  ; Start Time
               mov     cx,11
               mov     si,Offset ASC_TOD
               mov     di,Offset STTIME
               cld
               rep     movsb

               mov     dx,Offset FSPECWC ; Try Append 1st 
               mov     PBFSA,dx
               mov     ax,3D02h
               int     DOS
               jnc     @F
               jmp     Short NOFILE
@@:
               mov     PBFH,ax
               mov     HANDLE,ax

;      Out  dx:ax = File Size
               mov     ax,4202h  ; Set File to EOF
               xor     cx,cx
               xor     dx,dx
               mov     bx,HANDLE
               int     DOS
               jnc     @F
               jmp     ERR_SET
@@:
               jmp     Short GOFILE

;  In   [ds:dx] = ASCIIZ FSpec   cx = Attribute (0h-Std, 1h-R/O, 2h-Hidden,
;                        4h-System, 8h-Vol Label, 10h-Sub Dir, 20h-Archive)
;      Out  ax = File Handle
NOFILE:        mov     dx,Offset FSPECWC  ; Create NEW file
               xor     cx,cx
               mov     PBFSA,dx
               mov     ax,3C00h
               int     DOS
               jnc     @F
               jmp     ERR_SET
@@:
               mov     PBFH,ax
               mov     HANDLE,ax

GOFILE:        mov     es,BIOS_SEG
               mov     al,es:[49h]  ; Cur Screen Mode
               mov     XMODE,al
               cmp     al,7    ; Mode 7 is Mono Buffer at B000h
               je      Short @F
               cmp     al,86   ; Mode 86 (VGA)   " ...
               je      Short @F
               cmp     al,87   ; Mode 87   "     " ...
               jne     Short NOTMONO
@@:
               mov     ax,VBUF_MONO
               mov     VBUF_SEG,ax

NOTMONO:       mov     ax,es:[4Ah]  ; Cols
               mov     XCOLS,ax
               mov     SCCOLS,al

               mov     ax,es:[4Ch]  ; Bytes
               mov     XBYTES,ax

               mov     al,es:[62h]  ; Page
               mov     XPAGE,al

               mov     es,RUNES

               cmp     al,0    ; Page 0?
               je      @F
               cmp     al,7    ; Max 7
               jg      @F

               mov     ah,al   ; not zero
               add     ah,48
               xor     ah,ah
               mov     cl,al
               mov     ax,XBYTES
               mul     cl
               add     VBUF_SEG,ax  ; Page Offset
@@:
               mov     al,SCCOLS
               mov     cl,25
               xor     ah,ah
               mul     cl      ; Cols x 25
               mov     bx,ax
               mov     ax,XBYTES
               cmp     ax,bx   ; Min bytes?
               jge     @F
               mov     al,98   ; Bad data
               jmp     ERR_SET
@@:
               mov     cl,SCCOLS  ; Bytes/Cols/2
               mov     ax,XBYTES
               shr     ax,1
               div     cl
               mov     SCROWS,al  ; # Rows

               mov     si,Offset FILEMSG1
               mov     di,Offset DTASCREEN
               mov     cx,FILEML1
               cld
               rep     movsb

               mov     si,Offset FSPECWC
               xor     ch,ch
               mov     cl,FSVLI
               cld
               rep     movsb

               mov     si,Offset FILEMSG2
               mov     cx,FILEML2
               cld
               rep     movsb

               push    ds              ;Copy Screen
               mov     bl,SCCOLS
               mov     cl,bl
               mov     ch,25
               mov     ax,Word Ptr CRLF
               push    ax

               mov     ax,VBUF_SEG
               mov     ds,ax
               mov     si,0

DOBYTE:        cld
               lodsb
               stosb
               inc     si              ;Skip Attrib byte

               dec     cl
               cmp     cl,0
               jne     DOBYTE

               pop     ax
               push    ax
               cld
               stosw
               dec     ch

               mov     cl,bl
               cmp     ch,0
               jne     DOBYTE

               pop     ax
               pop     ds
               mov     cx,di           ;Save Last + 1 Addr
               mov     dx,Offset DTASCREEN
               sub     cx,dx           ;Compute length

; Write File Block
;      In   [ds:dx] = DTA Buffer
;           cx = # Bytes
;           bx = File Handle
;      Out  ax = # Bytes Written
               mov     bx,HANDLE
               mov     ax,4000h
               push    cx
               int     DOS
               jnc     @F
               pop     cx
               jmp     Short ERR_SET
@@:
               pop     cx
               cmp     ax,cx
               je      @F
               mov     RC,103
               jmp     Short ERR_EXIT
@@:
               mov     bx,HANDLE       ;Close Output
               mov     ax,3E00h
               int     DOS
               jnc     @F
               jmp     Short ERR_SET
@@:
               jmp     Short EXITP  ; Fini

; Error Handler
ERR_SET        Label   Proc
               mov     RC,al   ; Save Err #

ERR_EXIT:      mov     al,RC   ; Error #
               cmp     al,0
               je      EXITP

               call    STD_ERROR

; Exit to DOS
EXITP          Label   Proc
               mov     al,RC   ; ErrorLevel
               mov     ah,4Ch
               int     DOS     ; Exit
               ret

               END     START           ;Start Addr!
;*** End of Program ***

