PAGE 60,132
TITLE DTRBoot.Com  MS-DOS Cold Boot after Benchmark
; ---------------------------------------------------------------------

;  Syntax      DTRBOOT

;   Copyright  (c) 1996   Ben Ritchey Jr., et al
;                         Propriety Licensed use only
;                            All rights reserved

               .8086           ; Base Architecture
CSEG           SEGMENT
; Note : Place .386 here for 16-bit Segments
               ASSUME  cs:CSEG, ds:CSEG, es:CSEG, ss:CSEG
               Include Macro.Inc

; Interrupts (ah=Func)
BIOSVID        EQU     10h     ; BIOS Video Int
BIOSMEM        EQU     12h     ;  "   Memory Size
BIOSEXT        EQU     15h     ;  "   Extended
BIOSKBD        EQU     16h     ;  "   Keyboard
BIOSRTC        EQU     1Ah     ;  "   Real Time Clock

DOS            EQU     21h     ; DOS Sys Func Req
ALMINT         EQU     4Ah     ; SysRQ User Alarm

; ---------------------------------------------------------------------
; Program Segment Prefix (PSP x 256/100h)
               org     0
               org     2
PSPFree        Label   Word    ; Seg of 1st Free/Pgm Para Size
               org     2Ch
PSPEnv         Label   Word    ; Seg of Environ (Pgm Copy)
               org     5Ch
PSPFCB1        Label   Byte    ; Formatted FCB/FSpec of Arg 1 x16
               org     6Ch
PSPFCB2        Label   Byte    ; Formatted FCB/FSpec of Arg 2 x20

               org     80h     ; Default Disk Trfr Area x128
PSPVLI         Label   Byte    ; Args Len (1st = Sp @ 81h if >0)
               org     82h
PSPArgs        Label   Byte    ; 'args...' if Vli >1

               PAGE
; ---------------------------------------------------------------------
               org     100h
Start          Label   Proc

               mov     dx,Offset MSG
               @PUT_STR
               @GET_KEY

               mov     ax,40h
               mov     es,ax
               mov     WORD PTR es:[72h],0  ; Esc = IML { Cold BOOT }
               DB      0EAh    ; Far Jmp to FFFF:0 
               DW      0
               DW      0FFFFh
               ret
 
; ---------------------------------------------------------------------
; Data & Constants
;   Note: 'DD  Label' will NOT Convert

MSG            DB      13,10,10,4 DUP(32),218,62 DUP(196),191
               DB      13,10,4 DUP(32),179,32,32
               DB      'Remove diskette from Drive A:  '
               DB      '{ System will now re-BOOT }'
               DB      32,32,179
               DB      13,10,4 DUP(32),192,62 DUP(196),217
               DB      13,10,10,'Press any key to continue ... $'
RC             DB      0
CSEG           ENDS
               END     Start
;*** End of Program ***

