PAGE 60,132
TITLE DTRATE.Exe    Bus Data Transfer Rate Utility
; ----------------------------------------------------------------------

;    {c} 1996      Propriety License Use Only - All Rights Reserved
;                   Benjamin E. Ritchey Jr

;   Syntax :  DTRATE d    where d = Drive to Test

; ----------------------------------------------------------------------

               DOSSEG
               .MODEL  small
               .STACK  400h    ; 1K
               .386            ;  Base Architecture
               INCLUDE macro.inc
               INCLUDE called.inc

; ----------------------------------------------------------------------
; Un-initialized Data
               .DATA?
DTABUFF        DB      32768 DUP(?)  ; 32k Data Block
DTABL          Equ     $-DTABUFF

SCRBUFF        DB      8192 DUP(?)  ; 8k ScrSaver (50x80x2)
SCRBL          EQU     $-SCRBUFF 

; ----------------------------------------------------------------------
; Data Variables
               .DATA
; PASSBUFF  PassThru Buffer Area
PASSBUFF       LABEL   BYTE    ; PassThru Buffer
PBADDR         DD      PASSBUFF  ; Far Ptr to Here!
PBDRIVE        DB      'C'     ; Cur Drive
PBPATH         DB      64 DUP (0)  ; Cur Path
PBFSPEC        DB      12 DUP (0)  ; FileName.Ext
PBFH           DW      0       ; File Handle
PBDTA          DW      0       ; Disk Transfer Addr
PBSDTA         DW      0       ; DTA Seg
PBFSA          DW      0       ; FSpec Addr

RUNCS          DW      0       ; Runtime Code Seg
RUNDS          DW      0       ; Runtime Data Seg
RUNES          DW      0       ; Runtime Extra Seg
RUNFS          DW      0       ; Runtime Far Seg
PSPES          DW      0       ; PSP Seg
BIOS_SEG       DW      40h     ; ROM Bios RAM Data
GRAF_SEG       DW      0A000h  ; Graphics Video Buffer
TEXT_SEG       DW      0B000h  ; Text Video Buffer
VBUF_SEG       DW      0B800h  ; Color Video Buffer Addr
VBUF_MODE      DB      3       ; Video Mode
RESTFLAG       DB      0
VPAGE_LEN      DW      0       ; DOS Screen Bytes

FST_LOC        DW      0       ; Loc after Msgs
SKPFLAG        DB      0       ; 1=Skip Desc/No output
KBDESC         DB      134 DUP(0)
LSTMKC         DB      0       ; last actual char col +1
KBSTAT         DW      0       ; Kybd Stat Flag
CLOCK          DB      0       ; .nn last

DTAFIND        DB      30 DUP (?)  ; 256 Byte DTA
DTAFSPEC       DB      226 DUP (?)  ; Offset 30=FSpec

TERMMSG        DB      13,10, 'DTRate termination Level '
ELEVEL         DB      3 DUP (32), 13, 10, '$'

CSR_LOC        Label   Word    ; Current Cursor Location
CSR_ROW        DB      0       ;  "  Row (0-43)
CSR_COL        DB      0       ;  "  Col (0-131)
SAV_LOC        DW      0       ; Entry Loc
KEY_LOC        DW      0       ; Hilight

SRD_TME        DD      0
SWR_TME        DD      0
SDO_TME        DD      0
SMV_TME        DD      0
SCO_TME        DD      0
SSS_TME        DD      0

FSPECWC        DB      64 DUP(0)
STFSPEC        DB      '  Drive:\Data ',247,'  '
DTRFILE        DB      'd:\$DTvvv$   '
               DB      '  Algorithm ',247,'  '
DTRALGO        DB      '4k +8k +(1k x4) +16k',0,'$'
STFSL          Equ     $-STFSPEC-1
RATEMSG        DB      247,'   '
ASCRATE        DB      'nn,nnn kBytes/Sec',0,'$'
COUNT          DB      0
RFLAG          DB      0       ; 1=2nd Pass
TICKS          DW      0

ROOT           DB      'd:\',0         ;Root Path
RC             DB      0               ;Return Code
PROCESS        DB      'DTRate.Exe',0

; ----------------------------------------------------------------------
; Data Constants
               .CONST
BIOS10h        EQU     10h             ;BIOS Video Int
BIOS16h        EQU     16h             ;BIOS Kybd Int
DOS            EQU     21h             ;DOS Sys Func Req Int
ZERO           DB      0
SPACE          DB      ' '
DOLLAR         DB      '$'

SUPMSG         DB      'AEon {tm}  Micro x86  BUS Transfer Bench'
               DB      'mark  Version 1.0B'
               DB      13,10
               DB      'Propriety I.P. 1996  AEon Concepts  All '
               DB      'rights reserved.'
               DB      13,10,10,16,32
               DB      'Describe System Make/Model, CPU type & M'
               DB      'Hz, Drive C: Seek mSec & Bytes, etc.'
               DB      32,17,13,10,32,32
               DB      'Press ESC to BYPASS Input & Report optio'
               DB      'ns, else type TITLE then press ENTER'
               DB      13,10,32,32
               DB      ' Use Home, End, Backspace and Cursor Lef'
               DB      't or Right to EDIT Title description'
               DB      13,10,10
               DB      '? $'

SKIP_MSG       DB      16,' Report output skipped ...$'
BENCH_MSG      DB      16,' Writing Benchmark results to '
BENCHDRV       DB      'd:DTRate.Rpt ...$'
ENTER_MSG      DB      ' Press any key to continue ',17,' $'
CRLF           DB      13,10, 0,'$'
SPACES         DB      78 DUP(32),0
LMARKER        DB      175
RMARKER        DB      174
TXTFILE        DB      'DTRate.Rpt',0
TMSG1          DB      'Start'
TMSG2          DB      'Stop'

BUFFLEN        DW      DTABL   ;*** Must be = DTABUFF len above! ***
MAXREC         Equ     61      ; 2*(1000*1000)/DTABL
ONEkBs         Equ     36400   ; 2000 Bytes @ 18.2 Clicks = 1kB in 1 Sec
HALFkBs        Equ     ONEkBs/2
TWOkBs         Equ     ONEkBs*2
FOURkBs        Equ     ONEkBs*4
EIGHTkBs       Equ     ONEkBs*8
TICKMIP        Equ     16      ; Ticks for MIPS
ALGOMIP        Equ     879     ; 1000*(TICKMIP/18.2) Scaling Factor

SRD_LOC        DW      0A05h    ; Row 5, Col 10
SWR_LOC        DW      0A06h    ; Row 6
SDO_LOC        DW      0A07h    ; Row 7
READMSG        DB      ' Algorithm Data Read  Transfer .. ',0,'$'
WRITEMSG       DB      ' Algorithm Data Write Transfer .. ',0,'$'
DONEMSG        DB      ' Composite R/W Rate { NORMALized }',0,'$'

SRD_LOC2       DW      0A09h    ; Row 9
SWR_LOC2       DW      0A0Ah    ; Row 10
SDO_LOC2       DW      0A0Bh    ; Row 11
READMSG2       DB      ' Buffered 32kB Read  Transfer ... ',0,'$'
WRITEMSG2      DB      ' Buffered 32kB Write Transfer ... ',0,'$'
DONEMSG2       DB      ' Composite R/W Rate { FAST Cache }',0,'$'

SMV_LOC1       DW      0A0Fh    ; Row 15
SMV_LOC2       DW      0A0Eh    ; Row 14
SMV_LOC3       DW      0A0Dh    ; Row 13
SMV_LOC4       DW      0A10h    ; Row 16
SMV_LOCV       DW      0A11h    ; Row 17
SMV_LOC5       DW      0A12h    ; Row 18
MOVEMSG1       DB      '  8 Bit RAM to Video Data Transfer',0,'$'
MOVEMSG2       DB      ' 16 Bit RAM to Video Data Transfer',0,'$'
MOVEMSG3       DB      ' 32 Bit RAM to Video Data Transfer',0,'$'
MOVEMSG4       DB      ' 32 Bit RAM to  RAM  Data Transfer',0,'$'
MOVEMSGV       DB      '  8 Bit Video to Video D. Transfer',0,'$'
MOVEMSG5       DB      ' Composite RAM/VIDEO Transfer Rate',0,'$'

SCO_LOC        DW      0A14h    ; Row 20
COMPMSG        DB      ' Composite BUS Data Transfer Rate ',0,'$'

SSS_LOC        DW      1D15h    ; Row 21, Col 29
MIPSMSG        DB      '  MIpS   ',17,' ',0

CSR_RITE       DB      27,'[1C$'  ;Csr Right x 1
CSR_BACK       DB      27,'[1D', 27,'[1D$'  ;Bksp x 1

MAIN_SCR       DB      80 DUP(32,3)
               DB      213,25, 78 DUP(205,25),184,25
MAIN_SCRL      EQU     $-MAIN_SCR

DETAIL         DB      179,25, 78 DUP(32,19), 179,25
DETAILL        EQU     $-DETAIL
DETAIL2        DB      179,25, 9 DUP(32,19), 57 DUP(32,23)
               DB      12 DUP(32,19), 179,25
DETAIL2L       EQU     $-DETAIL2

MAIN_SCR2      DB      212,25, 78 DUP(205,25), 190,25
               DB      80 DUP(32,7)
               DB      80 DUP(32,48)
MAIN_SCR2L     EQU     $-MAIN_SCR2

TITLE_LOC      DB      0,21    ;Title
TME_LOC        Label   Word    ; Start
               DB      21,9
TME_LOC2       Label   Word    ; Stop
               DB      21,65
MSG_LOC        Label   Word
               DB      23,1    ; Msg Row/Col
MAIN_CSR       DB      13,43   ;Cursor 1st
MAIN_CSR2      DB      14,43
ACT_LOC        DB      17,13   ;Action Loc

; Colors: 
CO_TITLE       DB      11      ;Title      Hi-Cyan
CO_KEYS        DB      30      ;Opt Keys   Hi-Yellow on Blue (+16)
CO_TEXT        DB      19      ;Text       Cyan on Blue
CO_MSG         DB      11      ;Messages   Hi-Cyan
CO_LOGO        DB      48      ;Logo/Date  Rev-Cyan
CO_TME         DB      7       ; Clock     White on Black
CO_KEY         DB      27      ; Prompt    Hi-White on Blue

;Msg Table: 0-Row, 1-Col, 2-Addr, 4-Len
MAIN_MTBL      DB      0,TTL_LOC  ; Title
               DW      TITLEX
               DB      TITLEXL+128

               DB      2,5     ; d:\FSpec
               DW      STFSPEC
               DB      STFSL
               DB      2,22    ; d: Hi
               DW      DTRFILE
               DB      2+128
               DB      2,50    ; Algo Hi
               DW      DTRALGO
               DB      20+128
               DB      3,8     ; 1st Field: Flags
               DW      OPT_B
               DB      OPT_BL
               DB      3,8+CPUIDO
               DW      CPUID
               DB      2+128
               DB      3,8+ATRAMO
               DW      ATRAM
               DB      5+128
               DB      3,8+EQSBO
               DW      EQSB
               DB      12+128
               DB      3,8+DVFLGO
               DW      DVFLG
               DB      3+128

               DB      7,8     ; Left Marker
               DW      LMARKER
               DB      1+128
               DB      11,8    ; "
               DW      LMARKER
               DB      1+128
               DB      18,8    ; "
               DW      LMARKER
               DB      1+128
               DB      20,8    ; "
               DW      LMARKER
               DB      1+128
               DB      21,3    ; Start Msg
               DW      TMSG1
               DB      5

               DB      7,68    ; Right Marker
               DW      RMARKER
               DB      1+128
               DB      11,68   ; "
               DW      RMARKER
               DB      1+128
               DB      18,68   ; "
               DW      RMARKER
               DB      1+128
               DB      20,68   ; "
               DW      RMARKER
               DB      1+128
               DB      21,60   ; Stop Msg
               DW      TMSG2
               DB      4

               DB      24,2    ; Version
               DW      VERSION
               DB      VERSIONL
               DB      24,LEG_LOC  ; (c)
               DW      LEGEND
               DB      LEGENDL
               DB      24,59   ; Date
               DW      ASC_DATE
               DB      ASC_DATEL
               DB      5 DUP(0FFh)  ; EOT

TITLEX         DB      4 DUP(176),4 DUP(177),4 DUP(178),179
               DB      '    Micro  x86  BUS Transfer Benchmark   '
               DB      179,4 DUP(178),4 DUP(177),4 DUP(176)
TITLEXL        EQU     $-TITLEX
TTL_LOC        EQU     ((80-TITLEXL)/2)-1

; ----------------------------------------------------------- Version --
STVERS         LABEL   BYTE
VERSION        DB      'DTRate v1.0B  DOS '
DOSVER         DB      'ah.al '
VERSIONL       EQU     $-VERSION
               DB      ' Loading ...',0,'$'
LEGEND         DB      ' Propriety {IP} AEon Concepts '
LEGENDL        EQU     $-LEGEND
LEG_LOC        EQU     ((80-LEGENDL)/2)+((VERSIONL-ASC_DATEL)/2)

ROMBMSG        Label   Byte
OPT_B          DB      'BIOSystem  ',247,'   CPU '
CPUIDO         EQU     $-ROMBMSG
CPUID          DB      'xx   '
ATRAMO         EQU     $-ROMBMSG
ATRAM          DB      '--- 0 kB   '
EQSBO          EQU     $-ROMBMSG
EQSB           DB      'g p- s- u ab    Verify '
DVFLGO         Equ     $-ROMBMSG
DVFLG          DB      'OFF '
OPT_BL         EQU     $-OPT_B

; Memory Map  ( Data Seg = .DATA + .DATA? + .STACK )
;     Seg Name :   HDR   +  PSP  +  Data  +  Code  =   Total
;    Max Alloc :    16   +  256  +  64kB  +  64kB  = 131,344
;   16 =Pages :     1   +   16  +  4096  +  4096  =   8,209
; ( also PSPSeg:0002 xWord = 1st Byte Unused RAM! )
PBPAGES        DW      8209

PATCH          DD      16 DUP(0FFh)  ; 64 bytes Patch

; ----------------------------------------------------------------------
; Mainline Code (Logic Stuff)
               .CODE

Start:         mov     ax,@data  ; Data Seg Addr
               mov     ds,ax
               mov     RUNDS,ax
               mov     es,ax   ; Extra Seg=Data
               mov     RUNES,ax
               mov     RUNFS,cs  ; Far Seg=Code Seg
               mov     RUNCS,cs

               cli             ; Stack Seg=Data
               mov     ss,ax
               mov     sp,OFFSET STACK
               sti

; Free extra RAM
               mov     ah,62h  ; Get PSP Seg
               int     DOS
               mov     PSPES,bx  ; 1st Seg/Page
               mov     es,bx

               mov     ax,RUNDS  ; Calculate ACTUAL Size  <==
               mov     bx,sp   ; Convert Stack Ptr to Paras
               mov     cl,4
               shr     bx,cl   ;   to get Stack Size (/16)
               add     ax,bx   ; Add Stack Pages to DS (End of Pgm)
               mov     bx,es   ; Get Start of Program (PSP)
               sub     ax,bx   ; Subtract Start from End
               inc     ax      ; +1 for ?
;               mov     bx,PBPAGES  ; (to Plug Max No. Pages)
               mov     bx,ax   ; Now actual Seg/Page Size

               xor     al,al
               mov     ah,4Ah  ; Re-Allocate
               int     DOS
               jnc     Short @F
               jmp     ERR_SET

; Verify DOS >= 6.0
@@:            @GET_VER
               cmp     al,6
               jge     Short @F
               mov     RC,99
               jmp     ERR_EXIT

@@:            push    ax
               mov     ZBYTE,al
               call    BIN_DEC1
               mov     ax,Word Ptr DECIMAL+6
               cmp     al,'0'
               jne     Short @F
               mov     al,'v'
@@:            mov     Word Ptr DOSVER,ax
               pop     ax
               mov     ZBYTE,ah
               call    BIN_DEC1
               mov     ax,Word Ptr DECIMAL+6
               mov     Word Ptr DOSVER+3,ax

; Sys Hardware Info
               mov     bx,Offset HEXTABLE
               mov     ax,0F000h  ; cpu ID
               mov     es,ax
               mov     al,es:[0FFFEh]
               mov     es,RUNES
               mov     Word Ptr CPUID,'CP'
               cmp     al,0FFh
               je      Short @F
               mov     Word Ptr CPUID,'TX'
               cmp     al,0FEh
               je      Short @F
               mov     Word Ptr CPUID,'rJ'
               cmp     al,0FDh
               je      Short @F
               mov     Word Ptr CPUID,'TA'
               cmp     al,0FCh
               je      Short @F
               mov     ah,al   ; Unknown
               mov     cl,4
               shr     al,cl
               xlat
               mov     CPUID,al
               mov     al,ah
               and     al,0Fh
               xlat
               mov     CPUID+1,al

@@:            mov     ax,Word Ptr VERSION+8  ; FSpec $DTvvv$$
               mov     Word Ptr DTRFILE+6,ax
               mov     ax,Word Ptr VERSION+10
               mov     Word Ptr DTRFILE+7,ax

               int     11h     ; Bios Eq Stat
               push    ax
               mov     bx,Offset EQSB

               mov     al,'g'
               test    ah,16   ; Game bit
               jz      Short @F
               mov     al,'G'
@@:            mov     [bx],al
               inc     bx
               inc     bx

               mov     cl,6
               shr     ah,cl   ; Parallel
               mov     Byte Ptr [bx],'P'
               inc     bx
               add     ah,48
               mov     [bx],ah
               inc     bx
               inc     bx

               pop     ax
               shr     ah,1    ; Serial
               and     ah,111b
               mov     Byte Ptr [bx],'S'
               inc     bx
               add     ah,48
               mov     [bx],ah
               inc     bx
               inc     bx

               mov     ah,'u'
               test    al,2    ; Co uP
               jz      Short @F
               mov     ah,'U'
@@:            mov     [bx],ah
               inc     bx
               inc     bx

               cmp     Word Ptr CPUID,'TA'
               jne     Short END_BIOS

               mov     dx,70h  ; Config Chip Port
               mov     al,14h  ; Reg
               out     dx,al
               inc     dx      ; Data 71h
               in      al,dx

               mov     ah,al
               mov     dx,'ba'
               test    al,1    ; Floppies?
               jz      Short @F
               mov     dl,'A'
               test    al,64   ; B?
               jz      Short @F
               mov     dh,'B'
@@:            mov     [bx],dx

               mov     dx,70h  ; Get Ext RAM Lsb
               mov     al,30h
               out     dx,al
               inc     dx
               in      al,dx
               mov     bl,al

               dec     dx      ;  "  Msb
               mov     al,31h
               out     dx,al
               inc     dx
               in      al,dx
               mov     bh,al

               add     bx,640  ; plus DOS 640kB
               add     bx,256  ; plus Adapters
               mov     ZWORD,bx
               call    BIN_DEC2
               mov     si,Offset DECIMAL+3
               mov     di,Offset ATRAM
               mov     cx,5
               cld
@@:            lodsb
               cmp     al,'0'
               jne     Short @F
               mov     al,' '
               stosb
               loop    Short @B
               jmp     short END_BIOS
@@:            stosb
               dec     cx
               rep     movsb

END_BIOS:      mov     ax,2E00h  ; Verify OFF
               int     DOS

               @GET_DTA        ; PSP+80h=Cmd Args
               push    ds
               push    es
               mov     ax,RUNES
               mov     es,ax
               mov     di,OFFSET DTRFILE
               pop     ds      ; Store Drive
               mov     si,bx
               mov     al,[si]
               cmp     al,2    ; Len=1 if No args
               jge     Short @F
               pop     ds      ; Restore ds!
               jmp     Short NODRV

@@:            xor     ch,ch
               mov     cl,al
               dec     cl
               inc     si
               inc     si
               cld
               lodsb           ; Drive Letter ONLY
               and     al,223  ; Uppercase
               stosb
               pop     ds

NODRV:         mov     dx,OFFSET DTAFIND  ; Private DTA
               @SET_DTA
               @GET_CSR        ; Save Csr Pos
               mov     SAV_LOC,dx

               mov     ah,15   ; Cur Mode?
               int     BIOS10h
               cmp     al,VBUF_MODE
               jne     Short NOSAVE

               xor     si,si   ; Save screen
               mov     di,Offset SCRBUFF
               mov     cx,SCRBL
               shr     cx,2
               push    ds
               mov     ds,VBUF_SEG
               cld
               rep     movsd
               pop     ds
               mov     RESTFLAG,1  ; Set Restore=Yes

NOSAVE:        mov     al,VBUF_MODE  ; Mode=3 Color Txt
               or      al,128  ; as is
               xor     ah,ah
               xor     bx,bx
               int     BIOS10h

               cmp     CSR_ROW,0
               je      Short @F
               sub     CSR_ROW,1

@@:            mov     CSR_COL,0
               @SET_CSR

               mov     ax,40h  ; ROM Seg
               mov     es,ax
               mov     ax,es:[17h]  ; Save Kybd Stat
               mov     KBSTAT,ax
;               or      al,01000000b  ; CAPS Lock ON
;               mov     es:[17h],ax
               mov     es,RUNES

               mov     ax,40h  ; ROM-BIOS RAM-Data Seg
               mov     es,ax
               mov     ax,es:[4Ch]  ; Vid Bytes
               mov     es,RUNES
               mov     VPAGE_LEN,ax

               mov     bl,0    ; 25 lines

               cmp     ax,6880  ; 43?
               jl      Short @F
               mov     bl,18

@@:            cmp     ax,8000
               jl      Short @F
               mov     bl,25

@@:            mov     VADD,bl
               cmp     bl,0    ; Adj lines
               je      Short @F
               add     Byte Ptr MSG_LOC,bl

@@:            nop

               PAGE
; ----------------------------------------------------------------------
; Re-entrant
RESTART:       call    GET_DTE  ; Sys Date
               call    GET_TME

               @GET_DRV        ; Cur Drive
               mov     BENCHDRV,ah
               cmp     DTRFILE,'d'
               jne     Short @F
               mov     DTRFILE,ah

@@:            mov     si,Offset DTRFILE
               mov     di,Offset FSPECWC
               mov     cx,3
               cld
               rep     movsd

               mov     ah,1    ; Blk Csr
               xor     al,al
               mov     ch,0    ; Top
               mov     cl,13   ; Bottom
               xor     bx,bx   ; CRT/CPU Page or Attr
               xor     dx,dx   ; Row/Col
               int     BIOS10h   

               mov     dx,Offset SUPMSG
               @PUT_STR
               @GET_CSR
               mov     ax,CSR_LOC
               mov     FST_LOC,ax

               sub     al,3
               mov     KEY_LOC,ax
               mov     bx,Offset KEY_LOC
               call    VCALC
               mov     ah,CO_KEY
               mov     cx,80
               mov     es,VBUF_SEG
               cld
@@:            mov     al,es:[di]
               stosw
               loop    @B
               mov     es,RUNES
               call    SPEAKIT

NEWDCMD:       mov     ax,FST_LOC
               mov     LSTMKC,ah
               mov     CSR_LOC,ax
               mov     bx,Offset FST_LOC
               call    VCALC
               mov     ah,CO_TME
               mov     si,Offset SPACES
               call    VMOVZ

DOSMKEY:       @SET_CSR
               @GET_KEY

               cmp     al,27   ; Esc?
               jne     Short @F
               mov     ah,Byte Ptr FST_LOC+1
               cmp     LSTMKC,ah
               jne     Short NEWDCMD
               mov     SKPFLAG,1  ; No Input or Save
               jmp     DOSCR

@@:            cmp     al,8    ; Bs?
               jne     Short CHKMKT
               mov     ah,Byte Ptr FST_LOC+1
               cmp     LSTMKC,ah
               je      BADMKEY
               cmp     CSR_COL,0
               je      BADMKEY

               dec     CSR_COL
               @SET_CSR
               mov     dl,' '
               @PUT_CHR
               mov     al,LSTMKC
               dec     al
               cmp     al,CSR_COL
               jne     Short DOSMKEY
               mov     LSTMKC,al
               jmp     Short DOSMKEY

CHKMKT:        cmp     al,9    ; Tab?
               jne     Short @F
               cmp     CSR_COL,75
               jg      BADMKEY
               add     CSR_COL,4
               jmp     Short DOSMKEY

@@:            cmp     al,13   ; Enter?
               je      GOTMKEYS

               cmp     al,0    ; Ext'd?
               je      Short EXTMK2
               cmp     LSTMKC,127
               jge     BADMKEY

               mov     dl,al   ; No, Good key
               @PUT_CHR
               @GET_CSR
               cmp     dl,Byte Ptr FST_LOC
               je      Short @F
               mov     dl,Byte Ptr FST_LOC
               inc     dl
               mov     CSR_ROW,dl
               add     dh,80

@@:            cmp     dh,LSTMKC
               jle     Short @F
               mov     LSTMKC,dh
@@:            jmp     DOSMKEY

EXTMK2:        @GET_KEY        ; 2nd Code
               cmp     al,75   ; Left?
               jne     Short CHKMKL
               mov     ah,Byte Ptr FST_LOC+1
               cmp     LSTMKC,ah
               je      Short BADMKEY
               cmp     CSR_COL,0
               jg      Short @F 
               dec     CSR_ROW
               mov     CSR_COL,80

@@:            dec     CSR_COL
               jmp     DOSMKEY

CHKMKL:        cmp     al,77   ; Right?
               jne     Short @F
               cmp     LSTMKC,127
               jge     Short BADMKEY
               inc     CSR_COL
               cmp     CSR_COL,80
               jl      DOSMKEY
               inc     CSR_ROW
               mov     ah,Byte Ptr FST_LOC+1
               mov     CSR_COL,ah
               jmp     DOSMKEY

@@:            cmp     al,71   ; Home?
               jne     Short @F
               mov     ax,FST_LOC
               mov     CSR_LOC,ax
               jmp     DOSMKEY

@@:            cmp     al,79   ; End?
               jne     Short @F
               call    SETMKC
               jmp     DOSMKEY

@@:            nop

BADMKEY:       call    SPEAKER
               jmp     DOSMKEY

SETMKC:        mov     ax,FST_LOC
               mov     ah,LSTMKC
               mov     CSR_LOC,ax
               cmp     CSR_COL,80
               jl      Short @F
               inc     CSR_ROW
               sub     CSR_COL,80
@@:            ret

GOTMKEYS:      mov     ah,Byte Ptr FST_LOC+1
               cmp     LSTMKC,ah
               jne     Short @F
               mov     SKPFLAG,1
               jmp     Short DOSCR

@@:            mov     fs,VBUF_SEG 
               xor     ah,ah
               mov     al,Byte Ptr FST_LOC
               mov     cx,160
               xor     dx,dx
               mul     cx
               mov     si,ax
               mov     di,Offset KBDESC
               xor     ch,ch
               inc     LSTMKC
               mov     cl,LSTMKC
               cld

@@:            mov     al,fs:[si]
               stosb
               add     si,2
               loop    @B
               mov     ax,Word Ptr CRLF
               stosw
               stosw
               add     LSTMKC,4
               mov     fs,RUNFS

DOSCR:         mov     si,Offset MAIN_SCR  ; Display Screen Top
               mov     es,VBUF_SEG
               xor     di,di
               mov     cx,MAIN_SCRL
               shr     cx,2
               cld
               rep     movsd

               mov     cx,2
@@:            push    cx
               mov     si,Offset DETAIL  ; Top 2 Detail
               mov     cx,DETAILL
               shr     cx,2
               cld
               rep     movsd
               pop     cx
               loop    @B

               xor     ch,ch   ; Detail lines
               mov     cl,END_VTM
               sub     cl,4
               cmp     VADD,0  ; 43/50 lines
               je      Short @F
               add     cl,VADD

@@:            push    cx
               mov     si,Offset DETAIL2  ; Next
               mov     cx,DETAIL2L
               shr     cx,2
               cld
               rep     movsd
               pop     cx
               loop    @B

               mov     si,Offset MAIN_SCR2  ; Bottom
               mov     cx,MAIN_SCR2L
               shr     cx,2
               cld
               rep     movsd
               mov     es,RUNES

               mov     bx,OFFSET MAIN_MTBL  ; Fields
               call    VTMOVE

               mov     bx,Offset TME_LOC
               call    VCALC
               mov     ah,CO_TME
               mov     si,Offset ASC_TOD
               call    VMOVZ

               cmp     SKPFLAG,1
               jne     Short @F
               mov     ax,Word Ptr MSG_LOC  ; Msg Loc
               mov     CSR_LOC,ax
               @SET_CSR
               mov     dx,Offset SKIP_MSG
               @PUT_STR

; ----------------------------------------------------------------------
; Write Random Data to Disk per Algorithm

@@:            mov     di,Offset DTABUFF  ; Random Data
               mov     cx,BUFFLEN
               shr     cx,2
               mov     fs,BIOS_SEG
               mov     ebx,0AAE7CCFFh
               cld
@@:            mov     ax,fs:[6Ch]
               shl     eax,cl
               mov     ax,di
               xor     eax,ebx
               rol     ebx,3
               stosd
               loop    @B
               mov     fs,RUNFS
               xor     eax,eax
               xor     ebx,ebx

               mov     dx,Offset FSPECWC  ; Create Output
               xor     cx,cx
               @CREATEF

               mov     ax,SWR_LOC
               mov     CSR_LOC,ax
               @SET_CSR
               mov     dx,Offset WRITEMSG
               @PUT_STR

               call    W4TICK
               mov     SWR_TME,eax  ; Start Time

               call    SPEAKIT
               mov     COUNT,0

WLOOP:         mov     dx,OFFSET DTABUFF  ; Write 4k
               mov     cx,4096
               mov     bx,PBFH
               @WRITEF

               mov     dx,OFFSET DTABUFF  ; Write 8k
               mov     cx,8192
               mov     bx,PBFH
               @WRITEF

               mov     cx,4
W1K:           push    cx
               mov     dx,OFFSET DTABUFF  ; Write 1k * 4
               mov     cx,1024
               mov     bx,PBFH
               @WRITEF
               pop     cx
               loop    W1K

               mov     dx,OFFSET DTABUFF  ; Write 16k
               mov     cx,16384
               mov     bx,PBFH
               @WRITEF

               add     COUNT,2
               cmp     COUNT,MAXREC  ; 512kB?
               jl      WLOOP

               call    W4TICK  ; Stop Time
               mov     ecx,eax
               sub     ecx,SWR_TME  ; Elapsed clicks
               mov     SDO_TME,ecx
               mov     SCO_TME,ecx
               mov     eax,HALFkBs  ; 1/2 kB/Sec
               xor     ebx,ebx
               xor     edx,edx
               div     ecx

               mov     ZWORD,ax  ; Write kB/Sec
               call    BIN_DEC2
               call    DORATE
               mov     dx,Offset RATEMSG
               @PUT_STR

               mov     bx,PBFH
               @CLOSEF

; ----------------------------------------------------------------------
; Read back in
               mov     dx,Offset FSPECWC
               xor     ax,ax
               @OPENF

               mov     ax,SRD_LOC
               mov     CSR_LOC,ax
               @SET_CSR
               mov     dx,Offset READMSG
               @PUT_STR

               call    W4TICK
               mov     SRD_TME,eax  ; Start Time

               call    SPEAKIT
               mov     COUNT,0

RLOOP:         mov     dx,OFFSET DTABUFF  ; Read 4k
               mov     cx,4096
               mov     bx,PBFH
               @READF

               cmp     ax,4096  ; Full Read?
               je      Short @F
               mov     RC,109
               jmp     ERR_EXIT

@@:            mov     dx,OFFSET DTABUFF  ; Read 8k
               mov     cx,8192
               mov     bx,PBFH
               @READF

               cmp     ax,8192  ; Full Read?
               je      Short @F
               mov     RC,109
               jmp     ERR_EXIT

@@:            mov     cx,4

R1K:           push    cx
               mov     dx,OFFSET DTABUFF  ; Read 1k * 4
               mov     cx,1024
               mov     bx,PBFH
               @READF

               cmp     ax,1024  ; Full Read?
               je      Short @F
               pop     cx
               mov     RC,109
               jmp     ERR_EXIT

@@:            pop     cx
               loop    R1K

               mov     dx,OFFSET DTABUFF  ; Read 16k
               mov     cx,16384
               mov     bx,PBFH
               @READF

               cmp     ax,16384  ; Full Read?
               je      Short @F
               mov     RC,109
               jmp     ERR_EXIT

@@:            add     COUNT,2
               cmp     COUNT,MAXREC
               jl      RLOOP

               cmp     RFLAG,1  ; Twice = 1MB
               je      Short OK2ndAR
               mov     COUNT,0
               mov     bx,PBFH
               xor     cx,cx
               xor     dx,dx
               xor     al,al   ; TOF
               @STARTF
               mov     RFLAG,1
               jmp     RLOOP

OK2ndAR:       call    W4TICK  ; Stop Time
               mov     ecx,eax
               sub     ecx,SRD_TME  ; Elapsed clicks
               add     SDO_TME,ecx
               add     SCO_TME,ecx
               mov     eax,ONEkBs  ; 1kB/Sec
               xor     ebx,ebx
               xor     edx,edx
               div     ecx

               mov     ZWORD,ax  ; Read kB/Sec
               call    BIN_DEC2
               call    DORATE
               mov     dx,Offset RATEMSG
               @PUT_STR

               mov     bx,PBFH
               @CLOSEF

; ----------------------------------------------------------------------
               mov     ax,SDO_LOC
               mov     CSR_LOC,ax
               @SET_CSR
               mov     dx,Offset DONEMSG
               @PUT_STR

               mov     ecx,SDO_TME  ; Tot Access Time
               mov     eax,ONEkBs  ; 1.5 @ 1kB/Sec
               add     eax,HALFkBs
               xor     ebx,ebx
               xor     edx,edx
               div     ecx

               mov     ZWORD,ax
               call    BIN_DEC2
               call    DORATE
               mov     dx,Offset RATEMSG
               @PUT_STR

               mov     dx,OFFSET FSPECWC  ; Delete Work file
               @DELETEF

; ----------------------------------------------------------------------
; Write pattern data out @ 32k Buffer

               mov     di,Offset DTABUFF  ; Pattern Data
               mov     cx,BUFFLEN
               shr     cx,2
               mov     eax,0AAE7CCFFh
               cld
               rep     stosd
               xor     eax,eax
               xor     ebx,ebx

               mov     dx,Offset FSPECWC  ; Create Output
               xor     cx,cx
               @CREATEF

               mov     ax,SWR_LOC2
               mov     CSR_LOC,ax
               @SET_CSR
               mov     dx,Offset WRITEMSG2
               @PUT_STR

               call    W4TICK
               mov     SWR_TME,eax  ; Start Time

               call    SPEAKIT
               mov     COUNT,0

WLOOP2:        mov     dx,OFFSET DTABUFF  ; Write 32k
               mov     cx,BUFFLEN
               mov     bx,PBFH
               @WRITEF

               add     COUNT,1
               cmp     COUNT,MAXREC  ; xMB?
               jl      WLOOP2

               call    W4TICK  ; Stop Time
               mov     ecx,eax
               sub     ecx,SWR_TME  ; Elapsed clicks
               mov     SDO_TME,ecx
               add     SCO_TME,ecx
               mov     eax,ONEkBs  ; 1kB/Sec
               xor     ebx,ebx
               xor     edx,edx
               div     ecx

               mov     ZWORD,ax  ; Write kB/Sec
               call    BIN_DEC2
               call    DORATE
               mov     dx,Offset RATEMSG
               @PUT_STR

               mov     bx,PBFH
               @CLOSEF

; ----------------------------------------------------------------------
; Read back in @ 32k
               mov     dx,Offset FSPECWC
               xor     ax,ax
               @OPENF

               mov     ax,SRD_LOC2
               mov     CSR_LOC,ax
               @SET_CSR
               mov     dx,Offset READMSG2
               @PUT_STR

               call    W4TICK
               mov     SRD_TME,eax  ; Start Time

               call    SPEAKIT
               mov     COUNT,0

RLOOP2:        mov     dx,OFFSET DTABUFF  ; Read 32k
               mov     cx,BUFFLEN
               mov     bx,PBFH
               @READF

               cmp     ax,BUFFLEN  ; Full Read?
               je      Short @F
               mov     RC,109
               jmp     ERR_EXIT

@@:            add     COUNT,1
               cmp     COUNT,MAXREC
               jl      RLOOP2

               call    W4TICK  ; Stop Time
               mov     ecx,eax
               sub     ecx,SRD_TME  ; Elapsed clicks
               add     SDO_TME,ecx
               add     SCO_TME,ecx
               mov     eax,ONEkBs  ; 1kB/Sec
               xor     ebx,ebx
               xor     edx,edx
               div     ecx

               mov     ZWORD,ax  ; Read kB/Sec
               call    BIN_DEC2
               call    DORATE
               mov     dx,Offset RATEMSG
               @PUT_STR

               mov     bx,PBFH
               @CLOSEF

; ----------------------------------------------------------------------
               mov     ax,SDO_LOC2
               mov     CSR_LOC,ax
               @SET_CSR
               mov     dx,Offset DONEMSG2
               @PUT_STR

               mov     ecx,SDO_TME  ; Tot Access Time
               mov     eax,TWOkBs  ; 2 @ 1kB/Sec
               xor     ebx,ebx
               xor     edx,edx
               div     ecx

               mov     ZWORD,ax
               call    BIN_DEC2
               call    DORATE
               mov     dx,Offset RATEMSG
               @PUT_STR

               mov     dx,OFFSET FSPECWC  ; Delete Work file
               @DELETEF

; ----------------------------------------------------------------------
; Memory Move @ 8/16/32 bits
               mov     ax,SMV_LOC1
               mov     CSR_LOC,ax
               @SET_CSR
               mov     dx,Offset MOVEMSG1  ; 8 bit mode
               @PUT_STR

               call    W4TICK
               mov     SMV_TME,eax  ; Start Time

               call    SPEAKIT
               mov     es,GRAF_SEG
               mov     cx,MAXREC  ; xMB / 32,768

@@:            push    cx
               mov     cx,BUFFLEN
               mov     di,0
               mov     si,Offset DTABUFF
               cld
               rep     movsb   ; Move 32k
               pop     cx
               loop    @B      ; Repeat to xM

               mov     es,RUNES
               call    W4TICK  ; Stop Time
               mov     ecx,eax
               sub     ecx,SMV_TME  ; Elapsed clicks
               mov     SDO_TME,ecx
               add     SCO_TME,ecx
               mov     eax,ONEkBs  ; 1kB/Sec
               xor     ebx,ebx
               xor     edx,edx
               div     ecx

               mov     ZWORD,ax  ; Byte Move kB/Sec
               call    BIN_DEC2
               call    DORATE
               mov     dx,Offset RATEMSG
               @PUT_STR

; ----------------------------------------------------------------------
               mov     ax,SMV_LOC2
               mov     CSR_LOC,ax
               @SET_CSR
               mov     dx,Offset MOVEMSG2  ; 16 bit mode
               @PUT_STR

               call    W4TICK
               mov     SMV_TME,eax  ; Start Time

               call    SPEAKIT
               mov     es,GRAF_SEG
               mov     cx,MAXREC  ; MB / 32,768
               shl     cx,1    ; x2

@@:            push    cx
               mov     cx,BUFFLEN
               shr     cx,1
               mov     di,0
               mov     si,Offset DTABUFF
               cld
               rep     movsw   ; Move 32k
               pop     cx
               loop    @B      ; Repeat to xM

               mov     es,RUNES
               call    W4TICK  ; Stop Time
               mov     ecx,eax
               sub     ecx,SMV_TME  ; Elapsed clicks
               add     SDO_TME,ecx
               add     SCO_TME,ecx
               mov     eax,TWOkBs  ; 2 * 1kB/Sec
               xor     ebx,ebx
               xor     edx,edx
               div     ecx

               mov     ZWORD,ax  ; Word Move kB/Sec
               call    BIN_DEC2
               call    DORATE
               mov     dx,Offset RATEMSG
               @PUT_STR

; ----------------------------------------------------------------------
               mov     ax,SMV_LOC3
               mov     CSR_LOC,ax
               @SET_CSR
               mov     dx,Offset MOVEMSG3  ; 32 bit mode
               @PUT_STR

               call    W4TICK
               mov     SMV_TME,eax  ; Start Time

               call    SPEAKIT
               mov     es,GRAF_SEG
               mov     cx,MAXREC  ; MB / 32,768
               shl     cx,1    ; x2

@@:            push    cx
               mov     cx,BUFFLEN
               shr     cx,2
               mov     di,0
               mov     si,Offset DTABUFF
               cld
               rep     movsd   ; Move 32k
               pop     cx
               loop    @B      ; Repeat to xM

               mov     es,RUNES
               call    W4TICK  ; Stop Time
               mov     ecx,eax
               sub     ecx,SMV_TME  ; Elapsed clicks
               add     SDO_TME,ecx
               add     SCO_TME,ecx
               mov     eax,TWOkBs  ; 2 * 1kB/Sec
               xor     ebx,ebx
               xor     edx,edx
               div     ecx

               mov     ZWORD,ax  ; DWord Move kB/Sec
               call    BIN_DEC2
               call    DORATE
               mov     dx,Offset RATEMSG
               @PUT_STR

; ----------------------------------------------------------------------
               mov     ax,SMV_LOC4
               mov     CSR_LOC,ax
               @SET_CSR
               mov     dx,Offset MOVEMSG4  ; 32 bit RAM to RAM
               @PUT_STR

               call    W4TICK
               mov     SMV_TME,eax  ; Start Time

               call    SPEAKIT
               mov     es,RUNCS
               mov     cx,MAXREC  ; xMB / 32,768
               shl     cx,2    ; x4

@@:            push    cx
               mov     cx,BUFFLEN
               shr     cx,2
               mov     di,Offset DTABUFF2
               mov     si,Offset DTABUFF
               cld
               rep     movsd   ; Move 32k
               pop     cx
               loop    @B      ; Repeat to xM

               mov     es,RUNES
               call    W4TICK  ; Stop Time
               mov     ecx,eax
               sub     ecx,SMV_TME  ; Elapsed clicks
               add     SDO_TME,ecx
               add     SCO_TME,ecx
               mov     eax,FOURkBs  ; 4 * 1kB/Sec
               xor     ebx,ebx
               xor     edx,edx
               div     ecx

               mov     ZWORD,ax  ; DWord RAM Move kB/Sec
               call    BIN_DEC2
               call    DORATE
               mov     dx,Offset RATEMSG
               @PUT_STR

; ----------------------------------------------------------------------
               mov     ax,SMV_LOCV
               mov     CSR_LOC,ax
               @SET_CSR
               mov     dx,Offset MOVEMSGV  ; 8 Bit Video to Vid
               @PUT_STR

               call    W4TICK
               mov     SMV_TME,eax  ; Start Time

               call    SPEAKIT
               mov     es,GRAF_SEG
               mov     cx,MAXREC  ; xMB / 32,768
               mov     bx,BUFFLEN
               push    ds
               mov     ds,TEXT_SEG

@@:            push    cx
               mov     cx,bx
               mov     di,0
               mov     si,0
               cld
               rep     movsb   ; Move 32k
               pop     cx
               loop    @B      ; Repeat to xM

               pop     ds
               mov     es,RUNES
               call    W4TICK  ; Stop Time
               mov     ecx,eax
               sub     ecx,SMV_TME  ; Elapsed clicks
               add     SDO_TME,ecx
               add     SCO_TME,ecx
               mov     eax,ONEkBs  ; 1kB/Sec
               xor     ebx,ebx
               xor     edx,edx
               div     ecx

               mov     ZWORD,ax  ; Page Vid to Vid kB/Sec
               call    BIN_DEC2
               call    DORATE
               mov     dx,Offset RATEMSG
               @PUT_STR

; ----------------------------------------------------------------------
               mov     ax,SMV_LOC5
               mov     CSR_LOC,ax
               @SET_CSR
               mov     dx,Offset MOVEMSG5  ; Composite RAM/Video
               @PUT_STR
               call    SPEAKIT

               mov     ecx,SDO_TME  ; Tot Access Time
               mov     eax,EIGHTkBs  ; 10 @ 1kB/Sec
               add     eax,TWOkBs
               xor     ebx,ebx
               xor     edx,edx
               div     ecx

               mov     ZWORD,ax
               call    BIN_DEC2
               call    DORATE
               mov     dx,Offset RATEMSG
               @PUT_STR

; ----------------------------------------------------------------------
               mov     ax,SCO_LOC
               mov     CSR_LOC,ax
               @SET_CSR
               mov     dx,Offset COMPMSG  ; Composite Bus
               @PUT_STR
               call    SPEAKIT

               mov     ecx,SCO_TME  ; Tot Access Time
               mov     eax,EIGHTkBs  ; 13.5 @ 1kb/Sec
               add     eax,FOURkBs
               add     eax,ONEkBs
               add     eax,HALFkBs
               xor     ebx,ebx
               xor     edx,edx
               div     ecx

               mov     ZWORD,ax
               call    BIN_DEC2
               call    DORATE
               mov     dx,Offset RATEMSG
               @PUT_STR

; ----------------------------------------------------------------------
               mov     ax,SSS_LOC  ; Effective MIPS
               mov     CSR_LOC,ax
               @SET_CSR
               call    SPEAKIT

               call    W4TICK
               mov     SSS_TME,eax  ; Start Time
               add     eax,TICKMIP  ; Ticks interval
               mov     ecx,0
               mov     fs,BIOS_SEG

@@:            add     ecx,25
               push    cx
               mov     cx,18
               loop    $
               nop
               pop     cx
               cmp     DWord Ptr fs:[6Ch],eax
               jl      Short @B

               mov     eax,ecx
               mov     ecx,ALGOMIP  ; Scaling Factor: Ticks to MIPS
               xor     edx,edx
               div     ecx

               cmp     eax,0FFFFh  ; Oveflow?
               jle     Short @F
               call    SPEAKERR

@@:            mov     ZWORD,ax
               call    BIN_DEC2
               call    DORATE
               mov     si,Offset MIPSMSG
               mov     di,Offset ASCRATE+6
               mov     cx,3
               cld
               rep     movsd
               mov     ASCRATE+2,'.'
               mov     RATEMSG,16
               mov     dx,Offset RATEMSG
               @PUT_STR

; ----------------------------------------------------------------------
SKIP1:         call    GET_TME
               mov     bx,Offset TME_LOC2
               call    VCALC
               mov     ah,CO_TME
               mov     si,Offset ASC_TOD
               call    VMOVZ

               mov     es,VBUF_SEG  ; Hilight Composites
               mov     di,0
               mov     cx,4000
               mov     bl,LMARKER
               mov     bh,RMARKER

CHKMKR:        cmp     Byte Ptr es:[di],bl
               jne     Short NXTMKR
               inc     di
               mov     Byte Ptr es:[di],0
               inc     di

@@:            inc     di
               shl     Byte Ptr es:[di],4  ; Reverse from  to 
               inc     di
               cmp     Byte Ptr es:[di],bh
               jne     Short @B
               inc     di
               mov     Byte Ptr es:[di],0
               inc     di

NXTMKR:        add     di,2
               cmp     di,cx
               jl      Short CHKMKR

               mov     di,3295  ; Blink final
               mov     cx,9
               cld
@@:            or      Byte Ptr es:[di],128
               add     di,2
               loop    @B
               or      Byte Ptr es:[365],128  ; d:

               mov     es,RUNES

               mov     ax,Word Ptr MSG_LOC
               mov     CSR_LOC,ax
               @SET_CSR
               mov     dx,Offset BENCH_MSG
               cmp     SKPFLAG,1
               jne     Short @F
               mov     dx,Offset SKIP_MSG

@@:            @PUT_STR
               @GET_CSR

               call    SPEAKERB  ; Finish Beep
               cmp     SKPFLAG,1
               je      SKPFILE

; Dump Screen while ...

               mov     dx,Offset TXTFILE ; Try Append 1st 
               mov     PBFSA,dx
               mov     ax,3D02h
               int     DOS
               jnc     Short @F
               jmp     Short NOFILE

@@:            mov     PBFH,ax

               mov     ax,4202h  ; Set File to EOF
               xor     cx,cx
               xor     dx,dx
               mov     bx,PBFH
               int     DOS
               jnc     Short @F
               jmp     ERR_SET

@@:            jmp     Short GOFILE

NOFILE:        mov     dx,Offset TXTFILE  ; Create NEW file
               xor     cx,cx
               @CREATEF

GOFILE:        cmp     SKPFLAG,1
               je      Short NODESC

               mov     dx,OFFSET KBDESC  ; Write Desc
               xor     ch,ch
               mov     cl,LSTMKC
               mov     bx,PBFH
               @WRITEF

NODESC:        mov     fs,VBUF_SEG
               mov     si,0
               mov     cx,25

NXTDMP:        push    cx
               mov     cx,80

NXTBYT:        cld
               mov     al,fs:[si]
               add     si,2
               mov     ZBYTE,al

               pusha
               mov     dx,OFFSET ZBYTE  ; Write
               mov     cx,1
               mov     bx,PBFH
               @WRITEF
               popa

               loop    NXTBYT

               pop     cx      ; Last Row #

               pusha
               mov     dx,OFFSET CRLF  ; Write
               mov     cx,2
               mov     bx,PBFH
               @WRITEF
               popa

               loop    NXTDMP

               mov     dx,OFFSET CRLF  ; Write
               mov     cx,2
               mov     bx,PBFH
               @WRITEF
               mov     bx,PBFH
               @CLOSEF

SKPFILE:       @SET_CSR        ; Final Wait !
               mov     dx,Offset ENTER_MSG
               @PUT_STR
               call    SPEAKIT
               @GET_KEY

               jmp     ERR_EXIT  ; Fini (Dbl Chk RC!)

DTABUFF2       DB      32768 DUP(?)  ; 32k Data Block

; ----------------------------------------------------------------------
; Error Handler
ERR_SET:       mov     RC,al   ; Save Err #

ERR_EXIT:      mov     al,RC   ; Error #
               cmp     al,0
               je      Short @F
               call    STD_ERROR

@@:            cmp     RESTFLAG,1  ; Restore?
               je      Short @F

               call    BLANKIT  ; Clear Screen
               mov     SAV_LOC,0
               jmp     Short CHKRC

@@:            mov     si,Offset SCRBUFF  ; else Old Screen
               mov     es,VBUF_SEG
               xor     di,di
               mov     cx,SCRBL
               shr     cx,2
               cld
               rep     movsd

CHKRC:         mov     es,RUNES  ; Old Cursor
               mov     ax,SAV_LOC
               mov     CSR_LOC,ax
               @SET_CSR

; Exit to DOS
EXITP:         cmp     KBSTAT,0
               je      Short @F

               mov     es,BIOS_SEG
               mov     ax,KBSTAT  ; Restore Stat
               mov     es:[17h],ax
               mov     es,RUNES

@@:            call    BIN_DEC
               mov     di,Offset ELEVEL
               mov     ax,Word Ptr ECODE
               cmp     al,'0'
               jne     Short @F
               mov     al,' '
               cmp     ah,'0'
               jne     Short @F
               mov     ah,' '

@@:            stosb
               xchg    al,ah
               stosb
               mov     al,ECODE+2
               stosb

               mov     dx,OFFSET TERMMSG  ; Term Msg
               @PUT_STR

; Port 61h = 8253 Timer Channel 2 [ xxxxxx01b = Timer ]
               in      al,61h
               and     al,0FCh 
               or      al,1
               out     61h,al

               mov     al,RC   ; ErrorLevel
               mov     ah,4Ch
               int     DOS     ; Exit
               ret

; ----------------------------------------------------------------------
; *** Called Subroutines ***

W4TICK:        mov     fs,BIOS_SEG
               mov     eax,fs:[6Ch]

@@:            cmp     eax,fs:[6Ch]  ; Wait for Ticker to chg +1
               je      Short @B

               inc     eax
               mov     fs,RUNFS
               ret

DORATE:        mov     ASCRATE+2,','
               mov     ax,Word Ptr DECIMAL+3
               cmp     al,'0'
               jne     short @F
               mov     al,' '
               cmp     ah,'0'
               jne     Short @F
               mov     ah,' '
               mov     ASCRATE+2,' '

@@:            mov     Word Ptr ASCRATE,ax
               mov     ax,Word Ptr DECIMAL+5
               cmp     ASCRATE+2,','
               je      Short @F
               cmp     al,'0'
               jne     short @F
               mov     al,' '
               cmp     ah,'0'
               jne     Short @F
               mov     ah,' '

@@:            mov     Word Ptr ASCRATE+3,ax
               mov     al,DECIMAL+7
               mov     ASCRATE+5,al
               ret

; Click Speaker
SPEAKIT:       mov     bx,3    ; Count

DOCLK:         mov     dx,24   ; Duration
               in      al,61h
               and     al,0FEh

@@:            or      al,2
               out     61h,al
               mov     cx,100  ; On
               loop    $
               and     al,0FDh
               out     61h,al
               mov     cx,500  ; Off
               loop    $
               dec     dx
               jnz     Short @B

               xor     cx,cx  ; Interval
               loop    $
               dec     bx
               jnz     Short DOCLK
               ret

               END     Start   ; Start Addr!
;*** End of Program ***
