PAGE 60,132
TITLE DONE.Com  Sound series of Tones after Batch processing
; ---------------------------------------------------------------------

;  Syntax      DONE

;              (c) 1995   Ben Ritchey Jr., et al
;                         Propriety use only - All rights reserved

               .8086           ; Base Architecture
CSEG           SEGMENT
               ASSUME  cs:CSEG, ds:CSEG, es:CSEG, ss:CSEG

; Interrupts (ah=Func)
BIOSVID        EQU     10h     ; BIOS Video Int
BIOSEQU        EQU     11h     ;  "   Equipment Flags
BIOSMEM        EQU     12h     ;  "   Memory Size
BIOSDSK        EQU     13h     ;  "   Floppy Disk
BIOSCOM        EQU     14h     ;  "   Communications
BIOSEXT        EQU     15h     ;  "   Extended
BIOSKBD        EQU     16h     ;  "   Keyboard
BIOSPRT        EQU     17h     ;  "   Printer
BIOSRTC        EQU     1Ah     ;  "   Real Time Clock

DOS            EQU     21h     ; DOS Sys Func Req
ALMINT         EQU     4Ah     ; SysRQ User Alarm

; ---------------------------------------------------------------------
; Program Segment Prefix (PSP x 256/100h)

               org     80h     ; Default Disk Trfr Area x128
PspVLI         Label   Byte    ; Args Len (1st = Sp @ 81h if >0)
               org     82h
PspArgs        Label   Byte    ; 'args...' if Vli >1

               PAGE
; ---------------------------------------------------------------------
               org     100h
Start          Label   Proc

               mov     bx,3     ; Count/# tones (actual x2)

TONE:          mov     dx,25    ;  Duration of Tone
               in      al,61h   ; Read 8255 Port B
               and     al,0FEh  ;  Turn 8253 Timer OFF
@@:            or      al,2     ;  Turn Speaker ON
               out     61h,al   ; Write Port B
               mov     cx,120   ;  Duration HI
               loop    $        ; Delay HI

               and     al,0FDh  ;  Turn Speaker OFF
               out     61h,al   ; Write Port B
               mov     cx,120   ;  Duration LO
               loop    $        ; Delay LO

               mov     cx,1000
               loop    $

               dec     dx       ;  Cycle Freq
               jnz     Short @B       ; Repeat Wave

               mov     dx,25    ;  Duration of Tone
@@:            or      al,2     ;  Turn Speaker ON
               out     61h,al   ; Write Port B
               mov     cx,200   ;  Duration HI
               loop    $        ; Delay HI

               and     al,0FDh  ;  Turn Speaker OFF
               out     61h,al   ; Write Port B
               mov     cx,200   ;  Duration LO
               loop    $        ; Delay LO

               mov     cx,1000
               loop    $

               dec     dx       ;  Cycle Freq
               jnz     Short @B       ; Repeat Wave

               dec     bx      ;  Tone Count
               jnz     TONE    ; Next Tone

; Port 61h = 8253 Timer Channel 2 [ xxxxxx01b = Timer ]
               in      al,61h
               and     al,0FCh 
               or      al,1
               out     61h,al

EXIT:          mov     al,RC   ;ErrorLevel
               mov     ah,4Ch  ; Return/Exit
               int     DOS
               ret
 
; ---------------------------------------------------------------------
; Data & Constants
RC             DB      0
CSEG           ENDS
               END     Start
;*** End of Program ***

