; ----------------------------------------------------------------------
;                          Called Sub-Routines
; ----------------------------------------------------------------------
; CALLED.INC  Sub-Routine Include File    Author:  Ben Ritchey Jr
;             ( See Extra.Inc for other routines )
;             Propriety Use Only - All Rights Reserved!

;PROCESS        DB      'PROGRAM.EXE',0
               .CODE
STD_ERROR:     mov     es,RUNES
               IFDEF   ERR104D
               cmp     RC,104
               jne     Short @F
               mov     edx,Dword Ptr ERR104D
               ENDIF

@@:            mov     bx,Offset PROCESS  ; Process Addr
               xor     di,di
               cmp     PBFSA,0
               je      Short @F
               mov     di,PBFSA  ; FSpec Addr

@@:            mov     al,RC
               mov     ah,0FFh  ; Calls Int Routine
               int     BIOSEXT

               mov     es,RUNES
;               cmp     ah,0FFh  ; Ignore?
;               je      Short @F
;               cmp     ah,0AAh  ; Abort?
;               je      Short @F
;               cmp     ah,0EEh  ; Retry ?
;               jne     Short @F
;               call    SPEAKERR

@@:            ret

               .CODE
; Delay cx usec (Convert cx=n for loop $ to cx x2 usecs)
WAITusec:      push    ax
               push    bx
               push    dx

               shr     cx,1
               mov     dx,cx   ; Lsb
               xor     cx,cx   ; Msb x65536
               xor     bx,bx
               mov     ax,8600h  ; Delay usec
               int     BIOSEXT
               xor     cx,cx

               pop     dx
               pop     bx
               pop     ax
               ret

; Delay 30 msec (One 'loop $' if cx=0 at 33MHz)
WAIT2m:        push    ax
               push    bx
               push    cx
               push    dx

               xor     cx,cx   ; Msb x65536  (Wait 30k uSec, 30 mSec)
               mov     dx,30000  ; Lsb
               xor     bx,bx
               mov     ax,8600h  ; Delay usec
               int     BIOSEXT

               pop     dx
               pop     cx
               pop     bx
               pop     ax
               ret

; Clear Screen the HARD way!
BLANKIT:       push    ax
               push    cx
               push    dx
               push    di
               push    es

               mov     di,0
               xor     ax,ax
               cmp     VADD,0
               je      Short @F
               mov     cl,VADD  ; 43/50 lines
               mov     ax,80
               mul     cl

@@:            mov     cx,2000  ; 80x25x2
               add     cx,ax
               mov     al,' '  ; Wht SP on Blk
               mov     ah,7
               mov     es,VBUF_SEG
               cld
               rep     stosw

               pop     es
               pop     di
               pop     dx
               pop     cx
               pop     ax
               ret

; Update TOD Clock
UPD_TIME:      push    ax
               push    bx
               push    cx
               push    si

               mov     es,BIOS_SEG
               mov     al,Byte Ptr es:[6Ch]  ; Lsb Tod Clicks
               cmp     al,Byte Ptr SYS_TOD  ; .nn +1?
               jne     Short @F
               mov     es,RUNES
               jmp     Short UPD_TXIT

@@:            mov     es,RUNES
               call    GET_TME
               mov     bx,Offset TME_LOC
               call    VCALC
               mov     ah,CO_TME
               mov     si,Offset ASC_TOD
               call    VMOVZ

UPD_TXIT:      pop     si
               pop     cx
               pop     bx
               pop     ax
               ret

; Clear Message area
CLEAR_MSG:     push    ax
               push    bx
               push    cx

               mov     bx,Offset MSG_LOC  ; Clear Msg Area
               call    VCALC
               mov     ah,CO_MSG
               mov     al,32
               mov     cx,78
               call    VFILL

               pop     cx
               pop     bx
               pop     ax
               ret

; Blurp Speaker        dx = Duration
SPEAKER:       push    dx
               push    cx
               push    ax

               mov     dx,50   ;Repeat
               in      al,61h
               and     al,0FEh
@@:            or      al,2
               out     61h,al
               mov     cx,200   ;On
               call    WAITusec
               and     al,0FDh
               out     61h,al
               mov     cx,8000  ;Off
               call    WAITusec

               dec     dx
               jnz     @B

               pop     ax
               pop     cx
               pop     dx
               ret

; Click Speaker        dx = Duration
SPEAKERC:      push    dx
               push    cx
               push    bx
               push    ax

               mov     bx,3    ; Count
NXSPKRC:       mov     dx,20   ; Repeat
               in      al,61h
               and     al,0FEh
@@:            or      al,2
               out     61h,al
               mov     cx,200  ; On
               call    WAITusec
               and     al,0FDh
               out     61h,al
               mov     cx,600  ; Off
               call    WAITusec

               dec     dx
               jnz     @B
               dec     bx
               jnz     NXSPKRC

               pop     ax
               pop     bx
               pop     cx
               pop     dx
               ret

; Beep Speaker         cx = 1/2 Freq if Tone   dx = Duration
SPEAKERB:      push    dx
               push    cx
               push    ax

               mov     dx,100   ;Repeat
               in      al,61h
               and     al,0FEh

@@:            or      al,2
               out     61h,al
               mov     cx,800  ;On
               call    WAITusec
               and     al,0FDh
               out     61h,al
               mov     cx,1000  ;Off
               call    WAITusec

               dec     dx
               jnz     Short @B

               pop     ax
               pop     cx
               pop     dx
               ret

; Beep Spkr Thrice (Errors)
SPEAKERR:      push    cx

               call    SPEAKERB
               call    WAIT2m
               call    SPEAKERB
               call    WAIT2m
               call    SPEAKERB

               pop     cx
               ret

; 6845 CRTC Control Table for VGA - Propriety 30 line Screen
;   31.5 kHz Horiz freq - 60 Hz Vert freq (525 scan lines)
;   36 Rows/Frame - 7 Extra/Frame (8x14 character box)
               .DATA
CRTC_TBL       DB      0,122   ;Total Cells per Scan Line (-1) HTOTAL
               DB      1,80    ;Display Columns per Row        HDISP
               DB      2,87    ;Start Cell-Horiz Sync Pulse    HSPOS
               DB      3,14    ;Width of   "     "    "        HSWIDTH
               DB      4,36    ;Total Rows per Video Frame     VTOTAL
               DB      5,7     ;Extra Scan Lines per Frame     VADJ
               DB      6,31    ;Display Rows per Screen        VDISP
               DB      7,55    ;Start Row-Vert Sync Pulse      VSPOS
               DB      8,0     ;Interlace (0=Off)              INTERLACE
               DB      9,12    ;Max Scan Lines per Row(-1)     MAXSCAN
               DB      10,0    ;Cursor Start Scan Line         CSTART
               DB      11,13   ;"      End   "    "            CEND
               DB      12,0    ;Video Buffer Word Offset-Hi    VBUFFHI
               DB      13,0    ;"     "      "    "     -Lo    VBUFFLO
               DB      14,0    ;Rel Cursor Position (Hi)
               DB      15,0    ;"   "      "        (Lo)
               DW      0FFFFh  ; End of Tbl

ROM_SET        DB      24h     ; 1=8x14,2=8x8,3=MSR Block(bl=0 to 3)
MSR_BLK        DW      0       ; Map Select Register Block
ROM_ROW        DW      25

; For Bios Int 10h, Func 11h, SubF 0 (Custom)
CHR_PARMS      DB      0,11h   ; al = SubF 0,  ah = Func 11h
               DB      0,14    ; bl = Block# 0,  bh = Bytes/Char 14
               DW      1       ; cx = #Chars 1
               DW      132     ; dx = Start Char 132
               DW      CHR_132  ; bp = Char Data

; Chr(132) for 8x14 Set  "Left/Up/Right Arrow", etc.
SET_132        DB      0,11h,0,14
               DW      CHR_CNT  ; Char Count
               DW      132     ; 1st Char (Ascii)
               DW      CHR_132  ; Start Addr
CHR_132        DB      2,255,18,16,16,16,16,31,0,0,0,0,0,0  ; 132  Arw
               DB      3,11 DUP(4),3,0  ; 133       {
               DB      192,11 DUP(32),192,0  ; 134  }
               DB      0,0,0,0,60,66,129,129,129,66,60,0,0,0  ; 135   o
               DB      0,128,128,0,0,189,0,0,0,0,0,0,0,0  ; 136       -
               DB      6,9,17,32,64,128,0,0,0,0,0,0,0,0  ; 137        '
               DB      3,4,8,16,60,66,129,129,129,66,60,0,0,0  ; 138  o'
               DB      0,28,34,89,85,89,85,50,28,0,0,0,0,0 ; 139  R
               DB      0,0,0,0,0,0,2,255,2,0,0,0,0,0  ; 140  1/2 Arw
               DB      252,5 DUP(48),8 DUP(0)  ; 141  (+143) tm
               DB      0,0,0,28,34,77,81,81,77,34,28,0,0,0  ; 142  (c)
               DB      132,204,252,3 DUP(204),8 DUP(0)  ; 143 (see 141)
CHR_CNT        EQU     ($-CHR_132)/14

; VGA: 31.5 kHz Horiz Freq,  Vert Freqs: 50/60/70Hz,  Scan lines: 630/525/450
;               [ 8x16 Box, 25/30 Rows ]    [ 8x8, 25/30/43/50/60 ]
;                50Hz     60Hz     70Hz      50Hz     60Hz     70Hz
;  Rows/Frame :   38       31       27        77       64       55
;  Xtra/Frame :    6       13        2         6        5        2

;  VDISP/VSPOS/MAXSCAN  25/28/15,  31/55/12,  50/58/7

               .CODE
RESET_VID:     call    SAVE_REGS  ; 25 Lines
               jmp     Short SET_VIDX

SET_VIDEO:     call    SAVE_REGS  ; Set 30 Line Mode ONLY

               cmp     VADD,0  ; Skip if 43/50
               je      Short @F
               jmp     Short SET_VXIT

@@:            mov     es,VBUF_SEG  ; Clr VBuf xtra
               mov     di,VPAGE_LEN
               mov     cx,32768
               sub     cx,VPAGE_LEN
               shr     cx,1
               mov     ax,0720h
               cld
               rep     stosw
               mov     es,RUNES

               mov     ROM_SET,1
               mov     bx,OFFSET CRTC_TBL ;6845 Reg/Data Tbl
               mov     dx,3D4h ;Ctrl Port

@@:            mov     al,[bx] ;Register
               cmp     al,0FFh ;End?
               je      Short @F      ; Yes
               out     dx,al   ;Write Addr
               inc     bx
               inc     dx      ;Data Port=3D5
               mov     al,[bx] ;Data
               out     dx,al   ;Write Data
               inc     bx
               dec     dx      ;Ctrl Port=3D4
               jmp     Short @B

@@:            nop

SET_VIDX:      mov     ah,11h  ; ROM 8x14 Char Set { EGA/MCGA/VGA Ok}
               mov     al,ROM_SET
               mov     bx,MSR_BLK
               mov     dx,ROM_ROW
               int     BIOSVID

               mov     ax,Word Ptr SET_132  ; Custom Chars
               mov     bx,Word Ptr SET_132+2
               mov     cx,Word Ptr SET_132+4
               mov     dx,Word Ptr SET_132+6
               mov     bp,Word Ptr SET_132+8
               int     BIOSVID

               mov     ah,1    ; Better Cursor (DOS)
               xor     al,al
               mov     ch,0    ; Top
               mov     cl,13   ; Bottom
               xor     bx,bx
               xor     dx,dx
               int     BIOSVID

SET_VXIT:      call    REST_REGS
               ret

; Video Table Move (Msg to Video), NO Attr
;  In   [bx] = Msg Table ( Row-1, Col-1, Addr, Len )
;                          Len Bit 8=1 is Hi
;       VBUF_SEG = Video Buffer Addr
               .DATA
END_VTM        DB      22      ; Last Row +1 (1st line to Adj, 0-49)
VADD           DB      0       ; +18/25 Adj 43/50 lines

               .CODE

VTMOVE:        call    SAVE_REGS
               mov     es,VBUF_SEG     ;VBuf Seg

VT_NEXT:       xor     ah,ah
               mov     al,[bx]         ;Row or EOT
               cmp     al,0FFh         ;EOT?
               jne     Short @F  ; No
               call    REST_REGS
               ret

@@:            cmp     al,END_VTM
               jl      Short @F           
               add     al,VADD  ; 43/50 Rows

@@:            mov     cl,80           ;((Row*80)+Col)*2
               mul     cl
               mov     di,ax
               xor     ah,ah
               mov     al,[bx+1]       ;Col
               add     di,ax
               shl     di,1
               mov     si,[bx+2]       ;Addr
               xor     ch,ch
               mov     cl,[bx+4]       ;Len

               xor     dh,dh
               test    cl,128  ; Bit 7?
               jz      Short VT_BYT
               and     cl,127
               mov     dh,1  ; Flag Hi

VT_BYT:        cmp     Byte Ptr [si],0  ;ASCIIZ End?
               je      Short VT_END
               cld
               movsb                   ;Move
               inc     di              ;Skip Attr
               cmp     dh,0
               je      Short @F
               mov     ah,Byte Ptr es:[di-1]
               or      ah,8  ; Hi bit
               mov     Byte Ptr es:[di-1],ah

@@:            loop    Short VT_BYT

VT_END:        add     bx,5            ;Nxt Tbl
               jmp     VT_NEXT

; Calculate Video Buffer Offset from Row-1/Col-1
;   In    [bx] = Row-1/Col-1
;   Out   [di] = Buffer Offset

               .CODE
VCALC:         push    ax
               push    cx
               xor     ah,ah
               mov     al,[bx]
               mov     cl,80           ;((Row*80)+Col)*2
               mul     cl
               mov     di,ax
               xor     ah,ah
               mov     al,[bx+1]       ;Col
               add     di,ax
               shl     di,1
               pop     cx
               pop     ax
               ret

; Video Move (ASCIIZ Text to Video) w/ Attribute
;  In    ah = Attribute
;       [si] = ASCIIZ Text Data
;       [di] = Video Buffer Start

               .CODE
VMOVZ:         push    es
               push    ax
               mov     es,VBUF_SEG
               cld

@@:            lodsb
               cmp     al,0
               je      Short @F
               stosw
               jmp     Short @B

@@:            pop     ax
               pop     es
               ret

; Video Fill (Char to Video) w/ Attribute
;  In    ah = Attribute
;        al = Character
;        cx = Fill Length (no attr)
;       [di] = Video Buffer Start

               .CODE
VFILL:         push    es
               push    ax
               mov     es,VBUF_SEG
               cld
               rep     stosw
               pop     ax
               pop     es
               ret

; GET_TME  Get System Time
;  Out  BIN_TOD = Binary Time (hmsH)
;       ASC_TOD = ASCII Time (hh:mm:ss)

               .DATA
BIN_TOD        DB      4 DUP(0)  ; Binary
SYS_TOD        DD      0       ; Clicks @ 18.2/sec
ASC_TOD        DB      '00:00:00'  ; ASCII
ASC_TODL       EQU     $-ASC_TOD
MIDNIGHT       DB      ' xm',0,'$'

               .CODE
GET_TME:       call    SAVE_REGS

               mov     es,BIOS_SEG  ; store clicks (18.2/sec)
               mov     ax,word Ptr es:[6Ch]
               mov     Word Ptr SYS_TOD,ax
               mov     ax,word Ptr es:[6Eh]
               mov     es,RUNES
               mov     Word Ptr SYS_TOD+2,ax

               mov     ah,2Ch
               int     DOS       
               mov     bx,OFFSET BIN_TOD ;Save TOD
               mov     [bx],ch    ; Hour
               mov     [bx+1],cl  ; Minute
               mov     [bx+2],dh  ; Seconds
               mov     [bx+3],dl  ; Hund/Sec

               mov     ZBYTE,ch   ;Hours to ASCII
               call    BIN_DEC1
               mov     ax,WORD PTR [DECIMAL+6]
               cmp     al,'0'
               jne     Short @F
               mov     al,' '
@@:            mov     WORD PTR [ASC_TOD],ax

               mov     al,[BIN_TOD+1]  ;Minutes
               mov     ZBYTE,al
               call    BIN_DEC1
               mov     ax,WORD PTR [DECIMAL+6]
               mov     WORD PTR [ASC_TOD+3],ax

               mov     al,[BIN_TOD+2]  ;Seconds
               mov     ZBYTE,al
               call    BIN_DEC1
               mov     ax,WORD PTR [DECIMAL+6]
               mov     WORD PTR [ASC_TOD+6],ax

               mov     MIDNIGHT+1,'a'
               cmp     BIN_TOD,12
               jl      Short OKTIME
               mov     MIDNIGHT+1,'p'
               cmp     BIN_TOD,12
               je      Short OKTIME
               sub     ASC_TOD,1
               cmp     ASC_TOD+1,'2'
               jge     Short @F
               sub     ASC_TOD,1
               add     ASC_TOD+1,10

@@:            sub     ASC_TOD+1,2

OKTIME:        cmp     ASC_TOD,'0'
               jne     Short @F
               mov     ASC_TOD,' '

@@:            call    REST_REGS
               ret

; GET_DTE  Get System Date
;  Out       ASC_DATE = ASCII Date (dow mmm dd yyyy jjj)
;            BIN_DATE = Binary Date (wmdyyjj)
;            BCD_DATE = Packed BCD Date (mdy)

               .DATA
BIN_DATE       DB      7 DUP(0)  ;WMDYYJJ
ASC_DATE       DB      'dow mmm dd yyyy jjj' ;ASCII
ASC_DATEL      EQU     $-ASC_DATE
BCD_DATE       DB      3 DUP(0)  ;MDY
LEAP_FLAG      DW      0       ;1=Leap Year

               .CONST
MONTABLE       DB      'JanFebMarAprMayJunJulAugSepOctNovDec'
DOWTABLE       DB      'SunMonTueWedThuFriSat'
JULTABLE       DW      0,31,59,90,120,151,181,212,243,273,304,334

               .CODE
GET_DTE:       call    SAVE_REGS
               mov     ah,2Ah  ; Get DOS Date
               int     DOS
               mov     bx,OFFSET BIN_DATE ;Save Bin Date
               mov     [bx],al  ; Dow (0-6, 0=Sun)
               mov     [bx+1],dh  ; MM (1-12)
               mov     [bx+2],dl  ; DD (1-31)
               mov     [bx+3],cx  ; YYYY (1980-2099)

               push    dx
               xor     dx,dx
               mov     ax,cx   ; Leap Year?
               mov     cx,4
               div     cx
               cmp     dx,0
               jnz     Short @F      ; No
               mov     LEAP_FLAG,1  ; Yes

@@:            xor     ah,ah   ; Calc Bin Julien
               pop     dx
               mov     al,dh
               dec     al
               mov     cl,2
               mul     cl
               mov     si,ax
               mov     cx,[JULTABLE][si]
               cmp     dh,3
               jb      Short @F
               add     cx,LEAP_FLAG  ; Mar-Dec

@@:            xor     dh,dh
               add     cx,dx
               mov     WORD PTR [BIN_DATE+5],cx
               xor     ah,ah   ; Set Dow
               mov     al,BIN_DATE
               mov     cl,3
               mul     cl
               mov     si,OFFSET DOWTABLE
               add     si,ax
               mov     di,OFFSET ASC_DATE
               cld
               mov     cx,3
               rep     movsb
               inc     di
               xor     ah,ah   ; Set Month
               mov     al,[BIN_DATE+1]
               dec     al
               mov     cl,3
               mul     cl
               mov     si,OFFSET MONTABLE
               add     si,ax
               mov     cx,3
               rep     movsb
               inc     di
               mov     al,[BIN_DATE+2]  ; Set Day
               mov     ZBYTE,al
               call    BIN_DEC1
               mov     ax,WORD PTR [DECIMAL+6]
               cmp     al,'0'
               jne     Short @F
               mov     al,' '
@@:            mov     [di], ax
               add     di,3
               mov     ax, WORD PTR [BIN_DATE+3]  ; Set Year
               mov     ZWORD,ax
               call    BIN_DEC2
               lea     si,DECIMAL+4
               mov     cx,4
               rep     movsb
               inc     di
               mov     ax,WORD PTR [BIN_DATE+5]  ; Set Julien
               mov     ZWORD,ax
               call    BIN_DEC2
               lea     si,DECIMAL+5
               cmp     Byte Ptr [si],'0'
               jne     Short @F
               mov     Byte Ptr [si],' '
               cmp     Byte Ptr [si+1],'0'
               jne     Short @F
               mov     Byte Ptr [si+1],' '
@@:            mov     cx,3
               rep     movsb
               mov     al,[BIN_DATE+1]  ; Calc BCD Month
               mov     ZBYTE,al
               call    BIN_DEC1
               mov     cl,4
               mov     ah,[DECIMAL+6]
               sub     ah,48
               shl     ah,cl
               mov     al,[DECIMAL+7]
               sub     al,48
               add     al,ah
               mov     BCD_DATE,al
               mov     ah,[ASC_DATE+8]  ; Calc BCD Day
               sub     ah,48
               shl     ah,cl
               mov     al,[ASC_DATE+9]
               sub     al,48
               add     al,ah
               mov     [BCD_DATE+1],al
               mov     ah,[ASC_DATE+13]  ; Calc BCD Year
               sub     ah,48
               shl     ah,cl
               mov     al,[ASC_DATE+14]
               sub     al,48
               add     al,ah
               mov     [BCD_DATE+2],al

               call    REST_REGS
               ret

; BIN_DEC  Convert Bin RC to ASCII Decimal
;  In        RC    = Binary Value (0-255)
;  Out       ECODE = ASCII Dec (nnn)
               .DATA
ECODE          DB      'nnn'
               .CODE
BIN_DEC:       push    ax
               push    bx
               push    cx
               xor     ax,ax
               xor     bx,bx
               mov     al,RC
               mov     cx,100  ; Hunds
               div     cl
               mov     bl,al
               mov     al,HEXTABLE[bx]
               mov     ECODE,al
               mov     al,ah   ; Tens
               xor     ah,ah
               mov     cx,10
               div     cl
               mov     bl,al
               mov     al,HEXTABLE[bx]
               mov     ECODE+1,al
               mov     bl,ah   ; Ones
               mov     al,HEXTABLE[bx]
               mov     ECODE+2,al
               pop     cx
               pop     bx
               pop     ax
               ret

; BIN_DEC1  Convert Binary to ASCII Decimal
;  In        ZBYTE = Bin Val (hh)
;  Out       DECIMAL+5 = ASCII Dec (nnn)
               .DATA
ZBYTE          DB      0
DECIMAL        DB      8 DUP('0'),0,'$'

               .CONST
HEXTABLE       DB      '0123456789ABCDEF'

               .CODE
BIN_DEC1:      call    SAVE_REGS
               xor     ax,ax
               xor     bx,bx
               mov     al,ZBYTE
               mov     cx,100  ; Hunds
               div     cl
               mov     bl,al
               mov     al,HEXTABLE[bx]
               mov     DECIMAL+5,al
               mov     al,ah   ; Tens
               xor     ah,ah
               mov     cx,10
               div     cl
               mov     bl,al
               mov     al,HEXTABLE[bx]
               mov     DECIMAL+6,al
               mov     bl,ah   ; Ones
               mov     al,HEXTABLE[bx]
               mov     DECIMAL+7,al
               call    REST_REGS
               ret

; BIN_DEC2  Convert Binary to ASCII Decimal
;  In        ZWORD = Bin Val (hhhh)
;  Out       DECIMAL+3 = ASCII Dec (nnnnn)
               .DATA
ZWORD          DW      0
               .CODE
BIN_DEC2:      call    SAVE_REGS
               xor     bx,bx
               xor     dx,dx
               mov     ax,ZWORD
               mov     cx,10000  ; Ten Thous
               div     cx
               mov     bl,al
               mov     al,HEXTABLE[bx]
               mov     DECIMAL+3,al
               mov     ax,dx   ; Thous
               xor     dx,dx
               mov     cx,1000
               div     cx
               mov     bl,al
               mov     al,HEXTABLE[bx]
               mov     DECIMAL+4,al
               mov     ax,dx   ; Hunds
               mov     cx,100
               div     cl
               mov     bl,al
               mov     al,HEXTABLE[bx]
               mov     DECIMAL+5,al
               mov     al,ah   ; Tens
               xor     ah,ah
               mov     cx,10
               div     cl
               mov     bl,al
               mov     al,HEXTABLE[bx]
               mov     DECIMAL+6,al
               mov     bl,ah   ; Ones
               mov     al,HEXTABLE[bx]
               mov     DECIMAL+7,al
               call    REST_REGS
               ret

; SAVE_REGS / REST_REGS
;  Save/Restore ax, cx, dx, bx, bp, si, di, ds, es

               .DATA
IRADDR         DW      IRDATA  ; Next Index (+-18/36) Inc Fwd!
IRDATA         DW      252 DUP(0)  ; Reg Save Table (28 x18b @ 9r16)
               DW      0FFFFh

               .CODE
SAVE_REGS:     push    ax
               push    bx
               mov     bx,IRADDR
               cmp     Word Ptr [bx],0FFFFh
               jne     Short @F
               mov     Byte Ptr RC,95   ; Stack
               jmp     ERR_EXIT

@@:            mov     [bx],ax
               mov     [bx+2],cx
               mov     [bx+4],dx
               pop     ax         ; bx
               push    ax         ; "
               mov     [bx+6],ax  ; "
               mov     [bx+8],bp
               mov     [bx+10],si
               mov     [bx+12],di
               mov     [bx+14],ds
               mov     [bx+16],es
               add     bx,18
               mov     IRADDR,bx
               pop     bx
               pop     ax
               ret

REST_REGS:     mov     ax,Seg IRADDR
               mov     ds,ax
               mov     bx,IRADDR
               sub     bx,18
               mov     IRADDR,bx
               mov     ax,[bx]
               push    ax
               mov     Word Ptr [bx],0  ; in case FF!
               mov     cx,[bx+2]
               mov     dx,[bx+4]
               mov     bp,[bx+8]
               mov     si,[bx+10]
               mov     di,[bx+12]
               mov     ax,[bx+14]
               push    ax      ; ds
               mov     ax,[bx+16]
               mov     es,ax
               mov     ax,[bx+6]
               mov     bx,ax
               pop     ds
               pop     ax
               ret

.XLIST
; ******** Use these if .386 ON / 32-Bit Registers ! ********
;;  Save/Restore eax, ecx, edx, ebx, ebp, esi, edi, ds, es, fs, gs
;               .DATA
;IRDATA         DD      252 DUP(0)  ; Reg Save Table (28 x36b @ 7r32, 4r16)
;               DD      0FFFFFFFFh
;PUSHEAX        DD      0
;PUSHEBX        DD      0
;
;               .CODE
;SAVE_REGS:     push    ax
;               mov     PUSHEAX,eax
;               mov     PUSHEBX,ebx
;               mov     bx,IRADDR
;               cmp     DWord Ptr [bx],0FFFFFFFFh
;               jne     Short @F
;               mov     RC,95   ; Stack
;               jmp     ERR_EXIT
;
;@@:            mov     [bx],eax
;               mov     [bx+4],ecx
;               mov     [bx+8],edx
;               mov     eax,PUSHEBX  ; ebx
;               mov     [bx+12],eax  ; ebx
;               mov     [bx+16],ebp
;               mov     [bx+20],esi
;               mov     [bx+24],edi
;               mov     [bx+28],ds
;               mov     [bx+30],es
;               mov     [bx+32],fs
;               mov     [bx+34],gs
;               add     bx,36
;               mov     IRADDR,bx
;               mov     ebx,PUSHEBX
;               mov     eax,PUSHEAX
;               pop     ax
;               ret
;
;REST_REGS:     mov     ax,SEG IRADDR
;               mov     ds,ax
;               mov     bx,IRADDR
;               sub     bx,36
;               mov     IRADDR,bx
;               mov     eax,[bx]
;               mov     PUSHEAX,eax
;               mov     Word Ptr [bx],0  ; in case FF!
;               mov     ecx,[bx+4]
;               mov     edx,[bx+8]
;               mov     ebp,[bx+16]
;               mov     esi,[bx+20]
;               mov     edi,[bx+24]
;               mov     ax,[bx+28]
;               push    ax      ; ds
;               mov     ax,[bx+30]
;               mov     es,ax
;               mov     ax,[bx+32]
;               mov     fs,ax
;               mov     ax,[bx+34]
;               mov     gs,ax
;               mov     eax,[bx+12]
;               mov     ebx,eax
;               mov     eax,PUSHEAX
;               pop     ds
;               ret
.LIST

;*** End of Called.Inc ***


