PAGE 60,132
TITLE ALARM.Com  Repetitive Beeps until ALT Key is pressed
; ---------------------------------------------------------------------

; Syntax:      ALARM

;              (c) 1995  Ben Ritchey Jr.
;              Propriety Licensed Use Only - All rights reserved

               .8086           ; Base Architecture
               Include Macro.Inc

; ----------------------------------------------------------------------

CSEG           Segment
               Assume  cs:CSEG, ds:CSEG, es:CSEG, ss:CSEG

BIOS           equ     10h
DOS            equ     21h     ; DOS Sys Func Req

               org     100h
Start          Label   Proc

               mov     es,BIOS_SEG
SLOT:          mov     bx,3     ; Count/# tones

TONE:          mov     dx,120   ;  Duration of Tone
               in      al,61h   ; Read 8255 Port B
               and     al,0FEh  ;  Turn 8253 Timer OFF

@@:            or      al,2     ;  Turn Speaker ON
               out     61h,al   ; Write Port B
               mov     cx,200   ;  Duration HI
               loop    $        ; Delay HI

               and     al,0FDh  ;  Turn Speaker OFF
               out     61h,al   ; Write Port B
               mov     cx,1500  ;  Duration LO
               loop    $        ; Delay LO

               dec     dx       ;  Cycle Count
               jnz     @B       ; Repeat Wave
               loop    $        ; Wait between Tones

               test    Byte Ptr es:[17h],8  ; Alt?
               jnz     CHKKB
               dec     bx       ;  Tone Count
               jnz     TONE     ; Next Tone

               mov     cx,24    ; Wait between sequence
               call    WAITER
               test    Byte Ptr es:[17h],8  ; Alt?
               jnz     CHKKB

               @CHK_KEY         ; See if Key pressed
               cmp     al,0
               je      Short SLOT  ; NO - keep it up

               mov     cx,3     ; Wait for release
               call    WAITER

CLRKB:         @CLR_KEY         ; Clear Kybd Buffer
               mov     cx,3     ; Wait for Repeat 
               call    WAITER

CHKKB:         @CHK_KEY         ; See if Key(s) DOWN
               cmp     al,0
               jne     Short CLRKB  ; Clear until UP

EXIT:          nop
; Port 61h = 8253 Timer Channel 2 [ xxxxxx01b = Timer ]
               in      al,61h
               and     al,0FCh 
               or      al,1
               out     61h,al

               mov     al,RC   ;ErrorLevel
               mov     ah,4Ch  ; Return/Exit
               int     DOS
               ret

WAITER         Label   Proc
               push    cx

@@:            xor     cx,cx   ; Wait cycle
               loop    $

               pop     cx      ; Next count
               test    Byte Ptr es:[17h],8  ; Alt?
               jnz     @F
               dec     cx
               jz      @F      ; Zero
               push    cx
               jmp     Short @B

@@:            ret

; Data & Constants
RC             DB      0
BIOS_SEG       DW      40h

CSEG           EndS
               End     Start
;*** End of Program ***

