{ DOSINFO.PAS : Display DOS information

  title   : DOSINFO
  version : 1.2
  date    : Mar 25,1999
  author  : J R Ferguson
  language: Turbo Pascal v5.5
  usage   : Program
}

PROGRAM DOSINFO;

uses Dos;

const
  WeekDay: array[0..6] of string[6] =
  ('Sun', 'Mon', 'Tues', 'Wednes', 'Thurs', 'Fri', 'Satur');

type
  Char5   = packed array[1..5] of char;
  String5 = string[5];

  CDItyp  = record { Country Dependent Information }
              FmtDate      : word;
              SymCurrency  : Char5;
              Sep1000      : char;   Sep1000Z     : char;
              SepDec       : char;   SepDecZ      : char;
              SepDate      : char;   SepDateZ     : char;
              SepTime      : char;   SepTimeZ     : char;
              FmtCurrency  : byte;
              DecCurrency  : byte;
              FmtTime      : byte;
              MapCall      : pointer;
              SepDataList  : char;   SepDataListZ : char;
              reserved     : Char5;
            end;

var
  regs : Dos.Registers;
  CDI  : CDItyp;

function MakeStr(c: char; n: integer): String;
var S: String; i: integer;
begin
  S:= '';
  for i:= 1 to n do
    S:= S + c;
  MakeStr:= S;
end;

function AsciiZtoString5(asciiz: Char5): String5;
var i: 0..5; c: char; result: String5;
begin
  i:= 0; result:= '';
  repeat
    c:= asciiz[i+1];
    if c <> #0 then begin result:= result + c; inc(i); end;
  until c = #0;
  AsciiZtoString5:= result;
end;

procedure DosVersion;
begin with regs do begin
  ah:= $30; MsDos(regs);
  write  ('DOS version      : ');
  if al=0 then writeln(' < 2.0') else writeln(al,'.',ah);
end end;

procedure DateTime;
begin with regs do begin
  ah:= $2A; MsDos(regs);
  write  ('System date/time : ',WeekDay[al],'day ',dl,'-',dh,'-',cx,', ');
  ah:= $2C; MsDos(regs);
  writeln(ch,':',cl,':',dh,'.',dl);
end end;

procedure CurrentPath;
var drcode: byte; dirpath: packed array[1..65] of char; i: byte;
begin with regs do begin
  ah:= $19; MsDos(regs); drcode:= al;
  ah:= $47; dl:= 0; si:= Ofs(dirpath); ds:= Seg(dirpath); MsDos(regs);
  write  ('Current path     : ',chr(ord('A') + drcode), ':\');
  i:= 1; while dirpath[i] <> chr(0) do begin write(dirpath[i]); inc(i) end;
  writeln;
end end;

procedure VerifyFlag;
begin with regs do begin
  write  ('Verify flag      : ');
  ah:= $54; MsDos(regs);
  case al of
    0 : writeln('off');
    1 : writeln('on');
  else  writeln('unknown');
  end;
end end;

function DiskType(id: byte): string;
begin
  case id of
    $F0: DiskType:= 'Not Identifiable';
    $F8: DiskType:= 'Fixed disk';
    $F9: DiskType:= 'DS, 15 sectors/track or 9 sectors/track (720k)';
    $FC: DiskType:= 'SS, 9 sectors/track';
    $FD: DiskType:= 'DS, 9 sectors/track (360k)';
    $FE: DiskType:= 'SS, 8 sectors/track';
    $FF: DiskType:= 'DS, 8 sectors/track';
    else DiskType:= 'Unknown';
  end;
end;

procedure DiskInfo;
begin with regs do begin
  ah:= $1B; MsDos(regs);
  writeln('Disk info for current drive');
  writeln('  Disk format type: ', DiskType(mem[ds:bx]));
  writeln('  Clusters/disk   : ', dx);
  writeln('  Sectors/cluster : ', al);
  writeln('  Bytes/sector    : ', cx);
  writeln('  ==> total bytes : ', longint(dx) *
                                  longint(al) *
                                  longint(cx));
  ah:= $36; dl:= 0; MsDos(regs);
  writeln('  Available space : ', bx,' clusters = ',
                                  longint(bx) *
                                  longint(ax) *
                                  longint(cx), ' byte = ',
                                  100.0*bx/dx:4:1,'%');
end end;

function CDICountry(code: word): String;
begin
  case code of
      1: CDICountry:= 'United States';
     31: CDICountry:= 'Netherlands';
     32: CDICountry:= 'Belgium';
     33: CDICountry:= 'France';
     34: CDICountry:= 'Spain';
     39: CDICountry:= 'Italy';
     41: CDICountry:= 'Switzerland';
     44: CDICountry:= 'United Kingdom';
     45: CDICountry:= 'Denmark';
     46: CDICountry:= 'Sweden';
     47: CDICountry:= 'Norway';
     49: CDICountry:= 'Germany';
     61: CDICountry:= 'Australia';
    358: CDICountry:= 'Finland';
    972: CDICountry:= 'Israel';
    else CDICountry:= 'Unknown';
  end;
end;

function CDIDateFmt(code: word; sep: char): String;
begin
  case code of
    0 : CDIDateFmt:= 'mm' + sep + 'dd' + sep + 'yy';
    1 : CDIDateFmt:= 'dd' + sep + 'mm' + sep + 'yy';
    2 : CDIDateFmt:= 'yy' + sep + 'mm' + sep + 'dd';
  else  CDIDateFmt:= 'unknown, sep = "' + sep + '"';
  end;
end;

function CDITimeFmt(code: word; sep: char): String;
begin
  if (code and 1) = 0 then CDITimeFmt:= '12 hours, sep = "' + sep + '"'
                      else CDITimeFmt:= '24 hours, sep = "' + sep + '"';
end;

function CDICurrency(code: word; symbol: char5; sigdec: byte; sep: char):
         String;
var symstr: String5;
begin
  symstr:= AsciiZtoString5(symbol);
  case code of
    0: CDICurrency:= symstr + '1' + sep + MakeStr('0',sigdec);
    1: CDICurrency:= '1' + sep + MakeStr('0',sigdec) + symstr;
    2: CDICurrency:= symstr + ' ' + '1' + sep + MakeStr('0',sigdec);
    3: CDICurrency:= '1' + sep + MakeStr('0',sigdec) + ' ' + symstr;
  else CDICurrency:= 'unknown';
  end;
end;

procedure CountryInfo;
begin with regs,CDI do begin
  ah:= $38;
  al:= 0;
  ds:= Seg(CDI); dx:= Ofs(CDI);
  MsDos(regs);
  writeln('Country dependent information');
  writeln('  country code    : ',bx,' (',CDICountry(bx),')');
  writeln('  date format     : ',CDIDateFmt(FmtDate,SepDate));
  writeln('  time format     : ',CDITimeFmt(FmtTime,SepTime));
  writeln('  currency format : ',CDICurrency(FmtCurrency,SymCurrency,
                                             DecCurrency,SepDec));
  writeln('  thousands sep   : ',Sep1000);
  writeln('  decimal sep     : ',SepDec);
  writeln('  data list sep   : ',SepDataList);
end end;


begin
  writeln; DosVersion; DateTime; VerifyFlag; CurrentPath;
  writeln; DiskInfo;
  writeln; CountryInfo;
end.

