{ BIOSINFO.PAS : Display IBM-PC BIOS information

  title   : BIOSINFO
  version : 1.0
  date    : june 4, 1992
  author  : J R Ferguson
  language: Turbo Pascal v5.5
  usage   : Program
}

PROGRAM BIOSINFO;

uses Dos;

const
 VidMode: array[0..3] of string =
 ( { 0:} 'Unknown',
   { 1:} '40x25 BW/color',
   { 2:} '80x25 BW/color',
   { 3:} '80x25 BW/mono' );

var
 regs  : Dos.Registers;

procedure EquipmentStatus;
var status : word;
begin
  Intr($11,regs); status:= regs.ax;
  writeln;
  writeln('Equipment status');
  writeln('  Printers        : ',(status shr 14) and 1);
  writeln('  Game adapter    : ',(status shr 12) and 1 = 1);
  writeln('  Serial cards    : ',(status shr  9) and 3);
  writeln('  Disk drives     : ',(status and 1) * (1+((status shr 6) and 3)));
  writeln('  Initial vidmode : ',VidMode[(status shr 4) and 3]);
  writeln('  System RAM      : ',16 * ((status shr 2) and 3),' kb');
  writeln('  Math coprocessor: ',((status shr 1) and 1) = 1);
end;

procedure VideoState;
begin
  regs.ah:= $0F; Intr($10,regs);
  writeln;
  writeln('Current video state');
  writeln('  Screen width : ',regs.ah,' columns');
  writeln('  Display mode : ',regs.al);
  writeln('  Display page : ',regs.bh);
end;

procedure MemorySize;
begin
  Intr($12,regs);
  writeln;
  writeln('Contiguous memory at startup: ',regs.ax,' kb');
end;

begin
  EquipmentStatus;
  VideoState;
  MemorySize;
end.

