#include "Timer.h"

// The CTimer class was written by Feng Yuan, and was used from his post on www.codeguru.com.  

inline unsigned __int64 GetCycleCount(void)
{
    _asm    _emit 0x0F
    _asm    _emit 0x31
}

    CTimer::CTimer(void)
    {
        m_overhead = 0;
        Start();
        m_overhead = Stop();
    }
    
    void CTimer::Start(void)
    {
        m_startcycle = GetCycleCount();
    }

    unsigned __int64 CTimer::Stop(void)
    {
		return GetCycleCount()-m_startcycle-m_overhead;
    }
