        PAGE    60,132
NAME    BBL
        TITLE   CPUSerNo.COM version 1.0 1999 September 20

        .model tiny
        .486             ; only works on a pentium III
                         ; must use MASM 6.0.  OPTASM won't work.
COMMENT |

CPUSerNo.COM

By Roedy Green

Displays CPU serial number for Pentium III class machines.  Earlier
Pentium models don't have a serial numbert.  Reading can be blocked by
setting a bit the MSR to 1.  This blocks reading the CPU serial number
until next hard reset, (not just reboot).

Example of use:

  C:\Sys\CPUSerNo.Com
  if errorlevel 1 goto NoSerNo

Please report bugs and problems to:

Roedy Green
Canadian Mind Products
#208 - 525 Ninth Street
New Westminster BC Canada
V5H 2N6
tel:(604) 777-1804
mailto:roedy@mindprod.com
http://mindprod.com

Version 1.0 1999 September 20
- initial version


|


CR      MACRO   ; Carriage return line feed
        DB 0dh,0ah
        ENDM
;================================================


code    segment para

        assume  cs:code,ds:code
        org     100h

;================================================

CPUSerNo  proc    far             ; mainline routine

start:

        Call    getSerNo        ; result in ecx:edx
        mov     eax,ecx
        and     eax,edx
        jne     Present

Absent:
        lea     DX,AbsentMsg
        Call    Say
        mov     ax,4C01h        ; exit with errorlevel 1
        int     21h

Present:
        LEA     DX,PresentMsg
        call    say
        mov     eax,ecx
        shr     eax,24
        and     eax,0ffh
        call    SayHexByte
        mov     eax,ecx
        shr     eax,16
        and     eax,0ffh
        Call    SayHexByte
        mov     eax,ecx
        shr     eax,8
        and     eax,0ffh
        call    SayHexByte
        mov     eax,ecx
        and     eax,0ffh
        call    SayHexByte
        mov     eax,edx
        shr     eax,24
        and     eax,0ffh
        call    SayHexByte
        mov     eax,edx
        shr     eax,16
        and     eax,0ffh
        Call    SayHexByte
        mov     eax,edx
        shr     eax,8
        and     eax,0ffh
        call    SayHexByte
        mov     eax,edx
        and     eax,0ffh
        call    SayHexByte
        LEA     DX,PresentMsg2
        call    say


                                ; AL = 00 = return code
        MOV     AX,4C00h        ; AH = 4C = terminate process
                                ; and close files
        INT     21h             ; DOS function call
                                ; That's all folks
                                ; That's all folks
CPUSerNo  endp

;================================================

;       get serial number in ecx,edx

getSerNo  PROC    NEAR
         sub   eax,eax          ; check that level 3 CPUID is supported
         db    0fh, 0a2h        ; CPUID
         cmp   eax,3
         jge   hasSerno
         mov   ecx,0            ; not Pentium with serial number, return 0.
         mov   edx,0
         ret
hasSerno:
         mov   eax,3
         db    0fh, 0a2h        ; CPUID
         ret
getSerNo ENDP

;================================================

Say     Proc    Near
;       On entry DX points to a $ delimited string to display.
        MOV     AH,9h
        INT     21h
        RET
Say     EndP

;================================================

        EVEN
hexPAD  DB      '00$'   ; where numeric output built by SayHex

SayHexByte PROC NEAR

;       call with hex number 00..FF in AL
;       converts it to ASCII and displays it on the screen
;       If it is 0 shows as 00.         Leading 0's are not suppressed.
;       Field is always 2 chars wide.
;       No leading and no trailing space. DISPLAYED IN HEX
;       Can call repeatedly to get a SayHexWord etc.
;       Preserves all registers


        push    ax              ; preserve regs
        push    bx
        push    cx
        push    dx
        mov     dl,al           ; save input
;       Do first (leftmost digit)
        mov     cl,4
        shr     al,cl
        and     al,0fh          ; get first digit
        cmp     al,9
        jg      HexChar1
        add     al,'0'          ; convert digit to ASCII
        jmp     StoreChar1
HexChar1:
        add     al,'A'-0AH      ; convert to uppercase A..H
StoreChar1:
        mov     hexPad,al

;       Do second (rightmost digit)
        mov     al,dl
        and     al,0fh          ; get last digit
        cmp     al,9
        jg      HexChar2
        add     al,'0'          ; convert digit to ASCII
        jmp     StoreChar2
HexChar2:
        add     al,'A'-0AH      ; convert to uppercase A..H
StoreChar2:
        mov     hexPad+1,al

;       Number is ready
        lea     dx,Hexpad
        mov     AH,09h          ; BIOS put string terminated by $
        int     21h
        pop     dx
        pop     cx
        pop     bx
        pop     ax
        ret
SayHexByte      ENDP
;============================================

PresentMsg LABEL BYTE
        DB      "CPU serial number ","$"

PresentMsg2 LABEL BYTE
        db      ".",13,10,"$"

AbsentMsg LABEL BYTE
        DB      "No serial number available.",13,10,"$"

;================================================

CopyrightMsg    label byte      ; does not display
        CR
        DB      ' CPUSERNO 1.0 ۲'
        CR
        DB      'Freeware to discover the Pentium III serial number'
        CR
        DB      'usage:  CPUSERNO'
        CR
        DB      '        IF ERRORLEVEL 1 GOTO NotPentium'
        CR
        DB      'Copyright (c) 1999 Roedy Green Canadian Mind Products'
        CR
        DB      '#208 - 525 Ninth Street, New Westminster, BC Canada V3M 5T9',13,10
        DB      'tel:(604) 777-1804   mailto:roedy@mindprod.com   http://mindprod.com',13,10
        DB      'May be freely distributed and used for any purpose except military.'
        CR
        db      '$'

code    ends
        end     start
