; CPUID.asm                  Artion 2004.03.03
; Read CPUID
	.model tiny
        .386
	.code
	org 100h
main:
	jmp begin
        HELLOW  db 'Read CPUID                                                 Artion 2004.03.03',0Dh,0Ah,'$'
        FUNC0   db 'Func0 (vendor name) :',0Dh,0Ah,'$'
        FUNC1   db 'Func1 (family/model/stepping, features) :',0Dh,0Ah,'$'
        FUNC2   db 'Func2 :',0Dh,0Ah,'$'
        TABLE   db '0123456789ABCDEF'
        rEAX    dd ?
        rEBX    dd ?
        rECX    dd ?
        rEDX    dd ?
begin:
	push cs
	pop ds

        mov ah,09h
	mov dx,offset HELLOW
        int 21h

        pushfd                  ; Save EFLAGS to stack
        pop eax                 ; Store EFLAGS in EAX
        mov ebx,eax             ; Save in EBX for testing later
        xor eax,00200000h       ; Switch bit 21
        push eax                ; Copy changed value to stack
        cli
        popfd                   ; Save changed EAX to EFLAGS
        pushfd                  ; Push EFLAGS to top of stack
        pop eax                 ; Store EFLAGS in EAX
        sti
        cmp eax, ebx            ; See if bit 21 has changed
        jz NO_CPUID             ; If no change, no CPUID

        mov eax,0
        db 0Fh
        db 0A2h
        ;cpuid
        mov rEAX,eax
        mov rEBX,ebx
        mov rECX,ecx
        mov rEDX,edx

        mov ah,09h
        mov dx,offset FUNC0
        int 21h
        
        mov ax,'  '
        call SHOW_2char
        mov ax,'EA'
        call SHOW_2char
        mov ax,'X='
        call SHOW_2char
        mov eax,rEAX
        call SHOW_8hex
        mov ax,0D0Ah
        call SHOW_2char

        mov ax,'  '
        call SHOW_2char
        mov ax,'EB'
        call SHOW_2char
        mov ax,'X='
        call SHOW_2char
        mov eax,rEBX
        call SHOW_8hex
        call SHOW_4char
        mov ax,0D0Ah
        call SHOW_2char

        mov ax,'  '
        call SHOW_2char
        mov ax,'EC'
        call SHOW_2char
        mov ax,'X='
        call SHOW_2char
        mov eax,rECX
        call SHOW_8hex
        call SHOW_4char
        mov ax,0D0Ah
        call SHOW_2char

        mov ax,'  '
        call SHOW_2char  
        mov ax,'ED'
        call SHOW_2char
        mov ax,'X='
        call SHOW_2char
        mov eax,rEDX
        call SHOW_8hex
        call SHOW_4char
        mov ax,0D0Ah
        call SHOW_2char

        mov eax,1
        db 0Fh
        db 0A2h
        ;cpuid
        mov rEAX,eax
        mov rEDX,edx

        mov ah,09h
        mov dx,offset FUNC1
        int 21h

        mov ax,'  '
        call SHOW_2char
        mov ax,'EA'
        call SHOW_2char
        mov ax,'X='
        call SHOW_2char
        mov eax,rEAX
        call SHOW_8hex

        mov ax,'ED'
        call SHOW_2char
        mov ax,'X='
        call SHOW_2char
        mov eax, rEDX
        call SHOW_8hex
        mov ax,0D0Ah
        call SHOW_2char

        mov eax,2
        db 0Fh
        db 0A2h
        ;cpuid
        mov rEAX,eax
        mov rEBX,ebx
        mov rECX,ecx
        mov rEDX,edx

        mov ah,09h
        mov dx,offset FUNC2
        int 21h

        mov ax,'  '
        call SHOW_2char
        mov ax,'EA'
        call SHOW_2char
        mov ax,'X='
        call SHOW_2char
        mov eax,rEAX
        call SHOW_8hex

        mov ax,'EB'
        call SHOW_2char
        mov ax,'X='
        call SHOW_2char
        mov eax,rEBX
        call SHOW_8hex

        mov ax,'EC'
        call SHOW_2char
        mov ax,'X='
        call SHOW_2char
        mov eax,rECX
        call SHOW_8hex

        mov ax,'ED'
        call SHOW_2char
        mov ax,'X='
        call SHOW_2char
        mov eax,rEDX
        call SHOW_8hex

NO_CPUID:
EXIT:
	mov ax,4C00h
	int 21h

SHOW_2char proc
; ax <- 2 char
       push ax
       push bx
       push dx
	mov bx,ax
	; show on screen
	mov ah,02h
	mov dl,bh
	int 21h
	mov dl,bl
	int 21h
       pop dx
       pop bx
       pop ax
       ret
SHOW_2char endp

SHOW_4char proc
; eax <- 4char
        push eax
        push ebx

        mov ebx,eax

        shr eax,16
        call SHOW_2char 

        mov ax,bx
        call SHOW_2char

        pop ebx
        pop eax
        ret
SHOW_4char endp

SHOW_2hex proc
; al <-
      push dx
      push cx
      push bx
      push ax

; ch <- 00 , cl <- 00h-ffh
       mov ch,al
       shr ch,4

       mov cl,al
       and cl,00001111b
       
; MSB 
        mov al,ch
        mov bx,offset TABLE    ; ds:bx = table
        xlat TABLE             ; table[Nb] -> al
	
	mov dl,al
	mov ah,02h
	int 21h

; LSB
        mov al,cl
        mov bx,offset TABLE    ; ds:bx = table
        xlat TABLE             ; table[Nb] -> al
	
	mov dl,al
	mov ah,02h
	int 21h

not_show:       
       pop ax
       pop bx
       pop cx
       pop dx
       ret
SHOW_2hex endp

SHOW_8hex proc
; eax <- 8hex
        push eax
        push ebx
        push ecx
        push edx

        mov ebx,eax
        mov ecx,eax
        mov edx,eax
        shr eax,24
        call SHOW_2hex
        shr ebx,16
        mov al,bl
        call SHOW_2hex
        shr ecx,8
        mov al,cl
        call SHOW_2hex
        mov al,dl
        call SHOW_2hex
        mov ax,'h '
        call SHOW_2char
        mov ax,'  '
        call SHOW_2char

        pop edx
        pop ecx
        pop ebx
        pop eax
        ret
SHOW_8hex endp

	.stack
	end main
