//CD-ROM speed measurement program

#ifdef __TINY__

#include <stdio.h>
#include <io.h>
#include <bios.h>
#include <dos.h>

#define BLOCKS 320

void main(int argc,char** argv)
{
 unsigned long dwTime,dwResult[BLOCKS],dwStartSector=16;
 unsigned i,j;
 char cBuf[2048],bDrive;

 if(argc<2) { printf("No drive letter!\nUse: %s <DRIVE>\n",argv[0]); exit(1); }
 bDrive = toupper(argv[1][0]) - 'A';

 for(i=0;i<BLOCKS;i++) {
	dwTime=biostime(0,0L);
	for(j=0;j<1000;j++,dwStartSector++) {
		_SI = (unsigned)(dwStartSector>>16);
		_DI = (unsigned)(dwStartSector);
   		_ES = _DS;		// Segment of sect buffer
   		_CX = bDrive;		// 0=A, 1=B, 2=C, etc.
   		_BX = cBuf;		// Offset of sect buffer
   		_DX = 1;		// Read one sector

		asm mov ax,1508h;	// MSCDEX Absolute read
		asm int 2Fh;
		asm jc Stop
	}
	dwTime=biostime(0,0L)-dwTime;
	if(!dwTime) dwTime=1;
	dwResult[i]=dwTime;
 }
Stop:
 for(j=0;j<i;j++) printf("%u %u\n",j,2000*18/(unsigned)dwResult[j]);

 exit(0);
}

#else
#error Use Tiny model.
#endif	// #ifdef __TINY__
